<?php

class ps_robokassa extends shopPaymentSystem{

/* ========================================================================== */
/* ========================================================================== */

    /**
     *        $order
     *    
     * @param array $order 
     */
    public function __construct($order, $config){

        parent::__construct();

        $this->order    = $order;
        $this->config   = $config;

    }

/* ========================================================================== */
/* ========================================================================== */

    /**
     *          
     */
    public function getHtmlForm($order, $currency){

        global $_LANG;

        $currency_kurs  = $this->config['currency'][$currency];
        $this->order['summ']  = round($this->order['summ']/$currency_kurs, 2);

        $signature = $this->config['sMerchantLogin']['value'] . ':' .
                     $this->order['summ'] . ':' .
                     $this->order['id'] . ':' .
                     $this->config['sMerchantPass1']['value'];

        $this->order['secret_key'] = md5($signature);

        ob_start();

        include('form.php');

        return ob_get_clean();

    }

/* ========================================================================== */
/* ========================================================================== */

    private function preRequest($model) {

        $inCore         = cmsCore::getInstance();

        $out_summ       = $inCore->request('OutSum', 'str');
        $out_id         = $inCore->request('InvId', 'int');
        $out_signature  = $inCore->request('SignatureValue', 'str');

        // ,     
        $currency_kurs    = $this->config['currency']['RUR'];
        $currency_price   = ($currency_kurs > 1 ? round($this->order['summ']/$currency_kurs, 2) : round($this->order['summ']*$currency_kurs, 2));

        if ($currency_price != $out_summ) { return "ERR1:   "; }

        // ,      
        if ($this->order['id'] != $out_id) { return "ERR2:   "; }

        //  
        $signature = $out_summ . ':' .
                     $this->order['id'] . ':' .
                     $this->config['sMerchantPass2']['value'];

        if(strtoupper(md5($signature)) != $out_signature){ return "ERR3:    "; }

        //   
        $model->setOrderStatus($this->order['id'], $this->order['secret_key'], 2);

        //  
        $model->clearCart($client_sess_id);

        return "OK{$out_id}";

    }

/* ========================================================================== */
/* ========================================================================== */

    public function processPayment($model) {
               
        return iconv('cp1251', 'utf-8', $this->preRequest($model));

    }

/* ========================================================================== */
/* ========================================================================== */

}

?>