<?php

if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

$site->SetTitle('');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main':
		IndexPollsViewPolls();
		break;
	case 'voice':
		IndexPollsVoice();
		break;
	case 'viewpoll':
	case 'viewresult':
		IndexPollsViewPoll();
		break;
	// 
	case 'addpost': IndexPollsAddPost();
		break;
	case 'editpost': IndexPollsEditPost();
		break;
	case 'savepost': IndexPollsEditPostSave();
		break;
	case 'deletepost': IndexPollsDeletePost();
		break;
	// //
	default:
		HackOff();
}

function IndexPollsViewPolls()
{
	global $db, $site, $config, $user;

	$where = "`active`='1'";
	$ex_where = GetWhereByAccess('view');
	if($ex_where != ''){
		$where .= ' and ('.$ex_where.')';
	}
	$polls = $db->Select('polls', $where);

	$time = time();
	if(count($polls) > 0){
		$site->AddTemplatedBox('', 'module/polls_main.html');
		$site->AddBlock('polls_title', true, false, 'ptitle');
		$site->Blocks['polls_title']['vars'] = array('public'=>'', 'title'=>'', 'comments'=>'', 'voices'=>' ');
		$site->AddBlock('polls', true, true, 'poll');
		SortArray($polls, 'date', true);
		foreach($polls as $poll){
			$answers = unserialize($poll['answers']);
			$c = count($answers);
			$num_voices = 0;
			for($i = 0; $i < $c; $i++){
				$num_voices += SafeDB($answers[$i][2], 11, int);
			}
			$show_results_link = $config['polls']['show_results'];
			$vars = array();
			$vars['title'] = SafeDB($poll['question'], 255, str);
			$vars['url'] = Ufu('index.php?name=polls&op=viewpoll&poll_id='.SafeDB($poll['id'], 11, int), 'polls/{poll_id}/');
			$vars['public'] = TimeRender($poll['date'], false, false);
			$vars['num_voices'] = $num_voices;
			$vars['allow_comments'] = SafeDB($poll['allow_comments'], 1, int);
			$vars['comments'] = SafeDB($poll['com_counter'], 11, int);
			$site->AddSubBlock('polls', true, $vars);
		}
	}else{
		$site->AddTextBox('', '<center>  .</center>');
	}
}

function IndexPollsViewPoll()
{
	global $db, $site, $user, $op, $config;

	$id = SafeEnv($_GET['poll_id'], 11, int);
	$where = "`id`='$id' and `active`='1'";
	$ex_where = GetWhereByAccess('view');
	if($ex_where != ''){
		$where .= ' and ('.$ex_where.')';
	}
	$db->Select('polls', $where);
	if($db->NumRows() == 0){
		HackOff();
	}
	$poll = $db->FetchRow();

	$site->SetTitle(SafeDB($poll['question'], 255, str));

	//  
	$ip = getip();
	if($user->Auth){
		$uid = $user->Get('u_id');
	}else{
		$uid = -1;
	}
	$db->Select('polls_voices', "`poll_id`='$id' and (`user_ip`='$ip' or `user_id`='$uid')");
	$viewresult = $db->NumRows() != 0;
	$viewresult = $viewresult || ($op == 'viewresult' && ($config['polls']['show_results'] == '1' || $user->isAdmin()));

	$answers = unserialize($poll['answers']);
	$c = count($answers);
	$num_voices = 0;
	for($i = 0; $i < $c; $i++){
		$num_voices += SafeDB($answers[$i][2], 11, int);
	}

	if($viewresult){
		if($num_voices != 0){
			$per_c = 100 / $num_voices;
		}else{
			$per_c = 0;
		}
		$site->AddTemplatedBox('', 'module/poll_result.html');
		$vars = array('lresults_title'=>' ', 'lrvalue'=>'.');
		$site->AddBlock('poll_result_rows', true, true, 'pr');
		$c = count($answers);
		for($i = 0; $i < $c; $i++){
			if($answers[$i][0] != ''){
				$svars = array();
				if($answers[$i][1] != ''){
					$ans = '<font color="'.SafeDB($answers[$i][1], 255, str).'">'.SafeDB($answers[$i][0], 255, str).'<font>';
				}else{
					$ans = SafeDB($answers[$i][0], 255, str);
				}
				$svars['value'] = (round($per_c * $answers[$i][2]));
				$svars['num_voices'] = SafeDB($answers[$i][2], 11, int);
				$svars['answertext'] = $ans;
				$site->AddSubBlock('poll_result_rows', true, $svars);
			}
		}
	}else{
		$site->AddTemplatedBox('', 'module/poll.html');
		$vars = array();
		$vars['form_action'] = Ufu('index.php?name=polls&op=voice&poll_id='.SafeDB($poll['id'], 11, int), 'polls/{poll_id}/voice/');
		$site->AddBlock('poll_variants', true, true, 'variant');
		for($i = 0; $i < $c; $i++){
			if($answers[$i][0] != ''){
				if($answers[$i][1] != ''){
					$ans = '<font color="'.SafeDB($answers[$i][1], 255, str).'">'.SafeDB($answers[$i][0], 255, str).'<font>';
				}else{
					$ans = SafeDB($answers[$i][0], 255, str);
				}
				if($poll['multianswers'] == '1'){
					$control = $site->Check('voice[]', $i);
				}else{
					$control = $site->Radio('voice[]', $i);
				}
				$site->AddSubBlock('poll_variants', true, array('title'=>$ans, 'control'=>$control));
			}
		}
		$vars['poll_showresults'] = ($config['polls']['show_results'] == '1' || $user->isAdmin());
		$vars['showresults_url'] = Ufu('index.php?name=polls&op=viewresult&poll_id='.$id, 'polls/{poll_id}/results/');
		$vars['others_url'] = Ufu('index.php?name=polls', '{name}/');
	}
	$vars['title'] = SafeDB($poll['question'], 255, str);
	$vars['back_url'] = Ufu('index.php?name=polls', '{name}/');
	$vars['back_caption'] = '  ';
	$vars['lnum_voices'] = '';
	$vars['num_voices'] = $num_voices;
	$vars['lcomments'] = '';
	$vars['comments'] = SafeDB($poll['com_counter'], 11, int);
	$site->AddBlock('poll', true, false, '');
	$site->Blocks['poll']['vars'] = $vars;

	//  
	if(isset($_GET['page'])){
		$nav_page = SafeEnv($_GET['page'], 11, int);
	}else{
		$nav_page = 0;
	}
	include_once($config['inc_dir'].'posts.class.php');
	$posts = new Posts('polls_comments', $poll['allow_comments'] == '1');
	$posts->PostFormAction = "index.php?name=polls&op=addpost&poll_id=$id&page=$nav_page";
	$posts->EditPageUrl = "index.php?name=polls&op=editpost&poll_id=$id";
	$posts->DeletePageUrl = "index.php?name=polls&op=deletepost&poll_id=$id";

	$posts->NavigationUrl = Ufu("index.php?name=polls&op=viewpoll&poll_id=$id", 'polls/{poll_id}/page{page}/', true);

	$posts->RenderPosts($id, 'poll_comments', 'comments_navigation', false, $nav_page);
	$posts->RenderForm(false, 'poll_comments_form');
}

function IndexPollsVoice()
{
	global $db, $user, $site, $config;
	if(!isset($_GET['poll_id'])){
		GoBack();
	}
	if(!isset($_POST['voice'])){
		$site->AddTextBox('', '<center>      .</center>');
	}else{
		$pid = SafeEnv($_GET['poll_id'], 11, int);

		$where = "`id`='$pid' and `active`='1'";
		$ex_where = GetWhereByAccess('view');
		if($ex_where != ''){
			$where .= ' and ('.$ex_where.')';
		}
		$db->Select('polls', $where);

		if($db->NumRows() == 0){
			GoBack();
		}
		$poll = $db->FetchRow();
		$answers = unserialize($poll['answers']);
		$multianswers = SafeDB($poll['multianswers'], 1, int);
		$voice = SafeEnv($_POST['voice'], 11, int);
		if(!$multianswers){
			$voice = $voice[0];
		}
		//,       
		$ip = getip();
		if($user->Auth){
			$uid = $user->Get('u_id');
		}else{
			$uid = -1;
		}
		$db->Select('polls_voices', "`poll_id`='$pid' and (`user_ip`='$ip' or `user_id`='$uid')");
		if($db->NumRows() == 0){
			if(!$multianswers){
				if(isset($answers[$voice])){
					$answers[$voice][2] = $answers[$voice][2] + 1;
					$answers = serialize($answers);
					$db->Update('polls', "answers='$answers'", "`id`='$pid'");
				}else{
					GoBack();
				}
			}else{
				$c = count($voice);
				for($i = 0; $i < $c; $i++){
					if(isset($answers[$voice[$i]])){
						$answers[$voice[$i]][2] = $answers[$voice[$i]][2] + 1;
					}else{
						GoBack();
					}
				}
				$answers = serialize($answers);
				$db->Update('polls', "answers='$answers'", "`id`='$pid'");
			}
			$voice = serialize($voice);
			if($user->Auth){
				$user_id = $user->Get('u_id');
			}else{
				$user_id = 0;
			}
			$db->Insert('polls_voices', "'','$pid','".getip()."','$voice','$user_id'");
			$user->ChargePoints($config['points']['polls_answer']);
			GoBack();
		}else{
			$site->AddTextBox('', '<center>,       .</center>');
		}
	}
}

function IndexPollsAddPost()
{
	global $db, $config, $site;
	$get_id        = 'poll_id'; //    get   id 
	$table         = 'polls_comments'; //  
	$object_table  = 'polls'; //  
	$counter_field = 'com_counter'; //      
	$alloy_field   = 'allow_comments'; //      

	$id = SafeEnv($_GET[$get_id], 11, int);
	$db->Select($object_table, "`id`='$id'");
	$obj = $db->FetchRow();
	$alloy_comments = $obj[$alloy_field] == '1';
	//  
	include_once($config['inc_dir'].'posts.class.php');
	$posts = new Posts($table, $alloy_comments);
	if($posts->SavePost($id, false)){
		$db->Select($object_table, "`id`='$id'");
		$obj = $db->FetchRow();
		$counter = $obj[$counter_field] + 1;
		$db->Update($object_table, "`$counter_field`='$counter'", "`id`='$id'");
		//   
		$parent = explode('_', $_POST['parent_id'], 2);
		$parent_id = SafeEnv($parent[1], 11, int);
		$page = ($parent_id != 0 && $_GET['page'] != 0 ? "&page={$_GET['page']}" : '');
		$parent = ($parent_id != 0 ? "#post_$parent_id" : '#post_'.$db->GetLastId());
		GO(GetSiteUrl().Ufu("index.php?name=polls&op=viewpoll&poll_id=$id$page$parent", 'polls/{poll_id}/'.($page != '' ? 'page{page}/' : '')));
		// --------------------------
	}else{
		$site->AddTextBox('', $posts->PrintErrors());
	}
}

function IndexPollsEditPost( $back_id = null )
{
	global $site, $config;
	$get_id = 'poll_id';       //    get   id 
	$table = 'polls_comments'; //  
	if($back_id == null){
		$back_id = SaveRefererUrl();
	}
	$action_url = "index.php?name=polls&op=savepost&poll_id=".SafeEnv($_GET[$get_id], 11, int)."&back=$back_id";

	$site->AddTemplatedBox('','edit_comment.html');
	include_once($config['inc_dir'].'posts.class.php');
	$posts = new Posts($table);
	$posts->PostFormAction = $action_url;
	$posts->RenderForm(true, 'post_form');
}

function IndexPollsEditPostSave()
{
	global $config;
	$get_id = 'poll_id';       //    get   id 
	$table = 'polls_comments'; //  

	include_once($config['inc_dir'].'posts.class.php');
	$posts = new Posts($table);
	if($posts->SavePost(SafeEnv($_GET[$get_id], 11, int), true)){
		GoRefererUrl($_GET['back']);
	}else{
		$site->AddTextBox('', $posts->PrintErrors());
		IndexPollsEditPost($_GET['back']);
	}
}

function IndexPollsDeletePost()
{
	global $config, $db;
	$get_id = 'poll_id'; //    get   id 
	$table = 'polls_comments'; //  
	$object_table = 'polls'; //  
	$counter_field = 'com_counter'; //      

	if(!isset($_GET['back'])){
		$back_id = SaveRefererUrl();
	}else{
		$back_id = $_GET['back'];
	}
	$id = SafeEnv($_GET[$get_id], 11, int);
	$delete_url = "index.php?name=polls&op=deletepost&poll_id=$id&back=$back_id";

	include_once($config['inc_dir'].'posts.class.php');
	$posts = new Posts($table);
	$posts->DeletePageUrl = $delete_url;
	$deleted_posts_count = $posts->DeletePost();
	if($deleted_posts_count > 0){
		$db->Select($object_table, "`id`='$id'");
		$obj = $db->FetchRow();
		$counter = $obj[$counter_field] - $deleted_posts_count;
		$db->Update($object_table, "`$counter_field`='$counter'", "`id`='$id'");
		GoRefererUrl($back_id);
	}
}

?>