<?php

function mod_octopus_slider($module_id){
        $inCore = cmsCore::getInstance();
        $inDB = cmsDatabase::getInstance();

		$cfg = $inCore->loadModuleConfig($module_id);
			
		global $_LANG;
		
		if (!isset($cfg['subs'])) { $cfg['subs'] = 1; }
		if (!isset($cfg['cat_id'])) { $cfg['cat_id'] = 1; }
		
		$showtype = $cfg['showtype'];
		$today = date("Y-m-d H:i:s");
		
		if ($cfg['cat_id'] != '-1') {
			if (!$cfg['subs']){
				$catsql = ' AND con.category_id = '.$cfg['cat_id'];
			} else {
				$rootcat = $inDB->get_fields('cms_category', "id='{$cfg['cat_id']}'", 'NSLeft, NSRight');
				if(!$rootcat) { return false; }
				$catsql = "AND (cat.NSLeft >= {$rootcat['NSLeft']} AND cat.NSRight <= {$rootcat['NSRight']})";
			}		
			$rssid = $cfg['cat_id'];

		} else { $catsql = ''; $rssid = 'all'; } 
		
		$sql = "SELECT c.*, c.pubdate as fpubdate, 
						u.nickname as author, u.login as author_login,
						p.imageurl
				FROM cms_content c
				LEFT JOIN cms_users u ON u.id = c.user_id
				LEFT JOIN cms_category cat ON cat.id = c.category_id
				LEFT JOIN cms_user_profiles p ON p.user_id = c.user_id 
				WHERE c.published = 1 AND c.showlatest = 1 AND c.is_arhive = 0 AND c.pubdate <= '$today'
                      AND (c.is_end=0 OR (c.is_end=1 AND c.enddate >= '$today'))
											 ".$catsql."
				ORDER BY pubdate DESC 
				LIMIT ".$cfg['num'];

		$result = $inDB->query($sql);
		
	
		
		$items = array();
		$is_uc = false;
		
		if ($inDB->num_rows($result)){
			$is_uc = true;
			
            $inCore->loadModel('content');
            $model = new cms_model_content();
			$con = array();
			while($con = $inDB->fetch_assoc($result)){
				$item = array();
				$text = strip_tags($con['title']);							
				if (strlen($text)>70) { 
					$text = substr($text, 0, 70). '...'; 
				}
							
				$item['title'] = $text;
				$item['href'] = $model->getArticleURL($cfg['menuid'], $con['seolink']);
				
				$item['content'] = $con['content'];
				$item['content'] = substr($item['content'],0, 250);
				$item['content'] = substr($item['content'], 0, strrpos($item['content'], ' ' ));
				$item['content'] = strip_tags($item['content']).'...';
				
				$item['image']  = (file_exists(PATH.'/images/photos/medium/article'.$con['id'].'.jpg') ? '/images/photos/medium/article'.$con['id'].'.jpg' : '');                
				
				if ($con['imageurl'] && @file_exists(PATH.'/images/users/avatars/'.$con['imageurl'])){
					$item['imageurl'] =  '/images/users/avatars/medium/'.$con['imageurl'];
				} else {
					$item['imageurl'] =  '/images/users/avatars/medium/nopic.jpg';
				}
				
				$items[] = 	$item;							
			}	

			
			
		}
		
		foreach ($items as $key => $row) {
    		$volume[$key]  = $row['hits'];
		}

		array_multisort($volume, SORT_DESC, $items);
 		
		$smarty = $inCore->initSmarty('modules', 'mod_octopus_slider.tpl');			
		$smarty->assign('items', array_slice($items,0,$cfg['num']));
		$smarty->assign('cfg', $cfg);
		$smarty->assign('is_uc', $is_uc);			
		$smarty->display('mod_octopus_slider.tpl');
		
		return true;

		
}
?>