<?php
/******************************************************************************/
//                                                                            //
//                             InstantCMS v1.9                                //
//                        http://www.instantcms.ru/                           //
//                                                                            //
//                   written by InstantCMS Team, 2007-2011                    //
//                produced by InstantSoft, (www.instantsoft.ru)               //
//                                                                            //
//                        LICENSED BY GNU/GPL v2                              //
//                                                                            //
/******************************************************************************/

if(!defined('VALID_CMS')) { die('ACCESS DENIED'); }

function clubRootAlbumId($club_id){
    $inDB = cmsDatabase::getInstance();
	return $inDB->get_field('cms_photo_albums', "parent_id=0 AND NSDiffer='club".$club_id."'", 'id');
}

function clubRepairAlbums(){
    $inDB = cmsDatabase::getInstance();
	$sql = "UPDATE cms_photo_albums SET NSDiffer = CONCAT('club', user_id) WHERE NSDiffer = 'club'";	
	$inDB->query($sql);
}

function setClubRating($club_id){
    $inDB = cmsDatabase::getInstance();
	$sql = "SELECT SUM( u.rating ) AS rating
			FROM cms_user_clubs c
			LEFT JOIN cms_users u ON u.id = c.user_id
			WHERE c.club_id = '$club_id'";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		$data = $inDB->fetch_assoc($rs);
		$rating = $data['rating'] * 5;
	} else {
		$rating = 0;
	}
	
	$sql = "UPDATE cms_clubs SET rating = $rating WHERE id = $club_id";
	$inDB->query($sql);
}

function cmsUserClubs($user_id){
    $inDB = cmsDatabase::getInstance();
	$userclubs['member'] = array();
	$userclubs['moder'] = array();
	$userclubs['admin'] = array();

	//check member/moder
	$sql = "SELECT u.*, c.title as title, c.id as id
			FROM cms_user_clubs u, cms_clubs c
			WHERE u.user_id = $user_id AND u.club_id = c.id AND c.published = 1
			ORDER BY c.title DESC";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		while ($record = $inDB->fetch_assoc($rs)){
			if ($record['role'] == 'moderator'){
				$userclubs['moder'][] = $record;
			}
			if ($record['role'] == 'member'){
				$userclubs['member'][] = $record;
			}			
		}
	}
	
	//check admin
	$sql = "SELECT title, id, admin_id
			FROM cms_clubs
			WHERE admin_id = $user_id AND published = 1
			ORDER BY title DESC";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		while ($record = $inDB->fetch_assoc($rs)){
			$userclubs['admin'][] = $record;
		}
	}
	
	if ($userclubs['admin'] || $userclubs['member'] || $userclubs['moder']){
		return $userclubs;	
	} else {
		return false;
	}
}

function clubBlogId($club_id){
    $inDB = cmsDatabase::getInstance();
	$id   = $inDB->get_field('cms_blogs', "owner='club' AND user_id=$club_id", 'id');	
	if (!$id){
			$sql = "INSERT INTO cms_blogs (user_id, title, pubdate, allow_who, view_type, showcats, ownertype, premod, forall, owner)
					VALUES ('$club_id', '', NOW(), 'all', 'list', 1, 'multi', 0, 0, 'club')";	
			$inDB->query($sql);
			$id = $inDB->get_field('cms_blogs', "owner='club' AND user_id=$club_id", 'id');	
	}
	return $id;
}

function clubBlogContent($blog_id, $is_admin=false, $is_moder=false, $is_member=false){

    if (!$blog_id) { exit; }

    $inCore = cmsCore::getInstance();
    $inDB   = cmsDatabase::getInstance();

    $inCore->loadModel('blogs');

    $model = new cms_model_blogs();

	$html = '';
	$sql = "SELECT p.*, b.seolink as bloglink, p.pubdate as fpubdate
			FROM cms_blog_posts p
			LEFT JOIN cms_blogs b ON b.id = p.blog_id
			WHERE p.blog_id = $blog_id AND p.published = 1
			ORDER BY pubdate DESC
			LIMIT 10";

	$rs = $inDB->query($sql);

	if ($inDB->num_rows($rs) || $blog_id){

		$on_moderate = $inDB->rows_count('cms_blog_posts', 'blog_id='.$blog_id.' AND published = 0');
		$html = '<ul>';
		while ($post = $inDB->fetch_assoc($rs)){
            $bloglink = $post['bloglink'];
			$html .= '<li><a href="'.$model->getPostURL(null, $post['bloglink'], $post['seolink']).'">'.$post['title'].'</a> &mdash; '.$inCore->dateFormat($post['fpubdate']).'</li>';
		}
		if ($is_member || $is_moder || $is_admin){
			$html .= '<li class="service"><a href="/blogs/'.$blog_id.'/newpost.html">  </li>';
		}
		if (($is_admin || $is_moder) && $on_moderate){
			$html .= '<li><a class="on_moder" href="/blogs/'.$blog_id.'/moderate.html">  </a> ('.$on_moderate.')</li>';
		}
		$html .= '<li class="all"><a href="'.$model->getBlogURL(null, $bloglink).'"> </a> ('.$inDB->rows_count('cms_blog_posts', "blog_id=$blog_id AND published=1").')</li>';
		$html .= '</ul>';

	} else {

		if ($is_member || $is_moder || $is_admin){
			$html .= '<ul>';
				$html .= '<li class="service"><a href="/blogs/'.$blog_id.'/newpost.html">  </a></li>';
			$html .= '</ul>';	
		} else {
			$html = '<p>    .</p>';	
		}

	}

	return $html;

}

function clubPhotoAlbums($club_id, $is_admin=false, $is_moder=false, $is_member=false){
    $inCore = cmsCore::getInstance();
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { exit; }	

	$sql = "SELECT a.id, a.title, a.pubdate, f.file, IFNULL(COUNT(f.id), 0) as content_count
			FROM cms_photo_albums a
			LEFT JOIN cms_photo_files f ON f.album_id = a.id AND f.published = 1
			WHERE a.NSDiffer='club$club_id' AND a.user_id = '$club_id' AND a.parent_id > 0
			GROUP BY a.id
			ORDER BY a.id DESC LIMIT 6";
					
	$rs = $inDB->query($sql);

	$albums = array();

		if ($inDB->num_rows($rs)){
				while ($album = $inDB->fetch_assoc($rs)){
				$on_moderate  = '';
				$delete       = '';
				$add_to_album = '';
					if ($is_admin || $is_moder){
						$unpub = $inDB->rows_count('cms_photo_files', 'album_id='.$album['id'].' AND published = 0');
					if ($unpub) { 
						$album['on_moderate'] = $unpub;
					}
				}
				$album['file']    = $album['file'] ? $album['file'] : 'no_image.png';
				$album['pubdate'] = $inCore->dateFormat($album['pubdate']);
				$albums[] = $album;
		}
	}

    ob_start();

    $smarty = $inCore->initSmarty('components', 'com_clubs_albums.tpl');
    $smarty->assign('albums', $albums);
	$smarty->assign('club_id', $club_id);
    $smarty->assign('is_admin', $is_admin);
	$smarty->assign('is_moder', $is_moder);
	$smarty->assign('is_member', $is_member);
    $smarty->display('com_clubs_albums.tpl');

    return ob_get_clean();
}

function clubUserIsRole($club_id, $user_id, $role='member'){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { return; }
	return $inDB->rows_count('cms_user_clubs', "club_id = '$club_id' AND user_id = '$user_id' AND role='$role'")? true: false;
}

function clubUserIsMember($club_id, $user_id){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { return; }
	return $inDB->rows_count('cms_user_clubs', "club_id = '$club_id' AND user_id = '$user_id'")? true: false;
}

function clubUserIsAdmin($club_id, $user_id){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { return; }
	return $inDB->rows_count('cms_clubs', "id = '$club_id' AND admin_id = '$user_id'")? true: false;
}

function clubModerators($club_id){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { exit; }
	$moders = array();
	$sql = "SELECT c.user_id
			FROM cms_user_clubs c
			WHERE c.club_id = '$club_id' AND c.role = 'moderator'";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		while ($u = $inDB->fetch_assoc($rs)){
			if (!in_array($u['user_id'], $moders)){
				$moders[] = $u['user_id'];
			}
		}
	}
	return $moders;
}

function clubMembers($club_id){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { exit; }
	$members = array();
	$sql = "SELECT c.user_id 
			FROM cms_user_clubs c
			WHERE c.club_id = '$club_id' AND c.role = 'member'";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		while ($u = $inDB->fetch_assoc($rs)){
			if (!in_array($u['user_id'], $members)){
				$members[] = $u['user_id'];
			}
		}
	}
	return $members;
}

function clubTotalMembers($club_id){
    $inDB = cmsDatabase::getInstance();
	if (!$club_id) { exit; }
	$members = array();
	$sql = "SELECT 1
			FROM cms_user_clubs c
			WHERE c.club_id = '$club_id'";
	$rs = $inDB->query($sql);
	if ($inDB->num_rows($rs)){
		return $inDB->num_rows($rs) +1; //+1      ,   
	} else {
		return 1;
	}
}

function clubAddUser($club_id, $user_id, $role='member'){
    $inDB = cmsDatabase::getInstance();
	$inDB->query("INSERT INTO cms_user_clubs (user_id, club_id, role) VALUES ($user_id, $club_id, '$role')");
	return;
}

function clubRemoveUser($club_id, $user_id){
    $inDB = cmsDatabase::getInstance();
	$inDB->query("DELETE FROM cms_user_clubs WHERE user_id=$user_id AND club_id=$club_id");
	return;
}

function clubSaveUsers($club_id, $list, $role, $clubtype='public', $cfg=false){
    $inCore = cmsCore::getInstance();
    $inDB   = cmsDatabase::getInstance();
    $inUser = cmsUser::getInstance();
	if ($list){
        //get current club users list
        $current_list = $inDB->get_table('cms_user_clubs', "club_id={$club_id} AND role='{$role}'", 'user_id');

        //delete users which missed in new list
        foreach ($current_list as $key=>$user){
            if (!in_array($user['user_id'], $list)){
                $inDB->query("DELETE FROM cms_user_clubs WHERE club_id={$club_id} AND user_id={$user['user_id']} AND role='{$role}' LIMIT 1");
                //send notice
                if($cfg['notify_out'] && ($user_id != $inUser->id)){
                    $club_title = $inDB->get_field('cms_clubs', 'id='.$club_id, 'title');
                    cmsUser::sendMessage(USER_UPDATER, $user_id, ' <a href="'.cmsUser::getProfileURL($inUser->login).'">'.$inUser->nickname.'</a>       <a href="http://'.$_SERVER['HTTP_HOST'].'/clubs/'.$club_id.'">'.$club_title.'</a>.');
                }
            }
        }

        //add new users and update old
		foreach ($list as $key=>$user_id){
			$user_id = (int)$user_id;
            $already = $inDB->get_field('cms_user_clubs', "user_id={$user_id} AND club_id={$club_id}", 'role');
            if (!$already){
                //user first time in this club
                $sql = "INSERT INTO cms_user_clubs (user_id, club_id, role)
                        VALUES ($user_id, $club_id, '$role')";
                $inDB->query($sql);

                //send notice
                if($cfg['notify_in'] && ($user_id != $inUser->id)){
                    $club_title = $inDB->get_field('cms_clubs', 'id='.$club_id, 'title');
                    cmsUser::sendMessage(USER_UPDATER, $user_id, '<b>   .</b>  <a href="'.cmsUser::getProfileURL($inUser->login).'">'.$inUser->nickname.'</a>       <a href="http://'.$_SERVER['HTTP_HOST'].'/clubs/'.$club_id.'">'.$club_title.'</a>.');
                }
            } else {
                //user already in club, update his role if necessary
                if ($already != $role){
                    $sql = "UPDATE cms_user_clubs
                               SET role='{$role}'
                             WHERE user_id={$user_id} AND club_id={$club_id}";
                    $inDB->query($sql);
                }
            }
		}							
	} else {
        //if new users list is empty, drop everyone from this club
        $inDB->query("DELETE FROM cms_user_clubs WHERE club_id={$club_id} AND role='{$role}'  LIMIT 1");
    }
}

function clubAdminLink($club_id){
    $inCore = cmsCore::getInstance();
    $inDB = cmsDatabase::getInstance();
	$sql = "SELECT u.id as id, u.nickname as nickname, u.login as login, p.gender as gender
			FROM cms_clubs c
			LEFT JOIN cms_users u ON u.id = c.admin_id
			LEFT JOIN cms_user_profiles p ON p.user_id = u.id
			WHERE c.id = '$club_id'";
	$rs     = $inDB->query($sql);
	$html = '';
	if ($inDB->num_rows($rs) == 1){
		$usr = $inDB->fetch_assoc($rs);
		$html .= cmsUser::getGenderLink($usr['id'], $usr['nickname'], null, $usr['gender'], $usr['login']);
	}
	return $html;
}

function clubMembersList($club_id){
    $inCore     = cmsCore::getInstance();
    $inDB       = cmsDatabase::getInstance();
	
	$sql = "SELECT u.id as id, u.nickname as nickname, u.login as login, p.gender as gender
			FROM cms_user_clubs c
			LEFT JOIN cms_users u ON u.id = c.user_id
			LEFT JOIN cms_user_profiles p ON p.user_id = u.id
			WHERE c.club_id = '$club_id'";

	$rs     = $inDB->query($sql);
	$total  = $inDB->num_rows($rs);

	$now=0; $html = '';

	while($usr = $inDB->fetch_assoc($rs)){				
		$html .= cmsUser::getGenderLink($usr['id'], $usr['nickname'], null, $usr['gender'], $usr['login']);
		if ($now < $total-1) { $html .= ', '; }
		$now ++;
	}
    
	return $html;
}

?>