<?php
/*
=====================================================
DLE BAND INFORM V.1
-----------------------------------------------------
http://e-div.com/blog/dle-band-inform.html
-----------------------------------------------------
BY ELEGANT DIVISION, 24.05.2012, 00:45 ^_^*
=====================================================
*/

@error_reporting ( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set ( 'display_errors', true );
@ini_set ( 'html_errors', false );
@ini_set ( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

function cleanMe( $me ){
    $me = strip_tags( $me );
    $me = htmlspecialchars( $me );
    $me = str_replace("&amp;quot;", "\"", $me );
    return $me;
}

if (isset ( $_GET['band'] )) $band = rawurlencode( strip_tags( $_GET['band'] )); else die("Не выбрана группа");

// settings
$ed = array(
    'method' => 'artist.getinfo',
    'band'  => $band,
    'lang' => 'ru', 
    'api' => 'e938c7e8f6db6abb1c36503e59154596',
    'format' => 'json',
);

// donor :)
$url = "http://ws.audioscrobbler.com/2.0/?method=" . $ed['method'] . "&artist=" . $ed['band'] . "&lang=" . $ed['lang'] . "&format=" . $ed['format'] . "&api_key=" . $ed['api'];

$primary_info = @file_get_contents($url);

// check if link work
if( $primary_info ){

    // transform json to arrays
    $decoded_info = json_decode( $primary_info, true );

    // if band exist
    if( isset( $decoded_info['artist'] )) {

        $cover = cleanMe( $decoded_info['artist']['image'][3]['#text'] ); // image
        $band = cleanMe( $decoded_info['artist']['name'] ); // band name
        $info = cleanMe( $decoded_info['artist']['bio']['summary'] ); // about band
        
        // genre aka tags
        $all_tags = array();
        foreach($decoded_info['artist']['tags']['tag'] as $key => $value){
            $all_tags[] = cleanMe( $value['name'] );
        }
        $tags = ucwords( implode(", ", $all_tags));
        $tags = ( $tags != "" ? "<div class=\"edTags\">Жанры:<br />" . $tags . "</div>" : "" );

        $buffer = <<<ED
<div class="bandContent">
    <img src="{$cover}" class="photo left" alt="" />
    <div class="info">
        <h1>{$band}</h1>
        {$info}{$tags}
    </div>
    <div class="clear">&nbsp;</div>
</div>
ED;

    } else $buffer = $decoded_info['message'];
    
} else $buffer = "Данная фуксия временно не работает";

header( "Content-type: text/html; charset=utf-8" );
echo $buffer;

?>