/*
=======================================================================================
---  DLE Sort Smiles
---  V.1
---  http://e-div.com/blog/dle-sort-smiles.html
---------------------------------------------------------------------------------------
---  By Elegant Division
---  http://e-div.com
---  info@e-div.com
---------------------------------------------------------------------------------------
---  05.2013
=======================================================================================
*/

jQuery(document).ready(function($) {
	$(document).on('click', "[name='save_con[smilies]']", function(){
		
		var b = {},
			allSmiles = $(this).val().split(","),
			dialogContent = "",
			addSmile = "";

		b["Сохранить"] = function() {
			var returnSmiles = [],
				cName = "";

			$("#sortmisles tr:not(.heading):not([data-code=''])").each(function() {
				cName = $(this).data("code");
				if(cName != "" || cName != "undefined"){
					returnSmiles.push(cName);
				}
			});

			$("[name='save_con[smilies]']")
				.val(returnSmiles.join(","))
				.css("color","#A8A8A8")
				.animate({color: "#000"}, 800);

			$(this).dialog("close");
		};

		dialogContent = "<tr class=\"heading\">\
			<th style=\"text-align: center;\">ID</th>\
			<th>Название смайлика</th>\
			<th style=\"text-align: center;\">Смаил</th>\
			<th style=\"text-align: center;\">Удалить</th>\
		</tr>";

		$(allSmiles).each(function(index) {
			dialogContent += "<tr data-code=\"" + $(this)[0] + "\">\
				<td style=\"width: 32px; text-align: center;\" class=\"smNum\"></td>\
				<td style=\"width: 182px;\"><input type=\"text\" value=\"" + $(this)[0] + "\" /></td>\
				<td style=\"width: 60px; text-align: center;\"><img src=\"engine/data/emoticons/" + $(this)[0] + ".gif\" alt=\"" + $(this)[0] + "\" class=\"smile\" /></td>\
				<td style=\"width: 45px; text-align: center;\"><img src=\"engine/skins/images/delete.png\" title=\"Удалить\" alt=\"Удалить\" class=\"remove-smile\"></td>\
			</tr>";
		});

		addSmile = "<form><table id='addsmile'>\
			<tr>\
				<td style=\"width: 257px;\"><input type=\"text\" placeholder=\"Название смайлика\" /></td>\
				<td style=\"width: 123px;\"><input type=\"submit\" value=\"Добавить\" class=\"btn btn-large btn-info\" /></td>\
			</tr>\
		</table></form>";

		$("#dleeditsmiles").remove();
		$("body").append("<div id='dleeditsmiles' title='Редактирование смайликов' style='display:none'><div class='sortholder'><table id='sortmisles'><tbody>" + dialogContent + "</tbody></table></div>" + addSmile + "</div>");

		numSmiles();

		$("#dleeditsmiles").dialog({
			autoOpen: true,
			show: 'fade',
			width: 400,
			height: 470,
			dialogClass: "modalfixed",
			buttons: b
		});

		$("#sortmisles tbody").sortable({
			items: "tr:not(.heading)",
			stop: function(){
				numSmiles();
			}
		});

	});

	// refresh emoticon src
	$(document).on("change", "#sortmisles input[type='text']", function() {
		$(this).closest("tr").find(".smile").attr({
			"src": "engine/data/emoticons/" + $(this).val() + ".gif",
			"alt": $(this).val()
		});
	});

	// remove smile
	$(document).on("click", "#sortmisles .remove-smile", function() {
		$(this).closest("tr").fadeOut(150, function() {
			$(this).remove();
			numSmiles();
		});
	});

	// add smile
	$(document).on("click", "#addsmile .btn", function() {
		var nSmile = $("#addsmile input[type='text']").val();

		if(nSmile !== ""){
			var apContent = "<tr data-code=\"" + nSmile + "\">\
				<td style=\"width: 32px; text-align: center;\" class=\"smNum\"></td>\
				<td style=\"width: 182px;\"><input type=\"text\" value=\"" + nSmile + "\" /></td>\
				<td style=\"width: 60px; text-align: center;\"><img src=\"engine/data/emoticons/" + nSmile + ".gif\" alt=\"" + nSmile + "\" class=\"smile\" /></td>\
				<td style=\"width: 45px; text-align: center;\"><img src=\"engine/skins/images/delete.png\" title=\"Удалить\" alt=\"Удалить\" class=\"remove-smile\"></td>\
			</tr>";
			$("#sortmisles").append(apContent);
			$("#addsmile input[type='text']").val("");

			numSmiles();

			$(".sortholder").animate({
				scrollTop: $("#sortmisles").height()
			}, 200);
		}

		return false;
	});

	function numSmiles(){
		$("#sortmisles tr:not(first-child):not([data-code=''])").each(function(index) {
			$(this).find(".smNum").text(index);
		});
	}

	if( ! $("#sortmisles tbody.ui-sortable").length > 0){
		// jQuery UI Sortable:
		var head 	= document.getElementsByTagName('head')[0];
		script 		= document.createElement('script');
		script.src 	= "engine/modules/ed-sortsmiles/files/uisortable.js";
		script.type = 'text/javascript';
		head.appendChild(script);
	}
});