<?php
/*
####################################################
@copyright		(c) 2013 Nevex Group
@name			uTop
@version		5.0
@link			http://nevex.pw/
####################################################
*/

define('UTOP_DIR', ENGINE_DIR . '/modules/utop');

if(! defined( 'DATALIFEENGINE' )) exit();
require_once ENGINE_DIR . "/data/config.php";

header("Content-type: text/html; charset={$config['charset']}");

$config_file = UTOP_DIR . '/config.txt'; //   
$cache_file_path = UTOP_DIR . '/cache.txt'; //  
$hidden_users_file = UTOP_DIR . '/hidden_users.txt'; //  

require_once UTOP_DIR . "/utop.class.php";
require_once UTOP_DIR . "/cache.class.php";

//  
if($_POST['save'] == "yes") {
	$newCfg = $_POST['utop'];
	$newCfg['sort_list'] = uTop::parseSortList($newCfg['sort_list']);
	$result = uTop::saveConfig($newCfg, $config['charset']);
	echo $result;
	exit();
}

//  
if($_POST['action'] == "clearcache") {
	$utop = new uTop;
	$utop->cache->flush();
	exit("  ");
}

if($_POST['action'] == "update") {
	$utop = new uTop;
	$result = @file_get_contents("http://api.nevex.pw/utop/update.php?version={$utop->config['version']}");
	$update = 0;
	if($result){
		if(trim($result) == "ok") $message = "     .";
		else {
			$message = (strtolower($config['charset']) != "utf-8") ? iconv("UTF-8", $config['charset'], $result) : $result;
			$update = 1;
		}
	} else $message = "   .";
	echo "{$update}<!>{$message}";
	exit();
}

function loadHiddenList(){
	$data = trim(@file_get_contents(UTOP_DIR . "/hidden_users.txt"));
	if($data){
		$list = explode(",", $data);
	} else {
		$list = array();
	}
	return $list;
}
function saveHiddenList(array $list){
	foreach($hiddenUsers as $index => $userid){
		if(! is_numeric($userid)) unset($hiddenUsers[$index]);
	}
	$f = fopen(UTOP_DIR . "/hidden_users.txt", "w");
	fputs($f, implode(",", $list));
	fclose($f);
}

$hiddenUsers = loadHiddenList();

if($_REQUEST['action'] == "hidden"){
	$json = array();
	if($_POST['do'] == "add"){
		$name = $db->safesql(trim($_POST['name']));
		$user = $db->super_query("SELECT `user_id`, `name` FROM " .  USERPREFIX. "_users WHERE `name` = '{$name}'");
		if($user['user_id']){
			if(! in_array($user['user_id'], $hiddenUsers)) {
				$hiddenUsers[] = $user['user_id'];
				saveHiddenList($hiddenUsers);
				$hStatus = "ok";
				$utop = new uTop;
				$utop->cache->flush();
			} else $hStatus = "    .";
		} else $hStatus = " {$name}  .";
	}
	if($_POST['do'] == "delete"){
		$id = intval($_POST['userid']);
		foreach($hiddenUsers as $index => $userid){
			if($userid == $id){
				unset($hiddenUsers[$index]);
				break;
			}
		}
		saveHiddenList($hiddenUsers);
		$utop = new uTop;
		$utop->cache->flush();
		exit("ok");
	}
}

$hidden_users_list = "";
$hiddenUsers = implode(",", $hiddenUsers);
if($hiddenUsers){
	$db->query("SELECT `name`, `user_id`, `foto`, `user_group` FROM " . USERPREFIX . "_users WHERE `user_id` IN ({$hiddenUsers}) ORDER BY `name` ASC");
	while($row = $db->get_row()){
		
		if(($row['foto'] != "") AND (file_exists(ROOT_DIR . "/uploads/fotos/{$row['foto']}"))) {
			$row['foto'] = "{$config['http_home_url']}uploads/fotos/{$row['foto']}";
		} elseif (file_exists(ROOT_DIR . "/templates/{$config['skin']}/dleimages/noavatar.png")) { // noavatar fix (9.7+)
			$row['foto'] = "{$config['http_home_url']}templates/{$config['skin']}/dleimages/noavatar.png";
		} else {
			$row['foto'] = "{$config['http_home_url']}templates/{$config['skin']}/images/noavatar.png";
		}
		
		$hidden_users_list .= "<span class=\"mini-box\" id=\"u{$row['user_id']}\"><img src=\"{$row['foto']}\" alt=\"\" /><span class=\"del-btn\" onclick=\"deleteHiddenUser({$row['user_id']}); return false;\"></span><div><b>{$row['name']}</b><br />{$user_group[$row['user_group']]['group_name']}</div></span>";
	}
}

if($_REQUEST['action'] == "hidden") {
	echo "{$hStatus}<!>{$hidden_users_list}";
	exit();
}

//  
class uTopAdmin {
	public $uconfig = array();

	public function loadConfig() {
		$this->uconfig = uTop::loadConfig();
	}
	
	public function getInput($input_name) {
		$input = "<input class=\"styled big\" name=\"utop[{$input_name}]\" value=\"{$this->uconfig[$input_name]}\" />";
		return $input;
	}
	
	public function getSmallInput($input_name) {
		$input = "<input class=\"styled small numeric\" autocomplete=\"Off\" name=\"utop[{$input_name}]\" value=\"{$this->uconfig[$input_name]}\" />";
		return $input;
	}
	
	public function getTextarea($name) {
		$value = $this->uconfig[$name];
		if($name == "sort_list") $value = uTop::showSortList($value);
		$textarea = "<textarea name=\"utop[{$name}]\" class=\"styled\">{$value}</textarea>";
		return $textarea;
	}
	
	public function getSwitcher($name) {
		if ($this->uconfig[$name] == "1") {
			$checked_yes = 'checked="checked"';
		} else {
			$checked_no = 'checked="checked"';
		}
		$radio = "<div class=\"switcherBox\"><label><input type=\"radio\" name=\"utop[{$name}]\" {$checked_yes} value=\"1\">  </label><label><input type=\"radio\" name=\"utop[{$name}]\" {$checked_no} value=\"0\">  </label></div>";
		return $radio;
	}
	
	public function getSelect($options=array(), $name) {
		foreach ($options as $key=>$title) {
			if($this->uconfig[$name] == $key) {$selected = 'selected="selected"';} else {$selected = "";}
			$select .= "<option {$selected} value=\"{$key}\">{$title}</option>";
		}
		$select = "<select class=\"selector\" name=\"utop[{$name}]\">{$select}</select>";
		return $select;
	}
	
	public function getMultipleSelect($options=array(), $name) {
		foreach ($options as $key=>$title) {
			$selected = "";
			foreach ($this->uconfig[$name] as $id=>$value) {
				if($key == $value) {
					$selected = 'selected="selected"';
					break;
				}
			}
			$select_options .= "<option {$selected} value=\"{$key}\">{$title}</option>";
		}
		$select = "<select class=\"multipleSelect\" multiple=\"multiple\" size=\"6\" name=\"utop[{$name}][]\">{$select_options}</select>";
		return $select;
	}
	
	public function getSortOptions() {
		$options_list = (array)explode("\n", $this->uconfig['sort_list']);
		$options_result = array();
		foreach ($options_list as $str) {
			$str = trim($str);
			$arr = (array)explode("=", $str);
			$option_title = trim($arr[1]);
			$option_value = trim($arr[0]);
			if($option_title and $option_value) {
				$options_result[$option_value] = $option_title;
			}
		}
		return $options_result;
	}
}

$uTopAdmin = new uTopAdmin;
$uTopAdmin->loadConfig($config_file);



function showRow($title = "", $description = "", $field = ""){
	$row_html = <<<HTML
	<tr>
	<td class="option">{$title}<br /><div class="descr">{$description}</div></td>
	<td class="optionSetting">{$field}</td>
	</tr>
HTML;
	return $row_html;
}
function showSep($title = "") { return "<tr><th colspan=\"2\" class=\"tdSep\">{$title}</th></tr>"; }
?>
<!DOCTYPE html>
<html>
<head>
<title> UTOP</title>
<link rel="stylesheet" type="text/css" media='screen' href="<?=$config['http_home_url']?>engine/modules/utop/admin/styles.css" />
<link rel="shortcut icon" href="<?=$config['http_home_url']?>engine/modules/utop/admin/images/favicon.ico" />
<script type="text/javascript" src="<?=$config['http_home_url']?>engine/modules/utop/admin/jquery-2.0.0.min.js"></script>
<script type="text/javascript" src="<?=$config['http_home_url']?>engine/modules/utop/admin/jquery-ui-1.10.3.min.js"></script>
<script type="text/javascript" src="<?=$config['http_home_url']?>engine/modules/utop/admin/utop.js"></script>
<script type="text/javascript" src="<?=$config['http_home_url']?>engine/modules/utop/admin/jquery-ui.js"></script>
<script type="text/javascript">
var admin_path = "<?=$PHP_SELF?>";
var utop_dir = "<?=$config['http_home_url']?>engine/modules/utop";
</script>
</head>
<body>
	
	<div class="highlight-panel top"></div>
	<div class="highlight-panel bottom"></div>
	<div class="leftPanel">
		<div class="topButtons">
			<a class="button back" href="<?=$PHP_SELF?>?mod=options&amp;action=options" title="   DataLife Engine"></a>
			<a class="button site" href="<?=$config['http_home_url']?>" target="_blank" title="  "></a>
			<a class="button logout" href="<?=$PHP_SELF?>?action=logout" title=""></a>
		</div>
		<div class="utopLogo"></div>
		
		<div class="tabsList">
			<span class="tab" rel="settings"></span>
			<span class="tab<?=($uTopAdmin->uconfig['enable_hide_users']) ? "" : " disabled"?>" rel="hiddenu"> </span>
			<span class="tab" onclick="showAbout(); return false;"> uTop</span>
			<div class="sep"></div>
			<span class="tab" onclick="clearCache(); return false;"> </span>
		</div>
		
		<div class="buttonsBox">
			<button type="button" class="fbutton utopSaveButton forTab settings"></button>
			<div class="inputBox forTab hiddenu">
				<input value="" id="addusername" placeholder=" " />
				<span class="btnFind" onclick="addHiddenUser(); return false;" title=" "></span>
			</div>
		</div>
	</div>


	<div class="mainContainer">
		<div class="utopTab settings">
			<div class="warn" style="<?=($uTopAdmin->uconfig['online'])? "display: none;" : ""?>">uTop .</div>
			<form action="" method="post" id="utopForm">
				<h1></h1>
				<table border="0" cellpadding="0" cellspacing="0" class="settingsTable">
					<tbody>
						<?php
						$sort_options = $uTopAdmin->uconfig['sort_list'];
						$sort_options['utop_rand'] = "";
						$user_groups = array();
						foreach ($user_group as $group) {
							if($group['id'] == 5) continue;
							$user_groups[$group['id']] = $group['group_name'];
						}

						echo showSep("");
						echo showRow(" uTop", "     ,    .", $uTopAdmin->getSwitcher("online") );
						echo showRow(" ,   ", "", $uTopAdmin->getSmallInput("max_user"));

						echo showSep("");
						echo showRow(" ,      n ", "   : 0", $uTopAdmin->getSmallInput("last_visit_period") . " ");
						echo showRow("     ", "", $uTopAdmin->getMultipleSelect($user_groups, "show_groups") );
						echo showRow("  ", "", $uTopAdmin->getSwitcher("show_banned") );
						echo showRow(" \" \"", "      .", $uTopAdmin->getSwitcher("enable_hide_users") );
						echo showRow("      ", "       (  ).", $uTopAdmin->getSwitcher("allow_leave_top") );

						echo showSep(" ");
						echo showRow("  ", "<a href=\"#\" onclick=\"dateHelp(); return false;\"></a>", $uTopAdmin->getInput("regdate_format"));
						echo showRow("   ", "<a href=\"#\" onclick=\"dateHelp(); return false;\"></a>", $uTopAdmin->getInput("lastdate_format"));
						echo showRow(" ", "         \"\"    \"\"", $uTopAdmin->getSwitcher("offest_date_format") );

						$sort_order_options = array(
						'ASC' => "  (-)",
						'DESC' => "  (-)",
						);

						echo showSep("");
						echo showRow(" ", "", $uTopAdmin->getSelect($sort_order_options, "sort_order"));
						echo showRow("   ", "  ,      . (   .)", $uTopAdmin->getSelect($sort_options, "sort_type") . "<br /><a href=\"#\" onclick=\"reloadSort(); return false;\"> </a>");
						echo showRow(" ", "     .        :<br /><b>_=  </b>", $uTopAdmin->getTextarea("sort_list"));
						echo showRow("    ", "       ", $uTopAdmin->getSwitcher("allow_sort") );
						
						echo showSep("  SQL ( )");
						echo showRow("   ", "  ,           ( ).     : <b>*</b>.", $uTopAdmin->getInput("sql_rows"));
						echo showRow("  ", "        .           .", $uTopAdmin->getInput("sql_join"));

						echo showSep("");

						echo showRow(" ?", "     MySQL", $uTopAdmin->getSwitcher("cache") );
						echo showRow("  ", "       .", $uTopAdmin->getSmallInput("cache_max_time") . " .");

						echo showSep(" ");

						$nick_format_mode_options = array(
						'none' => "",
						'color' => " ",
						'group_settings' => "    ",
						);

						echo showRow("   ", "            .<br />         \"{$nick_format_mode_options['color']}\"", $uTopAdmin->getSelect($nick_format_mode_options, "nick_format_mode"));

						foreach ($user_group as $group) {
							if($group['id'] == 5) continue; //    
							echo showRow("  \"{$group['group_name']}\"", ": <b>#2A8000</b>, <b>rgb(42,128,0)</b>  <b>green</b>", $uTopAdmin->getInput("group{$group['id']}_color") );
						}
						?>
					</tbody>
				</table>
				<input type="hidden" name="save" value="yes" />
			</form>
		</div>

		<div class="utopTab hiddenu">
			<h1> </h1>
			     ,      .          .
			<br /><br />
			<div id="hiddenUsersBox" class="hidden_users_box"><?=$hidden_users_list?></div><br />
		</div>
	</div>	

<div id="utopAbout" style="display:none;" title="">
	<div align="center">
		<img src="<?=$config['http_home_url']?>engine/modules/utop/admin/images/utop.png" alt="uTop logo" /><br />
		<b> <?=$uTopAdmin->uconfig['version']?></b>
	</div>
	<br />
	<div id="utopUpdates"></div>
	<br />
	uTop (User Top)        TOP' .
	<br /><br />
	<div class="copyright">&copy; 2013 <a href="http://nevex.pw/" target="_blank">Nevex Group</a>.</div>
</div>
	
</body>
</html>