<?php
defined('GANTRY_VERSION') or die();

gantry_import('core.gantrybodylayout');

global $post, $posts, $query_string;

/**
 *
 * @package gantry
 * @subpackage html.layouts
 */
class GantryLayoutBody_Contact extends GantryBodyLayout {

    var $render_params = array(
        'schema' => null,
        'pushPull' => null,
        'classKey' => null,
        'sidebars' => '',
        'contentTop' => null,
        'contentBottom' => null
    );

    function render($params = array()) {
        global $gantry;

        $fparams = $this->_getParams($params);

        // logic to determine if the component should be displayed
        $display_mainbody = !($gantry->get("mainbody-enabled", true) == false);
        $display_component = !($gantry->get("component-enabled", true) == false);

        $name_error = '';
        $email_error = '';
        $message_error = '';

        

        ob_start();
        // XHTML LAYOUT
        ?>
        <?php if ($display_mainbody) { ?>
            <div id="rt-main" class="<?php echo $fparams->classKey; ?>">
                <div class="rt-container">

                    <div class="rt-grid-<?php echo $fparams->schema['mb']; ?> <?php echo $fparams->pushPull[0]; ?>">

                        <div class="rt-block">
                            <?php if ($display_component) { ?>

                            <div id="rt-mainbody">

                                <!-- Begin Contact Form Template -->

                                <div class="rt-wordpress">
                                    <div class="rt-page">
                                        <?php if (have_posts()) { 
                                            while (have_posts()) { 
                                                the_post(); ?>

                                        <!-- Begin Post -->

                                        <div class="rt-article">
                                            <div class="rt-article-bg">
                                                <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
                                                    <div id="jaw_contact">
                                        <?php if ($gantry->get('contactpage-contactgooglemap')) { ?>
                                                            <div id="jaw_contact_map">

                                                                <script type="text/javascript" src="http://maps.googleapis.com/maps/api/js?sensor=false"></script>
                                                                <script type="text/javascript">


                                                                    var geocoder;
                                                                    var map;
                                                                    function initialize() {
                                                                        geocoder = new google.maps.Geocoder();
                                                                        var latlng = new google.maps.LatLng(-34.397, 150.644);
                                                                        var myOptions = {
                                                                            zoom: 13,
                                                                            mapTypeId: google.maps.MapTypeId.ROADMAP
                                                                        }
                                                                        map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
                                                                    }

                                                                    function codeAddress(address) {
                                                                        //var address = document.getElementById("address").value;
                                                                        geocoder.geocode( { 'address': address}, function(results, status) {
                                                                            if (status == google.maps.GeocoderStatus.OK) {
                                                                                map.setCenter(results[0].geometry.location);
                                                                                var marker = new google.maps.Marker({
                                                                                    map: map, 
                                                                                    position: results[0].geometry.location
                                                                                });
                                                                            } else {
                                                                                alert("Geocode was not successful for the following reason: " + status);
                                                                            }
                                                                        });
                                                                    }
                                                                </script>
                                                                <script>
                                                                    jQuery(function(){
                                                                        initialize();
                                                                        codeAddress("<?php echo $gantry->get('contactgooglemapaddress'); ?>");
                                                                    });
                                                                </script>
                                                                <div id="map_canvas" style="width: <?php echo $gantry->get('contactpage-contactgooglemapwidth'); ?>px; height: <?php echo $gantry->get('contactpage-contactgooglemapheight'); ?>px"></div>
                                                            </div>
                                        <?php } ?>

                                                        <div id="jaw_contact_content">
                                        <?php if (strlen(get_the_title()) != 0 && $gantry->get('contactpage-title')) { ?>
                                                                <h1 class="title"><?php echo the_title(); ?></h1>
                                        <?php } ?>

                                        <?php if ($c=get_the_content()) { ?>        
                                                                <p><?php echo $c; ?></p>
                                        <?php } ?>
                                        <?php if ($gantry->get('contactpage-contactinfo')) { ?>
                                                                
                                        <?php if ($gantry->get('contactaddress')) { ?>
                                                                <span class="jaw_contact_span_title">Address</span>        
                                                                <p><?php echo nl2br($gantry->get('contactaddress')); ?></p>
                                        <?php } ?>

                                        <?php if ($gantry->get('contactpage-contactmail')) { ?>
                                                                <span class="jaw_contact_span_title">E-mail</span>
                                                                <p><?php echo ($gantry->get('contactemail')); ?></p>
                                        <?php } ?>    
                                                                    
                                        <?php if ($gantry->get('contactphone')) { ?>
                                                                <span class="jaw_contact_span_title">Phone</span>
                                                                <p><?php echo ($gantry->get('contactphone')); ?></p>
                                        <?php } 
                                        
                                        } // end contact info
                                        ?>

                                       <?php if ($gantry->get('contactpage-contactform')) { ?>
                                       
                                       <?php $options = array(
					    'mailto' => $gantry->get('contactpage-mailto'),
					    'captcha' => $gantry->get('contactpage-captcha'),
					    'thanks' => $gantry->get('contactpage-thanks'),
					    'subject' => $gantry->get('contactpage-subject'),
					    'error_name' => $gantry->get('contactpage-error_name'),
					    'error_mail' => $gantry->get('contactpage-error_mail'),
					    'error_text' => $gantry->get('contactpage-error_text'),
					    'error_captcha' => $gantry->get('contactpage-error_captcha'),
					    'label_name' => $gantry->get('contactpage-label_name'),
					    'label_mail' => $gantry->get('contactpage-label_mail'),
					    'submit_button' => $gantry->get('contactpage-submit_button')
		
					);

					$form = new jawcontactform(true,$options);
					$form->render(); ?>
				    <?php } ?>
                                                        </div>
                                                        <div class="clear"></div>
                                                    </div>
                                                </div>                     
                                            </div>                            
                                            </div>
                                        <?php } ?>
                                        <?php wp_reset_query(); ?>
                                        <?php } else { ?>

                                        <h1 class="rt-pagetitle">
                                            <?php _re('Sorry, no pages matched your criteria.'); ?>
                                        </h1>

                                        <?php } ?>


                                    </div>
                                </div> <!--  end rt-wordpress -->
                            </div> <!--  end main body -->

                        </div> <!--  end rt-block -->
                        <?php } ?>
                    </div> <!--  end main grid -->
                    <?php echo $fparams->sidebars; ?>
                    <div class="clear"></div>


                </div> <!--  end rt-conatiner -->
            </div> <!--  end rt-main -->
       <?php 
       }
        
          return ob_get_clean();
    }

}
