<?php

function jawtemplates_slide_add_css(){
  wp_enqueue_style('slides_meta_css', get_template_directory_uri() . '/post_types/slides/metaboxes/meta.css');  
}
if (is_admin()) {    
   add_action( 'admin_enqueue_scripts', 'jawtemplates_slide_add_css' );   
}

add_image_size( 'slides-admin', 150, 100, true );

/* post definition */
//http://codex.wordpress.org/Function_Reference/register_post_type
$labels = array(
    'name' => _x('Slides Manager', 'post type general name', "paula"),
    'singular_name' => _x('Slide', 'post type singular name', "paula"),
    'add_new' => _x('Add New', 'slide', "paula"),
    'add_new_item' => __('Add New Slide', "paula"),
    'edit_item' => __('Edit Slide', "paula"),
    'new_item' => __('New Slide', "paula"),
    'view_item' => __('Preview Slide', "paula"),
    'search_items' => __('Search Slides', "paula"),
    'not_found' => __('No slides found.', "paula"),
    'not_found_in_trash' => __('No slides found in Trash.', "paula"),
    'parent_item_colon' => '',
    'menu_name' => 'Slider Items',
    'description' => ''
);

register_post_type('jawslides', array(
    'label' => __('Slider options', "paula"),
    'labels' => $labels,
    'singular_label' => __('Slide', "paula"),
    'query_var' => "slide",
    'menu_position' => null,
    'show_ui' => true,
    'show_in_menu' => true,
    'hierarchical' => true,
    '_builtin' => false,
    'exclude_from_search' => true,
    'rewrite' => array("slug" => "slide"),  
    'capability_type' => 'page',
    'public' => true, 
    'supports' => array('title', 'thumbnail', 'page-attributes', 'editor')
));

// taxonomy
$labels_taxonomy = array(
    'name' => __('Slideshows', 'post type general name'),
    'all_items' => __('All Slideshows', 'all items'),
    'search_items' => __('Search Slideshow', 'search item'),
    'add_new_item' => __('Add New Slideshow', 'adding a new item'),
    'new_item_name' => __('New Slideshow Name', 'adding a new item'),
    
    
);

// taxonomy
$args_taxonomy = array(
    'labels' => $labels_taxonomy,
    'hierarchical' => true
);

//http://codex.wordpress.org/Function_Reference/register_taxonomy
register_taxonomy('slideshows', 'jawslides', $args_taxonomy);




/*
 Customize Manage Posts interface
*/

function add_columns_jawslide($columns) {

    $columns = array(
        "cb" => "<input type=\"checkbox\" />",
        
        "title" => __("Slide Title", "paula"),
        "slide_thumbnail" => __("Thumbnail", "paula"),
        "slideshows" => __("Slideshow", "paula"),
        "slide_type" => __("Slide Type", "paula"),
        "content" => __("Content", "jaw_theme"),
        "order" => __("Order", "paula")   
    );

    return $columns;
}

function custom_columns_slide($column) {
    global $post;
   
   //var_dump($post);
    
    switch ($column) {

        case "slide_thumbnail":
             if (has_post_thumbnail()) {
                     the_post_thumbnail('slides-admin');  
                } else {
                    _e("No featured image.", "paula");
                    
                    }
            
            
            break;

        case "slideshows":

            $slideshows = get_the_terms(0, "slideshows");
            $out = array();
            if ($slideshows) {
                foreach ($slideshows as $slideshow)
                    array_push($out, $slideshow->name);

                echo implode($out, ", ");
            }else{
               _e("No selected.", "paula"); 
                
            }
            break;

        case "slide_type":
             $type = get_post_meta(get_the_ID(), 'jaw_slide_linktype', TRUE);
            
            if ($type == "1") {
                _e("Open Lightbox", "paula");
            } else {
                $url = get_post_meta(get_the_ID(), 'jaw_slide_link', TRUE);
                if ($url) {
                    if (strlen($url)>50) $t='...';
                    else $t='';
                  echo '<a target="_blank" title="'.$url.'" href='.$url.'>'.mb_substr($url,0,50,'UTF-8').$t.'</a>';  
                }else{
                    _e("No url", "paula"); 
                }
               
            }
            break;
            
            case "order":
            echo $post->menu_order;
            break;
        
        case "content":
             if ($post->post_content) {
                    if (strlen($url)>50) $t='...';
                    else $t='';
                  echo mb_substr($post->post_content,0,50,'UTF-8').$t;  
                }
        
    }
}




function custom_columns_slide_sortable( $columns ) {

	$columns['order'] = 'order';

	return $columns;
}


add_filter( 'manage_edit-jawslides_sortable_columns', 'custom_columns_slide_sortable' );
add_filter("manage_edit-jawslides_columns", "add_columns_jawslide");
add_action("manage_pages_custom_column", "custom_columns_slide");

function jaw_slidesaved() {
    wp_redirect($_POST['_wp_http_referer']);
    exit;
}

$slide_metabox = new WPAlchemy_MetaBox(array
            (
            'id' => 'slides1',
            'title' => __("Slide Options", "paula"),
            'types' => array('jawslides'),
            'context' => 'normal',
            'priority' => 'high',
            'template' => get_theme_root() . '/paula/post_types/slides/metaboxes/metabox.php',
            'mode' => 'extract',
            'prefix' => 'jaw_',
            'save_action' => 'jaw_slidesaved'
        ));

?>