<?php
//remove_shortcode('gallery');
//add_shortcode('gallery','jawtheme_shortcode_gallery');
//add_filter('gallery','jawtheme_shortcode_gallery',10,2);
// Thank to Justin Tadlock (http://justintadlock.com)
function jawtheme_shortcode_gallery( $output, $attr ) {

    global $post;

	static $cleaner_gallery_instance = 0;
	$cleaner_gallery_instance++;

	/* We're not worried abut galleries in feeds, so just return the output here. */
	if ( is_feed() )
		return $output;

	/* Orderby. */
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}
	 /* Default gallery settings. */
	$defaults = array(
		'order' => 'ASC',
		'orderby' => 'menu_order ID',
		'id' => $post->ID,
		'link' => '',
		'itemtag' => 'dl',
		'icontag' => 'dt',
		'captiontag' => 'dd',
		'columns' => 3,
		'caption' => 'false',
		'lightboxtitle' => 'caption',//title,caption,none
		'size' => 'thumbnail',
		'include' => '',
		'exclude' => '',
		'numberposts' => -1,
		'offset' => ''
	);
    
    $attr = shortcode_atts( $defaults, $attr );
   
	extract( $attr );
	 
	
	/* Merge the defaults with user input. Make sure $id is an integer. */
	
	$id = intval( $id );

	/* Arguments for get_children(). */
	$children = array(
		'post_parent' => $id,
		'post_status' => 'inherit',
		'post_type' => 'attachment',
		'post_mime_type' => 'image',
		'order' => $order,
		'orderby' => $orderby,
		'exclude' => $exclude,
		'include' => $include,
		'numberposts' => $numberposts,
		'offset' => $offset,
	);

	/* Get image attachments. If none, return. */
	$attachments = get_children( $children );

	if ( empty( $attachments ) )
		return '';

	/* Properly escape the gallery tags. */
	$itemtag = tag_escape( $itemtag );
	$icontag = tag_escape( $icontag );
	$captiontag = tag_escape( $captiontag );
	$i = 0;

	/* Count the number of attachments returned. */
	$attachment_count = count( $attachments );



	/* Open the gallery <div>. */
	$output = "\n\t\t\t<div id='gallery-{$id}-{$cleaner_gallery_instance}' class='gallery gallery-{$id}'>";

	/* Loop through each attachment. */
	foreach ( $attachments as $id => $attachment ) {

		/* Open each gallery row. */
		if ( $columns > 0 && $i % $columns == 0 )
			$output .= "\n\t\t\t\t<div class='gallery-row'>";

		/* Open each gallery item. */
		$output .= "\n\t\t\t\t\t<{$itemtag} class='gallery-item col-{$columns}'>";

		/* Open the element to wrap the image. */
		$output .= "\n\t\t\t\t\t\t<{$icontag} class='gallery-icon'>";

		/* Add the image. */
		$img_src = wp_get_attachment_image_src($id, 'full');
		$img_src = $img_src[0];
                //var_dump($img_src);
		if (is_numeric($size)){
                    $img_attach='';
                    
                    $img_size = '&amp;w=' . $size;
                    
                }else{
                    $img_attach = 'attachment-' . $size;
                    $img_size = '&amp;w=132';
                }
		
		$img_alt = wptexturize( esc_html($attachment->post_excerpt) );
		
		if ( $img_alt == null )
			$img_alt = $attachment->post_title;
                 $rel = ' rel="prettyPhoto[post_gallery]"';
                 
		switch($lightboxtitle){
			case 'caption':
				$lightbox_title = wptexturize( esc_html($attachment->post_excerpt) );
				break;
			case 'title':
				$lightbox_title = $attachment->post_title;
				break;
			case 'none':
			default:
				$lightbox_title = '';
		}
		
		 //$output .= '<img src="' . get_template_directory_uri() . '/scripts/timthumb.php?src=' . $image[0] . '&amp;w=' . $image_width . '&amp;' . $image_h . '&amp;zc=1' . $image_src . '" alt="' . $item_title . '"  />';
                $image = '<img src="' . get_template_directory_uri() . '/scripts/timthumb.php?src=' . $img_src . $img_size.'&amp;zc=1" alt="' . $img_alt . '"  />';
		
		if(isset( $attr['link'] ) && 'file' == $attr['link']){
			$image = '<a href="' . $img_src . '" class="gallery-image-wrap" title="' . $lightbox_title . '" ' . $rel . '>'.$image.'</a>';
		}else{
                        $image = '<a href="' . $img_src . '" class="gallery-image-wrap" title="' . $lightbox_title . '">'.$image.'</a>';	
		}
		
		$output .= $image;
		
		/* Close the image wrapper. */
		$output .= "</{$icontag}>";
		
		/* Get the caption. */
		if($caption != 'false'){
			/* If image caption is set. */
			if ( !empty( $img_alt ) )
				$output .= "\n\t\t\t\t\t\t<{$captiontag} class='gallery-caption'>{$img_alt}</{$captiontag}>";
		}		

		/* Close individual gallery item. */
		$output .= "\n\t\t\t\t\t</{$itemtag}>";

		/* Close gallery row. */
		if ( $columns > 0 && ++$i % $columns == 0 )
			$output .= "\n\t\t\t\t</div>";
	}

	/* Close gallery row. */
	if ( $columns > 0 && $i % $columns !== 0 )
		$output .= "\n\t\t\t</div>";

	/* Close the gallery <div>. */
	$output .= "\n\t\t\t</div><!-- .gallery -->\n";

	/* Return out very nice, valid HTML gallery. */
	return $output;
}
