<?php
/**
 * @package   gantry
 * @subpackage widgets
 * @version   1.23 January 15, 2012
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */
defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');

add_action('widgets_init', array("GantryWidgetBreadcrumbs","init"));

class GantryWidgetBreadcrumbs extends GantryWidget {
    var $short_name = 'breadcrumbs';
    var $wp_name = 'gantry_breakcrumbs';
    var $long_name = 'Gantry Breadcrumbs';
    var $description = 'Gantry Breadcrumbs Widget';
    var $css_classname = 'widget_gantry_breadcrumbs';
    var $width = 200;
    var $height = 400;

    function init() {
        register_widget("GantryWidgetBreadcrumbs");
    }

    function render($args, $instance) {
        // set initial cunduct
        
        $showOnHome = (isset($instance['showonhome']))? $instance['showonhome'] : 0 ; // 1 - show breadcrumbs on the homepage, 0 - don't show
        if ($instance['delimiter']=='') $delimiter = '<span class="breadcrumb-separator"></span>';
        else $delimiter = $instance['delimiter']; // delimiter between crumbs
        $home = $instance['hometext']; // text for the 'Home' link
        $showCurrent = $instance['showcurrent'];// 1 - show current post/page title in breadcrumbs, 0 - don't show
        $before = '<span class="current">'; // tag before the current crumb
        $after = '</span>'; // tag after the current crumb

        global $post;
        $homeLink = get_home_url();
        //ob_start();
        //echo '<div class="breadcrumbs">';
        if (is_home() || is_front_page()) {

            if ($showOnHome == 1 && $home!='')
                echo '<div class="breadcrumbs"><a href="' . $homeLink . '">' . $home . '</a></div>';
        } else {
           if ($home!='')
                echo '<div class="breadcrumbs"><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';

            if (is_category()) {
                global $wp_query;
                $cat_obj = $wp_query->get_queried_object();
                $thisCat = $cat_obj->term_id;
                $thisCat = get_category($thisCat);
                $parentCat = get_category($thisCat->parent);
                if ($thisCat->parent != 0)
                    echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
                echo $before . single_cat_title('', false)  . $after;
            } elseif (is_day()) {
                echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
                echo '<a href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
                echo $before . get_the_time('d') . $after;
            } elseif (is_month()) {
                echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
                echo $before . get_the_time('F') . $after;
            } elseif (is_year()) {
                echo $before . get_the_time('Y') . $after;
            } elseif (is_single() && !is_attachment()) {
                if (get_post_type() != 'post') {
                    $post_type = get_post_type_object(get_post_type());
                    $slug = $post_type->rewrite;
                    echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a> ' . $delimiter . ' ';
                    if ($showCurrent == 1)
                        echo $before . get_the_title() . $after;
                } else {
                    $cat = get_the_category();
                    $cat = $cat[0];
                    echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                    if ($showCurrent == 1)
                        echo $before . get_the_title() . $after;
                }
            } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
                $post_type = get_post_type_object(get_post_type());
                echo $before . $post_type->labels->singular_name . $after;
            } elseif (is_attachment()) {
                $parent = get_post($post->post_parent);
                $cat = get_the_category($parent->ID);
                $cat = $cat[0];
                echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a> ' . $delimiter . ' ';
                if ($showCurrent == 1)
                    echo $before . get_the_title() . $after;
            } elseif (is_page() && !$post->post_parent) {
                if ($showCurrent == 1)
                    echo $before . get_the_title() . $after;
            } elseif (is_page() && $post->post_parent) {
                $parent_id = $post->post_parent;
                $breadcrumbs = array();
                while ($parent_id) {
                    $page = get_page($parent_id);
                    $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
                    $parent_id = $page->post_parent;
                }
                $breadcrumbs = array_reverse($breadcrumbs);
                foreach ($breadcrumbs as $crumb)
                    echo $crumb . ' ' . $delimiter . ' ';
                if ($showCurrent == 1)
                    echo $before . get_the_title() . $after;
            } elseif (is_search()) {
                //echo $before . 'Search results for "' . get_search_query() . '"' . $after;
                echo $before . get_search_query() . $after;
            } elseif (is_tag()) {
                //echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
                echo $before  . single_tag_title('', false) . $after;
            } elseif (is_author()) {
                global $author;
                $userdata = get_userdata($author);
                //echo $before . 'Articles posted by ' . $userdata->display_name . $after;
                echo $before . $userdata->display_name . $after;
            } elseif (is_404()) {
                //echo $before . 'Error 404' . $after;
                echo $before . $after;
            }
           
            if ($home!='')
	      echo '</div>';



            
            
            
           // echo ob_get_clean();
          //echo '</div>';  
        }

    }
}