<?php
defined('GANTRY_VERSION') or die();
gantry_import('core.gantrywidget');
add_action('widgets_init', array("GantryWidgetJawLoginForm","init"));

class GantryWidgetJawLoginForm extends GantryWidget {
    var $short_name = 'jawloginform';
    var $wp_name = 'gantry_jwaloginform';
    var $long_name = 'JaW Login Form';
    var $description = 'JaW Login Form Widget';
    var $css_classname = 'widget_gantry_jawloginform';
    var $width = 200;
    var $height = 400;

    function init() {
        register_widget("GantryWidgetJawLoginForm");
    }
    
    function render_title($args, $instance) {
    	global $gantry;
    	if($instance['title'] != '') :
    		echo $instance['title'];
    	endif;
    }

    function render($args, $instance){
        global $gantry, $current_user;
	    ob_start();
	    ?>
    	
    	<?php if(!is_user_logged_in()) : ?>
		
			<form id="form-login" action="<?php echo wp_login_url(get_site_url()); ?>" method="post">
				
			    <div class="form-login-username" >
				  <input id="modlgn_username" type="text" name="log"  class="inputbox" alt="username" value="<?php _re('Username'); ?>" onfocus="if (this.value=='<?php _re('Username'); ?>') this.value=''" onblur="if(this.value=='') { this.value='<?php _re('Username'); ?>'; return false; }" />
				<div class="info">
                                                <input type="checkbox" name="rememberme" class="checkbox" alt="<?php _re('Remember Me'); ?>" />
						<label class="rememberme" ><?php _re('Remember Me'); ?></label>
                                            </div>	
			    </div>
			    <div class="form-login-password">
				<input id="modlgn_passwd" type="password" class="inputbox" name="pwd" alt="password" value="<?php _re('Password'); ?>" onfocus="if (this.value=='<?php _re('Password'); ?>') this.value=''" onblur="if(this.value=='') { this.value='<?php _re('Password'); ?>'; return false; }" />
				<div class="info">
				<a href="<?php echo wp_lostpassword_url(); ?>"><?php _re('Forgot your password?'); ?></a>
</div>	
			    </div>
			    <div class="form-login-submit">
				  <input  type="submit" value="<?php _re('Login'); ?>" class="button" name="submit" />
			    </div>



		    <div class="clear"></div>
			     	
               			
				<div>
                <ul class="bullet-help">
					
			  <?php if(get_option('users_can_register')) : ?>
                    
					<li>
						<a href="<?php echo site_url(); ?>/wp-login.php?action=register"><?php _re('Register new user'); ?></a>
					</li>
                    
					<?php endif; ?>
                 </ul>
                 
					
				</div>				
			</form>
			
		<?php else : ?>
		
			<form id="form-login" action="<?php echo wp_logout_url(get_bloginfo('url')); ?>" method="post">
				<fieldset class="input">
					
					<div class="user-greeting">
						<b><?php echo $instance['user_greeting']; ?> <?php echo $current_user->display_name; ?></b><br />
					</div>
					<div class="readon"><input type="submit" name="Submit" class="button" value="Log out" /></div>
		
				</fieldset>
			</form>
		
		<?php endif; ?>
    	
	    <?php 
	    
	    echo ob_get_clean();
	
	}
}
