<?php

defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');


add_action('widgets_init', array("GantryWidgetJawSocial", "init"));
add_action('jawsocialform_post', array("GantryWidgetJawSocial", 'gantry_flush_widget_cache'));
add_action('transition_jawsocial_status', array("GantryWidgetJawSocial", 'gantry_flush_widget_cache'));


class GantryWidgetJawSocial extends GantryWidget {

    var $short_name = 'jawsocial';
    var $wp_name = 'gantry_jawsocial';
    var $long_name = 'JaW Social Icons';
    var $description = 'JaW Social Networks Widget';
    var $css_classname = 'widget_gantry_jawsocial';
    var $width = 200;
    var $height = 400;

    function init() {
        register_widget("GantryWidgetJawSocial");
    }

    
    function gantry_flush_widget_cache() {
        wp_cache_delete('gantry_jawsocial', 'widget');
    }
    
   
    
    function render($args, $instance) {
       
       
        $cache = wp_cache_get('gantry_jawsocial', 'widget');
        if (!is_array($cache))
            $cache = array();

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }
        
        ob_start(); ?>
            <ul class="jaw-social-ul">
                
                    <?php if ($instance['facebook']!=''){ ?>
                        <li class="ico_facebook"><a href="http://www.facebook.com/<?php echo $instance['facebook']; ?>"> </a></li>  
                    <?php }
                        if ($instance['linkedin']!=''){  ?>
                        <li class="ico_linkedin"><a href="http://www.linkedin.com/<?php echo $instance['linkedin']; ?>"> </a></li>
                    <?php }
                        if ($instance['twitter']!=''){  ?>
                        <li class="ico_twitter"><a href="https://twitter.com/<?php echo $instance['twitter']; ?>"> </a></li>
                    <?php }
                        if ($instance['digg']!=''){  ?>
                        <li class="ico_digg"><a href="http://digg.com/<?php echo $instance['digg']; ?>"> </a></li>
                    <?php }
                        if ($instance['flickr']!=''){  ?>
                        <li class="ico_flickr"><a href="http://www.flickr.com/photos/<?php echo $instance['flickr']; ?>"> </a></li>
                    <?php } ?>
          </ul>
        <?php 
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('gantry_jawsocial', $cache, 'widget');
    
    }
}