<?php
/**
 * @version		1.24 June 26, 2012
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Widget based on the WordPress core Recent Posts Widget.
 */
/*
 * JAW Templates
 */

defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');

add_action('widgets_init', array("GantryWidgetRecentPosts", "init"));
add_action('comment_post', array("GantryWidgetRecentPosts", 'gantry_flush_widget_cache'));
add_action('transition_comment_status', array("GantryWidgetRecentPosts", 'gantry_flush_widget_cache'));

class GantryWidgetRecentPosts extends GantryWidget {

    var $short_name = 'recentposts';
    var $wp_name = 'gantry_recentposts';
    var $long_name = 'Gantry Recent Posts';
    var $description = 'Gantry Recent Posts Widget';
    var $css_classname = 'widget_gantry_recentposts';
    var $width = 200;
    var $height = 400;

    function gantry_flush_widget_cache() {
        wp_cache_delete('gantry_recentposts', 'widget');
    }

    function init() {
        register_widget("GantryWidgetRecentPosts");
    }

    /*function render_title($args, $instance) {
        global $gantry;
        if ($instance['title'] != '') :
            echo $instance['title'];
        endif;
    }*/

    function render($args, $instance) {
        global $gantry;

        ob_start();

        $menu_class = $instance['custom-variations'];
        $number = $instance['number'];
        $cat = $instance['cat'];
        $rss = $instance['rss'];
        $title = $instance['title'];

        

        if (!$number = (int) $instance['number'])
            $number = 10;
        else if ($number < 1)
            $number = 1;
        else if ($number > 15)
            $number = 15;

        $cache = wp_cache_get('gantry_recentposts', 'widget');

        if (!is_array($cache))
            $cache = array();

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }

        
        if (strlen($rss) > 0 && $menu_class =='title1') {
            ?>
            
                <div class="jaw-latestarticle-title">
                    <h2 class="title" style="visibility: visible;"><?php echo $title; ?></h2>
                </div>
                <div class="jaw-latestarticle-image">
            <?php if (strlen($rss) > 0) { ?>
                        <a class="jaw-latestarticle-rss-icon" href="<?php echo $rss ?>">
                        </a>
                    <?php } else { ?>
                        <img src="<?php echo get_template_directory_uri(); ?>/images/body/rss.gif">
            <?php } ?>
                </div>
                <div class="clear"></div>
            
        <?php } else { ?>
                <div class="module-title">
                    <h2 class="title" style="visibility: visible;">
                         <?php echo $title; ?>   
                    </h2>
                </div>
            <?php } ?>

        <div class="jaw-latestarticle">


       <?php
       $rp = new WP_Query(array('showposts' => $number, 'nopaging' => 0, 'post_status' => 'publish', 'ignore_sticky_posts' => 1, 'cat' => $cat));
       if ($rp->have_posts()) : ?>

        <ul class="rp_posts_popular <?php echo $menu_class; ?>">
        <?php $count = 1; ?>
        <?php while ($rp->have_posts()) : 
            $rp->the_post();
            $image = wp_get_attachment_image_src ( get_post_thumbnail_id ( get_the_ID()), 'single-post-thumbnail' );
            $categorie = get_the_category();
            ?>
        <?php if ($count == $number) {
                $class = 'class="last-item"';
            }else{$class='';} ?>
                <li <?php echo $class; ?>>
                    <?php
                if (!$image[0]) {
                    // nacteni cesty k obrazku
                    preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i', get_the_content(), $imgsrc);
                    // cesta k obrazku
                    $image[0] = $imgsrc[1];
                }
                ?>
                <?php if($image[0]) { ?>
                <a href="<?php echo the_permalink(); ?>">
                    <img class="rp_thumb" src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $image[0]; ?>&amp;h=65&amp;w=106&amp;zc=1&amp;f=2" alt="img" />
                    <img style="display: none;" class="rp_thumb" src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $image[0]; ?>&amp;h=65&amp;w=106&amp;zc=1" alt="img" />
                </a>
                <?php } ?> 
                    <a class="rp_title" href="<?php echo the_permalink() ?>"><?php echo get_the_title() ?></a>
                <div class="jaw-latestarticle-info">
                    <div class="rp_cat"><a href="<?php echo get_category_link($categorie[0]); ?>"><?php echo $categorie[0]->cat_name; ?></a></div>
                    <div class="rp_date"><?php echo get_the_date(); ?></div>
                </div>
                <div class="clear"></div>
            </li>
            <?php $count++ ?>
            <div class="clear"></div>
                    
                    
                    
                  
        <?php endwhile; ?>

         </ul>


        <?php
        // Reset the global $the_post as this query will have stomped on it
        wp_reset_postdata();

        endif; ?>
</div>
        <?php $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('gantry_recentposts', $cache, 'widget');
    }

}