<?php
/**
 * @version		1.0 6.3.2012
 * @author		J&W Templates http://www.jawtemplates.com
 * @copyright           Copyright (C) 2011 - 2012 CCB spol. s.r.o.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */
defined('GANTRY_VERSION') or die();
/**
 * @package     gantry
 * @subpackage  admin.elements
 */
gantry_import('core.config.gantryformfield');

class GantryFormFieldJawSlider extends GantryFormField {

    protected $type = 'jawslider';
    protected $basetype = 'hidden';
    protected $children = array();

	public function getInput()
	{
		global $gantry;
		$output = '';


		$this->template = end(explode(DS, $gantry->templatePath));

        $class = $this->element['class'] ? $this->element['class'] : '';
        $name = $this->element['name'] ? $this->element['name']:'';
        $inputsize = $this->element['inputsize'] ? $this->element['inputsize']:'2';
        $slidersize = $this->element['slidersize'] ? $this->element['slidersize']:'192px';
        $node = $this->element;
        $control_name = $this->name;

		if (!defined('GANTRY_CSS')) {
			$gantry->addStyle($gantry->gantryUrl.'/admin/widgets/gantry.css');
			define('GANTRY_CSS', 1);
		}
        if (!defined('GANTRY_POSITIONS')) {
            $gantry->addScript($gantry->gantryUrl.'/admin/widgets/slider/js/slider.js');
			if (!defined('GANTRY_SLIDER')) define('GANTRY_SLIDER', 1);
        }

		if (!defined('GANTRY_SLIDERS_UTILS')){
			$gantry->addScript($gantry->gantryUrl.'/admin/widgets/slider/js/slider-utils.js');
			define('GANTRY_SLIDERS_UTILS', 1);
		}
		
		foreach($node->children() as $children) {
			$this->children[] = $children->data();
		}
		
		$gantry->addDomReadyScript($this->sliderInit($this->id));
		
		$output = '
		<div class="wrapper">
                    <div id="'.$this->id.'-wrapper" class="'.$class.'">
                            <!--<div class="note">
                                    Internet Explorer 6 supports only the <strong>Low Quality</strong> setting.
                            </div>-->
                            <div>
                                <div style="float:left;width:'.$slidersize.'" class="slider">
                                    <div class="slider2"></div>
                                        <div class="knob"></div>

                                </div>
                                <div style="margin-left:10px;float:right;">
                                    <input size="'.$inputsize.'" type="text" style="text-align:center" id="'.$this->id.'" name="'.$this->name.'" value="'.$this->value.'" />
                                </div>
                            </div>    


                    </div>
		</div>
		';
		
		return $output;
	}
	
	function sliderInit($name) {
		$steps = count($this->children) - 1;
		$current = array_search($this->value, $this->children);
		if ($current === false) $current = 0;
		$children = '[\'' . implode("', '", $this->children) . '\']';
		
		// id, children, current
		return "GantrySliders.add('".$this->id."', ".$children.", ".$steps.", ".$current.");";
	}
}

?>