<?php
$active_plugins = get_option('active_plugins');
include'sliders/functions-init.php';
if (!in_array('gantry/gantry.php', $active_plugins)) {
    if (!is_admin()) {
        add_filter('template_include', 'gantry_missing_nag', -10, 0);
    } else {
        add_action('admin_notices', 'gantry_admin_missing_nag');
    }
}

function gantry_admin_missing_nag() {
    $msg = __('The active theme requires the Gantry Framework Plugin to be installed and active');
    echo "<div class='update-nag'>$msg</div>";
}

function gantry_missing_nag() {
    echo "This theme requires the Gantry Framework Plugin to be installed and active.";
    die(0);
}
 load_theme_textdomain('paula',  get_template_directory().'/languages/');
 
// This will always set the Posts Per Page option to 1 to fix the WordPress bug
// when the pagination would return 404 page. To set the number of posts shown
// on the blog page please use the field under Theme Settings > Content > Blog > Post Count
function gantry_posts_per_page() {
    if (get_option('posts_per_page') != '1')
        update_option('posts_per_page', '1');
}

add_action('init', 'gantry_posts_per_page');



// JAW templates definition
include_once (get_template_directory() . '/lib/MetaBox.php');

// load custom post_types
require_once (get_template_directory() . '/post_types/slides/slide.php');
require_once (get_template_directory() . '/post_types/portfolio/portfolio.php');

// Pagination
include (get_template_directory() . '/lib/pagination.php');

// jaw contact form
include (get_template_directory() . '/lib/jawcontactform.php');

// Load shortcodes
include (get_template_directory() . '/shortcodes/portfolios.php');
//include (get_template_directory() . '/shortcodes/gallery.php');
include (get_template_directory() . '/shortcodes/media.php');
include (get_template_directory() . '/shortcodes/gmap.php');
include (get_template_directory() . '/shortcodes/layout.php');
include (get_template_directory() . '/shortcodes/typography.php');

//themplate defaults
add_editor_style('custom-editor-style.css');
add_theme_support('automatic-feed-links');
add_theme_support('post-thumbnails');
add_image_size('homepage-thumb', 220, 180);

// info this items are located in gantry plugin or gantry functions
// nav_menu, add_theme_support( 'custom-header', $args ),add_theme_support( 'custom-background', $args ),wp_head,wp_footer,register_sidebar()
// language_attributes,dynamic_sidebar,comments_templat,comment_form,body_class



global $content_width;
if (!isset($content_width)) {$content_width = 930;}

/* INSTALL SAMPLE DATA */
if ( $_POST['importdata'] == 1 ) {
    require_once (TEMPLATEPATH . '/sample/install.php');
    require_once(ABSPATH . "wp-admin/includes/taxonomy.php");
    require_once(ABSPATH . "wp-admin/includes/post.php");
    require_once(ABSPATH . "wp-admin/includes/comment.php");
    require_once(ABSPATH . "wp-admin/includes/image.php");
    
    rockettheme_custom_install();
}


/* Initialize translation mechanism */
//load_theme_textdomain( 'paula', get_template_directory().'/languages' );

/* Tags cloud font size filter */
add_filter('widget_tag_cloud_args', 'my_widget_tag_cloud_args');

function my_widget_tag_cloud_args($args) {
    $args = array(
        //'number' => 15,
        'smallest' => 11,
        'largest' => 11,
        'unit' => 'px');
    return $args;
}

if (is_admin()) {
    global $pagenow;
    if ($pagenow == "widgets.php") {
        add_action("admin_notices", 'jaw_widgets_admin_insert_override_header', 300);
    }
}

function jaw_widgets_admin_insert_override_header() {
    global $current_screen;
    if ($current_screen->id == 'widgets') {
        ob_start();
        ?>
        <div style="margin:0 15px 0px 5px;float:right">
            <div style="width:283px;padding:0px 10px;">
                <h2 style="margin-bottom:2px"><a target="_blank" href="<?php echo get_template_directory_uri(); ?>/help/index.html">Help with Widgets</a></h2>
                <span>Widgets description and variation. </span>
            </div>
            <div class="clean"></div>       
        </div>

        <?php
        echo $buffer = ob_get_clean();
    }
}