<?php
/**
 * @version		1.24 June 26, 2012
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

defined('GANTRY_VERSION') or die();

gantry_import('core.gantrygizmo');

/**
 * @package     gantry
 * @subpackage  features
 */
class GantryGizmoStyleDeclaration extends GantryGizmo {
    var $_name = 'styledeclaration';
    
    function HexToRGB($hex) {
        $hex = str_replace("#", "", $hex);
        $color = array();

        if (strlen($hex) == 3) {
            $color['r'] = hexdec(substr($hex, 0, 1) . $r);
            $color['g'] = hexdec(substr($hex, 1, 1) . $g);
            $color['b'] = hexdec(substr($hex, 2, 1) . $b);
        } else if (strlen($hex) == 6) {
            $color['r'] = hexdec(substr($hex, 0, 2));
            $color['g'] = hexdec(substr($hex, 2, 2));
            $color['b'] = hexdec(substr($hex, 4, 2));
        }

        return $color;
    }

    function isEnabled() {
        global $gantry;
        $menu_enabled = $this->get('enabled');

        if (1 == (int)$menu_enabled) return true;
        return false;
    }

	function query_parsed_init() {
        
        global $gantry;
        $css  = '';
        if ($gantry->get('cssstyle') == 'custom') {

            $mainColor = GantryGizmoStyleDeclaration::HexToRGB($gantry->get('maincolor'));   
            $hex = str_replace("#", "", $gantry->get('maincolor'));            
            $mainColorHex = "#".$hex;
            $hex = str_replace("#", "", $gantry->get('bgcolor'));            
            $backgroundColorHex = "#".$hex;
            $hex = str_replace("#", "", $gantry->get('linkcolor'));            
            $linkColorHex = "#".$hex;
            $hex = str_replace("#", "", $gantry->get('linkhovercolor'));            
            $linkHoverColorHex = "#".$hex;
            
            // Body background
            $css  = 'body {background:'.$backgroundColorHex.';}';
            
            // Links colors
            $css .= 'a {color: '.$linkColorHex.';}';
            $css .= 'a:hover {color: '.$linkHoverColorHex.';}';
            $css .= 'ul.rp_posts_popular li .rp_cat a {color: '.$linkColorHex.';}';
            $css .= 'ul.rp_posts_popular li .rp_cat a:hover {color: '.$linkHoverColorHex.';}';
            
            // All colors
            $css .= '#rt-logo-content {background: rgb('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].');}';
            $css .= '#rt-logo-content {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.92);}';
            $css .= '#rt-logo-background {background: rgb('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].');}';
            $css .= '#rt-logo-background {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.92);}';
            
            // Slider color
            $css .= '#rt-slider .slider_shadow .post_category a, #rt-slider .bigimg .post_category a {background: rgb('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].');}';
            $css .= '#rt-slider .slider_shadow .post_category a, #rt-slider .bigimg .post_category a {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.92);}';
            $css .= '#rt-slnav .slider .minus, .plus {background: '.$mainColorHex.';}';
            
            // Pagination
            $css .= '.rt-pagination-content ul li span {background: '.$mainColorHex.';}';
            $css .= '.rt-pagination li a:hover {background: '.$mainColorHex.'; border-color: '.$mainColorHex.' !important;}';
            
            // Main menu
            $css .= '#rt-menu ul.menu li a:hover, .menutop li.root > .item:hover, .menutop li.active.root.f-mainparent-itemfocus > .item, .menutop li.root.f-mainparent-itemfocus > .item, .menu-type-splitmenu .menutop li:hover > .item {background: '.$mainColorHex.' url("wp-content/themes/paula/images/menus/menu_line.png") 0 0 repeat-x;color: #fefefe;}';
            $css .= '#rt-menu ul.menu li.active a:hover, #rt-menu ul.menu li.active:hover a:hover, .menutop li.root.active:hover > .item, .menutop li.root.active:hover > .item:hover {background: '.$mainColorHex.' url("wp-content/themes/paula/images/menus/menu_line.png") 0 0 repeat-x;color: #fefefe;}';
            $css .= '.menutop li.root.active:hover {background: '.$mainColorHex.' url("wp-content/themes/paula/images/menus/menu_line.png") 0 0 repeat-x;color: #fff;}';  
            $css .= '.menutop li.root.f-mainparent-itemfocus {background: '.$mainColorHex.' url("wp-content/themes/paula/images/menus/menu_line.png") 0 0 repeat-x}';
            $css .= '.menutop ul li > .item:hover, .menutop ul li.f-menuparent-itemfocus > .item {background: '.$mainColorHex.' url("wp-content/themes/paula/images/menus/menu_line.png") 0 0 repeat-x;color: #eee;}';
            
            // Contact widget
            $css .= '.jaw_mod_contact .fc_mod_submit {background: '.$mainColorHex.';}';
            $css .= '.jaw_mod_contact .fc_mod_submit:hover {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.85);}';
            
            // Comments style
            $css .= 'ul.jcomments-latesttitle2 .comment a:hover {color: '.$mainColorHex.';}';
            
            // Latest post
            $css .= 'ul.rp_posts_popular li a:hover {color: '.$mainColorHex.';}';   
            
            // Title color
            $css .= '.title a:hover {color: '.$mainColorHex.';}';
            
            // Breadcrumb
            $css .= '.rt-blog-breadcrumbs2 .breadcrumbs span {color: '.$mainColorHex.';}';
            $css .= '.breadcrumbs span {color: '.$mainColorHex.';}';
            
            // Button style
            $css .= '.button {background-color: '.$mainColorHex.'; color: #FEFEFE;}';
            $css .= '.button:hover {background: rgb('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].');}';
            $css .= '.button:hover {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.85);}';
            
            // HIGHLIGHT
            $css .= '.highlight {background: none repeat scroll 0 0 '.$mainColorHex.';}';
            
            // Comment Buttons
            $css .= '#comments .comments-buttons a {background-color: '.$mainColorHex.';}';
            $css .= '#comments .comments-buttons a:hover {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.85);}';
            $css .= '#cancel-comment-reply-link {background-color: '.$mainColorHex.';}';
            $css .= '#cancel-comment-reply-link:hover {background: rgba('.$mainColor[r].','.$mainColor[g].','.$mainColor[b].', 0.85);}';
            
            //
            $css .= '.widget_calendar #wp-calendar caption {color: '.$mainColorHex.';}';
            
            //
            $css .= '.tagcloud a:hover, .rt-tags a:hover {background-color: '.$mainColorHex.';}';
            $css .= '.blog-info .rt-sticky {background-color: '.$mainColorHex.';}';

            $gantry->addInlineStyle($css);
            
        } else {
            $css  .= 'body {background:'.$gantry->get('background-color') .'}';
            $gantry->addInlineStyle($css);
        }

        // add inline css from the Custom CSS field
        $gantry->addInlineStyle($gantry->get('customcss'));

        //style stuff
        $gantry->addStyle($gantry->get('cssstyle').".css");
	}

}