<?php
/**
 * @version   1.24 June 26, 2012
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 */
defined('GANTRY_VERSION') or die();

gantry_import('core.gantrybodylayout');

/**
 *
 * @package gantry
 * @subpackage html.layouts
 */
class GantryLayoutBody_MainBody extends GantryBodyLayout {
    var $render_params = array(
        'schema'        =>  null,
        'pushPull'      =>  null,
        'classKey'      =>  null,
        'sidebars'      =>  '',
        'contentTop'    =>  null,
        'contentBottom' =>  null
    );

    function render($params = array()) {
        global $gantry;
        
        $blog_style = null;
        $fparams = $this-> _getParams($params);

        // logic to determine if the component should be displayed
        $display_component = !($gantry->get("component-enabled", true) == false);
        ob_start();
        // XHTML LAYOUT
        ?>
        <?php
	    $show_breadcrumb = 1;
            $custom_page_title = null;
            $custom_page_decs = null;
            
            if (is_category()) {
                $blog_style = $gantry->get('category-categoryblogstyle');
                $custom_page_title = $gantry->get('category-categorytitle');
                $custom_page_decs = $gantry->get('category-categorydesc');
                $show_breadcrumb = 0;
            }

            if (is_day() || is_month() || is_year() || is_author()) {
                $blog_style = $gantry->get('archive-categoryblogstyle'); 
            }

            if (is_tag()) {
                $blog_style = $gantry->get('tags-categoryblogstyle');
            }
            
            if (is_search()) {
                $blog_style = $gantry->get('search-categoryblogstyle');
            }
            
             if (is_home() || is_front_page()) {
                $blog_style = $gantry->get('blog-categoryblogstyle');
                $custom_page_title = $gantry->get('blog-categorytitle');
                $custom_page_decs = $gantry->get('blog-categorydesc');
            }
                
            $post_style = $gantry->get('post-poststyle');
            
        ?>
        <div id="rt-main" class="<?php echo $fparams->classKey; ?>">
            <div class="rt-container">
                
                <?php if ($blog_style == 'blog1b' || $blog_style == 'blog1s' || $blog_style == 'blogfullb' || $blog_style == 'blogfulls') { ?>                    
                
                <?php if ($custom_page_title || $custom_page_decs ) { ?>
                        <div class="rt-blog-description">
                        <?php if ( strlen($custom_page_title) != 0 ) { ?>
                            <h2><?php echo $custom_page_title; ?></h2>
                        <?php } ?>
                        <?php if ( strlen($custom_page_decs) != 0 ) { ?>
                            <p><?php echo $custom_page_decs; ?></p>
                        <?php } ?> 
                            <?php /** Begin breadcrumbs * */ if ($gantry->countModules('breadcrumb')) : ?>
                                <div id="rt-breadcrumbs">
                                    <div class="rt-container">
                                        <?php echo $gantry->displayModules('breadcrumb', 'standard', 'standard'); ?>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                            <?php /** End breadcrumbs * */ endif; ?> 
                         </div>
                 <?php } ?>
                <?php } else { ?>
                    <?php if ($show_breadcrumb) { ?>
                    <?php if(!is_home() && !is_front_page()) { ?>
                        <?php /** Begin breadcrumbs * */ if ($gantry->countModules('breadcrumb')) : ?>
                            <div class="rt-blog-description">
                                <div id="rt-breadcrumbs">
                                    <div class="rt-container">
                                        <?php echo $gantry->displayModules('breadcrumb', 'standard', 'standard'); ?>
                                        <div class="clear"></div>
                                    </div>
                                </div>
                            </div>
                        <?php /** End breadcrumbs * */ endif; ?>
                        <?php } ?>
                    <?php } ?>
                <?php } ?>
                <?php if (is_home()) { ?>
                <?php echo $fparams->sidebars; ?>
                <div class="rt-grid-<?php echo $fparams->schema['mb']; ?> <?php echo $fparams->pushPull[0]; ?> main_right">
                <?php if (isset($fparams->contentTop)) : ?>

                    <div id="rt-content-top">
                    <?php echo $fparams->contentTop; ?>
                        </div>
                <?php endif; ?>

                    <div class="rt-block">
                    <?php if ($display_component) : ?>

                        <div id="rt-mainbody">
                            <?php $this->include_type();?>
                        </div>
                    <?php endif; ?>
                        </div>
                <?php if (isset($fparams->contentBottom)) : ?>

                    <div id="rt-content-bottom">
                    <?php echo $fparams->contentBottom; ?>
                        </div>
                <?php endif; ?>
                    </div>
                <?php } else { ?>
                <?php if ( $blog_style == 'blogfulls' || $blog_style == 'blogfullb' || $post_style == "itemfulls" || $post_style == "itemfullb" || $blog_style == 'searchfulls' || $blog_style == 'searchfullb' ) { ?>
                <div class="rt-grid-12 <?php echo $fparams->pushPull[0]; ?>">
                <?php } else { ?>
                <div class="rt-grid-<?php echo $fparams->schema['mb']; ?> <?php echo $fparams->pushPull[0]; ?>">
                <?php } ?>
                <?php if (isset($fparams->contentTop)) : ?>

                    <div id="rt-content-top">
                    <?php echo $fparams->contentTop; ?>
                        </div>
                <?php endif; ?>

                    <div class="rt-block">
                    <?php if ($display_component) : ?>

                        <div id="rt-mainbody">
                            <?php $this->include_type();?>
                        </div>
                    <?php endif; ?>
                        </div>
                <?php if (isset($fparams->contentBottom)) : ?>

                    <div id="rt-content-bottom">
                    <?php echo $fparams->contentBottom; ?>
                        </div>
                <?php endif; ?>
                    </div>
                    <?php if ( $blog_style == 'blogfulls' || $blog_style == 'blogfullb' || $post_style == "itemfulls" || $post_style == "itemfullb" || $blog_style == 'searchfulls' || $blog_style == 'searchfullb' ) { ?>    
                    <?php } else { ?>
                    <?php echo $fparams->sidebars; ?>                    
                    <?php } ?>  
                <?php } ?>                
                <div class="clear"></div>
            </div>
        </div>
        <?php
                return ob_get_clean();
    }
}