<?php
/**
 * @version   1.23 January 15, 2012
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */
defined('GANTRY_VERSION') or die();

gantry_import('core.gantrylayout');

/**
 *
 * @package gantry
 * @subpackage html.layouts
 */
class GantryLayoutComment_Basic extends GantryLayout {

    var $render_params = array(
        'comment' => null,
        'depth' => 0,
        'args' => array()
    );

    function render($params = array()) {
        global $gantry;
        $fparams = $this->_getParams($params);
    }

    function render_comment($comment, $args, $depth) {
        ob_start();
        $GLOBALS['comment'] = $comment;

        $commentBoxIndentStyle = ' avatar-indent';
        ?>

        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
            <div id="comment-<?php comment_ID(); ?>" class="comment-div-wrapper">

                <div class="comment-author vcard" style="line-height: 50px;">

                    <div class="comment_gravatar_wrapper">
                        <?php 
                            $avatar_img = get_template_directory_uri().'/images/body/icon-user.png'; 
                            $avatar = get_avatar($comment->comment_author_email, $size=40,$avatar_img);
                            $avatar = str_replace("class='", "class='rt-image ", $avatar);
                        ?>
                        <?php echo $avatar; ?>
                    </div>

                    <!--<div class="comment-meta commentmetadata">
                        <?php printf(_r('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
                        <div class="comment-meta-time">
                            <a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)) ?>"><?php printf(_r('%1$s at %2$s'), get_comment_date(), get_comment_time()) ?></a>
                            <?php edit_comment_link(_r('(Edit)'), '  ', '') ?>
                        </div>
                    </div>-->
                    
                    <div class="comment-info">
                        <span class="comment-author"><?php echo get_comment_author_link(); ?></span>
                        <span class="comment-date"><?php echo get_comment_date(); ?></span>
                    </div>
                    
                    <div class="comment-body">
                        <?php comment_text() ?>
                        <span class="comments-buttons"><?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></span>
                    </div>

                    <div class="clr"></div>

                </div>

                <?php if ($comment->comment_approved == '0') : ?>

                    <span class=""><?php _re('Your comment is awaiting moderation.') ?></span>

                <?php endif; ?>


                <div class="clr"></div>

            </div>

            <?php
            echo ob_get_clean();
            return;
        }

    }