<?php
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$readmore_text = $gantry->get('readmore-text');

$query = $wp_query->query;
if (!is_array($query))
    parse_str($query, $query);

$custom_query = new WP_Query(array_merge($query, array('posts_per_page' => $gantry->get('search-count'), 'paged' => $paged)));
?>

<?php if ($custom_query->have_posts()) : ?>

    <?php if ($gantry->get('search-page-title')) : ?>

        <h1 class="rt-pagetitle">
            <?php _re('Search Results for'); ?>&nbsp;&#8216;<?php the_search_query(); ?>&#8217;
        </h1>

    <?php endif; ?>

    <?php while ($custom_query->have_posts()) : $custom_query->the_post(); ?>

        <?php
        //$title 	= strip_tags(get_the_title());
        $content = strip_tags(strip_shortcodes(get_the_content(false)));
        $excerpt = strip_tags(strip_shortcodes(get_the_excerpt()));
        $keys = explode(" ", $s);
        //$title	= preg_replace('/('.implode('|', $keys) .')/iu', '<span class="search-excerpt">\0</span>', $title);
        $content = preg_replace('/(' . implode('|', $keys) . ')/iu', '<span class="search-excerpt">\0</span>', $content);
        $excerpt = preg_replace('/(' . implode('|', $keys) . ')/iu', '<span class="search-excerpt">\0</span>', $excerpt);
        ?>

        <!-- Begin Post -->

        <div class="rt-article">
            <div class="blog-blog1s">
                <div class="rt-article-bg">
                    <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">

                        <?php if ($gantry->get('search-title')) : ?>

                            <!-- Begin Title -->

                            <div class="blog-header">
                                <div class="blog-title">
                                    <?php if ($gantry->get('search-link-title')) : ?>
                                        <h2 class="title">
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                        </h2>
                                    <?php else : ?>
                                        <h2 class="title">
                                            <?php the_title(); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <div class="blog-date">
                                    
                                    <div class="blog-date-content">
                                        <div class="day">
                                            <span ><?php the_time('d') ?></span>
                                        </div>
                                        <div class="month">
                                            <span><?php the_time('M') ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="clear"></div>
                            </div>

                            <div class="clear"></div>

                            <!-- End Title -->

                        <?php endif; ?>

                        <div class="rt-article-content">
                            <div class="blog-content">

                                <!-- Begin Thumbnail -->
                                <?php
                                $args = array('post_type' => 'attachment', 'orderby' => 'menu_order', 'order' => 'ASC', 'post_mime_type' => 'image', 'post_status' => null, 'numberposts' => null, 'post_parent' => $post->ID);

                                $attachments = get_posts($args);
                                if ($attachments) {
                                    foreach ($attachments as $attachment) {
                                        $alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
                                        $image_title = $attachment->post_title;
                                    }
                                }
                                $src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small');
                                ?>
                                <?php if ($gantry->get('search-open-lightbox')) { ?>
                                    <div class="blog-article-image">
                                        <a class="blog-article-image-link" href="<?php echo $src[0]; ?>" rel="prettyPhoto">
                                        <img class="blog-image"
                                        <?php
                                        if ($image_title):
                                            echo ' title="' . htmlspecialchars($image_title) . '"';
                                        endif;
                                        ?>
                                            src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $src[0]; ?>&amp;w=256&amp;zc=1" alt="<?php echo htmlspecialchars($alt); ?>"/>
                                        </a>                            
                                    </div>
                                <?php } else { ?>
                                    <div class="blog-article-image">
                                        <img class="blog-image"
                                        <?php
                                        if ($image_title):
                                            echo ' title="' . htmlspecialchars($image_title) . '"';
                                        endif;
                                        ?>
                                            src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $src[0]; ?>&amp;w=256&amp;zc=1" alt="<?php echo htmlspecialchars($alt); ?>"/>                           
                                    </div>
                                <?php } ?>                             
                                <!-- End Thumbnail -->				

                                <!-- Begin Post Content -->		

                                <?php if ($gantry->get('search-content') == 'content') : ?>

                                    <p><?php echo $content; ?></p>

                                <?php else : ?>

                                    <p><?php echo $excerpt; ?></p>

                                <?php endif; ?>
                                <div class="clear"></div>    
                                <?php if ($gantry->get('search-meta-comments') || $gantry->get('search-meta-date') || $gantry->get('search-meta-modified') || $gantry->get('search-meta-author')) : ?>
                                <!-- Begin Meta -->
                                <div class="blog-info">
                                    <div class="blog-article-info">   
                                        <div class="rt-articleinfo">
                                            <span class="rt-category"><?php _re('Category:'); ?> 
                                            <?php
                                            foreach((get_the_category()) as $category) { 
                                                echo '<a href="'.get_category_link($category->term_id ).'">'.$category->cat_name.'</a>';
                                            } 
                                            ?>
                                            </span>    
                                            <?php if ($gantry->get('search-meta-author')) : ?>

                                                <!-- Begin Author -->

                                                <span class="rt-author"><?php _re('Written by'); ?> <span><?php the_author(); ?></span></span>

                                                <!-- End Author -->

                                            <?php endif; ?>

                                            <?php if ($gantry->get('search-meta-comments')) : ?>

                                                <!-- Begin Comments -->
                                                <span class="rt-comment">
                                                <?php if ($gantry->get('search-meta-link-comments')) : ?>                                                    
                                                        <a href="<?php the_permalink(); ?>#comments">
                                                            <span class="rt-comment-text"><?php comments_number(_r('0 Comments'), _r('1 Comment'), _r('% Comments')); ?></span>
                                                        </a>                                                    

                                                <?php else : ?>                                                    
                                                        <span class="rt-comment-text"><?php comments_number(_r('0 Comments'), _r('1 Comment'), _r('% Comments')); ?></span>
                                                <?php endif; ?>
                                                </span>
                                                <!-- End Comments -->

                                            <?php endif; ?>

                                        </div>
                                    </div>                    
                                </div>
                                <!-- End Meta -->
                            <?php endif; ?>    

                            <?php if ($gantry->get('search-read-more-link')) { ?>    
                            <?php if (preg_match('/<!--more(.*?)?-->/', $post->post_content)) : ?>
                                <div class="blog-article-readmore">
                                <p class="rt-readon-surround">
                                    <?php if(strlen($readmore_text) > 0) { ?>
                                    <a href="<?php the_permalink(); ?>" class="readon"><span><?php echo  $readmore_text; ?></span></a>
                                    <?php } else { ?>
                                    <a href="<?php the_permalink(); ?>" class="readon"><span><?php _re('Learn more ...'); ?></span></a>
                                    <?php } ?>
                                </p>
                                </div>
                            <?php endif; ?>
                            <?php } ?>

                            <div class="clear"></div>

                                <!-- End Post Content -->

                            </div>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            </div>
            <!-- End Post -->

        <?php endwhile; ?>

        <div class="blog-item-separator"></div>
        <!-- Begin Navigation -->
        <?php
        if ($gantry->get('jawpagenation') && function_exists('pagination')) {
            pagination($custom_query->max_num_pages);
        } else {
            ?> 
            <?php if ($custom_query->max_num_pages > 1) : ?>

                <div class="rt-pagination nav">
                    <div class="alignleft">
                        <?php next_posts_link('&laquo; ' . _r('Older Entries'), $custom_query->max_num_pages); ?>
                    </div>
                    <div class="alignright">
                        <?php previous_posts_link(_r('Newer Entries') . ' &raquo;', $custom_query->max_num_pages) ?>
                    </div>
                    <div class="clear"></div>
                </div><br />

            <?php endif; ?>
        <?php } ?>    

        <!-- End Navigation -->

    <?php else : ?>

        <h1 class="rt-pagetitle">
            <?php _re("No posts found. Try a different search?"); ?>
        </h1>

    <?php endif; ?>

    <?php wp_reset_query(); ?>
