<?php
/* Pagination by: http://design.sparklette.net */

function pagination($pages = '', $range = 1) {
    $showitems = ($range * 2) + 1;

    global $paged;
    if (empty($paged))
        $paged = 1;

    if ($pages == '') {
        global $wp_query;
        $pages = $wp_query->max_num_pages;
        if (!$pages) {
            $pages = 1;
        }
    }
    ob_start();
    if (1 != $pages) {
        ?>
        <div class="rt-pagination">
            <div class="rt-pagination-back">
                <div class="rt-pagination-content">
                    <ul>
                        <?php if ($paged > 2 && $paged > $range + 1 && $showitems < $pages) { ?>
                            <li class="first"><a class="pagenav" title="start" href="<?php echo get_pagenum_link(1); ?>">&laquo;</a></li>
                        <?php } ?>
                        <?php if ($paged > 1 && $showitems < $pages) { ?> 
                            <li><a class="pagenav" title="prev" href="<?php echo get_pagenum_link($paged - 1); ?>">&lsaquo;</a></li>
                        <?php } ?>
                        <?php
                        for ($i = 1; $i <= $pages; $i++) {

                            if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems )) {
                                ?>
								<?php if ($i == 1) { ?>
									<li class="first"><?php if ($paged == $i) { ?><span class="pagenav"><?php echo $i; ?></span><?php } else { ?><a class="pagenav" href="<?php echo get_pagenum_link($i) ?>" ><?php echo $i; ?></a><?php } ?></li>
								<?php } else { ?>
									<li><?php if ($paged == $i) { ?><span class="pagenav"><?php echo $i; ?></span><?php } else { ?><a class="pagenav" href="<?php echo get_pagenum_link($i) ?>" ><?php echo $i; ?></a><?php } ?></li>							
								<?php } ?>
							<?php
                            }
                        }

                        if ($paged < $pages && $showitems < $pages) {
                            ?>
                            <li><a class="pagenav" title="next" href="<?php echo get_pagenum_link($paged + 1); ?>">&rsaquo;</a></li>
                        <?php } ?>
                        <?php if ($paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages) { ?>
                            <li><a class="pagenav" title="end" href="<?php echo get_pagenum_link($pages); ?>">&raquo;</a></li>
        <?php } ?> 
                    </ul> 
                </div>
            </div>
        </div>
    <?php
    }
    echo ob_get_clean();
}
?>