<?php

add_shortcode('portfolio', 'jawtheme_shortcode_portfolio');
add_shortcode('portfoliolist', 'jawtheme_shortcode_catlist_portfolio');


function jawtheme_shortcode_catlist_portfolio($atts, $content = null, $code) {
     $opts = shortcode_atts(array(
        'column' => 2,
        'pages' => '',
        'height' => '',
        'title' => 'true',
        'titlelink' => 'false',
        'group' => 'true',
        'lightbox' => 'true',
        'desc' => 'true',
	'maxlen' => -1,
        'hovericon' => 'zoom', // zoom,link,link,play custom
        'more' => 'true',
        'lightboxtitle' => 'title',
        'moretext' => '',
        'order' => 'ASC',
        'orderby' => 'menu_order', //none, id, author, title, date, modified, parent, rand, comment_count, menu_order
            ), $atts);

    extract($opts);
    $widgets = wp_get_sidebars_widgets();
    // v pripade, ze se nekdy bude pouzivat layout >> pomer mb a sd muze byt ruzny je treba tohle prepsat, 
    // tak aby se presne vedela sirka a mohlo se nastavit optimalni sirka obrazku
    $countsidebars = count($widgets['sidebar']);
   

    if ($countsidebars)
        $sidebar_style = '-sidebar';
    else
        $sidebar_style = '';
    $col_style = '';

    $image_height = $height;
    switch ($column) {
       case 1:
            $col_style = 'one_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 570;
            else
                $image_width = 570;
            break;
        case 2:
            $col_style = 'two_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 277;
            else
                $image_width = 457;
            break;
        case 3:
            $col_style = 'three_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 180;
            else
                $image_width = 300;
            break;
        case 4:
            $col_style = 'four_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 132;
            else
                $image_width = 222;
            break;
        case 5:
            $col_style = 'five_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 102;
            else
                $image_width = 174;
            break;
       /* case 6:
            $col_style = 'six_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 78;
            else
                $image_width = 142;
            break;*/
        default:
            $col_style = 'two_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 270;
            else
                $image_width = 277;
            break;
    }

    $output = '<div class="portfolio">'; // start output
    $size = array();
    $rel_group = 'portfolio_' . rand(10, 100000); //uniq id for lightbox group
    $query = array(
        'post_type' => 'page',
        'showposts' => count(explode(',', $pages)),
        'orderby' => $orderby,
        'order' => $order,
    );

    

    if ($pages) {
        $query['post__in'] = explode(',', $pages);
    }

    $posts = new WP_Query($query);
    $i = 1;


    switch ($more) {
        case 'false':
            $more = false;
            break;
        case 'true':
        default:
            $more = true;
            break;
    }
    $p = 0;
    while ($posts->have_posts() && $p < $posts->post_count) {

        $output .= '<div class="portfolio-row">';

        for ($i = 0; $i < $column; $i++) {
            $p++;
            if ($i == $column - 1)
                $row_end = 'row_end';
            else
                $row_end = '';
            if ($i == 0)
                $row_start = 'row_start';
            else
                $row_start = '';
 if ($column==1) $row_style=''; // radek je roztazen do boku
	    else $row_style='style="width: ' . $image_width . 'px;"';


            if ($posts->have_posts()) {
                if ($group == 'false')
                    $rel_group = 'portfolio_' . rand(100001, 200000);

                $output .='<div class="portfolio-row-item ' . $col_style . ' ' . $row_start . ' ' . $row_end . '">';

                $posts->the_post();
                
                if (has_post_thumbnail()) {
                    $image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'single-post-thumbnail');
                } else {
                    //todo any image
                }

                $width = '';
                $height = '';
                $href = '';
                if ($hovericon) $icon = 'portfolio-row-item-icon_'.$hovericon;
                else $icon = '';
                
                
                $href = $image[0];
                $more_link = get_permalink();
                
                if ($lightbox == 'true') {
                    $rel = ' rel="prettyPhoto[' . $rel_group . ']"';
                    $href = $image[0];
                } else {
                    $rel = '';
                    $href = $more_link;
                }


                switch ($lightboxtitle) {
                    case 'title':
                        $item_title = get_the_title();
                        break;
                    case 'desc':
                        $item_title = get_the_excerpt();
                        break;
                    case 'none':
                    default:
                        $item_title = '';
                }
		$text = getReadMore(get_the_content(),  get_the_ID());
		$text = maxContentLen($text,$maxlen);
                if ($image_height) $height_style='height:'.$image_height.'px';
		else $height_style = '';
                
                
                $output .= '<div class="portfolio-row-item-image">' . "\n";
                if ($image_height) $height_style='height:'.$image_height.'px';
		else $height_style = '';
                $output .='<span class="portfolio-row-item-frame " style="'.$height_style.'  width: ' . $image_width . 'px;">' . "\n";
                $output .= '<a alt="gallery" title="' . get_the_excerpt() . '" href="' . $href . '" ' . $rel . '>';
                if ($image_height)
                    $image_h = 'h=' . $image_height;
                else
                    $image_h = '';
                $output .= '<img src="' . get_template_directory_uri() . '/scripts/timthumb.php?src=' . $image[0] . '&amp;w=' . $image_width . '&amp;' . $image_h . '&amp;zc=1" alt="' . $item_title . '"  />';
                $output .= '<span class="image_overlay ' . $icon . '" ></span>';
                $output .= '</a>';
                $output .= '</span>';
                $output .= '</div>';


                $output .= '<div class="portfolio-row-item-details">';
		$output .= '<div class="portfolio-row-item-separator"></div>';
                if ($title == 'true') {
                    if ($titlelink == 'true') {
                        $output .= '<h2 class="portfolio-item-title"><a href="' . $more_link . '">' . get_the_title() . '</a></h2>';
                    } else {
                        $output .= '<h2 class="portfolio-item-title">' . get_the_title() . '</h2>';
                    }
                }

                if ($desc == 'true') {
                    $output .= '<div class="portfolio-item-desc">' . do_shortcode(wpautop(get_the_excerpt())) . '</div>';
                }

                if ($more == 'true') {
                    global $gantry;
                    if ($moretext == '')
                        $moretext = $gantry->get('readmore-text');

                    $output .= '<div class="portfolio-item-more_button"><a href="' . $more_link . '" '.(isset($link_target) ? 'target="' . $link_target . '" ' : '') . '><span>' . $moretext . '</span></a></div>';
                }

                $output .= '</div>'; //row-detail end  


                $output .= '</div>'; //row-item end
            }else {
                break; // game over, any posts
            }
        }
        $output .= '<div class="clear"></div>';
        $output .= '</div>'; //row end
    }

    $output .= '</div>'; // <div class="portfolio"> end

    wp_reset_postdata();
    $wp_filter['the_content'] = $the_content_filter_backup;

    return $output;

    
    
}




function jawtheme_shortcode_portfolio($atts, $content = null, $code) {
    $opts = shortcode_atts(array(
        'column' => 2,
        'cat' => '',
        'height' => '',
        'max' => -1,
        'title' => 'true',
        'titlelink' => 'false',
        'desc' => 'true',
	'maxlen' => -1,
        'more' => '',
        'moretext' => '',
        'group' => 'true',
        'lightboxtitle' => 'title', //title,desc,none
        'ids' => '',
        'order' => 'ASC',
        'orderby' => 'menu_order', //none, id, author, title, date, modified, parent, rand, comment_count, menu_order
            ), $atts);

    extract($opts);
    

    $widgets = wp_get_sidebars_widgets();
    // v pripade, ze se nekdy bude pouzivat layout >> pomer mb a sd muze byt ruzny je treba tohle prepsat, 
    // tak aby se presne vedela sirka a mohlo se nastavit optimalni sirka obrazku
    $countsidebars = count($widgets['sidebar']);
   

    if ($countsidebars)
        $sidebar_style = '-sidebar';
    else
        $sidebar_style = '';
    $col_style = '';

    $image_height = $height;
    switch ($column) {
        case 1:
            $col_style = 'one_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 570;
            else
                $image_width = 570;
            break;
        case 2:
            $col_style = 'two_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 277;
            else
                $image_width = 457;
            break;
        case 3:
            $col_style = 'three_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 180;
            else
                $image_width = 300;
            break;
        case 4:
            $col_style = 'four_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 132;
            else
                $image_width = 222;
            break;
        case 5:
            $col_style = 'five_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 102;
            else
                $image_width = 174;
            break;
       /* case 6:
            $col_style = 'six_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 78;
            else
                $image_width = 142;
            break;*/
        default:
            $col_style = 'two_column' . $sidebar_style;
            if ($countsidebars)
                $image_width = 270;
            else
                $image_width = 277;
            break;
    }


    $output = '<div class="portfolio">'; // start output
    $size = array();
    $rel_group = 'portfolio_' . rand(10, 100000); //uniq id for lightbox group
    $query = array(
        'post_type' => 'jawportfolio',
        'showposts' => $max,
        'orderby' => $orderby,
        'order' => $order
    );

    if ($cat != '') {
        global $wp_version;
        if (version_compare($wp_version, "3.1", '>=')) {
            $query['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'slug',
                    'terms' => explode(',', $cat)
                )
            );
        } else {
            $query['taxonomy'] = 'portfolio_category';
            $query['term'] = $cat;
        }
    }


    if ($ids) {
        $query['post__in'] = explode(',', $ids);
    }

    $posts = new WP_Query($query);
    $i = 1;



    switch ($more) {
        case 'false':
            $more = false;
            break;
        case 'true':
        default:
            $more = true;
            break;
    }
    $p = 0;
    while ($posts->have_posts() && $p < $posts->post_count) {

        $output .= '<div class="portfolio-row">';

        for ($i = 0; $i < $column; $i++) {
            $p++;
            if ($i == $column - 1)
                $row_end = 'row_end';
            else
                $row_end = '';
            if ($i == 0)
                $row_start = 'row_start';
            else
                $row_start = '';
	    if ($column==1) $row_style=''; // radek je roztazen do boku
	    else $row_style='style="width: ' . $image_width . 'px;"';

            if ($posts->have_posts()) {
                if ($group == 'false')
                    $rel_group = 'portfolio_' . rand(100001, 200000);
                
                $output .='<div class="portfolio-row-item ' . $col_style . ' ' . $row_start . ' ' . $row_end . '" '.$row_style.'>';

                $posts->the_post();
                $terms = get_the_terms(get_the_id(), 'jaw_portfolio_category');
                $type = get_post_meta(get_the_id(), 'jaw_portfolio_type', true);
                $link = get_post_meta(get_the_ID(), 'jaw_portfolio_link', true); //overrrides
                $link_target = get_post_meta(get_the_ID(), 'jaw_portfolio_targetlink', true);
                
                if ($link)
                    $more_link = $link;
                else
                    $more_link = get_permalink();
		//var_dump($posts);
                
                if (has_post_thumbnail()) {
                    $image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'single-post-thumbnail');
                } else {
                    //todo any image
                }
                $width = '';
                $height = '';
                
                $href = '';
                //var_dump($type);
                switch ($type) {
                    case 'image' :
                        $icon = 'zoom';
                        $lightbox = ' lightbox';
                        $href = $image[0];
                        if ($group == 'true') {
                            $rel = ' rel="prettyPhoto[' . $rel_group . ']"';
                        } else {
                            $rel = '';
                        }
                        break;
                    case 'video' :
                        $video_player = get_post_meta(get_the_id(), 'jaw_portfolio_video_player', true);
                        $video_width = get_post_meta(get_the_id(), 'jaw_portfolio_video_width', true);
                        $video_height = get_post_meta(get_the_id(), 'jaw_portfolio_video_height', true);
                        $video_src = get_post_meta(get_the_id(), 'jaw_portfolio_video_src', true);

                        if ($video_width == '')
                            $video_width = 640;
                        if ($video_height == '')
                            $video_height = 480;
                        switch ($video_player) {
                            case 'flash':
                                $href = $video_src . '?width=' . $video_width . '&amp;height=' . $video_height;
                                break;
                            case 'youtube':
                            case 'vimeo':
                                $href = $video_src;
                                break;
                            case 'quicktime':
                                $href = $video_src . '?width=' . $video_width . '&height=' . $video_height;
                                break;
                        }


                        $icon = 'play';
                        $lightbox = ' lightbox';
                        if ($group == 'true') {
                            $rel = ' rel="prettyPhoto[' . $rel_group . ']"';
                        } else {
                            $rel = '';
                        }
                        break;

                    case 'link' :
                        $icon = 'link';
                        $lightbox = '';
                        $href = $more_link;
                        $rel = '';
                        break;
                    default :
                        $href = $more_link;
                        $icon = 'doc';
                        $lightbox = '';
                        $rel = '';
                        break;
                }
				
                $text = getReadMore(get_the_content(),  get_the_ID());
                $text = maxContentLen($text,$maxlen);
				
                switch ($lightboxtitle) {
                    case 'title':
                        $item_title = get_the_title();
                        break;
                    case 'desc':
                        $item_title =  $text;
                        break;
                    case 'none':
                    default:
                        $item_title = '';
                }
                
                $output .= '<div class="portfolio-row-item-image">' . "\n";
				if ($image_height) $height_style='height:'.$image_height.'px';
				else $height_style = '';
                $output .='<span class="portfolio-row-item-frame " style="'.$height_style.'  width: ' . $image_width . 'px;">' . "\n";
                $output .= '<a class="' . $lightbox . '" ' . (isset($link_target) ? 'target="' . $link_target . '" ' : '') . ' alt="gallery" title="' . htmlspecialchars(strip_tags(($text),'<p><a><b><i>')) . '" href="' . $href . '" ' . $rel . '>';
                if ($image_height)
                    $image_h = 'h=' . $image_height;
                else
                    $image_h = '';
                $output .= '<img src="' . get_template_directory_uri() . '/scripts/timthumb.php?src=' . $image[0] . '&amp;w=' . $image_width . '&amp;' . $image_h . '&amp;zc=1"   />';
                $output .= '<span class="image_overlay portfolio-row-item-icon_' . $icon . '" ></span>';
                $output .= '</a>';
                $output .= '</span>';
                $output .= '</div>';

	      if ($title == 'true' || $more == 'true' || $title == 'true') {
                $output .= '<div class="portfolio-row-item-details">';
		$output .= '<div class="portfolio-row-item-separator"></div>';
                if ($title == 'true') {
                    if ($titlelink == 'true') {
                        $output .= '<h2 class="portfolio-item-title"><a '. (isset($link_target) ? 'target="' . $link_target . '" ' : '') . ' href="' . $more_link . '">' . get_the_title() . '</a></h2>';
                    } else {
                        $output .= '<h2 class="portfolio-item-title">' . get_the_title() . '</h2>';
                    }
                }

                if ($desc == 'true') {
                    $output .= '<div class="portfolio-item-desc">' . do_shortcode(wpautop($text)) . '</div>';
                }

                if ($more == 'true') {
                    global $gantry;
                    if ($moretext == '')
                        $moretext = $gantry->get('readmore-text');

                    $output .= '<div class="portfolio-item-more_button"><a href="' . $more_link . '" '.(isset($link_target) ? 'target="' . $link_target . '" ' : '') . '><span>' . $moretext . '</span></a></div>';
                }

                $output .= '</div>'; //row-detail end  
	}








                $output .= '</div>'; //row-item end
            }else {
                break; // game over, any posts
            }
        }
        $output .= '<div class="clear"></div>';
        $output .= '</div>'; //row end
    }

    $output .= '</div>'; // <div class="portfolio"> end

    wp_reset_postdata();
    

    return $output;
}

function getReadMore($content,$id) {
    $out='';
    
    if ($content){
        $pos =  strpos( $content,'<span id="more-'.$id.'"></span>');
        if ($pos) 
            return mb_substr($content,0,$pos,'UTF-8');
        else 
            return $content;      
    }
    return $out;
}

function maxContentLen($content,$maxlen='-1'){
    if (count($content)>$maxlen && $maxlen!='-1'){
        return mb_substr($content,0,$maxlen,'UTF-8').' [...]';
    } else {
        return $content;
    }    
}



?>
