<?php
/**
 * @version		1.24 June 26, 2012
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Widget based on the WordPress core Recent Comments Widget.
 */ 
 
defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');

add_action('widgets_init', array("GantryWidgetRecentComments","init"));
add_action('comment_post', array("GantryWidgetRecentComments", 'gantry_flush_widget_cache'));
add_action('transition_comment_status', array("GantryWidgetRecentComments", 'gantry_flush_widget_cache'));

class GantryWidgetRecentComments extends GantryWidget {
    var $short_name = 'recentcomments';
    var $wp_name = 'gantry_recentcomments';
    var $long_name = 'Gantry Recent Comments';
    var $description = 'Gantry Recent Comments Widget';
    var $css_classname = 'widget_gantry_recentcomments';
    var $width = 200;
    var $height = 400;
    
    function gantry_flush_widget_cache() {
		wp_cache_delete('gantry_recentcomments', 'widget');
	}

    function init() {
        register_widget("GantryWidgetRecentComments");
    }
    
    function render_title($args, $instance) {
    	global $gantry;
    	if($instance['title'] != '') :
    		echo $instance['title'];
    	endif;
    }

    function render($args, $instance){
        global $gantry, $comments, $comment;
	   
	    
	    $box_class = $instance['custom-variations'];
	    $menu_class = $instance['menu_class'];
	    $link_class = $instance['link_class'];
			
		if($menu_class != '') :
			$menu_class = ' '.$menu_class.'';
		else :
			$menu_class = '';
		endif;
		
		if($link_class != '') :
			$link_class = ' '.$link_class.'';
		else :
			$link_class = '';
		endif;
		
		$cache = wp_cache_get('gantry_recentcomments', 'widget');

		if (!is_array($cache))
			$cache = array();

		if (isset( $cache[$args['widget_id']])) {
			echo $cache[$args['widget_id']];
			return;
		}
                
 		

		if (!$number = (int)$instance['number'])
 			$number = 5;
 		else if ( $number < 1 )
 			$number = 1;
 			
 		if (!$word_limit = (int)$instance['word_limit'])
 			$word_limit = 8;
 		else if ( $word_limit < 1 )
 			$word_limit = 1;

		$comments = get_comments(array( 'number' => $number, 'status' => 'approve')); 
               //var_dump($comments);
                ob_start(); ?>
                <div class="jcomments-latest-body">
		<ul class="jcomments-latesttitle2 <?php echo $menu_class; ?>" >
		
		<?php 
                    if ($comments) {
                        $avatar_img = get_template_directory_uri().'/images/body/icon-user.png';
			foreach ((array)$comments as $comment) {
				$words = explode(' ', strip_tags($comment->comment_content));
				$comment_text = implode(' ', array_slice($words, 0, $word_limit));
				$avatar = get_avatar($comment->comment_author_email, $size=32,$avatar_img);
				$avatar = str_replace("class='", "class='rt-image ", $avatar); 
                                ?>
			
				<li>
                                    <div class="jcomments-avatar">
                                      <?php echo $avatar; ?>  
                                    </div>
                                    <div class="comment rounded avatar-indent">
                                        <div>
                                            <a href="<?php echo get_comment_link($comment->comment_ID); ?>" <?php echo $link_class; ?> >				
                                                    <?php echo $comment_text; ?>...
                                                    </a>

                                        </div>
                                    </div>

                                <div class="clear"></div>    
                                 <div class="jcomments-info">
                                       <span class="author"><?php echo $comment->comment_author; ?></span>
                                       <span class="date"><?php echo mysql2date('d. m. Y H:i', $comment->comment_date) ?></span>
                                        <span class="comment-separator">&#160;</span>
                                        
                                </div>       
                                        
                                </li>
			<?php } 
 		} ?>
 		
		</ul>
	</div>
                <?php 
                $cache[$args['widget_id']] = ob_get_flush();
                wp_cache_set('gantry_recentcomments', $cache, 'widget');
		
		
	    
	}
}