<?php

defined('GANTRY_VERSION') or die();
/**
 * @package     gantry
 * @subpackage  admin.elements
 */
gantry_import('core.config.gantryformfield');
gantry_import('core.config.gantryhtmlselect');

class GantryFormFieldImportButton extends GantryFormField {

    protected $type = 'importbutton';
    protected $basetype = 'button';
    
    public function getInput() {

        global $gantry;      
        $html = "";
        
        $filename = ABSPATH . '/wp-content/themes/paula/sample/install.php';
        
        if (file_exists($filename)) {
        
        $html .= "<div class='wrapper'>";
    
        $html .= "<span>It is highly recommended to do <b>complete backup</b> of your website before import (database and wordpress installation backup included).</span><br><br>";
        $html .= "<input type=\"hidden\" value=\"0\" name=\"importdata\" id=\"importdata\">";
        $html .= "<input id=\"importbutton\" class=\"button-primary\" type=\"submit\" value=\"Import sample data\">";        
        
        $html .= "<div class='clr'></div>";
        $html .= "</div>";

        $html .= "
            <script>
                jQuery(function(){
                    jQuery(\"#importbutton\").click(function() {                        
                        var answer = confirm('Really import?');
                        if (answer) {
                            jQuery(\"#importdata\").val(\"1\");
                            return true;
                        } else {
                            return false;
                        }
                    });
                });
           </script>";
        
        } else {
            $html .= "<div class='wrapper'>";
            $html .= "Sample data has been imported.";
            $html .= "</div>";
        }
        
        return $html;
        
    }
	

/**
	 * Method to get the field options.
	 
	 */    
protected function getOptions()
	{}

   
   
    
}

?>