<?php

defined('GANTRY_VERSION') or die();
/**
 * @package     gantry
 * @subpackage  admin.elements
 */
gantry_import('core.config.gantryformfield');
gantry_import('core.config.gantryhtmlselect');

class GantryFormFieldTaxonomySelector extends GantryFormField {

    protected $type = 'taxonomyselector';
    protected $basetype = 'select';
    protected $options = array();

    
    public function getInput() {

        global $gantry;
        if (!defined('GANTRY_SELECTBOX')) {
            $this->template = end(explode(DS, $gantry->templatePath));
            $gantry->addScript($gantry->gantryUrl . '/admin/widgets/selectbox/js/selectbox.js');

            define('GANTRY_SELECTBOX', 1);
        }

        $lis = $activeElement = "";
$this->translate_options = $this->getBool('translation', true);

        $options = $this->getOptions();
        $optionsOutput = "";


        $name = $this->name;

        $this->template = end(explode(DS, $gantry->templatePath));
        $name = substr(str_replace($gantry->templateName . '-template-options', "", $this->name), 1, -1);
        $name = str_replace("][", "-", $name);

        $class = $this->element['class'] ? $this->element['class'] : '';
        $slug = ($this->element['slug']);
        $this->default = ($this->element['default']) ? $this->element['default'] : 'none';

        if (!$slug)
            return "No taxonomy element set in templateDetails.xml";



        if (!defined('GANTRY_CSS')) {
            $gantry->addStyle($gantry->gantryUrl . '/admin/widgets/gantry.css');
            define('GANTRY_CSS', 1);
        }

        $default = new stdClass();
        $default->name = 'All';
        $default->slug = 'jawall';


        $tmp = get_terms((string) $slug);

        if (is_array($tmp))
            $terms = array_merge(array($default), $tmp);
        else
            $terms[] = $default;
//var_dump($terms);



        foreach ($terms as $term) {
          
            $optionData = $term->name;
            $optionValue = $term->slug;
           

           
            $cls = '';
           
            $selected = ($this->value == $optionValue) ? "selected='selected'" : "";
            $active = ($this->value == $optionValue) ? "class='active'" : "";
            if (strlen($active))$activeElement = $optionData;

           
           

           


            $text = $optionData;
            if ($optionValue == 'jawall')
                $optionsOutput .= "<option value='$optionValue' $cls $selected >" . $optionData . "</option>\n";
            else
                $optionsOutput .= "<option value='$optionValue' $cls $selected >" . $text . "</option>\n";

            $lis .= "<li " . $active . "><span>" . $term->name . "</span></li>";
        }


        $html = "<div class='wrapper'>";

        $html .= "<div class='selectbox-wrapper'>";

        $html .= "	<div class='selectbox'>";

        $html .= "		<div class='selectbox-top'>";
        $html .= "			<div class='selected'><span><span>" . _r($activeElement) . "</span></span></div>";
        $html .= "			<div class='arrow'></div>";
        $html .= "		</div>";
        $html .= "		<div class='selectbox-dropdown'>";
        $html .= "			<ul>" . $lis . "</ul>";
        $html .= "			<div class='selectbox-dropdown-bottom'><div class='selectbox-dropdown-bottomright'></div></div>";
        $html .= "		</div>";

        $html .= "	</div>";

        $html .= "	<select id='" . $this->id . "' name='" . $this->name . "' class='selectbox-real'>";
        $html .= $optionsOutput;
        $html .= "	</select>";
        $html .= "</div>";
        $html .= "<div class='clr'></div>";
        $html .= "</div>";

        return $html;
    }

    /**
     * Method to get the field options.

     */
    protected function getOptions() {
        // Initialize variables.
        $options = array();

        $slug = 'slideshow';
        $terms = get_terms((string) $slug);
if (isset($term->name)){
        foreach ($terms as $term) {

            $title = $term->name;
            // Create a new option object based on the <option /> element.
            $tmp = GantryHtmlSelect::option((string) $title, _r(trim((string) $title)), 'value', 'text', ((string) $title['disabled'] == 'true'));
            // Create a new option object based on the <option /> element.				
            // Set some option attributes.
            $tmp->class = (string) $title['class'];

            // Set some JavaScript option attributes.
            $tmp->onclick = (string) $title['onclick'];

            // Add the option object to the result set.
            $options[] = $tmp;
        }
}


        reset($options);

        return $options;
    }

}

?>