<?php
/**
 * @version   1.23 January 15, 2012
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */
// no direct access
?>

<?php global $post, $posts, $query_string; ?>

<div class="rt-wordpress">
    <div class="rt-page">

        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                <!-- Begin Post -->

                <div class="rt-article">
                    <div class="rt-article-bg">
                        <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
                            <!-- Begin Title -->
                            <?php if ($gantry->get('page-title')) : ?>
                                <?php if ($gantry->get('page-title-style') == 'type1') {  ?>
                                    <div class="blog-header">
                                        <div class="blog-title">
                                            <?php if ($gantry->get('page-link-title')) : ?>
                                                <h2 class="title">
                                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                                </h2>
                                            <?php else : ?>
                                                <h2 class="title">
                                                    <?php the_title(); ?>
                                                </h2>
                                            <?php endif; ?>
                                        </div>
                                        <div class="blog-date">
                                           
                                            <div class="blog-date-content">
                                                <div class="day">
                                            <span ><?php the_time('d') ?></span>
                                        </div>
                                        <div class="month">
                                            <span><?php the_time('M') ?></span>
                                        </div>
                                            </div>
                                        </div>
                                        <div class="clear"></div>
                                    </div>


                                <?php } else if ($gantry->get('page-title-style') == 'type2') { ?>
                            <div class="blog-header2">
                                        <div class="blog-title">
                                            <?php if ($gantry->get('page-link-title')) : ?>
                                                <h2 class="title">
                                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                                </h2>
                                            <?php else : ?>
                                                <h2 class="title">
                                                    <?php the_title(); ?>
                                                </h2>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="clear"></div>
                                    </div>
                            
                            

                                <?php } else if ($gantry->get('page-title-style') == 'type3') { ?>
                            <div class="page-header3">
                                        <div class="page-title">
                                            <?php if ($gantry->get('page-link-title')) : ?>
                                                <h2 class="title">
                                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                                </h2>
                                            <?php else : ?>
                                                <h2 class="title">
                                                    <?php the_title(); ?>
                                                </h2>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="clear"></div>
                                    </div>

                                <?php
                                } else {  //simple ?>
                            <div class="page-header">
                                    <div class="page-title">

                                        <h2 class="title">
                                            <?php if ($gantry->get('page-link-title')) : ?>
                                                <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                            <?php else : ?>

                                                <?php the_title(); ?>
                                            <?php endif; ?>
                                        </h2>     
                                    </div>
                                </div>
                                <?php } ?>


                                <!-- Begin Title -->


                                <div class="clear"></div>

                                <!-- End Title -->

                            <?php endif; ?>

                            <div class="rt-article-content">		

                                <!-- Begin Post Content -->		

                                <?php the_content(); ?>

                                <div class="clear"></div>

                                <div class="blog-info">
                                    <?php if ($gantry->get('page-meta-comments') || $gantry->get('page-meta-author')) : ?>

                                        <!-- Begin Meta -->

                                        <div class="rt-articleinfo">

                                            <?php if ($gantry->get('page-meta-author')) : ?>

                                                <!-- Begin Author -->

                                                <div class="rt-author"><?php _re('Written by'); ?> <span><?php the_author(); ?></span></div>

                                                <!-- End Author -->

                                            <?php endif; ?>

                                            <?php if ($gantry->get('page-meta-comments')) : ?>

                                                <!-- Begin Comments -->

                                                <div class="rt-comment">
                                                    <span class="rt-comment-text"><?php comments_number(_r('0 Comments'), _r('1 Comment'), _r('% Comments')); ?></span>
                                                </div>

                                                <!-- End Comments -->

                                            <?php endif; ?>


                                            <div class="rt-edit">
                                                <?php edit_post_link(_r('Edit this entry'), '<div class="edit-entry">', '</div>'); ?>
                                            </div>

                                            <div class="clear"></div>
                                        </div>
                                        <!-- End Meta -->
                                    <?php endif; ?>
                                </div>
                                <div class="blog-item-separator"></div>

                                <?php wp_link_pages('before=<div class="rt-pagination">' . _r('Pages:') . '&after=</div><br />'); ?>

                                <?php if (comments_open() && $gantry->get('page-comments-form')) : ?>

                                    <a name="comments"></a>

                                    <?php echo $gantry->displayComments(true, 'basic', 'basic'); ?>

                                <?php endif; ?>

                                <div class="clear"></div>

                                <!-- End Post Content -->

                            </div>														
                        </div>
                        <div class="clear"></div>                       


                    </div>
                </div>

                <!-- End Post -->

            <?php endwhile; ?>

        <?php else : ?>

            <h1 class="rt-pagetitle">
                <?php _re('Sorry, no pages matched your criteria.'); ?>
            </h1>

        <?php endif; ?>

        <?php wp_reset_query(); ?>

    </div>
</div>