<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

        <!-- Begin Post -->

        <div class="rt-article">
            <div class="blog-blog1b">
                <div class="rt-article-bg">
                    <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">

                        <?php if ($gantry->get('post-title')) : ?>

                            <!-- Begin Title -->
                            <div class="blog-header">
                                <div class="blog-title">
                                    <?php if ($gantry->get('post-title-link')) : ?>
                                        <h2 class="title">
                                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
                                        </h2>
                                    <?php else : ?>
                                        <h2 class="title">
                                            <?php the_title(); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <div class="blog-date">
                                    
                                    <div class="blog-date-content">
                                        <div class="day">
                                            <span ><?php the_time('d') ?></span>
                                        </div>
                                        <div class="month">
                                            <span><?php the_time('M') ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="clear"></div>
                            </div>

                            <div class="clear"></div>

                            <!-- End Title -->

                        <?php endif; ?>

                        <div class="rt-article-content">                           						

                            <!-- Begin Post Content -->                                                                                                                               

                            <div class="blog-content">
                                <?php if (function_exists('the_post_thumbnail') && has_post_thumbnail()) { ?>
                                    <?php
                                    $src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'small');
                                    ?>
                                    <?php if ($gantry->get('post-open-lightbox')) { ?>
                                    <div class="blog-article-image-big">
                                        <a class="blog-article-image-link" href="<?php echo $src[0]; ?>" rel="prettyPhoto">
                                        <img class="blog-image"
                                        <?php
                                        if ($image_title):
                                            echo ' title="' . htmlspecialchars($image_title) . '"';
                                        endif;
                                        ?>
                                            src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $src[0]; ?>&amp;w=580&amp;zc=1" alt="<?php echo htmlspecialchars($alt); ?>"/>
                                        </a>                            
                                    </div>
                                    <?php } else { ?>
                                        <div class="blog-article-image-big">
                                        <img class="blog-image"
                                        <?php
                                        if ($image_title):
                                            echo ' title="' . htmlspecialchars($image_title) . '"';
                                        endif;
                                        ?>
                                            src="<?php echo get_template_directory_uri(); ?>/scripts/timthumb.php?src=<?php echo $src[0]; ?>&amp;w=580&amp;zc=1" alt="<?php echo htmlspecialchars($alt); ?>"/>                            
                                    </div>
                                    <?php } ?>
                                <?php } ?>
                                <?php the_content(); ?>
                            </div>
                            <div class="clear"></div>

                            <?php wp_link_pages('before=<div class="rt-pagination">' . _r('Pages:') . '&after=</div><br />'); ?>

                            <?php if (has_tag() && $gantry->get('post-tags')) : ?>

                                <div class="rt-tags important">

                                    <?php the_tags('<span>' . _r('Tags:') . ' &nbsp;</span>', '', ''); ?>

                                </div>

                            <?php endif; ?>
                            
                            <div class="blog-info">
                                <?php if ($gantry->get('post-meta-comments') || $gantry->get('post-meta-date') || $gantry->get('post-meta-modified') || $gantry->get('post-meta-author')) : ?>

                                <!-- Begin Meta -->

                                <div class="rt-articleinfo">
					    <?php if (is_sticky(get_the_ID())) { ?>
						<span class="rt-sticky"><?php _e('Featured','paula'); ?></span>
					    <?php } ?>

                                    <?php if ($gantry->get('post-meta-author')) : ?>

                                        <!-- Begin Author -->

                                        <div class="rt-author"><?php _re('Written by'); ?> <span><?php the_author(); ?></span></div>

                                        <!-- End Author -->

                                    <?php endif; ?>

                                    <?php if ($gantry->get('post-meta-comments')) : ?>

                                        <!-- Begin Comments -->

                                        <div class="rt-comment">
                                            <span class="rt-comment-text"><?php comments_number(_r('0 Comments'), _r('1 Comment'), _r('% Comments')); ?></span>
                                        </div>

                                        <!-- End Comments -->

                                    <?php endif; ?>
                                        
                                    <?php if ($gantry->get('post-twitter-enabled')) : ?>
                                        <div class="rt-twitter">
                                            <a href="https://twitter.com/share" class="twitter-share-button" data-dnt="true" data-count="horizontal" data-text="" data-url="">Tweet</a>
                                        </div>
                                    <?php endif; ?>
                                        
                                    <?php if ($gantry->get('post-gplus-enabled')) : ?>
                                        <div class="rt-google">
                                            <g:plusone href="<?php the_permalink(); ?>" size="medium"></g:plusone>
                                        </div>
                                    <?php endif; ?>
                                        
                                    <?php if ($gantry->get('post-facebook-enabled')) : ?>
                                        <div class="rt-facebook">
                                            <div id="fb-root"></div>
                                            <fb:like 
                                                href="<?php the_permalink(); ?>"
                                                layout="button_count"  action="like" show_faces="true" colorscheme="light"></fb:like>
                                        </div>
                                    <?php endif; ?>
                                     
                                    <div class="rt-edit">
                                         <?php edit_post_link(_r('Edit this entry'), '<div class="edit-entry">', '</div>'); ?>
                                    </div>
                                        
                                    <div class="clear"></div>
                                </div>
                                <!-- End Meta -->
                                <?php endif; ?>
                            </div>
                            <div class="blog-item-separator"></div>
                            
                           

                            <?php if ($gantry->get('post-footer')) : ?>

                                <div class="rt-post-footer">
                                    <small>

                                        <?php _re('This entry was posted'); ?>
                                        <?php
                                        /* This is commented, because it requires a little adjusting sometimes.
                                          You'll need to download this plugin, and follow the instructions:
                                          http://binarybonsai.com/archives/2004/08/17/time-since-plugin/ */
                                        /* $entry_datetime = abs(strtotime($post->post_date) - (60*120)); echo time_since($entry_datetime); echo ' ago'; */
                                        ?>
                                        <?php echo $post->post_date; ?>
                                        <?php _re('on'); ?> <?php the_time('l, F jS, Y') ?> <?php _re('at'); ?> <?php the_time() ?>
                                        <?php _re('and is filed under'); ?> <?php the_category(', ') ?>.
                                        <?php _re('You can follow any responses to this entry through the'); ?> <?php post_comments_feed_link('RSS 2.0'); ?> <?php _re('feed'); ?>.

                                        <?php
                                        if (('open' == $post->comment_status) && ('open' == $post->ping_status)) {
                                            // Both Comments and Pings are open 
                                            ?>
                                            <?php _re('You can'); ?> <a href="#respond"><?php _re('leave a response'); ?></a>, <?php _re('or'); ?> <a href="<?php trackback_url(); ?>" rel="trackback"><?php _re('trackback'); ?></a> <?php _re('from your own site.'); ?>

                                            <?php
                                        } elseif (!('open' == $post->comment_status) && ('open' == $post->ping_status)) {
                                            // Only Pings are Open 
                                            ?>
                                            <?php _re('Responses are currently closed, but you can'); ?> <a href="<?php trackback_url(); ?> " rel="trackback"><?php _re('trackback'); ?></a> <?php _re('from your own site.'); ?>

                                            <?php
                                        } elseif (('open' == $post->comment_status) && !('open' == $post->ping_status)) {
                                            // Comments are open, Pings are not 
                                            ?>
                                            <?php _re('You can skip to the end and leave a response. Pinging is currently not allowed.'); ?>

                                            <?php
                                        } elseif (!('open' == $post->comment_status) && !('open' == $post->ping_status)) {
                                            // Neither Comments, nor Pings are open 
                                            ?>
                                            <?php _re('Both comments and pings are currently closed.'); ?>

                                        <?php } edit_post_link(_r('Edit this entry'), '', '.'); ?>

                                    </small>
                                </div>

                            <?php endif; ?>

                            <?php if (comments_open() && $gantry->get('post-comments-form')) : ?>

                                <a name="comments"></a>

                                <?php echo $gantry->displayComments(true, 'basic', 'basic'); ?>

                            <?php endif; ?>

                            <div class="clear"></div>

                            <!-- End Post Content -->

                        </div>																
                    </div>
                    <div class="clear"></div>
                </div>		
            </div>

            <!-- End Post -->

        <?php endwhile; ?>

    <?php else : ?>

        <h1 class="rt-pagetitle">
            <?php _re('Sorry, no posts matched your criteria.'); ?>
        </h1>

    <?php endif; ?>

    <?php wp_reset_query(); ?>
</div>