<?php

session_start();



    if ($_SERVER['REQUEST_METHOD'] == 'POST' && @$_POST['do'] == 'contact') {
        // if the form has been submitted

        foreach ($_POST as $key => $value) {
            if (!is_array($key)) {
                // sanitize the input data
                if ($key != 'ct_message')
                    $value = strip_tags($value);
                $_POST[$key] = htmlspecialchars(stripslashes(trim($value)));
            }
        }

        $name = @$_POST['fc_mod_name'];    // name from the form
        $email = @$_POST['fc_mod_email'];   // email from the form
        $message = @$_POST['fc_mod_text']; // the message from the form
        $captcha = @$_POST['captcha_code']; // the user's entry for the captcha code
	$id = @$_POST['id']; // the user's entry for the captcha code
        $name = substr($name, 0, 64);  // limit name to 64 characters

        $errors = array();  // initialize empty error array
        // only check for errors if the form is not in debug mode

        if (strlen($name) < 1) {
            // name too short, add error
            $errors['e_name'] = '1';
        }

        if (strlen($email) == 0) {
            // no email address given
            $errors['e_mail'] = '1';
        } else if (!preg_match('/^(?:[\w\d]+\.?)+@(?:(?:[\w\d]\-?)+\.)+\w{2,4}$/i', $email)) {
            // invalid email format
            $errors['e_mail'] = '1';
        }

        if (strlen($message) < 1) {
            // message length too short
            $errors['e_text'] = '1';
        }

	//if (isset($_SESSION['jaw_use_captcha_'.$id]))
        if ($_SESSION['jaw_use_captcha_'.$id] && sizeof($errors) == 0) {
            require_once dirname(__file__) . '/securimage.php';
            $securimage = new Securimage();

            if ($securimage->check($captcha) == false) {
                $errors['e_captcha'] = '1';
            }
        }
 


        if (sizeof($errors) == 0) {
            // no errors, send the form
            $time = date('r');
            $message = "A message was submitted from the contact form.  The following information was provided.<br /><br />"
                    . "Name: $name<br />"
                    . "Email: $email<br />"
                    . "Message:<br />"
                    . "<pre>$message</pre>"
                    . "<br /><br />IP Address: {$_SERVER['REMOTE_ADDR']}<br />"
                    . "Time: $time<br />"
                    . "Browser: {$_SERVER['HTTP_USER_AGENT']}<br />";


            // send the message with mail()
            @mail($_SESSION['jaw_mailto_'.$id],  $_SESSION['jaw_subject_'.$id], $message, "From: {$_SESSION['jaw_mailto_'.$id]}\r\nReply-To: {$email}\r\nContent-type: text/html; charset=ISO-8859-1\r\nMIME-Version: 1.0");


            $return = array('error' => 0, 'type' => 'OK');
            die(json_encode($return));
        } else {



            $return = array('error' => 1, 'type' => $errors);
            die(json_encode($return));
        }
    } // POST

?>