<?php
/* defination items */
function jawtemplates_portfolio_add_css(){
    wp_enqueue_style('portfolio_meta_css', get_template_directory_uri() . '/post_types/portfolio/metaboxes/meta.css');
    }
if (is_admin()) {    
   add_action( 'admin_enqueue_scripts', 'jawtemplates_portfolio_add_css' );   
}


add_image_size( 'portfolio-admin', 150, 100, true );

/* post definition */
//http://codex.wordpress.org/Function_Reference/register_post_type
$labels = array(
    'name' => _x('Portfolio', 'post type general name', "paula"),
    'singular_name' => _x('Portfolio', 'post type singular name', "paula"),
    'add_new' => _x('Add New', 'portfolio', "paula"),
    'add_new_item' => __('Add New Portfolio', "paula"),
    'edit_item' => __('Edit Portfolio', "paula"),
    'new_item' => __('New Portfolio', "paula"),
    'view_item' => __('Preview Portfolio', "paula"),
    'search_items' => __('Search Portfolio', "paula"),
    'not_found' => __('No portfolio found.', "paula"),
    'not_found_in_trash' => __('No portfolio found in Trash.', "paula"),
    'parent_item_colon' => '',
    'menu_name' => 'Portfolio Items',
    'description' => ''
);

register_post_type('jawportfolio', array(
    'label' => __('Portfolio options', "paula"),
    'labels' => $labels,
    'singular_label' => __('Categorie', "paula"),
    'query_var' => "portfolio",
    'menu_position' => null,
    'show_ui' => true,
    'show_in_menu' => true,
    'hierarchical' => true,
    '_builtin' => false,
    'exclude_from_search' => true,
    'rewrite' => array("slug" => "portfolio"),  
    'capability_type' => 'page',
    'public' => true, 
    'supports' => array('title', 'thumbnail', 'page-attributes', 'editor')
));

// taxonomy
$labels_taxonomy = array(
    'name' => __('Category', 'post type general name'),
    'all_items' => __('All Portfolio', 'all items'),
    'search_items' => __('Search Portfolio', 'search item'),
    'add_new_item' => __('Add New Portfolio', 'adding a new item'),
    'new_item_name' => __('New Portfolio Name', 'adding a new item'),
    
    
);

// taxonomy
$args_taxonomy = array(
    'labels' => $labels_taxonomy,
    'hierarchical' => true
);

//http://codex.wordpress.org/Function_Reference/register_taxonomy
register_taxonomy('portfolio_category', 'jawportfolio', $args_taxonomy);




/*
 Customize Manage Posts interface
*/

function add_columns_jawportfolio($columns) {

    $columns = array(
        "cb" => "<input type=\"checkbox\" />",
        
        "title" => __("Portfolio Title", "paula"),
        "portfolio_thumbnail" => __("Thumbnail", "paula"),
        "portfolio_category" => __("Category", "paula"),
        "portfolio_type" => __("Portfolio Type", "paula"),
        "contents" => __("Content", "paula"),
        "order" => __("Order", "paula")   
    );

    return $columns;
}

function custom_columns_portfolio($column) {
    global $post;
   
  
   
    switch ($column) {

        case "portfolio_thumbnail":
             if (has_post_thumbnail()) {
                     the_post_thumbnail('portfolio-admin');  
                } else {
                    _e("No featured image.", "paula");
                    
                    }
            
            
            break;

        case "portfolio_category":
            //var_dump($post);
            $portfoliohows = get_the_terms(0, "portfolio_category");
             
            $out = array();
            if ($portfoliohows) {
                foreach ($portfoliohows as $portfoliohow)
                    array_push($out, $portfoliohow->name);

                echo implode($out, ", ");
            }else{
               _e("No selected.", "paula"); 
                
            }
            break;

        case "portfolio_type":
            $types = array('image'=>'Image', 'video'=>'Video','doc'=>'Doc','link'=>'Link');
            $videotypes = array('flash'=>'Flash', 'youtube'=>'Youtube','vimeo'=>'Vimeo','quicktime'=>'QuickTime');

             $type = get_post_meta(get_the_ID(), 'jaw_portfolio_type', TRUE);
             $player = get_post_meta(get_the_ID(), 'jaw_portfolio_video_player', TRUE);
             
                if (array_key_exists($type, $types)) {
                    
                  echo $types[$type];
                  if ($player && $types[$type]=='video') echo ' - '.$videotypes[$player];
                }else{
                    _e("No Type", "paula"); 
                }
               
            
            break;
            
           
        
        case "contents":
            
             if ($post->post_content) {
                    if (strlen($post->post_content)>50) $t='...';
                    else $t='';
                  echo mb_substr($post->post_content,0,50,'UTF-8').$t;  
                }
            break;
        
    }
}




function custom_columns_portfolio_sortable( $columns ) {

	$columns['order'] = 'order';

	return $columns;
}


add_filter( 'manage_edit-jawportfolio_sortable_columns', 'custom_columns_portfolio_sortable' );
add_filter("manage_edit-jawportfolio_columns", "add_columns_jawportfolio");
add_action("manage_pages_custom_column", "custom_columns_portfolio");

function jaw_portfolioaved() {

    wp_redirect($_POST['_wp_http_referer']);

    exit;
}

$portfolio_metabox = new WPAlchemy_MetaBox(array
            (
            'id' => 'portfolio1',
            'title' => __("Portfolio Options", "paula"),
            'types' => array('jawportfolio'),
            'context' => 'normal',
            'priority' => 'high',
            'template' => get_theme_root() . '/paula/post_types/portfolio/metaboxes/metabox.php',
            'mode' => 'extract',
            'prefix' => 'jaw_',
            'save_action' => 'jaw_portfolioaved'
        ));

?>