<?php

function replace_token_url($var) {
    $out = $var;
    if (is_string($var)) {
        $out = str_replace("@RT_SITE_URL@", get_bloginfo("wpurl"), $var);
    }
    return $out;
}

function filter_token_url($value, $oldvalue) {
    if (is_array($value)) {
        return multidimensionalArrayMap("replace_token_url", $value);
    } else if (is_string($value))
        return replace_token_url($value);
    else
        return $value;
}

function multidimensionalArrayMap($func, $arr) {
    $newArr = array();
    foreach ($arr as $key => $value) {
        $newArr[$key] = ( is_array($value) ? multidimensionalArrayMap($func, $value) : $func($value) );
    }
    return $newArr;
}

// unpublish hellow world
$hello_world = array();
$hello_world["ID"] = 1;
$hello_world["post_status"] = "draft";
wp_update_post($hello_world);

/* * **** UPDATE OVERRIDES *************************************************** */
update_option('sidebars_widgets', array(
    'wp_inactive_widgets' =>
    array(
    ),
    'drawer' =>
    array(
    ),
    'top-a' =>
    array(
        0 => 'nav_menu-2',
    ),
    'top-b' =>
    array(
        0 => 'search-3',
    ),
    'top-c' =>
    array(
        0 => 'gantry_jawsocial-2',
    ),
    'logo' =>
    array(
        0 => 'gantry_logo-2',
    ),
    'navigation' =>
    array(
        0 => 'gantry_menu-2',
    ),
    'featured-right' =>
    array(
        0 => 'gantry_recentposts-2',
    ),
    'feature' =>
    array(
    ),
    'utility' =>
    array(
    ),
    'maintop' =>
    array(
    ),
    'breadcrumb' =>
    array(
        0 => 'gantry_breadcrumbs-2',
    ),
    'sidebar' =>
    array(
        0 => 'text-3',
        1 => 'gantry_recentcomments-2',
        2 => 'text-4',
    ),
    'content-top' =>
    array(
    ),
    'content-bottom' =>
    array(
    ),
    'mainbottom' =>
    array(
    ),
    'bottom' =>
    array(
    ),
    'footer-left-a' =>
    array(
        0 => 'text-2',
    ),
    'footer-left-b' =>
    array(
        0 => 'gantry_jawtwitter-2'
    ),
    'footer-right-a' =>
    array(
        0 => 'gantry_jawcontactform-2',
    ),
    'copyright' =>
    array(
    ),
    'analytics' =>
    array(
    ),
    'debug' =>
    array(
    ),
    'array_version' => 3,
));

remove_filter('pre_update_option_active_plugins', 'filter_token_url', 10, 2);
/******************************************************************************/

/* GANTRY LOGO ****************************************************************/
add_filter('pre_update_option_widget_gantry_logo', 'filter_token_url', 10, 2);
update_option('widget_gantry_logo', array(
    2 =>
    array(
        'perstyle' => '1',
        'css' => 'body #rt-logo',
        'custom-variations' => '',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_logo', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET GANTRY MENU *********************************************************/
add_filter('pre_update_option_widget_gantry_menu', 'filter_token_url', 10, 2);

update_option('widget_gantry_menu', array(
    2 =>
    array(
        'title' => '',
        'nav_menu' => 'main-menu',
        'theme' => 'gantry_fusion',
        'limit_levels' => '0',
        'startLevel' => '0',
        'endLevel' => '0',
        'showAllChildren' => '1',
        'show_empty_menu' => '0',
        'maxdepth' => '10',
        'fusion_load_css' => '0',
        'fusion_enable_js' => '1',
        'fusion_opacity' => '1',
        'fusion_effect' => 'slidefade',
        'fusion_hidedelay' => '500',
        'fusion_menu_animation' => 'Quad.easeOut',
        'fusion_menu_duration' => '400',
        'fusion_pill' => '0',
        'fusion_pill_animation' => 'Back.easeOut',
        'fusion_pill_duration' => '400',
        'fusion_centeredOffset' => '0',
        'fusion_tweakInitial_x' => '0',
        'fusion_tweakInitial_y' => '0',
        'fusion_tweakSubsequent_x' => '0',
        'fusion_tweakSubsequent_y' => '0',
        'fusion_enable_current_id' => '0',
        'menu_suffix' => '',
        'custom-variations' => '',
    ),
    '_multiwidget' => 1,
));

remove_filter('pre_update_option_widget_gantry_menu', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET SEARCH **************************************************************/
add_filter('pre_update_option_widget_search', 'filter_token_url', 10, 2);
update_option('widget_search', array(
    3 =>
    array(
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_search', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET TOP MENU ************************************************************/
add_filter('pre_update_option_widget_nav_menu', 'filter_token_url', 10, 2);
update_option('widget_nav_menu', array(
    2 =>
    array(
        'nav_menu' => 'top-menu',
    ),	
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_nav_menu', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET JAW SOCIAL **********************************************************/
add_filter('pre_update_option_widget_gantry_jawsocial', 'filter_token_url', 10, 2);
update_option('widget_gantry_jawsocial', array(
    2 =>
    array(
        'facebook' => '#',
        'twitter' => '#',
        'linkedin' => '#',
        'digg' => '#',
        'flickr' => '#',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_jawsocial', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET RECENT POSTS ********************************************************/
add_filter('pre_update_option_widget_gantry_recentposts', 'filter_token_url', 10, 2);
update_option('widget_gantry_recentposts', array(
    2 =>
    array(
        'title' => 'Latest Posts',
        'number' => '3',
        'custom-variations' => 'title2',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_recentposts', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET RECENT COMMENTS *****************************************************/
add_filter('pre_update_option_widget_gantry_recentcomments', 'filter_token_url', 10, 2);
update_option('widget_gantry_recentcomments', array(
    2 =>
    array(
        'title' => 'Latest Comments',
        'number' => '3',
        'word_limit' => '8',
        'custom-variations' => 'title2',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_recentcomments', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET TEXT FOOTER LEFT-B JAW TWEETS ***************************************/
add_filter('pre_update_option_widget_gantry_jawtwitter', 'filter_token_url', 10, 2);
update_option('widget_gantry_jawtwitter', array(
    2 =>
    array(
        'title' => 'JaW Tweets',
        'number' => '3',
        'nick' => 'jawtemplates',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_jawtwitter', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET TEXT FOOTER RIGHT-A CONTACT FORM ************************************/
add_filter('pre_update_option_widget_gantry_jawcontactform', 'filter_token_url', 10, 2);
update_option('widget_gantry_jawcontactform', array(
    2 =>
    array(
        'title' => 'Contact Us',
        'custom-variations' => '',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_jawcontactform', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET breadcrumbs ************************************/
add_filter('pre_update_option_widget_gantry_breadcrumbs', 'filter_token_url', 10, 2);
update_option('widget_gantry_breadcrumbs', array(
    2 =>
    array(
        'title' => '',
        'custom-variations' => '',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_gantry_breadcrumbs', 'filter_token_url', 10, 2);
/******************************************************************************/

/* WIDGET TEXT ****************************************************************/
add_filter('pre_update_option_widget_text', 'filter_token_url', 10, 2);
update_option('widget_text', array(
    2 =>
    array(
      'title' => 'About Us',
      'text' => '<p>Lorem ipsum dolor sit amet, con sectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut aoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis.</p><p>Designed by Jawtemplates.<br>Powered by Gantry Framework<br>Copyright (c) 2012</p>',
      'filter' => false,
      'custom-variations' => '',
    ),
    3 => 
    array (
      'title' => 'iPhone Fashion Shot',
      'text' => '<p>Integer pharetra metus <a href="http://vimeo.com/13081827" target="_blank" >http://vimeo.com/13081827</a><br /><br />
[video type="vimeo"  clip_id ="13081827" width="325" height ="200"]</p>',
      'filter' => false,
      'custom-variations' => '',
    ),
    4 => 
    array (
      'title' => '',
      'text' => '<p><img border="0" alt="" src="@RT_SITE_URL@/wp-content/themes/paula/sample/img/banner.jpg" style="opacity: 1;"></p>',
      'filter' => false,
      'custom-variations' => '',
    ),
    '_multiwidget' => 1,
));
remove_filter('pre_update_option_widget_text', 'filter_token_url', 10, 2);
/******************************************************************************/

/******************************************************************************/
function rokimport_get_post_from_guid($guid) {
    global $wpdb;
    var_dump($guid);
    $guid = replace_token_url($guid);
    var_dump($guid);
    $posts = $wpdb->get_results("SELECT ID FROM " . $wpdb->posts . " WHERE guid = '" . $guid . "'");
    var_dump($posts);
    return (count($posts) > 0) ? $posts[0]->ID : 0;
}

function rokimport_get_taxonomy($name, $taxonomy) {
    $taxfield = get_term_by("slug", $name, $taxonomy);
    return $taxfield->term_id;
}
/******************************************************************************/

$gantry_menu_items = array();
/* FILL MAIN MENU *************************************************************/
global $wp_version;
if (version_compare($wp_version, "3.0", ">=")) {
    $importing_menu = wp_get_nav_menu_object("main-menu");
    $menu_item_mapping = array(0 => 0);
    $menu_item_mapping[59] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Home',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '1',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[59]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );

    /***** MENU BLOG ******************************************************** */
    $menu_item_mapping[108] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'taxonomy',
        'menu-item-title' => 'Blog',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => ' ',
        'menu-item-xfn' => '',
        'menu-item-position' => '2',
        'menu-item-attr-title' => '',
        'menu-item-object-id' => rokimport_get_taxonomy('blog', 'category'),
        'menu-item-object' => 'category'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[108]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );

    /***** MENU FEATURED ******************************************************/
    $menu_item_mapping[107] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
            'menu-item-type' => 'taxonomy',
            'menu-item-title' => 'Featured',
            'menu-item-status' => 'publish',
            'menu-item-target' => '',
            'menu-item-classes' => '',
            'menu-item-description' => ' ',
            'menu-item-xfn' => '',
            'menu-item-position' => '3',
            'menu-item-attr-title' => '',
            'menu-item-object-id' => rokimport_get_taxonomy('features', 'category'),
            'menu-item-object' => 'category'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[107]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[130] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[107],
		'menu-item-type' => 'post_type',
		'menu-item-title' => 'Typography',
		'menu-item-status' => 'publish',
		'menu-item-target' => '',
		'menu-item-classes' => '',
		'menu-item-description' => ' ',
		'menu-item-xfn' => '',
		'menu-item-position' => '1',
		'menu-item-attr-title' => '',
		'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=25'),
		'menu-item-object' => 'page'
		));
		$gantry_menu_items["main-menu"][$menu_item_mapping[107]] = array (
		  'gantrymenu_subtext' => '',
		  'gantrymenu_icon' => '',
		  'gantrymenu_submenu_cols' => '1',
		);

    $menu_item_mapping[131] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[107],
		'menu-item-type' => 'post_type',
		'menu-item-title' => 'Widget position',
		'menu-item-status' => 'publish',
		'menu-item-target' => '',
		'menu-item-classes' => '',
		'menu-item-description' => ' ',
		'menu-item-xfn' => '',
		'menu-item-position' => '2',
		'menu-item-attr-title' => '',
		'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=28'),
		'menu-item-object' => 'page'
		));
		$gantry_menu_items["main-menu"][$menu_item_mapping[107]] = array (
		  'gantrymenu_subtext' => '',
		  'gantrymenu_icon' => '',
		  'gantrymenu_submenu_cols' => '1',
		);

		$menu_item_mapping[156] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[107],
		'menu-item-type' => 'post_type',
		'menu-item-title' => 'Media',
		'menu-item-status' => 'publish',
		'menu-item-target' => '',
		'menu-item-classes' => '',
		'menu-item-description' => ' ',
		'menu-item-xfn' => '',
		'menu-item-position' => '3',
		'menu-item-attr-title' => '',
		'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=259'),
		'menu-item-object' => 'page'
		));
		$gantry_menu_items["main-menu"][$menu_item_mapping[156]] = array (
		  'gantrymenu_subtext' => '',
		  'gantrymenu_icon' => '',
		  'gantrymenu_submenu_cols' => '1',
		);
			
			$menu_item_mapping[157] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[107],
		'menu-item-type' => 'post_type',
		'menu-item-title' => 'Theme Settings',
		'menu-item-status' => 'publish',
		'menu-item-target' => '',
		'menu-item-classes' => '',
		'menu-item-description' => ' ',
		'menu-item-xfn' => '',
		'menu-item-position' => '4',
		'menu-item-attr-title' => '',
		'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=606'),
		'menu-item-object' => 'page'
		));
		$gantry_menu_items["main-menu"][$menu_item_mapping[157]] = array (
		  'gantrymenu_subtext' => '',
		  'gantrymenu_icon' => '',
		  'gantrymenu_submenu_cols' => '1',
		);
		
		
    /**************************************************************************/
    
    /***** MENU GALLERY *******************************************************/
    $menu_item_mapping[106] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'post_type',
        'menu-item-title' => 'Portfolio',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => ' ',
        'menu-item-xfn' => '',
        'menu-item-position' => '4',
        'menu-item-attr-title' => '',
        'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=312'),
        'menu-item-object' => 'page'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[106]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
	
		
		
	
    /**************************************************************************/
    
    /***** MENU PURCHASE IT ***************************************************/
    $menu_item_mapping[109] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Purchase it',
        'menu-item-status' => 'publish',
        'menu-item-target' => '_blank',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '5',
        'menu-item-attr-title' => '',
        'menu-item-url' => 'http://themeforest.net/user/jawtemplates/portfolio'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[109]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    /**************************************************************************/
    
    /***** MENU CONTACT *******************************************************/
    $menu_item_mapping[125] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'post_type',
        'menu-item-title' => 'Contact',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => ' ',
        'menu-item-xfn' => '',
        'menu-item-position' => '6',
        'menu-item-attr-title' => '',
        'menu-item-object-id' => rokimport_get_post_from_guid('@RT_SITE_URL@/?page_id=145'),
        'menu-item-object' => 'page'
            ));
    $gantry_menu_items["main-menu"][$menu_item_mapping[125]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    update_option("gantry_menu_items", $gantry_menu_items);
}
/******************************************************************************/

/* FILL TOP MENU **************************************************************/
if (version_compare($wp_version, "3.0", ">=")) {
    $importing_menu = wp_get_nav_menu_object("top-menu");
    $menu_item_mapping = array(0 => 0);
    $menu_item_mapping[139] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'About Us',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '1',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["top-menu"][$menu_item_mapping[139]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[140] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Sitemap',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '1',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["top-menu"][$menu_item_mapping[140]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[141] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Support',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '1',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["top-menu"][$menu_item_mapping[141]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );

    update_option("gantry_menu_items", $gantry_menu_items);
}
/******************************************************************************/

/* FILL SIDEBAR MENU **************************************************************/
if (version_compare($wp_version, "3.0", ">=")) {
    $importing_menu = wp_get_nav_menu_object("sidebar-menu");
    $menu_item_mapping = array(0 => 0);
    $menu_item_mapping[142] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 1',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '1',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[142]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[143] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 2',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '2',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[143]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[144] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 3',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '3',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[144]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[145] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 4',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '4',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[145]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[146] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 5',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '5',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[146]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );
    
    $menu_item_mapping[147] = wp_update_nav_menu_item($importing_menu->term_id, 0, array(
        'menu-item-parent-id' => $menu_item_mapping[0],
        'menu-item-type' => 'custom',
        'menu-item-title' => 'Paula Category 6',
        'menu-item-status' => 'publish',
        'menu-item-target' => '',
        'menu-item-classes' => '',
        'menu-item-description' => '',
        'menu-item-xfn' => '',
        'menu-item-position' => '6',
        'menu-item-attr-title' => '',
        'menu-item-url' => '@RT_SITE_URL@/'
            ));
    $gantry_menu_items["sidebar-menu"][$menu_item_mapping[147]] = array(
        'gantrymenu_subtext' => '',
        'gantrymenu_icon' => '',
        'gantrymenu_submenu_cols' => '1',
    );

    update_option("gantry_menu_items", $gantry_menu_items);
}
/******************************************************************************/