<?php
/**
 * @version		1.24 June 26, 2012
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Widget based on the WordPress core Recent Posts Widget.
 */
/*
 * JAW Templates
 */

defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');

add_action('widgets_init', array("GantryWidgetJawContactForm", "init"));
add_action('jawcontactform_post', array("GantryWidgetJawContactForm", 'gantry_flush_widget_cache'));
add_action('transition_jawcontactform_status', array("GantryWidgetJawContactForm", 'gantry_flush_widget_cache'));

class GantryWidgetJawContactForm extends GantryWidget {

    var $short_name = 'jawcontactform';
    var $wp_name = 'gantry_jawcontactform';
    var $long_name = 'Jaw Contact Form';
    var $description = 'Jaw Contact Form Widget';
    var $css_classname = 'widget_gantry_jawcontactform';
    var $width = 200;
    var $height = 400;

    function gantry_flush_widget_cache() {
        wp_cache_delete('gantry_jawcontactform', 'widget');
    }

    function init() {
        register_widget("GantryWidgetJawContactForm");
    }

    function render_title($args, $instance) {
        global $gantry;
        if ($instance['title'] != '') :
            echo $instance['title'];
        endif;
    }

    function render($args, $instance) {
        global $gantry;
        
              $e_name = $instance['error-name'];
        $e_mail = $instance['error-mail'];
        $e_text = $instance['error-text'];
        $e_captcha = $instance['error-captcha'];
        $thanks = $instance['thanks'];
        $label_name = $instance['label-name'];
        $label_mail = $instance['label-mail'];
        $_SESSION['jaw_subject'] = $instance['subject'];
        $_SESSION['jaw_mailto'] = $instance['mailto'];
        $submit = $instance['submit-button'];
        
        
        
        if (isset($instance['captcha'])&&$instance['captcha']){ 
           
            require_once get_template_directory() . '/lib/securimage/securimage.php';
             $src = get_template_directory_uri() . "/lib/securimage/captcha.php";
            $securimage = new Securimage();
        }
       
        
        $cache = wp_cache_get('gantry_recentposts', 'widget');
       
        if (!is_array($cache))
            $cache = array();

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }

        $options = array(
                                         'mailto' => $instance['mailto'],
					 'captcha' => $instance['captcha'],
					'thanks' => $instance['thanks'],
					'subject' => $instance['subject'],
					'error_name' => $instance['error-name'],
					'error_mail' => $instance['error-mail'],
					'error_text' => $instance['error-text'],
					'error_captcha' => $instance['error-captcha'],
					'label_name' => $instance['label-name'],
					'label_mail' => $instance['label-mail'],
					'submit_button' => $instance['submit-button']
	    
                                    );
                                    
                                    
                                    
          $form = new jawcontactform(true,$options);
                                     
        ob_start(); 
        
        $form->render();
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('gantry_recentposts', $cache, 'widget');
    }

}