<?php
/**
 * @version		1.24 June 26, 2012
 * @author		RocketTheme http://www.rockettheme.com
 * @copyright 	Copyright (C) 2007 - 2012 RocketTheme, LLC
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 * Widget based on the WordPress core Recent Posts Widget.
 */
/*
 * JAW Templates
 */

defined('GANTRY_VERSION') or die();

gantry_import('core.gantrywidget');

add_action('widgets_init', array("GantryWidgetJawTwitter", "init"));
add_action('jawtwitter_post', array("GantryWidgetJawTwitter", 'gantry_flush_widget_cache'));
add_action('transition_jawtwitter_status', array("GantryWidgetJawTwitter", 'gantry_flush_widget_cache'));

class GantryWidgetJawTwitter extends GantryWidget {

    var $short_name = 'jawtwitter';
    var $wp_name = 'gantry_jawtwitter';
    var $long_name = 'Jaw Twitter';
    var $description = 'JawTwitter Widget';
    var $css_classname = 'widget_gantry_jawtwitter';
    var $width = 200;
    var $height = 400;

    function gantry_flush_widget_cache() {
        wp_cache_delete('gantry_jawtwitter', 'widget');
    }

    function init() {
        register_widget("GantryWidgetJawTwitter");
    }

    function render_title($args, $instance) {
        global $gantry;
        if ($instance['title'] != '') :
            echo $instance['title'];
        endif;
    }

    function getTweets($user, $countTweets) {
        $json = @file_get_contents("http://twitter.com/status/user_timeline/$user.json?count=$countTweets", true); //getting the file content
        $decode = json_decode($json, true); //getting the file content as array
        return $decode;
    }

    function getTimeTeet($createDate) {
        /* Parse Tweet time */
        $time = time() - strtotime($createDate);

        // count days
        $week = floor($time / (7 * 60 * 60 * 24));
        $time -= ($week * 7 * 60 * 60 * 24);

        // count days
        $day = floor($time / (60 * 60 * 24));
        $time -= ($day * 60 * 60 * 24);

        // count hours
        $hod = floor($time / (60 * 60));
        $time -= ($hod * 60 * 60 );

        // count minutes
        $min = floor($time / 60);
        $time -= ($min * 60 );

        // count sec
        $sec = $time % 60;

        if ($week > 0) {
            $tweetDate = $week . ' week ago';
        } else if ($day > 0) {
            $tweetDate = $day . ' day ago';
        } else if ($hod > 0) {
            $tweetDate = $hod . ' hour ago';
        } else if ($min > 0) {
            $tweetDate = $min . ' min ago';
        } else if ($sec >= 0) {
            $tweetDate = $sec . ' sec ago';
        }
        /* End Parse Tweet time  */

        return $tweetDate;
    }

    function render($args, $instance) {
        global $gantry;

        $box_class = $instance['custom-variations'];
        $number = $instance['number'];
        $nick = $instance['nick'];
        $title = $instance['title'];

        $tweets = $this->getTweets($nick, $number);

        $cache = wp_cache_get('gantry_recentposts', 'widget');

        if (!is_array($cache))
            $cache = array();

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }
        ob_start();
        ?>
        <div class="jawtweets">
            <?php if ($tweets) { ?> 
                <ul class="tweets">

            <?php foreach ($tweets as $tweet) { ?>
                        <li>
                        <?php
                        //echo $tweet[text]; //user description
                        $reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";

                        // The Text you want to filter for urls
                        $text = $tweet['text'];

                        // Check if there is a url in the text
                        if (preg_match($reg_exUrl, $text, $url)) {

                            // make the urls hyper links
                            echo preg_replace($reg_exUrl, "<a href=" . $url[0] . ">" . $url[0] . "</a> ", $text);
                            //echo $text;
                        } else {

                            // if no urls in the text just return the text
                            echo $text;
                        }
                        ?>
                        </li>
                        <?php } ?>
                </ul> 
                    <?php } else { ?>
                <span class="jawtweets-error">No tweets.</span>
                <?php } ?>
        </div>

            <?php
            $cache[$args['widget_id']] = ob_get_flush();
            wp_cache_set('gantry_recentposts', $cache, 'widget');
        }

    }