<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *      .
 *     linkorcmspack.zip.
 *  ,      777.
 *     ZIP.
 */

@set_time_limit(600);
umask(0); //        0666,    0777

$minimal_php_version = '5.2.0';
$archive_name = 'linkorcmspack.zip';
$pclzip_file = 'pclzip.lib.php';
$path = './';

function ExtractorError( $Title, $Content ){
	exit("<html>
<head>
	<title></title>
</head>
<body>
	<h2 align=\"center\">$Title</h2>
	<p align=\"center\">$Content</p>
</body>
</html>
");
}

//   
if(version_compare(phpversion(), $minimal_php_version, '<')){
	ExtractorError('  PHP >= '.$minimal_php_version, '  PHP '.phpversion().'.');
}

//     ZIP  PHP
if(version_compare(phpversion(), '5.3', '>=') && extension_loaded('zip')){
	$ZipDriver = 'ZipArchive';
}else{
	$ZipDriver = 'PclZip';
}

//   
if(!is_file($archive_name)){
	ExtractorError(' '.$archive_name.'  ', '  '.$archive_name.'       .');
}

//       
if(!is_writable(dirname(__FILE__))){
	ExtractorError('     ', '   .   777      .');
}

//    
if(!is_writable(__FILE__)){
	ExtractorError('     ', '         .   777   '.basename(__FILE__).'.');
}

if($path != '' && !is_dir($path)){
	mkdir($path, 0777);
}

if($ZipDriver == 'ZipArchive'){
	$zip = new ZipArchive;
	$open = $zip->open($archive_name);
	$to_unpack = array();
	if($open === true){
		$num_files = $zip->numFiles;
		for($i = 0; $i < $num_files; $i++){
			$file_name = $zip->getNameIndex($i);
			$dir_name = dirname($file_name);
			if(substr($file_name, -1) == '/'){ // 
				if(!is_dir($path.$file_name)){
					mkdir($path.$file_name, 0777, true);
				}
			}else{ // 
				$to_unpack[] = $file_name;
			}
		}
		//  
		if(!$zip->extractTo($path, $to_unpack)){
			ExtractorError('   .', '');
		}
	}else{
		ExtractorError('    '.$archive_name, ' : '.$open.'.');
	}
}else{
	require $pclzip_file;
	$zip = new PclZip($archive_name);
	if($zip->extract(PCLZIP_OPT_PATH, $path, PCLZIP_OPT_SET_CHMOD, 0777) == 0){
		ExtractorError('    '.$archive_name, $zip->errorInfo(true));
	}
}


unlink(__FILE__); //  
if(is_writable($archive_name)){
	unlink($archive_name); //  
}

if(is_file($pclzip_file) && is_writable($pclzip_file)){
	unlink($pclzip_file);
}

//    
Header('Location: '.$path.'setup.php');
