<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


class AdminPage extends PageTemplate{

	public $SideBarMenuLinks = array();
	public $FormRows = array();
	public $BreadCrumbs = array();
	public $ConfigGroups = array();

	/**
	 *        null
	 * @var null
	 */
	public $Mod = null;

	/**
	 *   ( ,   )
	 * @var string
	 */
	public $ModIcon = '';

	/**
	 *     BreadCrumbs      
	 * @var bool
	 */
	public $AutoBreadCrumbs = true;

	/**
	 *  Ajax
	 * @var Bool
	 */
	public $AjaxMode;
	/**
	 * @var Starkyt
	 */
	public $AjaxSidebarTemplate;
	/**
	 * @var Starkyt
	 */
	public $AjaxContentTemplate;

	/**
	 *   
	 * @var StarkytSubBlock
	 */
	public $CurrentContentSubBlock;

	/**
	 * @var StarkytBlock
	 */
	public $BlockTemplate;

	/**
	 * @var StarkytBlock
	 */
	public $BlockContentBox;

	/**
	 * @var StarkytBlock
	 */
	public $BlockContents;

	/**
	 * @var StarkytBlock
	 */
	public $BlockAdminBlocks;

	private $content_block = false;
	private $tool_menu_block = false;

	/**
	 *  
	 * @param  $PageTemplate     (body)
	 * @return void
	 */
	public function Init( $PageTemplate ){
		$this->AjaxMode = IsAjax();
		$this->InitPageTemplate($this->AjaxMode);
		$this->SetGZipCompressionEnabled(System::config('general/gzip_status') == '1');
		//   
		$Template = System::user()->Data('admin_template');
		if(!isset($Template)){
			$Template = 'default_admin';
		}
		$TemplateDir = System::config('tpl_dir').$Template.'/';
		$DefaultTemplateDir = System::config('tpl_dir').'default_admin'.'/';
		$this->SetRoot($TemplateDir);
		$this->DefaultRoot = $DefaultTemplateDir;
		$this->Title = '-';
		if($this->AjaxMode){ // AJAX  
			$this->AjaxSidebarTemplate = new Starkyt();
			$this->BlockAdminBlocks = $this->AjaxSidebarTemplate->NewBlock('admin_blocks', true, true, 'block');
			$this->AjaxSidebarTemplate->InitStarkyt($TemplateDir, 'sidebar_ajax.html');
			$this->AjaxContentTemplate = new Starkyt();
			$this->BlockContentBox = $this->AjaxContentTemplate->NewBlock('content_box', true, true);
			$this->AjaxContentTemplate->InitStarkyt($TemplateDir, 'content_box_ajax.html');
			Navigation::$StarkytDefault = $this->AjaxContentTemplate;
			Navigation::$AdminAjaxLinks = true;
		}else{ //   
			if(System::config('admin_panel/replace_logo')){
				$logo = '<span class="logo_text">'.System::config('general/site_name').'</span>';
			}else{
				$logo = '<img class="logo_image" src="'.str_replace('{template_root}', System::admin()->Root, System::config('admin_panel/logo')).'">';
			}
			$this->BlockTemplate = $this->NewBlock('template', true, false, 'page');
			$this->BlockTemplate->vars = array(
				'dir'                    => $this->Root,
				'admin_file'             => ADMIN_FILE,
				'admin_id'               => System::user()->Get('u_id'),
				'admin_name'             => System::user()->Get('u_name'),
				'admin_avatar'           => System::user()->Get('u_avatar'),
				'admin_avatar_small'     => System::user()->Get('u_avatar_small'),
				'admin_avatar_smallest'  => System::user()->Get('u_avatar_smallest'),
				'cms_name'               => CMS_NAME,
				'cms_version'            => CMS_VERSION,
				'cms_version_str'        => CMS_VERSION_STR,
				'site'                   => System::config('general/site_name'),
				'errors_text'            => '',
				'logo'                   => $logo,
				'tool_menu_block'        => false,
				'content_block'          => false
			);
			if(defined('MOD_DIR')){
				$this->BlockTemplate->vars['mdir'] = MOD_DIR.'templates/';
				$this->ModRoot = MOD_DIR.'templates/';
			}
			$this->BlockContentBox = $this->NewBlock('content_box', true, true, '', 'content_box.html');
			$this->BlockAdminBlocks = $this->NewBlock('admin_blocks', true, true, 'block');

			//   Admin
			System::admin()->AddOnLoadJS("\n\t".'Admin.Init("'.ADMIN_FILE.'", '.(System::config('admin_panel/enable_ajax') ? 'true' : 'false').');');

			$this->SetTempVar('head', 'body', $PageTemplate);
		}
	}

	public function InitPage(){
		$this->Init('theme_admin.html');
		UseScript('admin', 'jquery', 'jquery_ui', 'jquery_menu');
	}

	public function Login( $AuthMessage = '', $AuthTitle = ' ' ){
		$admin_name = '';
		$admin_password = '';
		$admin_template = '';
		if(isset($_POST['admin_login'])){
			$admin_name = $_POST['admin_name'];
			$admin_password = $_POST['admin_password'];
			$admin_template = $_POST['admin_template'];
		}else{
			$admin_template = System::user()->Data('admin_template');
			if(!isset($admin_template)){
				$admin_template = 'default_admin';
			}
		}
		$this->Init('login.html');
		$this->SetTempVar('head', 'body', 'login.html');
		$this->AddBlock('template', true, false, 'login');
		$this->Blocks['template']['vars'] = array(
			'action' => GetPageUri(true),
			'dir' => $this->Root,
			'auth_message' => $AuthMessage,
			'auth_title' => $AuthTitle,
			'admin_name' => $admin_name,
			'admin_password' => $admin_password
		);
		$this->AddBlock('admin_templates', true, true, 'at');
		$templates = System::database()->Select('templates', "`admin`='1'");
		foreach($templates as $t){
			$this->AddSubBlock('admin_templates', true, array(
					'name'=>SafeDB($t['folder'], 255, str),
					'title'=>SafeDB($t['name'], 255, str),
					'selected'=>($t['folder'] == $admin_template)
				)
			);
		}
		UseScript('admin', 'jquery', 'jquery_ui');
		$this->EchoAll();
		exit();
	}

	/**
	 *       .
	 * @param $subtitle
	 */
	public function AddSubTitle( $subtitle ){
		$this->Title .= ' > '.$subtitle;
	}

	/**
	 *    .
	 * @param $title
	 */
	public function AddCenterBox( $title ){
		$this->BlockContents = $this->BlockContentBox->NewSubBlock(true, array('title'=>$title), array(), '', '')->NewBlock('contents', true, true, 'content');
		$this->content_block = true;
	}

	/**
	 *     
	 * @param string $text
	 * @return void
	 */
	public function AddText( $text ){
		$this->BlockContents->NewSubBlock(true, array(), array(), '', $text);
	}

	/**
	 *   
	 * @param $title
	 * @param $text
	 */
	public function AddTextBox( $title, $text ){
		$this->AddCenterBox($title);
		$this->AddText($text);
	}

	/**
	 *    
	 */
	public function AddNavigation(){
		$this->BlockContents->NewSubBlock(true, array(), array(), 'navigation_subblock.html');
	}

	/**
	 *           
	 * @param string $name
	 */
	public function NotDeveloping( $name ){
		$text = ' <u>'.$name.'</u>      .';
		$this->AddTextBox('!!!   !!!', $text);
	}

	/**
	 *   
	 * @param $Text
	 * @return void
	 */
	public function Highlight( $Text ){
		$this->BlockContents->NewSubBlock(true, array('text'=>$Text), array(), 'highlight.html');
	}

	/**
	 *    
	 * @param $Text
	 * @return void
	 */
	public function HighlightError( $Text ){
		$this->BlockContents->NewSubBlock(true, array('text'=>$Text), array(), 'highlight_error.html');
	}

	/**
	 *   " "
	 * @param bool $exit   
	 */
	public function AccessDenied( $exit = true ){
		Header('HTTP/1.1 403 Forbidden');
		$this->AddCenterBox('');
		$this->HighlightError(' !');
		if($exit){
			$this->TEcho();
			exit();
		}
	}

	/**
	 *     ""  ""
	 * @param $Text
	 * @param $YesUrl
	 * @param string $CancelUrl
	 */
	public function HighlightConfirm( $Text, $YesUrl, $CancelUrl = 'javascript:history.go(-1)' ){
		$Text .= '<br /><br />'.$this->SpeedButton('', $CancelUrl, 'images/admin/delete.png', false, true).'&nbsp;&nbsp;'.$this->SpeedButton('', $YesUrl, 'images/admin/accept.png', true, true);
		$this->Highlight($Text);
	}

	public function HighlightConfirmNoAjax( $Text, $YesUrl, $CancelUrl = 'javascript:history.go(-1)' ){
		$Text .= '<br /><br />'.$this->SpeedButton('', $CancelUrl, 'images/admin/delete.png', false, true).'&nbsp;&nbsp;'.$this->SpeedButton('', $YesUrl, 'images/admin/accept.png', false, true);
		$this->Highlight($Text);
	}

	/**
	 *       
	 * @param string $Title
	 * @param string $Url
	 * @param string $ImgSrc
	 * @param bool $Ajax
	 * @param bool $ShowText
	 * @param string $OtherParams
	 * @return string <type>
	 */
	public function SpeedButton( $Title, $Url, $ImgSrc = '', $Ajax = true, $ShowText = false, $OtherParams = '' ){
		$text = '';
		if($ImgSrc != ''){
			$text = '<img src="'.$ImgSrc.'">';
			if($ShowText){
				$text .= '&nbsp;'.$Title;
				$Title = '';
			}
		}else{
			$text = $Title;
		}
		$OtherParams = ($OtherParams != '' ? $OtherParams.' class="button"' : 'class="button"');
		return $this->Link($text, $Url, $Title, $Ajax, $OtherParams);
	}

	/**
	 *  -   
	 * @param string $Title
	 * @param string $Url
	 * @param string $ImgSrc
	 * @param string $ConfirmMsg
	 * @param bool $Ajax
	 * @param bool $ShowText
	 * @param string $OtherParams
	 * @return string
	 */
	public function SpeedConfirm( $Title, $Url, $ImgSrc = '', $ConfirmMsg = '?', $Ajax = true, $ShowText = false, $OtherParams = '' ){
		$Title = HtmlChars($Title, ENT_QUOTES);
		$ConfirmMsg = HtmlChars($ConfirmMsg, ENT_QUOTES);
		if($ImgSrc != ''){
			$text = '<img src="'.$ImgSrc.'">';
			if($ShowText){
				$text .= '&nbsp;'.$Title;
				$Title = '';
			}
		}else{
			$text = $Title;
		}
		if($Ajax){
			$ajax = 'true';
		}else{
			$ajax = 'false';
		}
		return '<a title="'.$Title.'" href="'.$Url.'" class="button" onclick="return Admin.Buttons.Confirm(\''.$ConfirmMsg.'\', \''.$Url.'\',this, event, '.$ajax.');" onmousedown="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true);"'.($OtherParams != '' ? ' '.$OtherParams : '').'>'.$text.'</a>';
	}

	/**
	 *    JS   
	 * @param string $Title  
	 * @param string $OnClickJS JavaScript   
	 * @param string $ImgSrc   
	 * @param string $ConfirmMsg  ,  ,   
	 * @param bool $ShowText
	 * @param string $OtherParams
	 * @return string
	 */
	public function SpeedConfirmJs( $Title, $OnClickJS, $ImgSrc = '', $ConfirmMsg = '', $ShowText = false, $OtherParams = '' ){
		$Title = HtmlChars($Title);
		$OnClick = '';
		if($ConfirmMsg != ''){
			$ConfirmMsg = HtmlChars($ConfirmMsg, ENT_QUOTES);
			$OnClick = "if(confirm('$ConfirmMsg')){ ";
		}
		$OnClick .= "$OnClickJS;";
		if($ConfirmMsg != ''){
			$OnClick .= ' } ';
		}
		$OnClick .= "(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true); return false;";
		$text = '';
		if($ImgSrc != ''){
			$text = '<img src="'.$ImgSrc.'">';
			if($ShowText){
				$text .= '&nbsp;'.$Title;
				$Title = '';
			}
		}else{
			$text = $Title;
		}
		return '<a title="'.$Title.'" href="#" class="button" onclick="'.$OnClick.'" onmousedown="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true)"'.($OtherParams != '' ? ' '.$OtherParams : '').'>'.$text.'</a>';
	}

	/**
	 *      AJAX .        .
	 * @param  $EnabledTitle
	 * @param  $DisabledTitle
	 * @param  $AjaxUrl
	 * @param  $Status
	 * @param string $EnabledImage
	 * @param string $DisabledImage
	 * @param bool $ShowText
	 * @param bool $ShowImage
	 * @param string $OtherParams
	 * @return string
	 */
	public function SpeedStatus( $EnabledTitle, $DisabledTitle, $AjaxUrl, $Status, $EnabledImage = '', $DisabledImage = '', $ShowText = false, $ShowImage = true, $OtherParams = '' ){
		if($EnabledImage == '') $EnabledImage = 'images/bullet_green.png';
		if($DisabledImage == '') $DisabledImage = 'images/bullet_red.png';
		$Title = ($Status ? $EnabledTitle : $DisabledTitle);
		if($ShowImage){
			$ImgSrc = ($Status ? $EnabledImage : $DisabledImage);
			$text = '<img src="'.$ImgSrc.'">';
			if($ShowText){
				$text .= '&nbsp;<span class="status_button_title">'.$Title.'</span>';
				$Title = '';
			}
		}else{
			$text = $Title;
		}
		$EnabledTitle = HtmlChars($EnabledTitle, ENT_QUOTES);
		$DisabledTitle = HtmlChars($DisabledTitle, ENT_QUOTES);

		if($ShowText) $ShowText = 'true'; else $ShowText = 'false';
		if($ShowImage) $ShowImage = 'true'; else $ShowImage = 'false';
		if($Status) $Status = '1'; else $Status = '0';
		$OnClick = "Admin.Buttons.Status('$EnabledTitle', '$DisabledTitle', '$EnabledImage', '$DisabledImage', $ShowText, $ShowImage, '$AjaxUrl', this); (event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true); return false;";
		$s = '<a title="'.$Title.'" href="#" class="button" onclick="'.$OnClick.'" onmousedown="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true);" status="'.$Status.'"'.($OtherParams != '' ? ' '.$OtherParams : '').'>'.$text.'</a>';
		return $s;
	}

	public function SpeedAjax($Title, $AjaxUrl, $ImgSrc = '', $ConfirmMsg = '', $OnStart = '', $OnSuccess = '',
		$Method = 'post', $Params = '', $OtherParams = ''){
		$Title = HtmlChars($Title, ENT_QUOTES);
		$ConfirmMsg = HtmlChars($ConfirmMsg, ENT_QUOTES);
		$OnClick = "Admin.Buttons.Ajax('$AjaxUrl', function(link){ $OnStart }, function(data, textStatus, jqXHR){ $OnSuccess }, '$Method', '$Params', '$ConfirmMsg',  this); (event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true);";
		return '<a title="'.$Title.'" href="#" class="button" onclick="'.$OnClick.' return false;" onmousedown="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true);"'.($OtherParams != '' ? ' '.$OtherParams : '').'>'
			.($ImgSrc != '' ? '<img src="'.$ImgSrc.'">' : $Title).'</a>';
	}

	/**
	 *       Ajax             
	 * @param $Text
	 * @param $Address
	 * @param string $Title
	 * @param bool $Ajax
	 * @param string $Other
	 * @return string
	 */
	public function Link( $Text, $Address, $Title = '', $Ajax = true, $Other = '' ){
		$Address = HtmlChars($Address, ENT_QUOTES);
		$Title = HtmlChars($Title, ENT_QUOTES);
		if($Ajax){
			return '<a href="'.$Address.'" title="'.$Title.'" onclick="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true); return !Admin.LoadPage(\''.$Address.'\', event);" onmousedown="(event.stopPropagation ? event.stopPropagation() : event.cancelBubble = true);" '.$Other.'>'.$Text.'</a>';
		}else{
			return '<a href="'.$Address.'" title="'.$Title.'" '.$Other.'>'.$Text.'</a>';
		}
	}

	/**
	 *    
	 * @param $Caption
	 * @param $Control
	 * @param string $OtherParams
	 */
	public function FormRow( $Caption, $Control, $OtherParams = '' ){
		$this->FormRows[] = array('caption'=>$Caption, 'control'=>$Control, 'other_params'=>$OtherParams, 'type'=>'row');
	}

	/**
	 *   .
	 * @param string $TitleCaption
	 * @param string $OtherParams
	 * @return void
	 */
	public function FormTitleRow( $TitleCaption, $OtherParams = '' ){
		$this->FormRows[] = array('caption'=>$TitleCaption, 'other_params'=>$OtherParams, 'type'=>'title');
	}

	/**
	 *        
	 *
	 * @param string $Caption
	 * @param string $Control
	 * @param string $OtherParams
	 *
	 */
	public function FormTextRow( $Caption, $Control, $OtherParams = '' ){
		$this->FormRows[] = array('caption'=>$Caption, 'control'=>$Control, 'other_params'=>$OtherParams, 'type'=>'wide');
	}

	/**
	 *   
	 */
	public function FormClear(){
		$this->FormRows = array();
	}

	/**
	 *    
	 * @param $open
	 * @param $submit_btn
	 */
	public function AddForm( $open, $submit_btn ){
		$sub = $this->BlockContents->NewSubBlock(true, array(), array(), 'form.html', '');
		$rows = $sub->NewBlock('rows', true, true, 'row');

		foreach($this->FormRows as $row){
			$rows->NewSubBlock(true, $row);
		}
		$sub->vars = array('form_open'=>$open, 'form_submit'=>$submit_btn);
		$this->FormClear();
	}

	/**
	 *      
	 * @param $Groups
	 * @param bool $ShowTitles
	 * @return void
	 */
	public function ConfigGroups( $Groups, $ShowTitles = false ){
		if(!is_array($Groups)){
			$Groups = explode(',', $Groups);
		}
		foreach($Groups as $group){
			$this->ConfigGroups[] = array($group, $ShowTitles);
		}
	}

	/**
	 *     
	 * @param $Action
	 * @param string $ConfigTable
	 * @param string $GroupsTable
	 * @return void
	 */
	public function AddConfigsForm( $Action, $ConfigTable = 'config', $GroupsTable = 'config_groups' ){
		include_once System::config('inc_dir').'forms.inc.php'; //  

		$edit_configs = System::config('admin_panel/inline_edit_config') && System::user()->isSuperUser();
		$back = '';
		if($edit_configs){
			$back = SaveRefererUrl();
		}

		//      
		$configs_db = System::database()->Select($ConfigTable, "`visible`='1'");
		$configs = array();
		foreach($configs_db as $config){
			$configs[$config['group_id']][] = $config;
		}

		//   
		$groups_db = System::database()->Select($GroupsTable);
		$groups = array();
		foreach($groups_db as $gr){
			$groups[$gr['name']] = $gr;
		}

		//      
		$content_vars = array(
			'action' => $Action,
			'submit' => $this->Submit(''),
			'edit_configs' => $edit_configs
		);
		$form = $this->BlockContents->NewSubBlock(true, $content_vars, array(), 'config.html');
		$form_groups = $form->NewBlock('config_groups', true, true, 'group');

		foreach($this->ConfigGroups as $config_group){
			$group = $groups[$config_group[0]];
			if($config_group[1]){
				$group_title = SafeDB($group['hname'], 255, str);
			}else{
				$group_title = false;
			}
			$is_configs = isset($configs[$group['id']]);
			$group_vars = array(
				'title'=>$group_title,
				'noconfigs'=>!$is_configs,
				'edit_configs' => $edit_configs,
				'add_button' => ''
			);
			if($edit_configs){
				$group_vars['add_button'] = $this->SpeedButton(
					' ',
					ADMIN_FILE.'?exe=config_admin&group='.SafeDB($group['id'], 11, int).'&back='.$back.($ConfigTable == 'plugins_config' ? '&a=add_plugins&plugins=1' : '&a=add'),
					'images/admin/plus.png',
					true,
					true
				);
			}
			$form_group = $form_groups->NewSubBlock(true, $group_vars);
			$form_configs = $form_group->NewBlock('config_group_configs', $is_configs, true, 'config');
			if($is_configs){
				foreach($configs[$group['id']] as $config){
					$id = SafeDB($config['id'], 11, int);
					$name = SafeDB($group['name'], 255, str).'/'.SafeDB($config['name'], 255, str);
					$title = SafeDB($config['hname'], 255, str).($edit_configs ? ' <span style="color: #888">['.$name.']</span>' : '');
					$desc = SafeDB($config['description'], 255, str);
					$value = $config['value'];
					$kind = $config['kind'];
					$type = $config['type'];
					$values = $config['values'];
					$vars = array(
						'title' => $title,
						'description' => $desc,
						'controlvalue' => FormsGetControl($name, $value, $kind, $type, $values),
						'edit_buttons' => ''
					);
					if($edit_configs){
						$plug = ($ConfigTable == 'plugins_config' ? '&plugins=1' : '');
						$vars['edit_buttons'] = System::admin()->SpeedButton('', ADMIN_FILE.'?exe=config_admin&a=edit&id='.$id.'&back='.$back.$plug, 'images/admin/edit.png')
						.System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=config_admin&a=delete&id='.$id.'&ok=0&back='.$back.$plug, 'images/admin/delete.png', '     .  ,   .  ?');
					}
					$form_configs->NewSubBlock(true, $vars);
				}
			}
		}
	}

	public function SaveConfigs( $SaveGroups, $ConfigTable = 'config', $GroupsTable = 'config_groups' ){
		include_once System::config('inc_dir').'forms.inc.php';
		if(!is_array($SaveGroups)){
			$SaveGroups = explode(',', $SaveGroups);
		}

		//      
		$configs_db = System::database()->Select($ConfigTable, "`visible`='1'");
		$configs = array();
		foreach($configs_db as $config){
			$configs[$config['group_id']][] = $config;
		}

		//   
		$groups_db = System::database()->Select($GroupsTable);
		$groups = array();
		foreach($groups_db as $gr){
			$groups[$gr['name']] = $gr['id'];
		}

		foreach($SaveGroups as $group_name){
			$gid = $groups[$group_name];
			$group_name = strtr($group_name, '.', '_');// PHP        POST
			foreach($configs[$gid] as $config){
				$config_name = $config['name'];
				$post_name = $group_name.'/'.$config_name;
				if(isset($_POST[$post_name])){
					$name = $config_name;
					$kind = explode(':', $config['kind']);
					$kind = trim(strtolower($kind[0]));
					$save_func = trim($config['savefunc']);
					$type = trim($config['type']);
					if($type != ''){
						$type = explode(',', $type);
					}else{
						$type = array(255, str, false);
					}
					switch($kind){
						case 'edit':
						case 'radio':
						case 'combo':
						case 'text':
							if(FormsConfigCheck2Func('function', $save_func, 'save')){
								$save_func = CONF_SAVE_PREFIX.$save_func;
								$value = $save_func(FormsCheckType($_POST[$post_name], $type));
							}else{
								$value = FormsCheckType($_POST[$post_name], $type);
							}
							break;
						case 'check':
						case 'list':
							if(FormsConfigCheck2Func('function', $save_func, 'save')){
								$save_func = CONF_SAVE_PREFIX.$save_func;
								$value = $save_func(FormsCheckType($_POST[$post_name], $type));
							}else{
								if(isset($_POST[$post_name])){
									$c = count($_POST[$post_name]);
								}else{
									$c = 0;
								}
								$value = '';
								for($k = 0; $k < $c; $k++){
									$value .= ',';
									$value .= FormsCheckType($_POST[$post_name][$k], $type);
								}
								$value = substr($value, 1);
							}
							break;
						default:
							if(FormsConfigCheck2Func('function', $save_func, 'save')){
								$save_func = CONF_SAVE_PREFIX.$save_func;
								$value = $save_func(FormsCheckType($_POST[$post_name], $type));
							}else{
								$value = FormsCheckType($_POST[$post_name], $type);
							}
					}
					$where = "`name`='".SafeEnv($config_name, 255, str)."' and `group_id`='".SafeEnv($gid, 11, int)."'";
					System::database()->Update($ConfigTable, "`value`='$value'", $where); // FIXME:  
				}
			}
		}
		//   
		System::cache()->Clear('config');
	}

	/**
	 *      
	 * @param $menu
	 * @param int $parentId
	 * @return array
	 */
	protected function GenAdminMenu( &$menu, $parentId = 0 ){
		$menuData = array();
		if(!isset($menu[$parentId])){
			return $menuData;
		}
		$last_delimiter = false;
		foreach($menu[$parentId] as &$item){
			if($item['type'] == 'delimiter' && $last_delimiter){ //     
				continue;
			}
			$last_delimiter = false;
			$data = array(
				'id' => SafeDB($item['id'], 11, int),
				'title' => SafeDB($item['title'], 255, str),
				'icon' => SafeDB($item['icon'], 255, str),
				'submenu'   => $this->GenAdminMenu($menu, $item['id']),
				'type' => $item['type']
			);
			if($item['type'] == 'admin'){
				$data['admin_link'] = ADMIN_FILE.'?'.SafeDB($item['admin_link'], 255, str);
			}elseif($item['type'] == 'external'){
				$data['link'] = SafeDB($item['external_link'], 255, str);
				$data['blank'] = $item['blank'] == '1' ? 'true' : 'false';
			}elseif($item['type'] == 'js'){
				$data['js'] = SafeDB($item['js'], 0, str, false, false);
			}elseif($item['type'] == 'delimiter'){
				$last_delimiter = true;
			}
			$menuData[] = $data;
		}
		if($menuData[0]['type'] == 'delimiter'){
			array_shift($menuData);
		}
		if($menuData[count($menuData)-1]['type'] == 'delimiter'){
			array_pop($menuData);
		}
		return $menuData;
	}

	/**
	 *       JSON   .
	 *
	 * @return void
	 */
	public function AddAdminMenu(){
		if($this->AjaxMode) return; //     AJAX 
		$menu = System::database()->Select('adminmenu', "`enabled`='1'", null, 'order');
		$modulesdb = System::database()->Select('modules');
		$modules = array();
		foreach($modulesdb as $mod){
			$modules[$mod['folder']] = $mod;
		}
		$systemAdmin = System::user()->isSuperUser();
		$items = array(); //     
		foreach($menu as &$item){
			$mod = $item['module'];
			$show = true;
			if($mod != '' && isset($modules[$mod])){
				if($modules[$mod]['enabled'] != '1'){
					$show = false;
				}elseif(!$systemAdmin && ($modules[$mod]['system'] == '1' || !System::user()->CheckAccess2($mod, $mod))){
					$show = false;
				}
			}
			if($show){
				$items[$item['parent']][] = $item;
			}
		}
		$this->BlockTemplate->vars['menu_data'] = JsonEncode($this->GenAdminMenu($items));
	}

	/**
	 *     
	 * @param $Title
	 * @param $AdminLocation
	 * @param string $Icon
	 */
	public function BreadCrumbAdd( $Title, $AdminLocation = '', $Icon = '' ){
		if($AdminLocation == ''){
			$AdminLocation = GetPageUri(true);
		}else{
			$AdminLocation = ADMIN_FILE.'?'.$AdminLocation;
		}
		$crumb = array(
			'title'=>$Title,
			'link'=>$AdminLocation
		);
		if($Icon != '') $crumb['icon'] = $Icon;
		$this->BreadCrumbs[] = $crumb;
	}

	/**
	 *         
	 * @param $menu    jquery.menu
	 * @see GenAdminMenu
	 * @example [{id:"0", title:"", type: "admin", admin_link: "admin.php?exe=news"}, {}]
	 */
	public function BreadCrumbMenuSetData( $menu ){
		$this->BreadCrumbs[count($this->BreadCrumbs)-1]['menu'] = $menu;
	}

	/**
	 *          
	 * @param $AdminLocation
	 * @param $Title
	 * @param string $Icon
	 */
	public function BreadCrumbMenuItem( $Title, $AdminLocation, $Icon = '' ){
		$menu = &$this->BreadCrumbs[count($this->BreadCrumbs)-1]['menu'];
		$data = array(
			'id' => count($menu),
			'title' => $Title,
			'icon' => $Icon,
			'type' => 'admin',
			'admin_link' => ADMIN_FILE.'?'.$AdminLocation
		);
		$menu[] = $data;
	}

	/**
	 *          
	 * @param $AdminLocation
	 * @param $Title
	 * @param string $Icon
	 */
	public function BreadCrumbMenuDelimiter(){
		$menu = &$this->BreadCrumbs[count($this->BreadCrumbs)-1]['menu'];
		$data = array(
			'id' => count($menu),
			'type' => 'delimiter'
		);
		$menu[] = $data;
	}

	public function BreadCrumbsInit( $Ajax = false ){
		$crumbs = array();
		if(!$this->AjaxMode){ //   
			$menu = array();
			System::database()->Select('modules', "`enabled`='1' and `showinmenu`='1'", null, 'name');
			$mod_dir = System::config('mod_dir');
			while($row = System::database()->FetchRow()){
				if($row['folder'] == 'adminpanel') continue;
				$icon = '';
				if(is_file($mod_dir.$row['folder'].'/icon.png')){
					$icon = $mod_dir.$row['folder'].'/icon.png';
				}
				$menu[] = array(
					'id' => SafeDB($row['id'], 11, int),
					'title' => SafeDB($row['name'], 255, str),
					'icon' => $icon,
					'type' => 'admin',
					'admin_link' => ADMIN_FILE.'?exe='.SafeDB($row['folder'], 255, str)
				);
			}
			$crumbs[] = array(
				'title'=>'-',
				'link'=>ADMIN_FILE,
				'icon'=>'images/logo16.png',
				'default'=>true,
				'menu'=>$menu
			);
		}
		//   
		if($this->Mod !== null && $this->Mod['folder'] != 'adminpanel'){
			if($this->ModIcon == ''){
				$icon = MOD_ICON;
			}else{
				$icon = $this->ModIcon;
			}
			$crumbs[] = array(
				'title'=>SafeDB($this->Mod['name'], 255, str),
				'link'=>ADMIN_FILE.'?exe='.SafeDB($this->Mod['folder'], 255, str),
				'icon'=>$icon
			);
		}
		$this->BreadCrumbs = $crumbs;
	}

	/**
	 *    -   .
	 *     AJAX.
	 *
	 * @param  $Title   
	 * @param  $AdminLocation  -.  "exe=news&a=add"
	 * @param bool $Active
	 * @return void
	 */
	public function SideBarAddMenuItem( $Title, $AdminLocation, $Active = false ){
		$url = ADMIN_FILE.'?'.$AdminLocation;
		$js = "return Admin.LoadPage('$url', event);";
		$this->SideBarMenuLinks[] = array('title'=>$Title, 'js'=>$js, 'url'=>$url, 'active'=>$Active, 'del'=>false);
		if($this->AutoBreadCrumbs){
			$this->BreadCrumbMenuItem($Title, $AdminLocation);
		}
	}

	/**
	 *      .
	 *
	 * @param  $Title   
	 * @param  $Url 
	 * @param bool $External    /
	 * @param bool $Active
	 * @return void
	 */
	public function SideBarAddMenuItemLink( $Title, $Url, $External = false, $Active = false ){
		if($External){
			$js = "window.open('$Url'); return false;"; // TODO:   Admin.Leave
		}else{
			$js = "location = '$Url'; return false;";
		}
		$this->SideBarMenuLinks[] = array('title'=>$Title, 'js'=>$js, 'url'=>$Url, 'active'=>$Active, 'del'=>false);
	}

	/**
	 *     .       JavaScript .
	 *
	 * @param  $Title   
	 * @param  $JavaScript        
	 * @param bool $Active
	 * @return void
	 */
	public function SideBarAddMenuItemJs( $Title, $JavaScript, $Active = false ){
		$this->SideBarMenuLinks[] = array('title'=>$Title, 'js'=>$JavaScript, 'url'=>'#', 'active'=>$Active, 'del'=>false);
	}

	/**
	 *     .
	 *
	 * @return void
	 */
	public function SideBarAddMenuItemDelimiter(){
		$this->SideBarMenuLinks[] = array('title'=>'', 'js'=>'', 'url'=>'', 'active'=>null, 'del'=>true);
	}

	/**
	 *     .
	 *
	 * @param string $Title
	 * @param bool $ActiveItemActive
	 * @return StarkytBlock
	 */
	public function SideBarAddMenuBlock( $Title = '', $ActiveItemActive = true ){
		$menu = $this->BlockAdminBlocks->NewSubBlock(true, array('title'=>$Title), array(), 'block/menu.html')->NewBlock('menu_items', true, true, 'item');
		$active = null;
		foreach($this->SideBarMenuLinks as $link){
			if(isset($link['active']) && $link['active'] == $ActiveItemActive){
				$link['active'] = true;
				$active = $link;
			}else{
				$link['active'] = false;
			}
			$menu->NewSubBlock(true, $link);
		}
		$this->SideBarMenuLinks = array();
		$this->tool_menu_block = true;
		if($this->AutoBreadCrumbs && $active != null){
			$this->BreadCrumbAdd($active['title'], parse_url($active['url'], PHP_URL_QUERY));
		}
		return $menu;
	}

	/**
	 *      .
	 *
	 * @param $Title
	 * @param $Text
	 * @return StarkytSubBlock
	 */
	public function SideBarAddTextBlock( $Title, $Text ){
		$this->tool_menu_block = true;
		return $this->BlockAdminBlocks->NewSubBlock(true, array('title'=>$Title, 'content'=>$Text), array(), 'block/text.html');
	}

	/**
	 *       .
	 *
	 * @param  $Title
	 * @param  $TemplateFile
	 * @return StarkytSubBlock
	 */
	public function SideBarAddTemplatedBlock( $Title, $TemplateFile ){
		$this->tool_menu_block = true;
		return $this->BlockAdminBlocks->NewSubBlock(true, array('title'=>$Title), array('content'=>$TemplateFile), 'block/text.html');
	}

	/**
	 *   .
	 * @param bool $Return
	 * @return bool|void
	 */
	public function TEcho( $Return = false ){
		//     
		$ErrorsText = '';
		if(System::config('debug/php_errors')){
			$ErrorsText .= implode("<br>\n", System::$Errors);
		}
		if(ob_get_level() > 0 && ob_get_length() > 0){
			$ErrorsText .= ob_get_clean();
		}
		if($this->AjaxMode){
			$start = microtime(true);
			$response = array(
				'content'=>'',
				'sidebar'=>'',
				'show_sidebar'=>false,
				'css'=>array(),
				'js'=>array(),
				'js_inline'=>'',
				'js_onunload'=>'',
				'errors'=>'',
				'info'=>'',
				'title'=>'',
				'uri' => '', //   (    ,     )
				'mod' => $this->Mod,
				'mod_icon' => $this->ModIcon,
				'breadcrumbs_data' => $this->BreadCrumbs
			);
			$response['content'] = $this->AjaxContentTemplate->Compile();
			if($this->tool_menu_block){
				$response['sidebar'] = $this->AjaxSidebarTemplate->Compile();
			}else{
				$response['sidebar'] = '';
			}
			$response['show_sidebar'] = $this->tool_menu_block;

			foreach($this->css as $file){
				$response['css'][] = $file[0];
			}
			foreach($this->css_inc as $file){
				$response['css'][] = $file;
			}
			if($this->JQueryFile != ''){
				$response['js'][] = $this->JQueryFile;
				foreach($this->JQueryPlugins as $filename){
					$response['js'][] = $filename[0];
				}
			}
			foreach($this->js as $filename){
				$response['js'][] = $filename[0];
			}
			foreach($this->js_inc as $filename){
				$response['js'][] = $filename;
			}
			$response['js_inline'] = $this->TextJavaScript."\n".$this->OnLoadJavaScript;
			$response['onbeforeunload'] = $this->OnUnloadJavaScript;
			$response['errors'] = $ErrorsText;
			$response['info'] = $this->GetPageInfo($start);
			$response['title'] = $this->GenerateTitle();
			$response['uri'] = GetPageUri();
			echo JsonEncode($response);
			return true;
		}else{
			System::user()->OnlineProcess($this->Title);
			$this->BlockTemplate->vars['breadcrumbs_data'] = JsonEncode($this->BreadCrumbs);
			$this->BlockTemplate->vars['content_block'] = $this->content_block;
			$this->BlockTemplate->vars['tool_menu_block'] = $this->tool_menu_block;
			$this->BlockTemplate->vars['showinfo'] = System::config('general/show_script_time');
			$this->BlockTemplate->vars['errors_text'] = $ErrorsText;
			return $this->EchoAll($Return);
		}
	}

}

//        
/**
 *     
 * @param $Title 
 * @param $Action        
 * @param $Exe       "exe="
 */
function TAddToolLink( $Title, $Action, $Exe ){
	System::admin()->SideBarAddMenuItem($Title, 'exe='.$Exe, $Action);
}
/**
 *    
 * @param $CurrentAction   
 * @param string $Title   
 */
function TAddToolBox( $CurrentAction, $Title = '' ){
	System::admin()->SideBarAddMenuBlock($Title, $CurrentAction);
}

//   API
function AddCenterBox( $title ){System::admin()->AddCenterBox($title);}
function AddText( $text ){System::admin()->AddText($text);}
function AddTextBox( $title, $text ){System::admin()->AddTextBox($title, $text);}
function NotDeveloping( $name ){System::admin()->NotDeveloping($name);}
function SpeedButton( $Title, $Url, $ImgSrc ){return System::admin()->SpeedButton($Title, $Url, $ImgSrc);}
function TAddSubTitle( $subtitle ){System::admin()->AddSubTitle($subtitle);}
function AddNavigation(){System::admin()->AddNavigation();}
function FormRow( $capt, $ctrl ){System::admin()->FormRow($capt, $ctrl);}
function FormTextRow( $capt, $ctrl ){System::admin()->FormTextRow($capt, $ctrl);}
function AddForm( $open, $submit_btn ){System::admin()->AddForm($open, $submit_btn);}
function FormClear(){System::admin()->FormClear();}
function GenAdminMenu(){System::admin()->AddAdminMenu();}
function TEcho(){System::admin()->TEcho();}
