<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


abstract class System{

	static public $Errors = array();

	/**
	 *      .
	 * @return LcDatabaseFilesDB
	 */
	static public function database(){
		return $GLOBALS['db'];
	}

	/**
	 *        .
	 * @return User
	 */
	static public function user(){
		return $GLOBALS['user'];
	}

	/**
	 *   .
	 * @return LmFileCache
	 */
	static public function cache(){
		return LmFileCache::Instance();
	}

	/**
	 *     .
	 * @return Page
	 */
	static public function site(){
		if($GLOBALS['site'] == null){
			$GLOBALS['site'] = new Page();
		}
		return $GLOBALS['site'];
	}

	/**
	 *     -.
	 * @return AdminPage
	 */
	static public function admin(){
		if($GLOBALS['site'] == null){
			$GLOBALS['site'] = new AdminPage();
		}
		return $GLOBALS['site'];
	}

	static private function configs( $globalVarName, $Path, $SetValue = null ){
		static $Cache = array();
		if(!isset($SetValue) && isset($Cache[$Path])){
			return $Cache[$Path];
		}
		$Paths = explode('/', $Path);
		if(isset($Paths[1])){
			if(isset($SetValue)){
				$old_value = $GLOBALS[$globalVarName][$Paths[0]][$Paths[1]];
				$GLOBALS[$globalVarName][$Paths[0]][$Paths[1]] = $SetValue;
				ConfigSetValue($Paths[0], $Paths[1], $SetValue);
				if(isset($Cache[$Path])) {
					$Cache[$Path] = $SetValue;
				}
				return $old_value;
			}else{
				if(isset($GLOBALS[$globalVarName][$Paths[0]][$Paths[1]])){
					$Cache[$Path] = $GLOBALS[$globalVarName][$Paths[0]][$Paths[1]];
					return $GLOBALS[$globalVarName][$Paths[0]][$Paths[1]];
				}else{
					return false;
				}
			}
		}else{
			if(isset($GLOBALS[$globalVarName][$Path])){
				$Cache[$Path] = $GLOBALS[$globalVarName][$Path];
				return $GLOBALS[$globalVarName][$Path];
			}else{
				return false;
			}
		}
	}

	/**
	 *       .
	 * @static
	 * @param  $Path       
	 * @param null $SetValue     (  )
	 * @return mixed     ,   
	 */
	static public function config( $Path, $SetValue = null ){
		return self::configs('config', $Path, $SetValue);
	}

	/**
	 *    
	 * @static
	 * @param  $Path
	 * @return bool
	 */
	static public function plug_config( $Path ){
		return self::configs('plug_config', $Path);
	}

	/**
	 *    .
	 * @static
	 * @param string $Message
	 * @param bool $exit
	 * @return Logi
	 */
	static public function log_errors( $Message = '', $exit = false ){
		if(!isset($GLOBALS['ErrorsLog'])){
			$GLOBALS['ErrorsLog'] = new Logi(self::config('log_dir').'errors.log'); //    
		}
		if($Message != ''){
			$GLOBALS['ErrorsLog']->Write($Message, $exit);
		}
		return $GLOBALS['ErrorsLog'];
	}

	/**
	 *    .
	 * @static
	 * @param string $Message
	 * @param bool $exit
	 * @return Logi
	 */
	static public function log( $Message = '', $exit = false ){
		if(!isset($GLOBALS['SiteLog'])){
			$GLOBALS['SiteLog'] = new Logi(self::config('log_dir').'site.log');
		}
		if($Message != ''){
			$GLOBALS['SiteLog']->Write($Message, $exit);
		}
		return $GLOBALS['SiteLog'];
	}

	/**
	 *      .
	 * @static
	 * @param $No
	 * @param $Error
	 * @param $File
	 * @param $Line
	 */
	static public function error( $No, $Error, $File, $Line = -1 ){
		ErrorHandler($No, $Error, $File, $Line);
	}

	/**
	 *  .
	 * @param      $ClassName
	 * @param bool $Admin
	 * @return mixed
	 */
	static public function run( $ClassName, $Admin = false ){
		$anns = GetAnnotations($ClassName);
		$action_param = isset($anns['class']['ActionParam']) ? $anns['class']['ActionParam'] : 'a';
		$action = isset($_GET[$action_param]) ? $_GET[$action_param] : 'main';
		$title = isset($anns['class']['Title']) ? $anns['class']['Title'] : '';
		if($Admin && $title != '') self::admin()->AddSubTitle($title);
		foreach($anns['methods'] as $method=>$params){
			if(!isset($params['Action'])) continue;
			$actions = array();
			$titles = array();
			if(is_string($params['Action'])){
				$actions[] = $params['Action'];
			}else{
				$actions = $params['Action'];
			}
			/*
			 *  ActionParam      Action .
			 */
			if(($s = array_search($action, $actions)) !== false){
				$params['Action'] = $action;
				$anns['Action'] = $action;
				/*
				 *  .
				 *     Access    .
				 */
				if(isset($params['Access']) && !System::user()->CheckAccess2($params['Access'][0], $params['Access'][1])){
					if($Admin){
						System::admin()->AccessDenied();
					}else{
						Header('HTTP/1.1 403 Forbidden');
						System::site()->InitPage();
						System::site()->AddTextBox('', '<p align="center"> .</p>');
						System::site()->TEcho();
						exit;
					}
				}
				/*
				 *   .
				 */
				if(isset($params['Title'])){
					if(is_string($params['Title'])){
						$titles[] = $params['Title'];
					}else{
						$titles = $params['Title'];
					}
				}else{
					$titles[] = $title;
				}
				/*
				 *      (Action)
				 */
				$title = $titles[$s];
				$params['Title'] = $title;
				$anns['Title'] = $title;
				if($title != ''){
					if($Admin){
						self::admin()->AddSubTitle($title);
					}else{
						self::site()->SetTitle($title);
					}
				}
				/*
				 *     .
				 */
				$mod_obj = new $ClassName($anns);
				call_user_func(array($mod_obj, $method), $params);
			}
		}
	}

}

abstract class LController{
	public function __construct(){

	}
}

abstract class LAdminController{
	public function __construct(){

	}
}
