<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *        Ajax 
 */

/**
 *     Ajax (XMLHttpRequest) ?
 *
 * @return bool
 */
function IsAjax(){
	return isset($_SERVER['HTTP_X_REQUESTED_WITH']) ? $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' : false;
}

/**
 *     JSON
 *
 * @param     $Value   ,   .       resource.
 * @param int $Options      JSON_HEX_QUOT, JSON_HEX_TAG, JSON_HEX_AMP, JSON_HEX_APOS, JSON_NUMERIC_CHECK, JSON_PRETTY_PRINT, JSON_UNESCAPED_SLASHES, JSON_FORCE_OBJECT, JSON_UNESCAPED_UNICODE.
 * @return string
 * @since 1.3.5
 */
function JsonEncode($Value, $Options = 0){
	if(version_compare(PHP_VERSION, '5.3.0', '>=')){
		return json_encode(ObjectCp1251ToUtf8($Value), $Options);
	}else{
		return json_encode(ObjectCp1251ToUtf8($Value));
	}
}

/**
 *       JSON
 *
 * @param      $Json    Json  (string)  .
 * @param bool $Assoc    TRUE,       .
 * @param int  $Depth     .
 * @param int  $Options     JSON.      JSON_BIGINT_AS_STRING (           (float))
 * @return mixed
 * @since 1.3.5
 */
function JsonDecode($Json, $Assoc = true, $Depth = 128, $Options = 0){
	if(version_compare(PHP_VERSION, '5.4.0', '>=')){
		$decoded = json_decode($Json, $Assoc, $Depth, $Options);
	}elseif(version_compare(PHP_VERSION, '5.3.0', '>=')){
		$decoded = json_decode($Json, $Assoc, $Depth);
	}else{
		$decoded = json_decode($Json, $Assoc);
	}
	return ObjectUtf8ToCp1251($decoded);
}
