<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *   .
 * @param $Name
 * @param $ObjTable
 * @param $ObjIdColl
 * @param $ObjCounterColl
 * @param $ObjCounterCollIndex
 */
function RegisterCommentTable( $Name, $ObjTable, $ObjIdColl, $ObjCounterColl, $ObjCounterCollIndex, $SearchUrl = '', $SearchUfu = '', $SearchNavUfu = '', $PageParam = 'page' ){
	$vals = Values(
		'',
		$Name,
		$ObjTable,
		$ObjIdColl,
		$ObjCounterColl,
		$ObjCounterCollIndex,
		$SearchUrl,
		$SearchUfu,
		$SearchNavUfu,
		$PageParam
	);
	System::database()->Insert('comments', $vals);
}

/**
 *   
 * @param $Name
 * @param bool $Drop
 * @return void
 */
function UnRegisterCommentTable( $Name, $Drop = false ){
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('comments', "`table`='$Name'");
	if($Drop){
		System::database()->DropTable($Name);
	}
}

/**
 *       .
 *        SafeEnv.
 * @param $UserId
 * @param $NewUserId
 * @param $Name
 * @param $Email
 * @param $HideEmail
 * @param $HomePage
 * @param null $UserIp
 */
function UpdateUserComments( $UserId, $NewUserId, $Name, $Email, $HideEmail, $HomePage, $UserIp = null ){
	$set = "user_id='$NewUserId',user_name='$Name',user_homepage='$HomePage',user_email='$Email',"
	."user_hideemail='$HideEmail'".($UserIp<>null?",user_ip='$UserIp'":'');
	$where = "`user_id`='$UserId'";
	$ctables = System::database()->Select('comments', '');
	foreach($ctables as $table){
		System::database()->Update($table['table'], $set, $where);
	}
}

/**
 *    .
 * @param int $UserId
 * @return void
 */
function DeleteAllUserComments( $UserId ){
	$UserId = SafeEnv($UserId, 11, int);
	$where = "`user_id`='$UserId'";
	$ctables = System::database()->Select('comments');
	foreach($ctables as $table){
		$comms = System::database()->Select(SafeEnv($table['table'], 255, str), $where);
		$comments = array();
		$objects = array();
		// id   
		foreach($comms as $com){
			$comments[$com['object_id']] = SafeEnv($com['id'], 11, int);
			$objects[] = SafeEnv($com['object_id'], 11, int);
		}
		//      
		foreach($objects as $obj){
			$id_coll = SafeEnv($table['id_coll'], 255, str);
			CalcCounter(
				$table['objects_table'],
				"`$id_coll`='{$obj}'",
				$table['counter_coll'],
				count($comments[$obj]) * -1
			);
		}
		System::database()->Delete(SafeEnv($table['table'], 255, str), $where);
	}
}

/**
 *     .
 * @param $ObjTable
 * @param $WhereObj
 * @param $ObjCounterColl
 * @param $CalcVal
 */
function CalcCounter( $ObjTable, $WhereObj, $ObjCounterColl, $CalcVal ){
	$ObjCounterColl = SafeEnv($ObjCounterColl, 255, str);
    System::database()->Select($ObjTable, $WhereObj);
	if(System::database()->NumRows() > 0){
		$counterVal = System::database()->QueryResult[0][$ObjCounterColl] + $CalcVal;
		System::database()->Update($ObjTable, "$ObjCounterColl='$counterVal'", $WhereObj);
	}
}

function CommentsAddPost( $ObjectId, $CommentsTable, $ObjectsTable, $CounterField, $AlloyField, $BackUrl, $BackUrlUfu, $PageParam = 'page', $PageParamUfu = null, $BackUrlUfuSuffix = '' ){
	$parent_id = explode('_', $_POST['parent_id'], 2);
	if($parent_id[1] == 0){
		$sp = false;
	}else{
		$sp = true;
	}
	if(!isset($PageParamUfu)){
		$PageParamUfu = $PageParam;
	}
	$back_url = GetSiteUrl().Ufu(
		$BackUrl.($sp ? "&$PageParam=".$_GET[$PageParam] : ''),
		$BackUrlUfu.($sp ? $PageParamUfu.'{'.$PageParam.'}' : '').$BackUrlUfuSuffix
	);
	// -----------------------------------------------------
	System::database()->Select($ObjectsTable, "`id`='$ObjectId'");
	$obj = System::database()->FetchRow();
	$alloy_comments = $obj[$AlloyField] == '1';
	$posts = new Posts($CommentsTable, $alloy_comments);
	if($posts->SavePost($ObjectId, false)){
		$post_id = System::database()->GetLastId();
		$counter = $obj[$CounterField] + 1;
		System::database()->Update($ObjectsTable, "`$CounterField`='$counter'", "`id`='$ObjectId'");
		$parent_id = explode('_', $_POST['parent_id'], 2);
		$parent_id = SafeDB($parent_id[1], 11, int);
		$post_anchor = ($parent_id != 0 ? "#post_$parent_id" : '#post_'.$post_id);
		GO($back_url.$post_anchor);
	}else{
		System::site()->AddTextBox('', $posts->PrintErrors());
	}
}

function CommentsEditPost( $CommentsTable, $SaveUrl ){
	System::site()->AddTemplatedBox('','edit_comment.html');
	$posts = new Posts($CommentsTable);
	$posts->PostFormAction = $SaveUrl;
	$posts->RenderForm(true, 'post_form');
}

function CommentsEditPostSave( $ObjectId, $CommentsTable ){
	$posts = new Posts($CommentsTable);
	if($posts->SavePost($ObjectId, true)){
		$post_anchor = "#post_".SafeDB($_GET['post_id'], 11, int);
		GoRefererUrl($_REQUEST['back'], $post_anchor);
	}else{
		System::site()->AddTextBox('', $posts->PrintErrors());
		return false;
	}
}

function CommentsDeletePost( $ObjectId, $CommentsTable, $ObjectsTable, $CounterField, $DeleteUrl, $Anchor = '#comments' ){
	$posts = new Posts($CommentsTable);
	$posts->DeletePageUrl = $DeleteUrl;
	$deleted_posts_count = $posts->DeletePost();
	if($deleted_posts_count > 0){
		System::database()->Select($ObjectsTable, "`id`='$ObjectId'");
		$obj = System::database()->FetchRow();
		$counter = $obj[$CounterField] - $deleted_posts_count;
		System::database()->Update($ObjectsTable, "`$CounterField`='$counter'", "`id`='$ObjectId'");
		GoRefererUrl($_REQUEST['back'], $Anchor);
	}
}
