<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


// 
define('ERROR_HANDLER', true);
define('ERROR', 1);
define('WARNING', 2);
define('PARSE', 4);
define('NOTICE', 8);
define('CORE_ERROR', 16);
define('CORE_WARNING', 32);
define('COMPILE_ERROR', 64);
define('COMPILE_WARNING', 128);
define('USER_ERROR', 256);
define('USER_WARNING', 512);
define('USER_NOTICE', 1024);

/**
 *   
 * @return void
 */
function ErrorsOn(){
	global $SITE_ERRORS;
	$SITE_ERRORS = true;
}

/**
 *    
 * @return void
 */
function ErrorsOff(){
	global $SITE_ERRORS;
	$SITE_ERRORS = false;
}

/**
 *  .
 * @param  $No
 * @param  $Error
 * @param  $File
 * @param  $Line
 * @return void
 */
function ErrorHandler( $No, $Error, $File, $Line = -1 ){
	global $SITE_ERRORS;
	if(!$SITE_ERRORS) return;
	$root = GetSiteRoot();
	$errortype = array(
		1 => '', 2 => '!', 4 => ' ', 8 => '', 16 => ' ', 32 => ' !', 64 => ' ',
		128 => ' !', 256 => ' ', 512 => ' !', 1024 => ' ', 2048 => ' ',
		4096 => ' ', 8192 => ' ', 16384 => '  ()'
	);
	/*
	 *  HTML  .       css .
	 */
	$ErrorId = count(System::$Errors);
	$ErrorHtml = '<div class="debug_error_container" id="debug_error_'.$ErrorId.'" data-id="'.$ErrorId.'">';
	$ErrorHtml .= '<span class="debug_error"><span class="debug_error_type debug_error_type_'.$No.'">'.$errortype[$No].'</span>: '
		         .'<span class="debug_error_text">"'.SafeDB($Error, 255, str).'"</span>  <span class="debug_error_file">'.SafeDB(str_replace($root, '', $File), 255, str).'</span>'
		         .($Line > -1 ? '   <span class="debug_error_line">'.$Line.'</span>' : '')
		         .'.</span>';
	/*
	 *   
	 */
	$trace = array_reverse(debug_backtrace());
	array_pop($trace);
	$ErrorHtml .= "\n".'<div class="debug_backtrace_container" id="debug_backtrace_'.$ErrorId.'">';
	foreach($trace as $i=>$t){
		$ErrorHtml .= ($i+1).'. ';
		if(isset($t['class'])){
			$ErrorHtml .= '<span class="debug_backtrace_class">'.$t['class'].'</span>::';
		}
		if(isset($t['function'])){
			$ErrorHtml .= '<span class="debug_backtrace_function">'.SafeDB($t['function'], 255, str).'</span>';
		}
		if(isset($t['args']) && count($t['args'])){
			$ErrorHtml .= '(';
			foreach($t['args'] as $a){
				if(is_array($a)){
					$a = 'Array';
				}elseif(is_object($a)){
					$a = 'Object';
				}elseif(is_bool($a)){
					$a = ($a ? 'true' : 'false');
				}
				$ErrorHtml .= '<span class="debug_backtrace_arg">'.SafeDB((string)$a, 100, str).'</span>, ';
			}
			$ErrorHtml = substr($ErrorHtml, 0, -2).')';
		}
		if(isset($t['file'])){
			$ErrorHtml .= ' <span class="debug_backtrace_path">['.SafeDB(str_replace($root, '', $t['file']), 255, str).(isset($t['line']) ? ':'.$t['line'] : '').']</span>';
		}
		$ErrorHtml .= "<br>\n";
	}
	$ErrorHtml = substr($ErrorHtml, 0, -5).';';
	$ErrorHtml .= '</div></div>';
	/*
	 *     .
	 */
	System::$Errors[] = $ErrorHtml;
}

/**
 *     .
 * @param $No
 * @param $Error
 * @param $File
 * @param $Line
 */
function error_handler( $No, $Error, $File, $Line = -1 ){
	ErrorHandler($No, $Error, $File, $Line);
}
