<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


//     .
function IsMainHost( $url ){
	$host = $_SERVER['HTTP_HOST'];
	if(stristr(Url($url), Url($host))) {
		return true;
	}else{
		return false;
	}
}

/**
 *       .
 *    Header('Location: ...');
 *
 * @param String $address //  .
 * @param bool   $exit
 * @param int    $response_code
 * @return bool
 */
function GO( $address, $exit = true, $response_code = 303 ){
	if($address == '') return false;
	if(count(System::$Errors) == 0 || !System::config('debug/php_errors')){
		if($response_code == 302){
			Header('Location: '.$address);
		}else{
			Header('Location: '.$address, true, $response_code);
		}
		if($exit){
			exit;
		}
		return true;
	}else{
		return false;
	}
}

function GoBack( $exit = true, $response_code = 303 ){
	if(isset($_SERVER['HTTP_REFERER'])){
		return GO($_SERVER['HTTP_REFERER'], $exit, $response_code);
	}else{
		return GO(Ufu('index.php'), $exit, $response_code);
	}
}

//            
//      $BackSteps  ,       GoBack()
//   $BackSteps  .
function HistoryGoBack( $BackSteps, $exit = true, $response_code = 303 ){
	$history = System::user()->Get('HISTORY');
	if(isset($history[10-$BackSteps])){
		return GO($history[10-$BackSteps], $exit, $response_code);
	}else{
		return false;
	}
}

function HistoryGetUrl( $BackSteps ){
	$history = System::user()->Get('HISTORY');
	if(isset($history[10-$BackSteps])){
		return $history[10-$BackSteps];
	}else{
		return '';
	}
}

/**
 *       
 * @param string $Url  URL
 * @return String <type>
 */
function SaveRefererUrl( $Url = '' ){
	static $Cache;
	if(isset($Cache[$Url])){
		return $Cache[$Url];
	}
	if($Url == ''){ //   
		$Url = GetSiteHost(true).GetPageUri();
	}
	if(isset($_SESSION['saved_urls']) && in_array($Url, $_SESSION['saved_urls'])){
		$key = array_keys($_SESSION['saved_urls'], $Url);
		$Cache[$Url] = $key[0];
		return $key[0];
	}
	$id = GenRandomString(10);
	$_SESSION['saved_urls'][$id] = $Url;
	return $id;
}

/**
 *       
 * @param        $id      
 * @param string $anchor    . : #post244. -     .
 * @param bool   $unset_url   URL  
 * @return bool
 */
function GoRefererUrl( $id, $anchor = '', $unset_url = true ){
	if(isset($_SESSION['saved_urls'][$id])){
		$url = $_SESSION['saved_urls'][$id];
		if($unset_url){
			unset($_SESSION['saved_urls'][$id]);
		}
		return GO($url.$anchor);
	}else{
		return GO(HistoryGetUrl(2));
	}
}

function GetRefererUrl( $id, $unset_url = true ){
	if(isset($_SESSION['saved_urls'][$id])){
		$url = $_SESSION['saved_urls'][$id];
		if($unset_url){
			unset($_SESSION['saved_urls'][$id]);
		}
		return $url;
	}else{
		return HistoryGetUrl(2);
	}
}

/**
 *   ,    .
 * @param bool $EndSlash   
 * @return String
 * @since 1.3.3
 */
function GetSiteDir( $EndSlash = true ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = str_replace('\\', '/', dirname($_SERVER['PHP_SELF']));

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *      .
 * @param bool $EndSlash   
 * @return string
 */
function GetSiteRoot( $EndSlash = true ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = $_SERVER['DOCUMENT_ROOT'].GetSiteDir(true);

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *   
 * @return string
 */
function GetSiteDomain(){
	return getenv("HTTP_HOST");
}

/**
 *   
 * @param bool $EndSlash
 * @return void
 */
function GetSiteHost( $EndSlash = false ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = 'http://'.GetSiteDomain();

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *  URL        .
 *
 * @param bool $EndSlash
 * @return String
 * @since 1.3.3
 */
function GetSiteUrl( $EndSlash = true ){
	return GetSiteHost().GetSiteDir($EndSlash);
}

/**
 *     .
 * @param bool $FirstSlash
 * @return string
 */
function GetPageUri( $FirstSlash = false ){
	static $Result = null;
	if(isset($Result)){
		return ($FirstSlash ? '/' : '').$Result;
	}

	$Result = $_SERVER['REQUEST_URI'];

	if(substr($Result, 0, 1) == '/'){
		$Result = substr($Result, 1);
	}
	return ($FirstSlash ? '/' : '').$Result;
}

/**
 *    404   .
 * @param bool $Exit  false    .
 */
function Error404( $Exit = true ){
	Header("HTTP/1.1 404 Not Found");
	$path = System::config('tpl_dir').System::config('general/site_template').'/';
	if($path.'404.html'){
		$page = new Page('404.html', '', false, PAGE_AJAX);
		$page->TEcho(false, false);
	}else{
		readfile('errorpages/404.html');
	}
	if($Exit){
		exit;
	}
}