<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


define('PLUGINS', true);

//  
define('PLUG_AUTORUN', 1); //  (   config/init.php)
define('PLUG_ADMIN_AUTORUN', 2); //    
define('PLUG_MAIN_AUTORUN', 3); //    
// -------------
define('PLUG_CALLEE', 4); //    index.php&name=plugins&p=plugin_name (   modules/plugins/index.php)
// -------------
define('PLUG_MANUAL', 5); //        .  .
define('PLUG_MANUAL_ONE', 7); //   -   .  .
// ----------------------------
define('PLUG_SYSTEM', false); //  .  .

/**
 *   
 * @return void
 */
function PluginsClearCache(){
	System::cache()->Delete(system_cache, array('plugins', 'plugins_auto_main', 'plugins_auto_admin'));
}

/**
 *     
 * @return array
 */
function PluginsConfigsGroups(){
	$result = array();
	System::database()->Select('plugins_config_groups', '');
	while($group = System::database()->FetchRow()){
		$result[$group['name']] = $group;
	}
	return $result;
}

/**
 *            .
 * .
 * @return array
 */
function PluginsGetInstalled(){
	static $plugins = null;
	if(System::cache()->HasCache(system_cache, 'plugins')){
		$plugins = System::cache()->Get(system_cache, 'plugins');
	}
	if(!isset($plugins)){
		$plugins = System::database()->Select('plugins', "(`type`='5' or `type`='7') and `enabled`='1'");
		System::cache()->Write(system_cache, 'plugins', $plugins, Day2Sec);
	}
	return $plugins;
}

/**
 *     .
 * @param string $Group
 * @param string $function
 * @return arrays
 */
function PluginsGetInfo( $Group = '', $function = '' ){
	global $config;
	$plugins = PluginsGetInstalled();
	$plug_dir = System::config('plug_dir');
	$result = array();
	foreach($plugins as $plugin){
		if($Group == $plugin['group'] && ($function == '' || $function == $plugin['function'])){
			$include_plugin_path = RealPath2($plug_dir.$plugin['group'].'/'.$plugin['name']).'/';
			$info = ExtLoadInfo($include_plugin_path);
			$info['path'] = $include_plugin_path;
			$info['folder'] = $plugin['name'];
			$result[] = $info;
		}
	}
	return $result;
}

/**
 *   
 * @param $group 
 * @param string $function 
 * @param bool $return        
 * @return array
 */
function IncludePluginsGroup( $group, $function = '', $return = false ){
	global $config, $db, $user; //    
	global $include_plugin_path; //      
	$plugins = PluginsGetInstalled();
	$plug_dir = System::config('plug_dir');
	$result = array();
	foreach($plugins as $plugin){
		if($group == $plugin['group'] && ($function == '' || $function == $plugin['function'])){
			$include_plugin_path = RealPath2($plug_dir.$group.'/'.$plugin['name']).'/';
			if($return){
				$result[] = $include_plugin_path;
			}else{
				include $include_plugin_path.'index.php';
			}
		}
	}
	return $result;
}
