<?php

/**
 *  *    
 * @todo Annotations  
 * @param string|object $ClassObject
 * @param bool $WithMethods
 * @param bool $WithProperties
 * @return array
 */
function GetAnnotations( $ClassObject, $Cache = true, $WithMethods = true, $WithProperties = false ){
	if(is_object($ClassObject)){
		$ClassName = get_class($ClassObject);
	}else{
		$ClassName = $ClassObject;
	}
	$result = array();

	$ref  = new ReflectionClass($ClassName);
	$result['class'] = ParseAnnotations($ref->getDocComment());

	if($WithMethods){
		$result['methods'] = array();
		foreach($ref->getMethods() as $method){
			$result['methods'][$method->getName()] = ParseAnnotations($method->getDocComment());
		}
	}

	if($WithProperties){
		$result['properties'] = array();
		foreach($ref->getProperties() as $prop){
			$result['properties'][$prop->getName()] = ParseAnnotations($prop->getDocComment());
		}
	}

	return $result;
}

function ParseAnnotations( $DocComment ){
	preg_match_all('/@([a-zA-Z0-9_-]+)\:(.+)/', $DocComment, $parsed);
	$annotations = array();
	foreach($parsed[1] as $i=>$Name){
		$annotations[] = '"'.$Name.'": '.$parsed[2][$i];
	}
	$Json = '{'.implode(',', ObjectCp1251ToUtf8($annotations)).'}';
	return JsonDecode($Json);
}