<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *       .
 * @since 1.4.1
 */
function UfuInit(){
	if(System::config('general/ufu')){
		if(isset($_GET['ufu'])){
			$Path = trim($_GET['ufu']);
			if($Path != ''){
				$_GET = UfuRewrite($_GET['ufu']);
				if($_GET === false){
					Error404();
				}
			}
		}
	}
}

/**
 *   .
 * @param string $Ufu
 * @param bool $Clear
 * @return array
 */
function &UfuGetRules( $Ufu = null, $Clear = false ){
	static $UfuRewriteRules = null;
	if($Clear){
		$UfuRewriteRules = null;
		System::cache()->Delete(system_cache, 'rewrite_rules');
		return $UfuRewriteRules;
	}
	if($UfuRewriteRules == null){
		if(System::cache()->HasCache(system_cache, 'rewrite_rules')){
			$UfuRewriteRules = System::cache()->Get(system_cache, 'rewrite_rules');
		}else{
			$UfuRewriteRules = array();
			$_rules = System::database()->Select('rewrite_rules');
			SortArray($_rules, 'order');
			foreach($_rules as $_rule){
				$rule = array(
					'ufu' => $_rule['ufu'],
					'pattern' => $_rule['pattern'],
					'params' => $_rule['params']
				);
				if($_rule['module'] != '' && $_rule['name'] != ''){
					$UfuRewriteRules[$_rule['module'].':'.$_rule['name']] = $rule;
				}else{
					$UfuRewriteRules[$_rule['ufu']] = $rule;
				}
			}
			System::cache()->Write(system_cache, 'rewrite_rules', $UfuRewriteRules, Day2Sec);
		}
	}
	if(isset($Ufu)){
		if(isset($UfuRewriteRules[$Ufu])){
			return $UfuRewriteRules[$Ufu];
		}else{
			$null = null;
			return $null;
		}
	}
	return $UfuRewriteRules;
}

/**
 *      ,
 *      .
 *
 * @param $Path
 * @return bool
 */
function UfuRewrite( $Path ){
	$Rules = UfuGetRules();
	$search = array();
	$replace = array();
	foreach($Rules as $Rule){
		if(preg_match_all('/^'.$Rule['pattern'].'$/u', $Path, $matches)){
			foreach($matches as $i=>$m){
				$search[] = '$'.$i;
				$replace[] = $m[0];
			}
			parse_str(str_replace($search, $replace, $Rule['params']), $Params);
			return $Params;
		}
	}
	return false; //  
}

/**
 *  ()         .
 *
 * @param $text
 * @return mixed
 */
function UfuLink( $text ){
	$text = preg_replace('/[^[\pL_\-\.\ 0-9]+]*/u', '', Cp1251ToUtf8($text));
	$text = str_replace(array(' ', '_'), '-', $text);
	return Utf8ToCp1251($text);
}

/**
 *        .
 * @param      $UfuTemplate           .
 * @param      $Params           ,     "name=value&name2=val".
 * @param bool $PatternsInParams     .
 * @return array (RegExp, Replace)
 * @since 1.4.1
 */
function UfuGeneratePattern( $UfuTemplate, $Params, $PatternsInParams = false ){
	if(is_string($Params)){
		parse_str($Params, $Params);
	}

	$r_patterns = array(
		'{num}'  => '([0-9]+)',
		'{ustr}' => '([\pL_\-\.\ 0-9]+)',
		'{str}'  => '([a-zA-Z_\-\.\ 0-9]+)'
	);

	//            
	$temp_pos = array();
	foreach($Params as $key=>$val){
		$p = strpos($UfuTemplate, '{'.$key.'}');
		if($p !== false){
			$temp_pos[] = array($p, $key);
		}
	}
	SortArray($temp_pos, 0);
	$pos = array();
	foreach($temp_pos as $key=>$val){
		$pos[$val[1]] = $key+1;
	}

	//      
	$replace = array();
	$ReplacePattern = '';
	foreach($Params as $key=>$val){
		if(strpos($UfuTemplate, '{'.$key.'}') !== false){
			$param_pattern = '';
			if($val != ''){
				if($PatternsInParams){
					if(isset($r_patterns[$val])){
						$param_pattern = $r_patterns[$val];
					}else{
						$param_pattern = '('.$val.')';
					}
				}else{
					if(is_numeric($val)){
						$param_pattern = '([0-9]+)';
					}else{
						$param_pattern = '([\pL_\-\.\ 0-9]+)';
					}
				}
			}
			$replace['\{'.$key.'\}'] = $param_pattern;
			$ReplacePattern .= "$key=\${$pos[$key]}&";
		}else{
			$ReplacePattern .= "$key=$val&";
		}
	}
	if(substr($ReplacePattern, -1) == '&'){
		$ReplacePattern = substr($ReplacePattern, 0, -1);
	}
	$Pattern = strtr(preg_quote($UfuTemplate, '/'), $replace);
	return array($Pattern, $ReplacePattern);
}

/**
 *      .
 * @param int $Start
 * @return int
 */
function UfuGetOrder( $Start = 0 ){
	static $OrderCache = array();
	if(!isset($OrderCache[$Start])){
		$Max = $Start;
		foreach(System::database()->Select('rewrite_rules') as $rule){
			if($rule['order'] > $Max){
				$Max = $rule['order'];
			}
		}
		$OrderCache[$Start] = $Max;
	}
	$OrderCache[$Start] ++;
	return $OrderCache[$Start];
}

/**
 *       .
 * @param        $Module           .
 * @param        $Name              Ufu.
 * @param        $Description  .
 * @param        $Params         ,      UfuTemplate,       .
 *                                       .
 *                                   {num} - , {str} - ,  , {ustr} - Unicode ,
 *                                    -  ,  'name=news&topic=[0-9]{4}'.
 * @param        $UfuTemplate      ,             .
 *                            : 'news/{topic}/'
 * @param int   $MinOrder        . 0 -   , 1000 -  ( ), 5000 -  ( ), 10000 -  .
 *                                   ,    1000,    -  5000.
 * @return array                .
 * @since    1.4.1
 * @examples
 *
 *           UfuAddRuleByTemplate('news', 'topics', '   .', 'name=news&topic={num}', 'news/{topic}/');
 *           Ufu('index.php?name=news&topic=1', 'news:topics');
 *           UfuAddRuleByTemplate('news', 'topics-pagination', '    ( ).', 'name=news&topic={num}&page={num}', 'news/{topic}/page-{page}/');
 *           Ufu('index.php?name=news&topic=1', 'news:topics-pagination', 'page');
 */
function UfuAddRuleByTemplate( $Module, $Name, $Description, $Params, $UfuTemplate, $MinOrder = 5000 ){
	list($Pattern, $Replace) = UfuGeneratePattern($UfuTemplate, $Params, true);
	$rule = array(
		'id'=>'',
		'name'=>SafeEnv($Name, 255, str),
		'module'=>SafeEnv($Module, 255, str),
		'description'=>SafeEnv($Description, 255, str),
		'ufu'=>SafeEnv($UfuTemplate, 255, str),
		'pattern'=>SafeEnv($Pattern, 255, str),
		'params'=>SafeEnv($Replace, 255, str),
		'order'=>UfuGetOrder($MinOrder)
	);
	System::database()->Insert('rewrite_rules', Values($rule));
	$rule['id'] = System::database()->GetLastId();
	UfuGetRules(null, true);
	return $rule;
}

/**
 *      .
 *       Ufu().
 * @param        $UfuTemplate
 * @param        $Params
 * @param int    $MinOrder
 * @return array   .
 * @see UfuAddRuleByTemplate()
 */
function UfuAddRewriteRule( $UfuTemplate, $Params, $MinOrder = 10000 ){
	list($Pattern, $Replace) = UfuGeneratePattern($UfuTemplate, $Params);
	$rule = array(
		'id'=>'',
		'name'=>'',
		'module'=>'_any',
		'description'=>'',
		'ufu'=>SafeEnv($UfuTemplate, 255, str),
		'pattern'=>SafeEnv($Pattern, 255, str),
		'params'=>SafeEnv($Replace, 255, str),
		'order'=>UfuGetOrder($MinOrder)
	);
	System::database()->Insert('rewrite_rules', Values($rule));
	$rule['id'] = System::database()->GetLastId();
	UfuGetRules(null, true);
	return $rule;
}

/**
 *      .     ,     .
 * @param        $Module
 * @param string $Name
 */
function UfuRemoveRule( $Module, $Name = '' ){
	$Module = SafeEnv($Module, 255, str);
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('rewrite_rules', "`module`='$Module'".($Name != '' ? " and `name`='$Name'" : ''));
	UfuGetRules(null, true);
}

/**
 *      .
 * @param               $Url
 * @param string        $Ufu
 * @param string|bool   $NavLink
 * @param string        $NavParam
 * @param int           $MinOrder
 * @return string
 * @examples
 *           Ufu('index.php?name=news&topic=5', 'news/{topic}/');
 *           Ufu('index.php?name=news&topic=5', 'news:show-topics');
 */
function Ufu( $Url, $Ufu = '', $NavLink = null, $NavParam = null, $MinOrder = 10000 ){
	if(System::config('general/ufu')){
		if($Url == 'index.php'){
			return GetSiteUrl().'index.html';
		}

		//   
		$p = strpos($Url, '?');
		if($p !== false){
			$Url = substr($Url, $p + 1);
		}
		$p = strrpos($Url, '#');
		if($p !== false){
			$anchor = substr($Url, $p);
			$Url = substr($Url, 0, $p);
		}else{
			$anchor = '';
		}
		parse_str($Url, $params);

		// NavLink
		if(isset($NavLink) && !is_string($NavLink)){
			if($NavLink === true){
				if(isset($NavParam)){
					$NavLink = $NavParam;
				}else{
					$NavLink = 'page';
				}
			}else{
				$NavLink = null;
			}
		}

		//      ufu 
		$replace = array();
		foreach($params as $key=>$val){
			$replace['{'.$key.'}'] = rawurlencode(Cp1251ToUtf8($val));
		}

		//  
		$rule = UfuGetRules($Ufu);
		if(!isset($rule)){
			if(isset($NavLink)){
				$params[$NavLink] = '1';
			}
			$rule = UfuAddRewriteRule($Ufu, $params, $MinOrder);
		}

		//     
		return strtr($rule['ufu'], $replace).$anchor;
	}else{
		if($Url == 'index.php'){
			return GetSiteUrl().$Url;
		}else{
			$Url = new Url($Url);
			return $Url->ToString();
		}
	}
}
