<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


//   
// LinkorCMS Development Group
if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

$vars['title'] = $title;

$bcache_name = 'news'.System::user()->AccessLevel();
if(!System::cache()->HasCache('block', $bcache_name)){
	$block_config = unserialize($block_config);
	$topic = SafeDB($block_config['topic'], 11, int); //  
	$max_news = SafeDB($block_config['count'], 11, int); //    
	if($topic != 0){
		$where = "`enabled`='1' and `topic_id`='$topic'";
	}else{
		$where = "`enabled`='1'";
	}
	$newsdb = System::database()->Select('news', GetWhereByAccess('view', $where), $max_news, 'date', true);
	$news = array();
	foreach($newsdb as $new){
		$news[] = array(
			'title' => SafeDB($new['title'], 255, str),
			'text' => substr(SafeDB($new['start_text'], 0, str, true, false), 0, 255),
			'date' => $new['date'],
			'url' => Ufu('index.php?name=news&op=readfull&news='.SafeDB($new['id'], 11, int).'&topic='.SafeDB($new['topic_id'], 11, int), 'news/{topic}/{news}/')
		);
	}
	System::cache()->Write('block', $bcache_name, $news);
}else{
	$news = System::cache()->Get('block', $bcache_name);
}

$count = count($news);
$en = !($count == 0);
$tempvars['content'] = 'block/content/news.html';
System::site()->AddBlock('no_news', !$en);
System::site()->AddBlock('block_news', $en);
System::site()->AddBlock('block_news_news', true, true, 'news');

foreach($news as $new){
	$text = $new['text'];
	$pp = strpos($text, '. ');
	if($pp !== false){
		$text = substr($text, 0, $pp+1);
	}else{
		$text = substr($text, 0, 128).' ...';
	}
	$news_vars = array();
	$news_vars['title'] = $new['title'];
	$news_vars['url'] = $new['url'];
	$news_vars['text'] = $text;
	$news_vars['date'] = TimeRender($new['date']);
	System::site()->AddSubBlock('block_news_news', true, $news_vars);
}
