<?php

/*header*/

/**
 *  
 */

define('ACCESS_ADMIN', 1);
define('ACCESS_MEMBER', 2);
define('ACCESS_GUEST', 3);
define('ACCESS_ALL', 4);

/**
 *    
 *        
 * @param bool $LowProtect
 * @param bool $Redirect
 * @return void
 */
function HackOff( $LowProtect=false, $Redirect=true ){
	global $config;
	if(System::user()->isAdmin() || $LowProtect){
		if(defined('MAIN_SCRIPT') || defined('PLUG_SCRIPT') || !defined('ADMIN_SCRIPT')){
			if($Redirect){
				GO(Ufu('index.php'));
			}
		}elseif(defined('ADMIN_SCRIPT')){
			GO(ADMIN_FILE);
		}
	}else{
		if(System::config('security/hack_event') == 'alert'){
			die(System::config('security/hack_alert'));
		}elseif(System::config('security/hack_event') == 'ban'){
			die('     ,    
			   .   ,     , - 
			    e-mail '.System::config('general/site_email').'.');
		}else{
			if($Redirect){
				GO(Ufu('index.php'));
			}
		}
	}
}

/**
 *     
 * @param $Level
 * @param string $Admins
 * @param string $Members
 * @param string $Guests
 * @param string $All
 * @return string
 */
function ViewLevelToStr( $Level, $Admins='', $Members='', $Guests='', $All='' ){
	switch($Level){
		case 1: $Admins == '' ? $view = '<span style="color: #FF0000;"></span>' : $view = $Admins;
		break;
		case 2: $Members == '' ? $view = '<span style="color: #0080FF;"></span>' : $view = $Members;
		break;
		case 3: $Guests == '' ? $view = '<span style="color: #A0A000;"></span>' : $view = $Guests;
		break;
		case 4:
		default: $All == '' ? $view = '<span style="color: #008000;"></span>' : $view = $All;
	}
	return $view;
}

/**
 *          (),
 *       
 * @param $ParamName         
 * @param $ExWhere  
 * @param null $UserAccess   
 * @return string
 */
function GetWhereByAccess( $ParamName, $ExWhere = '', $UserAccess=null ){
	if($UserAccess == null){
		$UserAccess = System::user()->AccessLevel();
	}
	$where = "`$ParamName`='4'";
	if($UserAccess == ACCESS_ADMIN){ // 
		$where = '';
	}elseif($UserAccess == ACCESS_MEMBER){ // 
		$where .= " or `$ParamName`='2'";
	}else{ // 
		$where .= " or `$ParamName`='3'";
	}
	if($ExWhere != '' && $where != ''){
		return '('.$ExWhere.') and ('.$where.')';
	}elseif($ExWhere != '' && $where == ''){
		return $ExWhere;
	}elseif($ExWhere == '' && $where != ''){
		return $where;
	}else{
		return '';
	}
}

/**
 *             .
 * @param Integer $viewlevel   
 * @param null $user_access   
 * @internal param int $accesslevel   
 * @return Boolean
 */
 function AccessIsResolved( $viewlevel, $user_access = null ){
	if($user_access == null){
		$user_access = System::user()->AccessLevel();
	}
	if($user_access == ACCESS_ADMIN){
		return true;
	}elseif($user_access == ACCESS_MEMBER && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_MEMBER)){
		return true;
	}elseif($user_access == ACCESS_GUEST && ($viewlevel == ACCESS_ALL || $viewlevel == ACCESS_GUEST)){
		return true;
	}elseif($user_access == $viewlevel){
		return true;
	}
	return false;
}

/**
 *     ,        .
 * @param array|string $Conditions
 * @param array|string $Uri
 */
function VisibilityConditionsAdmin( $Conditions = array(), $Uri = array() ){
	if(is_string($Conditions)){
		$Conditions = unserialize($Conditions);
	}
	if(is_string($Uri)){
		$Uri = unserialize($Uri);
	}
	$extrauri = SafeDB(implode(WIN_EOL, $Uri), 0, str);

	//          
	$mods = System::database()->Select('modules', "`isindex`='1'");
	array_unshift($mods, array('name'=>' ', 'folder'=>'INDEX'));

	$num = 0;
	$ac = '';
	$ac .= Indent('
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
			<tr>
				<td style="border: none;"><label>'.System::site()->Radio('showin[]', 'SELECT_ONLY', in_array('SELECT_ONLY', $Conditions) || !in_array('ALL_EXCEPT', $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;"> :</span></label></td>
				<td style="border: none;"><label>'.System::site()->Radio('showin[]', 'ALL_EXCEPT', in_array('ALL_EXCEPT', $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;"> , :<span></label></td>
			</tr>
		</table>
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
	');
	foreach($mods as $a){
		if($num == 0){
			$ac .= '<tr>';
		}
		$num++;
		$ac .= '<td style="border: none;"><label>'.System::site()->Check('showin[]', SafeDB($a['folder'], 255, str), in_array(SafeDB($a['folder'], 255, str), $Conditions)).'<span style="display: inline-block; vertical-align: top; padding-top: 3px;">'.SafeDB($a['name'], 255, str).'</span></label></td>';
		if($num == 3){
			$ac .= '</tr>';
			$num = 0;
		}
	}
	if($num != 0){
		$ac .= '</tr>';
	}
	$ac .= Indent('
		</table>
		<table width="100%" cellspacing="0" cellpadding="0" style="margin-bottom: 5px;">
			<tr>
				<td style="border: none; padding-bottom: 4px;"> (URL):<br>: /index.php?name=pages&amp;file=page  /pages/page.html.    .</td>
			</tr>
			<tr>
				<td style="border: none;">'.System::site()->TextArea('extra_uri', $extrauri, 'style="width: 95%; min-width: 400px; height: 100px;"').'</td>
			</tr>
		</table>
	');
	System::admin()->FormTitleRow(' ');
	FormRow('', $ac);
}

/**
 *     .
 */
function VisibilityConditionsAdminSave( &$ShowIn, &$ShowInUri ){
	$ShowIn = serialize(SafeEnv($_POST['showin'], 0, str));
	$ShowInUri = serialize(SafeEnv(explode(WIN_EOL, $_POST['extra_uri']), 0, str));
}

/**
 *       .
 * @param array $Conditions
 * @param array $Uri
 * @return bool
 */
function VisibilityConditionsCheck( $Conditions = array(), $Uri = array() ){
	global $ModuleName;

	if(is_string($Conditions)){
		if($Conditions == ''){
			$Conditions = array();
		}else{
			$Conditions = unserialize($Conditions);
		}
	}
	if(is_string($Uri)){
		if($Uri == ''){
			$Uri = array();
		}else{
			$Uri = unserialize($Uri);
		}
	}

	$r = false;

	if(INDEX_PHP == true){
		if(in_array('INDEX', $Conditions)){
			$r = true;
		}
	}else{
		if(in_array($ModuleName, $Conditions)){
			$r = true;
		}elseif($_SERVER['REQUEST_URI'] != '' && in_array($_SERVER['REQUEST_URI'], $Uri)){
			$r = true;
		}
	}

	if(in_array('ALL_EXCEPT', $Conditions)){
		$r = !$r;
	}
	return $r;
}

/**
 *       .
 * @param type $Group
 * @param type $Name
 * @param type $Description
 */
function AddAccessRestriction( $Group, $Name, $Description ){
	$Group = SafeEnv($Group, 255, str);
	$Name = SafeEnv($Name, 255, str);
	$Description = SafeEnv($Description, 255, str);
	System::database()->Insert('access', "'','$Group','$Name','$Description'");
}

/**
 *    .
 * @param type $Group
 * @param type $Name
 */
function RemoveAccessRestriction( $Group, $Name ){
	System::database()->Delete('access', "`group`='$Group' and `name`='$Name'");
}

/*header*/

/**
 *     
 */

/**
 *        
 * @param $Title
 * @param $LoadTitle
 * @param $FileName
 * @param $Dir
 * @param string $Name
 * @param string $LoadName
 * @param string $FormName
 * @return void
 */
function AdminImageControl( $Title, $LoadTitle, $FileName, $Dir, $Name = 'image', $LoadName = 'up_image', $FormName = 'edit_form' ){
	$max_file_size = ini_get('upload_max_filesize');

	$images_data = array();
	$Dir = RealPath2($Dir).'/';

	$images = array();
	$images = GetFiles($Dir,false,true,'.gif.png.jpeg.jpg');
	$images[-1] = 'no_image/no_image.png';
	System::admin()->DataAdd($images_data,$images[-1],' ',($FileName == ''));

	$selindex = -1;
	for($i=0,$c=count($images)-1;$i<$c;$i++){
		if($FileName == $images[$i]){
			$sel = true;
			$selindex = $i;
		}else{
			$sel = false;
		}
		System::admin()->DataAdd($images_data, $images[$i], $images[$i], $sel);
	}

	$select = System::admin()->Select($Name,$images_data,false,'onchange="document.'.$FormName.'.iconview.src=\''.$Dir.'\'+document.'.$FormName.'.'.$Name.'.value;"');

	$ctrl = <<<HTML
<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
		<td valign="top" style="border-bottom:none;">$select</td>
	</tr>
	<tr>
		<td style="border-bottom:none; padding-top: 5px;" width="100%" align="left"><img height="80" id="iconview" src="$Dir{$images[$selindex]}"></td>
	</tr>
</table>
HTML;
	System::admin()->FormRow($Title, $ctrl);
	System::admin()->FormRow($LoadTitle, System::admin()->FFile($LoadName).'<br /><small>   *.jpg,*.jpeg,*.gif,*.png</small><br /><small>  : '.$max_file_size.'</small>');
}

/**
 *      
 * @param string $Email
 * @param string $Name
 * @return string
 */
function PrintEmail( $Email, $Name = '' ){
	$Email = SafeDB($Email, 255, str);
	$Name = SafeDB($Name, 255, str);
	if($Email == ''){
		return '&nbsp;';
	}else{
		return '<a href="mailto:'.$Email.'">'.($Name != '' ? $Name : $Email).'</a>';
	}
}

/*header*/

/**
 *        Ajax 
 */

/**
 *     Ajax (XMLHttpRequest) ?
 *
 * @return bool
 */
function IsAjax(){
	return isset($_SERVER['HTTP_X_REQUESTED_WITH']) ? $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' : false;
}

/**
 *     JSON
 *
 * @param     $Value   ,   .       resource.
 * @param int $Options      JSON_HEX_QUOT, JSON_HEX_TAG, JSON_HEX_AMP, JSON_HEX_APOS, JSON_NUMERIC_CHECK, JSON_PRETTY_PRINT, JSON_UNESCAPED_SLASHES, JSON_FORCE_OBJECT, JSON_UNESCAPED_UNICODE.
 * @return string
 * @since 1.3.5
 */
function JsonEncode($Value, $Options = 0){
	if(version_compare(PHP_VERSION, '5.3.0', '>=')){
		return json_encode(ObjectCp1251ToUtf8($Value), $Options);
	}else{
		return json_encode(ObjectCp1251ToUtf8($Value));
	}
}

/**
 *       JSON
 *
 * @param      $Json    Json  (string)  .
 * @param bool $Assoc    TRUE,       .
 * @param int  $Depth     .
 * @param int  $Options     JSON.      JSON_BIGINT_AS_STRING (           (float))
 * @return mixed
 * @since 1.3.5
 */
function JsonDecode($Json, $Assoc = true, $Depth = 128, $Options = 0){
	if(version_compare(PHP_VERSION, '5.4.0', '>=')){
		$decoded = json_decode($Json, $Assoc, $Depth, $Options);
	}elseif(version_compare(PHP_VERSION, '5.3.0', '>=')){
		$decoded = json_decode($Json, $Assoc, $Depth);
	}else{
		$decoded = json_decode($Json, $Assoc);
	}
	return ObjectUtf8ToCp1251($decoded);
}

/*header*/

/**
 *     
 */

/**
 *    ,   
 *       .
 *       .
 * @param  $ObjArray 
 * @param  $OnPage      
 * @param  $Page      
 * @return array
 */
function ArrayPage( &$ObjArray, $OnPage, $Page ){
	$pages_count = ceil(count($ObjArray) / $OnPage);
	if($Page < 1){
		$Page = 1;
	}elseif($Page > $pages_count){
		$Page = $pages_count;
	}
	$start = $OnPage * $Page - $OnPage;
	return array_slice($ObjArray, $start, $OnPage);
}

/**
 *     .      
 *       foreach.
 *
 * @param Array $Array    $array = array(array(col1=1,col2=2,...),arr...)
 *        
 * @param Integer $Colls             .
 * @param Boolean $OnDecreases  true       ,
 *          .
 * @return void
 */
function SortArray( &$Array, $Colls, $OnDecreases = false ) {
	global $SATempVar, //  
	       $SATempVar2; //    
	if (!function_exists('SorterUp')) {
		function SorterUp($a, $b){
			global $SATempVar;
			if ($a[$SATempVar] == $b[$SATempVar]) return 0;
			return ($a[$SATempVar] < $b[$SATempVar]) ? -1 : 1;
		}
		function SorterDown($a, $b){
			global $SATempVar;
			if ($a[$SATempVar] == $b[$SATempVar]) return 0;
			return ($a[$SATempVar] > $b[$SATempVar]) ? -1 : 1;
		}
		function SorterMulti($a, $b){
			global $SATempVar, $SATempVar2;
			$i = 0;
			$c = count($SATempVar);
			while($i < $c){
				if($a[$SATempVar[$i]] != $b[$SATempVar[$i]]){
					if($SATempVar2[$i]){
						return ($a[$SATempVar[$i]] > $b[$SATempVar[$i]]) ? -1 : 1;
					}else{
						return ($a[$SATempVar[$i]] < $b[$SATempVar[$i]]) ? -1 : 1;
					}
				}
				$i++;
			}
		}
	}
	$SATempVar = $Colls;
	if(is_array($SATempVar)){
		if(is_array($OnDecreases)){
			$SATempVar2 = $OnDecreases;
		}else{
			$SATempVar2 = array();
			foreach($Colls as &$coll){
				$SATempVar2[] = $OnDecreases;
			}
		}
		usort($Array, 'SorterMulti');
	}else{
		if($OnDecreases){
			usort($Array, 'SorterDown');
		}else{
			usort($Array, 'SorterUp');
		}
	}
}

/**
 *      
 * @param $Array
 * @param $Value
 * @param null $AfterKey
 * @param null $Key
 * @return array
 */
function InsertToArray( $Array, $Value, $AfterKey = null, $Key = null ){
	$newarray = array();
	foreach($Array as $sk=>$sv){
		if($Key == null){
			$newarray[] = $sv;
		}else{
			$newarray[$sk] = $sv;
		}
		if($sk == $AfterKey){
			if($Key == null){
				$newarray[] = $Value;
			}else{
				$newarray[$Key] = $Value;
			}
		}
	}
	return $newarray;
}

/**
 *     .
 * @param $Array
 * @param $Value
 * @param null $Key
 * @return array
 */
function InsertToArrayFirst( $Array, $Value, $Key = null){
	$newarray = array();
	if($Key == null){
		$newarray[] = $Value;
	}else{
		$newarray[$Key] = $Value;
	}
	foreach($Array as $sk=>$sv){
		if($Key == null){
			$newarray[] = $sv;
		}else{
			$newarray[$sk] = $sv;
		}
	}
	return $newarray;
}

/**
 *       
 * @param $Array 
 * @param $Key     
 * @param bool $SaveKeys     
 * @return void
 */
function DeleteFromArray( $Array, $Key, $SaveKeys = true ){
	$newarray = array();
	foreach($Array as $k=>$row){
		if($k == $Key) continue;
		if($SaveKeys){
			$newarray[$k] = $row;
		}else{
			$newarray[] = $row;
		}
	}
	return $newarray;
}

/**
 *       .
 * @param $Action
 * @return bool
 */
function Audit( $Action ){
	if(System::user()->Auth == false) return false;
	$user_ip = getip();
	$user_id = System::user()->Get('u_id');
	$date = time();
	$Action = SafeEnv($Action, 255, str);
	System::database()->Insert('audit', Values('', $user_id, $date, $Action, $user_ip));
	return true;
}

/**
 *     .
 * @param $referer
 */
function AuditWriteReferer( $referer ){
	if(trim($referer) != '' && !IsMainHost($referer)){
		$referer = SafeEnv(Url($referer), 255, str);
		$count = 1;
		System::database()->Select('referers', "`referer`='$referer'");
		if(System::database()->NumRows() > 0){
			$ref = System::database()->FetchRow();
			$count = SafeDB($ref['count'], 11, int);
			$count++;
			System::database()->Update('referers', "count='$count'", "`referer`='$referer'");
		}else{
			$values = Values('', $referer, $count);
			System::database()->Insert('referers', $values);
		}
	}
}

/*header*/

/**
 *  
 */

/**
 *  
 * @param $ClassName
 */
function __autoload( $ClassName ){
	if(isset($GLOBALS['system_autoload'][$ClassName])){
		require_once $GLOBALS['system_autoload'][$ClassName];
	}else{
		ErrorHandler(E_USER_ERROR, 'Class not found: '.$ClassName, __FILE__, __LINE__);
	}
}

/**
 *    
 * @param $ClassName  
 * @param $FileName  
 */
function RegisterClass( $ClassName, $FileName ){
	$GLOBALS['system_autoload'][$ClassName] = $FileName;
}

/**
 *     
 * @param $ClassesArray      
 * @param string $Path   
 */
function RegisterClassesArray( $ClassesArray, $Path = '' ){
	foreach($ClassesArray as $class=>$file){
		$GLOBALS['system_autoload'][$class] = $Path.$file;
	}
}

/**
 *       
 * @param string|array $ClassName
 */
function UnregisterClass( $ClassName ){
	if(is_array($ClassName)){
		foreach($ClassName as $class){
			unset($GLOBALS['system_autoload'][$class]);
		}
	}else{
		unset($GLOBALS['system_autoload'][$ClassName]);
	}
}

/*header*/

/**
 * BBCode 
 */

/**
 *    BB-
 * @param $tag
 * @param $part
 * @return mixed|string
 */
function BbCodeTag( $tag, $part ){
	static $first_run = true;
	if($first_run){
		$first_run = false;
		ini_set('highlight.string', '#008800');
		ini_set('highlight.comment', '#969696');
		ini_set('highlight.keyword', '#0000DD');
		ini_set('highlight.default', '#444444');
		ini_set('highlight.html', '#0000FF');
	}
	switch($tag){
		case 'php':
			$part = str_replace('<br />', '', $part);
			$part = HtmlCharsDecode($part);
			if(substr($part, 0, 2) != '<?'){
				$part = "<?\n".$part."\n?>";
			}
			$part = '<div class="bbcode_php">'.highlight_string($part, true).'</div>';
			break;
	}
	return $part;
}

/**
 *   
 * @param  $Text
 * @return string
 */
function BbCodePrepare( $Text ){
	$preg = array(
		'~\[s\](.*?)\[\/s\]~si' => '<del>$1</del>',
		'~\[b\](.*?)\[\/b\]~si' => '<strong>$1</strong>',
		'~\[i\](.*?)\[\/i\]~si' => '<em>$1</em>',
		'~\[u\](.*?)\[\/u\]~si' => '<u>$1</u>',
		'~\[color=(.*?)\](.*?)\[\/color\]~si' => '<span style="color:$1;">$2</span>',
		'~\[size=(.*?)\](.*?)\[\/size\]~si' => '<span style="font-size:$1px;">$2</span>',
		'~\[div=(.*?)\](.*?)\[\/div\]~si' => '<div style="$1">$2</div>',
		'~\[p=(.*?)\](.*?)\[\/p\]~si' => '<p style="$1">$2</p>',
		'~\[span=(.*?)\](.*?)\[\/span\]~si' => '<span style="$1">$2</span>',
		'~\[left (.*?)\](.*?)\[\/left\]~si' => '<div style="text-align: left; $1">$2</div>',
		'~\[left\](.*?)\[\/left\]~si' => '<div style="text-align: left;">$1</div>',
		'~\[right (.*?)\](.*?)\[\/right\]~si' => '<div style="text-align: right; $1">$2</div>',
		'~\[right\](.*?)\[\/right\]~si' => '<div style="text-align: right;">$1</div>',
		'~\[center (.*?)\](.*?)\[\/center\]~si' => '<div style="text-align: center; $1">$2</div>',
		'~\[center\](.*?)\[\/center\]~si' => '<div style="text-align: center;">$1</div>',
		'~\[justify\](.*?)\[\/justify\]~si' => '<p style="text-align: justify;">$1</p>',
		'~\[pleft\](.*?)\[\/pleft\]~si' => '<p style="text-align: left;">$1</p>',
		'~\[pright\](.*?)\[\/pright\]~si' => '<p style="text-align: right;">$1</p>',
		'~\[pcenter\](.*?)\[\/pcenter\]~si' => '<p style="text-align: center;">$1</p>',
		'~\[br\]~si' => '<br clear="all">',
		'~\[hr\]~si' => '<hr color="#B5B5B5">',
		'~\[line\]~si' => '<hr>',
		'~\[table\]~si' => '<div><table border="1" cellspacing="1" cellpadding="1" width="50%" style="margin:10px;  float:left;" >',
		'~\[\/table\]~si' => '</table></div>',
		'~\[tr\]~si' => '<tr>',
		'~\[\/tr\]~si' => '</tr>',
		'~\[td\]~si' => '<td style="padding:10px;">',
		'~\[\/td\]~si' => '</td>',
		'~\[th\]~si' => '<th>',
		'~\[\/th\]~si' => '</th>',
		'~\[\*\](.*?)\[\/\*\]~si' => '<li>$1</li>',
		'~\[\*\]~si' => '<li>',
		'~\[ul\](.*?)\[\/ul\]~si' => "<ul>$1</li></ul>",
		'~\[list\](.*?)\[\/list\]~si' => "<ul>$1</li></ul>",
		'~\[ol\](.*?)\[\/ol\]~si' => '<ol>$1</li></ol>',
		'~\[php\](.*?)\[\/php\]~sei' => "'<span>'.BbCodeTag('php', '$1').'</span>'",
		'~\[hide\](.*?)\[\/hide\]~sei' => "'<div class=\"bbcode_hide\"><a href=\"javascript:onclick=ShowHide(\''.strlen(md5('$1')).substr(md5('$1'),0,3).'\')\"> </a><div id=\"'.strlen(md5('$1')).substr(md5('$1'),0,3).'\" style=\"visibility: hidden; display: none;\">$1</div></div>'",
		'~\[h1\](.*?)\[\/h1\]~si' => '<h1>$1</h1>',
		'~\[h2\](.*?)\[\/h2\]~si' => '<h2>$1</h2>',
		'~\[h3\](.*?)\[\/h3\]~si' => '<h3>$1</h3>',
		'~\[h4\](.*?)\[\/h4\]~si' => '<h4>$1</h4>',
		'~\[h5\](.*?)\[\/h5\]~si' => '<h5>$1</h5>',
		'~\[h6\](.*?)\[\/h6\]~si' => '<h6>$1</h6>',
		'~\[video\](.*?)\[\/video\]~sei' => "'<div align=\"center\">'.strip_tags(HtmlCharsDecode('$1'), '<object><param><embed>').'</div>'",
		'~\[code\](.*?)\[\/code\]~si' => '<div class="bbcode_code"><code>$1</code></div>',
		'~\[email\](.*?)\[\/email\]~sei' => "AntispamEmail('$1')",
		'~\[email=(.*?)\](.*?)\[\/email\]~sei' => "'<a rel=\"noindex\" href=\"mailto:'.str_replace('@', '.at.','$1').'\">$2</a>'",
		'~\[url\](.*?)\[\/url\]~sei' => "'<a href=\"'.UrlRender('$1').'\" target=\"_blank\">$1</a>'",
		'~\[url=(.*?)?\](.*?)\[\/url\]~sei' => "'<a href=\"'.UrlRender('$1').'\" target=\"_blank\">$2</a>'",
		'~\[img=(.*?)x(.*?)\](.*?)\[\/img\]~si' => '<img src="$3" style="width: $1px; height: $2px" >',
		'~\[img (.*?)\](.*?)\[\/img\]~si' => '<img src="$2" title="$1" alt="$1">',
		'~\[img\](.*?)\[\/img\]~si' => '<a href="$1" target="_blank"><img src="$1"></a>',
		'~\[quote\](.*?)\[\/quote\]~si' => '<div class="bbcode_quote">$1</div>',
		'~\[quote=(?:&quot;|"|\')?(.*?)["\']?(?:&quot;|"|\')?\](.*?)\[\/quote\]~si' => '<div class="bbcode_quote"><strong>$1:</strong>$2</div>',
	);
	$Text = preg_replace(array_keys($preg), array_values($preg), $Text);
	return $Text;
}

/*header*/

/**
 *   .
 * @param $Name
 * @param $ObjTable
 * @param $ObjIdColl
 * @param $ObjCounterColl
 * @param $ObjCounterCollIndex
 */
function RegisterCommentTable( $Name, $ObjTable, $ObjIdColl, $ObjCounterColl, $ObjCounterCollIndex, $SearchUrl = '', $SearchUfu = '', $SearchNavUfu = '', $PageParam = 'page' ){
	$vals = Values(
		'',
		$Name,
		$ObjTable,
		$ObjIdColl,
		$ObjCounterColl,
		$ObjCounterCollIndex,
		$SearchUrl,
		$SearchUfu,
		$SearchNavUfu,
		$PageParam
	);
	System::database()->Insert('comments', $vals);
}

/**
 *   
 * @param $Name
 * @param bool $Drop
 * @return void
 */
function UnRegisterCommentTable( $Name, $Drop = false ){
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('comments', "`table`='$Name'");
	if($Drop){
		System::database()->DropTable($Name);
	}
}

/**
 *       .
 *        SafeEnv.
 * @param $UserId
 * @param $NewUserId
 * @param $Name
 * @param $Email
 * @param $HideEmail
 * @param $HomePage
 * @param null $UserIp
 */
function UpdateUserComments( $UserId, $NewUserId, $Name, $Email, $HideEmail, $HomePage, $UserIp = null ){
	$set = "user_id='$NewUserId',user_name='$Name',user_homepage='$HomePage',user_email='$Email',"
	."user_hideemail='$HideEmail'".($UserIp<>null?",user_ip='$UserIp'":'');
	$where = "`user_id`='$UserId'";
	$ctables = System::database()->Select('comments', '');
	foreach($ctables as $table){
		System::database()->Update($table['table'], $set, $where);
	}
}

/**
 *    .
 * @param int $UserId
 * @return void
 */
function DeleteAllUserComments( $UserId ){
	$UserId = SafeEnv($UserId, 11, int);
	$where = "`user_id`='$UserId'";
	$ctables = System::database()->Select('comments');
	foreach($ctables as $table){
		$comms = System::database()->Select(SafeEnv($table['table'], 255, str), $where);
		$comments = array();
		$objects = array();
		// id   
		foreach($comms as $com){
			$comments[$com['object_id']] = SafeEnv($com['id'], 11, int);
			$objects[] = SafeEnv($com['object_id'], 11, int);
		}
		//      
		foreach($objects as $obj){
			$id_coll = SafeEnv($table['id_coll'], 255, str);
			CalcCounter(
				$table['objects_table'],
				"`$id_coll`='{$obj}'",
				$table['counter_coll'],
				count($comments[$obj]) * -1
			);
		}
		System::database()->Delete(SafeEnv($table['table'], 255, str), $where);
	}
}

/**
 *     .
 * @param $ObjTable
 * @param $WhereObj
 * @param $ObjCounterColl
 * @param $CalcVal
 */
function CalcCounter( $ObjTable, $WhereObj, $ObjCounterColl, $CalcVal ){
	$ObjCounterColl = SafeEnv($ObjCounterColl, 255, str);
    System::database()->Select($ObjTable, $WhereObj);
	if(System::database()->NumRows() > 0){
		$counterVal = System::database()->QueryResult[0][$ObjCounterColl] + $CalcVal;
		System::database()->Update($ObjTable, "$ObjCounterColl='$counterVal'", $WhereObj);
	}
}

function CommentsAddPost( $ObjectId, $CommentsTable, $ObjectsTable, $CounterField, $AlloyField, $BackUrl, $BackUrlUfu, $PageParam = 'page', $PageParamUfu = null, $BackUrlUfuSuffix = '' ){
	$parent_id = explode('_', $_POST['parent_id'], 2);
	if($parent_id[1] == 0){
		$sp = false;
	}else{
		$sp = true;
	}
	if(!isset($PageParamUfu)){
		$PageParamUfu = $PageParam;
	}
	$back_url = GetSiteUrl().Ufu(
		$BackUrl.($sp ? "&$PageParam=".$_GET[$PageParam] : ''),
		$BackUrlUfu.($sp ? $PageParamUfu.'{'.$PageParam.'}' : '').$BackUrlUfuSuffix
	);
	// -----------------------------------------------------
	System::database()->Select($ObjectsTable, "`id`='$ObjectId'");
	$obj = System::database()->FetchRow();
	$alloy_comments = $obj[$AlloyField] == '1';
	$posts = new Posts($CommentsTable, $alloy_comments);
	if($posts->SavePost($ObjectId, false)){
		$post_id = System::database()->GetLastId();
		$counter = $obj[$CounterField] + 1;
		System::database()->Update($ObjectsTable, "`$CounterField`='$counter'", "`id`='$ObjectId'");
		$parent_id = explode('_', $_POST['parent_id'], 2);
		$parent_id = SafeDB($parent_id[1], 11, int);
		$post_anchor = ($parent_id != 0 ? "#post_$parent_id" : '#post_'.$post_id);
		GO($back_url.$post_anchor);
	}else{
		System::site()->AddTextBox('', $posts->PrintErrors());
	}
}

function CommentsEditPost( $CommentsTable, $SaveUrl ){
	System::site()->AddTemplatedBox('','edit_comment.html');
	$posts = new Posts($CommentsTable);
	$posts->PostFormAction = $SaveUrl;
	$posts->RenderForm(true, 'post_form');
}

function CommentsEditPostSave( $ObjectId, $CommentsTable ){
	$posts = new Posts($CommentsTable);
	if($posts->SavePost($ObjectId, true)){
		$post_anchor = "#post_".SafeDB($_GET['post_id'], 11, int);
		GoRefererUrl($_REQUEST['back'], $post_anchor);
	}else{
		System::site()->AddTextBox('', $posts->PrintErrors());
		return false;
	}
}

function CommentsDeletePost( $ObjectId, $CommentsTable, $ObjectsTable, $CounterField, $DeleteUrl, $Anchor = '#comments' ){
	$posts = new Posts($CommentsTable);
	$posts->DeletePageUrl = $DeleteUrl;
	$deleted_posts_count = $posts->DeletePost();
	if($deleted_posts_count > 0){
		System::database()->Select($ObjectsTable, "`id`='$ObjectId'");
		$obj = System::database()->FetchRow();
		$counter = $obj[$CounterField] - $deleted_posts_count;
		System::database()->Update($ObjectsTable, "`$CounterField`='$counter'", "`id`='$ObjectId'");
		GoRefererUrl($_REQUEST['back'], $Anchor);
	}
}

/*header*/

/**
 *    ,    .
 */
function GetConfigGroups($GroupsTable = 'config_groups', $Aggregate = 'name'){
	static $GroupsCache = array();
	if($GroupsTable == 'clear'){
		$GroupsCache = array();
		return;
	}
	if(!isset($GroupsCache[$GroupsTable][$Aggregate])){
		$groups = System::database()->Select($GroupsTable);
		foreach($groups as $group){
			$GroupsCache[$GroupsTable][$Aggregate][$group[$Aggregate]] = $group;
		}
	}
	return $GroupsCache[$GroupsTable][$Aggregate];
}

/**
 *  c   .
 *
 * @param        $ConfigVar      
 * @param string $ConfigTable
 * @param string $GroupsTable
 * @return void
 */
function LoadSiteConfig(&$ConfigVar, $ConfigTable = 'config', $GroupsTable = 'config_groups'){
	if(System::cache()->HasCache('config', $ConfigTable)){
		$ConfigVar = System::cache()->Get('config', $ConfigTable);
		return;
	}

	$temp = System::database()->Select($ConfigTable, "`autoload`='1'");
	foreach($temp as $i){
		$configs[$i['group_id']][] = $i;
	}

	//   
	$config_groups = System::database()->Select($GroupsTable, '');
	foreach($config_groups as $group){
		if(isset($configs[$group['id']])){
			foreach($configs[$group['id']] as $config){
				$gname  = $group['name'];
				$cname  = $config['name'];
				$cvalue = $config['value'];
				$type   = trim($config['type']);
				if($type <> ''){
					$type = explode(',', $type);
				} else{
					$type = array(
						255,
						'string',
						'false'
					);
				}
				if($type[0] > 0){
					$cvalue = substr($cvalue, 0, $type[0]);
				}
				if($type[2] != 'false'){
					$cvalue = HtmlChars(strip_tags($cvalue));
				}
				settype($cvalue, $type[1]);
				if($cvalue === '' && ($type[1] == 'bool' || $type[1] == 'boolean')){
					$cvalue = '0';
				}
				$ConfigVar[$gname][$cname] = $cvalue;
			}
		}
	}

	System::cache()->Write('config', $ConfigTable, $ConfigVar);
}

/**
 *   .
 * @param string $Group
 * @param string $ConfigName
 * @param string $NewValue
 * @param string $Table
 * @param string $GroupsTable
 */
function ConfigSetValue($Group, $ConfigName, $NewValue, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Update($Table, "`value`='$NewValue'", "`group_id`='$Group' and `name`='$ConfigName'");
	System::cache()->Clear('config');
}

/**
 *    .
 * @param string $Group
 * @param string $ConfigName
 * @param string $NewValue
 */
function ConfigPluginSetValue($Group, $ConfigName, $NewValue){
	ConfigSetValue($Group, $ConfigName, $NewValue, 'plugins_config', 'plugins_config_groups');
}

/**
 *   .
 * @param string         $Group         .
 * @param string         $Name         (   ).
 * @param string         $Title       .
 * @param string         $Value        .
 * @param string         $Description .
 * @param bool           $Visible     .
 * @param string         $KindControl     .
 * @param string         $Type          ((255),(string - PHP Type), (true, false)).
 * @param string         $Values          . (optval:title,optval:title)   (function:Callback), .  .
 * @param string         $SaveHandler      . .  .
 * @param bool           $Autoload      $config.
 * @param string         $Table
 * @param string         $GroupsTable
 */
function AddConfig($Group, $Name, $Title, $Value, $Description = '', $Visible = false, $KindControl = '', $Type = '255,string,false', $Values = '', $SaveHandler = '', $Autoload = true, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	if($Visible){
		$Visible = '1';
	} else{
		$Visible = '0';
	}
	if($Autoload){
		$Autoload = '1';
	} else{
		$Autoload = '0';
	}
	$Name        = SafeEnv($Name, 255, str);
	$Value       = SafeEnv($Value, 0, str);
	$Title       = SafeEnv($Title, 255, str);
	$Description = SafeEnv($Description, 255, str);
	$Values      = SafeEnv($Values, 255, str);
	System::database()->Insert($Table, "'','$Group','$Name','$Value','$Visible','$Title','$Description','$KindControl','$Values','$SaveHandler','$Type','$Autoload'");
	System::cache()->Clear('config');
}

/**
 *  .
 * @param int|string $Group  ,   ,    .
 * @param string     $Name   .
 * @param string     $Table
 * @param string     $GroupsTable
 */
function RemoveConfig($Group, $Name, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Delete($Table, "`group_id`='$Group' and `name`='$Name'");
}

/**
 *    .
 * @param string         $Group         .
 * @param string         $Name         (   ).
 * @param string         $Title       .
 * @param string         $Value        .
 * @param string         $Description .
 * @param bool           $Visible     .
 * @param string         $KindControl     .
 * @param string         $Type          ((255),(string - PHP Type), (true, false)).
 * @param string         $Values          . (optval:title,optval:title)   (function:Callback), .  .
 * @param string         $SaveHandler      . .  .
 * @param bool           $Autoload      $config.
 */
function AddPluginConfig($Group, $Name, $Title, $Value, $Description = '', $Visible = false, $KindControl = '', $Type = '255,string,false', $Values = '', $SaveHandler = '', $Autoload = true){
	AddConfig(
		$Group,
		$Name,
		$Title,
		$Value,
		$Description,
		$Visible,
		$KindControl,
		$Type,
		$Values,
		$SaveHandler,
		$Autoload,
		'plugins_config',
		'plugins_config_groups'
	);
}

/**
 *   .
 * @param int|string $Group  ,   ,    .
 * @param string     $Name   .
 */
function RemovePluginConfig($Group, $Name){
	RemoveConfig($Group, $Name, 'plugins_config', 'plugins_config_groups');
}

/**
 *      .
 * @param string         $Name
 * @param string         $Title
 * @param string         $Description
 * @param bool           $Visible
 * @param string         $GroupsTable
 * @return int
 */
function AddConfigGroup($Name, $Title, $Description = '', $Visible = false, $GroupsTable = 'config_groups'){
	if($Visible){
		$Visible = '1';
	} else{
		$Visible = '0';
	}
	System::database()->Insert($GroupsTable, "'','$Name','$Title','$Description','$Visible'");
	GetConfigGroups('clear');
	return System::database()->GetLastId();
}

/**
 *   .
 * @param string   $Group    .
 * @param string   $Table
 * @param string   $GroupsTable
 */
function RemoveConfigGroup($Group, $Table = 'config', $GroupsTable = 'config_groups'){
	if(!is_numeric($Group)){
		$groups = GetConfigGroups($GroupsTable);
		$Group  = SafeEnv($groups[$Group]['id'], 11, int);
	}
	System::database()->Delete($GroupsTable, "`id`='$Group'");
	//    
	System::database()->Delete($Table, "`group_id`='$Group'");
	GetConfigGroups('clear');
}

/**
 *       .
 * @param string         $Name
 * @param string         $Title
 * @param string         $Description
 * @param bool           $Visible
 * @return int
 */
function AddPluginConfigGroup($Name, $Title, $Description = '', $Visible = false){
	return AddConfigGroup($Name, $Title, $Description = '', $Visible, 'plugins_config_groups');
}

/**
 *    .
 * @param string $Group    .
 */
function RemovePluginConfigGroup($Group){
	RemoveConfigGroup($Group, 'plugins_config', 'plugins_config_groups');
}

/*header*/

$Parser_WhereCache = array();
$Parser_SetCache = array();
$Parser_UseCache = true;

/**
 *         .
 *         SafeEnv  SafeR.
 *
 * @return string
 * @example Values('a','b','c'); => "'a','b','c'";
 */
function Values(){
	$args = func_get_args();
	if(is_array($args[0])){
		$args = $args[0];
	}
	$result = '';
	foreach($args as $var){
		$result .= ",'".$var."'";
	}
	return substr($result, 1);
}

/**
 *  SET     .
 *         SafeEnv  SafeR.
 *
 * @return string
 */
function MakeSet(){
	$args = func_get_args();
	$set = '';
	foreach($args as $a){
		foreach($a as $name=>$value){
			$set .= ",`$name`='$value'";
		}
	}
	return substr($set, 1);
}

/**
 *        .
 *     VALUES .
 *
 * @param string $Values   "'','login','pass','order'"
 * @return string
 */
function MakeValues( $Values ){
	$num = func_num_args();
	for($i = 1; $i < $num; $i++){
		$a = func_get_arg($i);
		foreach($a as $name=>$value){
			$Values = str_replace($name, $value, $Values);
		}
	}
	return $Values;
}

/**
 *  SET     .
 *
 * @param string $set   "name='name',login='root',pass=''".
 * @param array $row      .
 * @param array $info    .
 * @return array     array('name','root','').
 */
function Parser_ParseSetStr( &$set, &$row, &$info ){
	$s = str_replace("\\\\", '<&#92;>', $set);
	$s = str_replace("\\'", '<&#39;>', $s);
	$maxlength=count($info['cols']);
	for($i=0;$i<$maxlength;$i++){
		$args[$i] = $row[$i];
		$names[$info['cols'][$i]['name']] = $i;
	}
	for($i=0;$i<$maxlength;$i++){
		$pos = strpos($s, '='); //   =
		if($pos===false){
			break;
		}
		$col = trim(substr($s, 0, $pos));
		if(substr($col, 0, 1)=='`'){
			$col = substr($col, 1, strlen($col)-2);
		}
		$s = substr($s,$pos+1);
		$pos = strpos($s,"'");
		$s = substr($s,$pos+1);
		$pos = strpos($s,"'");
		$val = substr($s,0,$pos);
		$s = substr($s,$pos+1);
		$pos = strpos($s,",");
		$s = substr($s,$pos+1);
		if(isset($names[$col])){
			$val = str_replace('<&#39;>',"'",$val);
			$val = str_replace('<&#92;>', "\\",$val);
			$args[$names[$col]] = $val;
		}else{
			echo "   .  ".$col."    !";
			return $row;
		}
	}
	return $args;
}

/**
 *  VALUES     .
 *
 * @param string $values   "'name','root',''".
 * @param array $Info    .
 * @param bool $isUpdateMethod ,         .
 * @param bool $lastvals     ,   .
 * @return array     array('name','root','').
 */
function Parser_ParseValuesStr(&$values, &$Info, $isUpdateMethod = false, $lastvals = false){
	$values2 = str_replace("\\\\", '<&#92;>', $values);
	$values2 = str_replace("\\'", '<&#39;>', $values2);
	$values2 = trim($values2);
	$maxlength = Count($Info['cols']);
	for($i=0; $i<$maxlength; $i++){
		$pos = strpos($values2, "'");
		if($pos === false){
			break;
		}
		$values2 = substr($values2, $pos + 1);
		$pos = strpos($values2, "'");
		$val = substr($values2, 0, $pos);
		$values2 = substr($values2, $pos + 1);

		if(isset($Info['cols'][$i]['auto_increment']) && $Info['cols'][$i]['auto_increment'] == true){
			if(!$isUpdateMethod){
				if($val == ''){
					$Info['counter']++;
					$args[$i] = $Info['counter'];
				}else{
					$args[$i] = intval($val);
					if(intval($val) > $Info['counter']){
						$Info['counter'] = intval($val);
					}
				}
				continue;
			}else{
				if($val != ''){
					$args[$i] = intval($val);
				}elseif(isset($lastvals[$i])){
					$args[$i] = $lastvals[$i];
				}
				continue;
			}
		}
		$val = str_replace('<&#39;>',"'",$val);
		$val = str_replace('<&#92;>', "\\", $val);
		$args[$i] = $val;
	}
	return $args;
}

/**
 *   WHERE    SQL.
 *
 * @param  $where   "`pass`='1' and `login`='admin'"
 * @param  $row      .
 * @param  $info    .
 * @param int $index     .   `index`,
 *     .
 * @return bool   ,    .
 */
function Parser_ParseWhereStr( $where, $row, $info, $index = 0 ){
	if($where == ''){ return true; };
	global $Parser_UseCache, $Parser_WhereCache;
	$vars = array();
	//     
	// fixme:      
	for($j=0,$ccnt=count($info['cols']);$j<$ccnt;$j++){
		$n = $info['cols'][$j]['name'];
		$vars[$n] = $row[$j];
		$names[] = $n;
	}
	$vars['index'] = $index;
	$names[] = 'index';
	$ccnt++;
	//         
	if(isset($Parser_WhereCache[$where])){
		return Parser_ParseWhereStr2($Parser_WhereCache[$where], $vars);
	}
	//          PHP    
	$where2 = str_replace("\\'", '<&#39;>', $where);
	$chs = explode("'", $where2);
	for($i=1,$cnt=count($chs)+1; $i<$cnt; $i++){
		if($i%2>0){
			$chs[$i-1] = str_replace("=", "==", $chs[$i-1]);
			for($j=0;$j<$ccnt;$j++){
				$chs[$i-1] = str_replace('`'.$names[$j].'`', '$'.$names[$j], $chs[$i-1]);
			}
		}
	}
	$where2 = implode("'", $chs);
	$where2 = str_replace('<&#39;>', "\\'", $where2);
	//      
	if($Parser_UseCache){
		$Parser_WhereCache[$where] = $where2;
	}
	return Parser_ParseWhereStr2($where2, $vars);
}

function Parser_ParseWhereStr2(){
	extract(func_get_arg(1), EXTR_OVERWRITE);
	eval('if('.func_get_arg(0).'){ $result = true; }else{ $result = false; }');
	return $result;
}

/**
 *      ,       .
 *
 * @param string $cname   ( SQL).
 * @param string $type  ( SQL).
 * @param int $length  .
 * @param bool $auto_increment   () .
 * @param string $default    .
 * @param string $attributes  ( SQL).
 * @param bool $notnull    null.
 * @param bool $primary    .
 * @param bool $index  .
 * @param bool $unique  .
 * @param bool $fulltext  .
 * @return array
 */
function GetCollDescription( $cname, $type, $length, $auto_increment=false, $default='', $attributes='', $notnull=true, $primary=false, $index=false, $unique=false, $fulltext=false ){
	$newcoll = array(
		'name'=>$cname,
		'type'=>$type,
		'length'=>$length,
	);
	if($auto_increment == true){
		$newcoll['auto_increment'] = true;
	}
	if($default <> ''){
		$newcoll['default'] = $default;
	}
	if($attributes <> ''){
		$newcoll['attributes'] = $attributes;
	}
	if($notnull == true){
		$newcoll['notnull'] = $notnull;
	}
	if($primary <> ''){
		$newcoll['primary'] = $primary;
	}
	if($index <> ''){
		$newcoll['index'] = $index;
	}
	if($unique <> ''){
		$newcoll['unique'] = $unique;
	}
	if($fulltext <> ''){
		$newcoll['fulltext'] = $fulltext;
	}
	return $newcoll;
}

/*header*/

//   
define('Min2Sec', 60);
define('Hour2Sec', 3600);
define('Day2Sec', 86400);

function GetGmtArray(){
	$tlist = timezone_identifiers_list();
/*
	$tlist2 = array(
		'Africa/Abidjan' => ', ',
		'Africa/Accra' => 'Africa/Accra',
		'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
		'Africa/Algiers' => 'Africa/Algiers',
		'Africa/Asmara' => 'Africa/Asmara',
		'Africa/Bamako' => 'Africa/Bamako',
		'Africa/Bangui' => 'Africa/Bangui',
		'Africa/Banjul' => 'Africa/Banjul',
		'Africa/Bissau' => 'Africa/Bissau',
		'Africa/Blantyre' => 'Africa/Blantyre',
		'Africa/Brazzaville' => 'Africa/Brazzaville',
		'Africa/Bujumbura' => 'Africa/Bujumbura',
		'Africa/Cairo' => 'Africa/Cairo',
		'Africa/Casablanca' => 'Africa/Casablanca',
		'Africa/Ceuta' => 'Africa/Ceuta',
		'Africa/Conakry' => 'Africa/Conakry',
		'Africa/Dakar' => 'Africa/Dakar',
		'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
		'Africa/Djibouti' => 'Africa/Djibouti',
		'Africa/Douala' => 'Africa/Douala',
		'Africa/El_Aaiun' => 'Africa/El_Aaiun',
		'Africa/Freetown' => 'Africa/Freetown',
		'Africa/Gaborone' => 'Africa/Gaborone',
		'Africa/Harare' => 'Africa/Harare',
		'Africa/Johannesburg' => 'Africa/Johannesburg',
		'Africa/Juba' => 'Africa/Juba',
		'Africa/Kampala' => 'Africa/Kampala',
		'Africa/Khartoum' => 'Africa/Khartoum',
		'Africa/Kigali' => 'Africa/Kigali',
		'Africa/Kinshasa' => 'Africa/Kinshasa',
		'Africa/Lagos' => 'Africa/Lagos',
		'Africa/Libreville' => 'Africa/Libreville',
		'Africa/Lome' => 'Africa/Lome',
		'Africa/Luanda' => 'Africa/Luanda',
		'Africa/Lubumbashi' => 'Africa/Lubumbashi',
		'Africa/Lusaka' => 'Africa/Lusaka',
		'Africa/Malabo' => 'Africa/Malabo',
		'Africa/Maputo' => 'Africa/Maputo',
		'Africa/Maseru' => 'Africa/Maseru',
		'Africa/Mbabane' => 'Africa/Mbabane',
		'Africa/Mogadishu' => 'Africa/Mogadishu',
		'Africa/Monrovia' => 'Africa/Monrovia',
		'Africa/Nairobi' => 'Africa/Nairobi',
		'Africa/Ndjamena' => 'Africa/Ndjamena',
		'Africa/Niamey' => 'Africa/Niamey',
		'Africa/Nouakchott' => 'Africa/Nouakchott',
		'Africa/Ouagadougou' => 'Africa/Ouagadougou',
		'Africa/Porto-Novo' => 'Africa/Porto-Novo',
		'Africa/Sao_Tome' => 'Africa/Sao_Tome',
		'Africa/Tripoli' => 'Africa/Tripoli',
		'Africa/Tunis' => 'Africa/Tunis',
		'Africa/Windhoek' => 'Africa/Windhoek',
		'America/Adak' => 'America/Adak',
		'America/Anchorage' => 'America/Anchorage',
		'America/Anguilla' => 'America/Anguilla',
		'America/Antigua' => 'America/Antigua',
		'America/Araguaina' => 'America/Araguaina',
		'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
		'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
		'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
		'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
		'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
		'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
		'America/Argentina/Salta' => 'America/Argentina/Salta',
		'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
		'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
		'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
		'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
		'America/Aruba' => 'America/Aruba',
		'America/Asuncion' => 'America/Asuncion',
		'America/Atikokan' => 'America/Atikokan',
		'America/Bahia' => 'America/Bahia',
		'America/Bahia_Banderas' => 'America/Bahia_Banderas',
		'America/Barbados' => 'America/Barbados',
		'America/Belem' => 'America/Belem',
		'America/Belize' => 'America/Belize',
		'America/Blanc-Sablon' => 'America/Blanc-Sablon',
		'America/Boa_Vista' => 'America/Boa_Vista',
		'America/Bogota' => 'America/Bogota',
		'America/Boise' => 'America/Boise',
		'America/Cambridge_Bay' => 'America/Cambridge_Bay',
		'America/Campo_Grande' => 'America/Campo_Grande',
		'America/Cancun' => 'America/Cancun',
		'America/Caracas' => 'America/Caracas',
		'America/Cayenne' => 'America/Cayenne',
		'America/Cayman' => 'America/Cayman',
		'America/Chicago' => 'America/Chicago',
		'America/Chihuahua' => 'America/Chihuahua',
		'America/Costa_Rica' => 'America/Costa_Rica',
		'America/Creston' => 'America/Creston',
		'America/Cuiaba' => 'America/Cuiaba',
		'America/Curacao' => 'America/Curacao',
		'America/Danmarkshavn' => 'America/Danmarkshavn',
		'America/Dawson' => 'America/Dawson',
		'America/Dawson_Creek' => 'America/Dawson_Creek',
		'America/Denver' => 'America/Denver',
		'America/Detroit' => 'America/Detroit',
		'America/Dominica' => 'America/Dominica',
		'America/Edmonton' => 'America/Edmonton',
		'America/Eirunepe' => 'America/Eirunepe',
		'America/El_Salvador' => 'America/El_Salvador',
		'America/Fortaleza' => 'America/Fortaleza',
		'America/Glace_Bay' => 'America/Glace_Bay',
		'America/Godthab' => 'America/Godthab',
		'America/Goose_Bay' => 'America/Goose_Bay',
		'America/Grand_Turk' => 'America/Grand_Turk',
		'America/Grenada' => 'America/Grenada',
		'America/Guadeloupe' => 'America/Guadeloupe',
		'America/Guatemala' => 'America/Guatemala',
		'America/Guayaquil' => 'America/Guayaquil',
		'America/Guyana' => 'America/Guyana',
		'America/Halifax' => 'America/Halifax',
		'America/Havana' => 'America/Havana',
		'America/Hermosillo' => 'America/Hermosillo',
		'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
		'America/Indiana/Knox' => 'America/Indiana/Knox',
		'America/Indiana/Marengo' => 'America/Indiana/Marengo',
		'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
		'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
		'America/Indiana/Vevay' => 'America/Indiana/Vevay',
		'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
		'America/Indiana/Winamac' => 'America/Indiana/Winamac',
		'America/Inuvik' => 'America/Inuvik',
		'America/Iqaluit' => 'America/Iqaluit',
		'America/Jamaica' => 'America/Jamaica',
		'America/Juneau' => 'America/Juneau',
		'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
		'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
		'America/Kralendijk' => 'America/Kralendijk',
		'America/La_Paz' => 'America/La_Paz',
		'America/Lima' => 'America/Lima',
		'America/Los_Angeles' => 'America/Los_Angeles',
		'America/Lower_Princes' => 'America/Lower_Princes',
		'America/Maceio' => 'America/Maceio',
		'America/Managua' => 'America/Managua',
		'America/Manaus' => 'America/Manaus',
		'America/Marigot' => 'America/Marigot',
		'America/Martinique' => 'America/Martinique',
		'America/Matamoros' => 'America/Matamoros',
		'America/Mazatlan' => 'America/Mazatlan',
		'America/Menominee' => 'America/Menominee',
		'America/Merida' => 'America/Merida',
		'America/Metlakatla' => 'America/Metlakatla',
		'America/Mexico_City' => 'America/Mexico_City',
		'America/Miquelon' => 'America/Miquelon',
		'America/Moncton' => 'America/Moncton',
		'America/Monterrey' => 'America/Monterrey',
		'America/Montevideo' => 'America/Montevideo',
		'America/Montreal' => 'America/Montreal',
		'America/Montserrat' => 'America/Montserrat',
		'America/Nassau' => 'America/Nassau',
		'America/New_York' => 'America/New_York',
		'America/Nipigon' => 'America/Nipigon',
		'America/Nome' => 'America/Nome',
		'America/Noronha' => 'America/Noronha',
		'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
		'America/North_Dakota/Center' => 'America/North_Dakota/Center',
		'America/North_Dakota/New_Salem' => 'America/North_Dakota/New_Salem',
		'America/Ojinaga' => 'America/Ojinaga',
		'America/Panama' => 'America/Panama',
		'America/Pangnirtung' => 'America/Pangnirtung',
		'America/Paramaribo' => 'America/Paramaribo',
		'America/Phoenix' => 'America/Phoenix',
		'America/Port-au-Prince' => 'America/Port-au-Prince',
		'America/Port_of_Spain' => 'America/Port_of_Spain',
		'America/Porto_Velho' => 'America/Porto_Velho',
		'America/Puerto_Rico' => 'America/Puerto_Rico',
		'America/Rainy_River' => 'America/Rainy_River',
		'America/Rankin_Inlet' => 'America/Rankin_Inlet',
		'America/Recife' => 'America/Recife',
		'America/Regina' => 'America/Regina',
		'America/Resolute' => 'America/Resolute',
		'America/Rio_Branco' => 'America/Rio_Branco',
		'America/Santa_Isabel' => 'America/Santa_Isabel',
		'America/Santarem' => 'America/Santarem',
		'America/Santiago' => 'America/Santiago',
		'America/Santo_Domingo' => 'America/Santo_Domingo',
		'America/Sao_Paulo' => 'America/Sao_Paulo',
		'America/Scoresbysund' => 'America/Scoresbysund',
		'America/Shiprock' => 'America/Shiprock',
		'America/Sitka' => 'America/Sitka',
		'America/St_Barthelemy' => 'America/St_Barthelemy',
		'America/St_Johns' => 'America/St_Johns',
		'America/St_Kitts' => 'America/St_Kitts',
		'America/St_Lucia' => 'America/St_Lucia',
		'America/St_Thomas' => 'America/St_Thomas',
		'America/St_Vincent' => 'America/St_Vincent',
		'America/Swift_Current' => 'America/Swift_Current',
		'America/Tegucigalpa' => 'America/Tegucigalpa',
		'America/Thule' => 'America/Thule',
		'America/Thunder_Bay' => 'America/Thunder_Bay',
		'America/Tijuana' => 'America/Tijuana',
		'America/Toronto' => 'America/Toronto',
		'America/Tortola' => 'America/Tortola',
		'America/Vancouver' => 'America/Vancouver',
		'America/Whitehorse' => 'America/Whitehorse',
		'America/Winnipeg' => 'America/Winnipeg',
		'America/Yakutat' => 'America/Yakutat',
		'America/Yellowknife' => 'America/Yellowknife',
		'Antarctica/Casey' => 'Antarctica/Casey',
		'Antarctica/Davis' => 'Antarctica/Davis',
		'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie' => 'Antarctica/Macquarie',
		'Antarctica/Mawson' => 'Antarctica/Mawson',
		'Antarctica/McMurdo' => 'Antarctica/McMurdo',
		'Antarctica/Palmer' => 'Antarctica/Palmer',
		'Antarctica/Rothera' => 'Antarctica/Rothera',
		'Antarctica/South_Pole' => 'Antarctica/South_Pole',
		'Antarctica/Syowa' => 'Antarctica/Syowa',
		'Antarctica/Vostok' => 'Antarctica/Vostok',
		'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
		'Asia/Aden' => 'Asia/Aden',
		'Asia/Almaty' => 'Asia/Almaty',
		'Asia/Amman' => 'Asia/Amman',
		'Asia/Anadyr' => 'Asia/Anadyr',
		'Asia/Aqtau' => 'Asia/Aqtau',
		'Asia/Aqtobe' => 'Asia/Aqtobe',
		'Asia/Ashgabat' => 'Asia/Ashgabat',
		'Asia/Baghdad' => 'Asia/Baghdad',
		'Asia/Bahrain' => 'Asia/Bahrain',
		'Asia/Baku' => 'Asia/Baku',
		'Asia/Bangkok' => 'Asia/Bangkok',
		'Asia/Beirut' => 'Asia/Beirut',
		'Asia/Bishkek' => 'Asia/Bishkek',
		'Asia/Brunei' => 'Asia/Brunei',
		'Asia/Choibalsan' => 'Asia/Choibalsan',
		'Asia/Chongqing' => 'Asia/Chongqing',
		'Asia/Colombo' => 'Asia/Colombo',
		'Asia/Damascus' => 'Asia/Damascus',
		'Asia/Dhaka' => 'Asia/Dhaka',
		'Asia/Dili' => 'Asia/Dili',
		'Asia/Dubai' => 'Asia/Dubai',
		'Asia/Dushanbe' => 'Asia/Dushanbe',
		'Asia/Gaza' => 'Asia/Gaza',
		'Asia/Harbin' => 'Asia/Harbin',
		'Asia/Hebron' => 'Asia/Hebron',
		'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
		'Asia/Hong_Kong' => 'Asia/Hong_Kong',
		'Asia/Hovd' => 'Asia/Hovd',
		'Asia/Irkutsk' => 'Asia/Irkutsk',
		'Asia/Jakarta' => 'Asia/Jakarta',
		'Asia/Jayapura' => 'Asia/Jayapura',
		'Asia/Jerusalem' => 'Asia/Jerusalem',
		'Asia/Kabul' => 'Asia/Kabul',
		'Asia/Kamchatka' => 'Asia/Kamchatka',
		'Asia/Karachi' => 'Asia/Karachi',
		'Asia/Kashgar' => 'Asia/Kashgar',
		'Asia/Kathmandu' => 'Asia/Kathmandu',
		'Asia/Kolkata' => 'Asia/Kolkata',
		'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
		'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
		'Asia/Kuching' => 'Asia/Kuching',
		'Asia/Kuwait' => 'Asia/Kuwait',
		'Asia/Macau' => 'Asia/Macau',
		'Asia/Magadan' => 'Asia/Magadan',
		'Asia/Makassar' => 'Asia/Makassar',
		'Asia/Manila' => 'Asia/Manila',
		'Asia/Muscat' => 'Asia/Muscat',
		'Asia/Nicosia' => 'Asia/Nicosia',
		'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
		'Asia/Novosibirsk' => 'Asia/Novosibirsk',
		'Asia/Omsk' => 'Asia/Omsk',
		'Asia/Oral' => 'Asia/Oral',
		'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
		'Asia/Pontianak' => 'Asia/Pontianak',
		'Asia/Pyongyang' => 'Asia/Pyongyang',
		'Asia/Qatar' => 'Asia/Qatar',
		'Asia/Qyzylorda' => 'Asia/Qyzylorda',
		'Asia/Rangoon' => 'Asia/Rangoon',
		'Asia/Riyadh' => 'Asia/Riyadh',
		'Asia/Sakhalin' => 'Asia/Sakhalin',
		'Asia/Samarkand' => 'Asia/Samarkand',
		'Asia/Seoul' => 'Asia/Seoul',
		'Asia/Shanghai' => 'Asia/Shanghai',
		'Asia/Singapore' => 'Asia/Singapore',
		'Asia/Taipei' => 'Asia/Taipei',
		'Asia/Tashkent' => 'Asia/Tashkent',
		'Asia/Tbilisi' => 'Asia/Tbilisi',
		'Asia/Tehran' => 'Asia/Tehran',
		'Asia/Thimphu' => 'Asia/Thimphu',
		'Asia/Tokyo' => 'Asia/Tokyo',
		'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
		'Asia/Urumqi' => 'Asia/Urumqi',
		'Asia/Vientiane' => 'Asia/Vientiane',
		'Asia/Vladivostok' => 'Asia/Vladivostok',
		'Asia/Yakutsk' => 'Asia/Yakutsk',
		'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
		'Asia/Yerevan' => 'Asia/Yerevan',
		'Atlantic/Azores' => 'Atlantic/Azores',
		'Atlantic/Bermuda' => 'Atlantic/Bermuda',
		'Atlantic/Canary' => 'Atlantic/Canary',
		'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
		'Atlantic/Faroe' => 'Atlantic/Faroe',
		'Atlantic/Madeira' => 'Atlantic/Madeira',
		'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
		'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
		'Atlantic/St_Helena' => 'Atlantic/St_Helena',
		'Atlantic/Stanley' => 'Atlantic/Stanley',
		'Australia/Adelaide' => 'Australia/Adelaide',
		'Australia/Brisbane' => 'Australia/Brisbane',
		'Australia/Broken_Hill' => 'Australia/Broken_Hill',
		'Australia/Currie' => 'Australia/Currie',
		'Australia/Darwin' => 'Australia/Darwin',
		'Australia/Eucla' => 'Australia/Eucla',
		'Australia/Hobart' => 'Australia/Hobart',
		'Australia/Lindeman' => 'Australia/Lindeman',
		'Australia/Lord_Howe' => 'Australia/Lord_Howe',
		'Australia/Melbourne' => 'Australia/Melbourne',
		'Australia/Perth' => 'Australia/Perth',
		'Australia/Sydney' => 'Australia/Sydney',
		'Europe/Amsterdam' => 'Europe/Amsterdam',
		'Europe/Andorra' => 'Europe/Andorra',
		'Europe/Athens' => 'Europe/Athens',
		'Europe/Belgrade' => 'Europe/Belgrade',
		'Europe/Berlin' => 'Europe/Berlin',
		'Europe/Bratislava' => 'Europe/Bratislava',
		'Europe/Brussels' => 'Europe/Brussels',
		'Europe/Bucharest' => 'Europe/Bucharest',
		'Europe/Budapest' => 'Europe/Budapest',
		'Europe/Chisinau' => 'Europe/Chisinau',
		'Europe/Copenhagen' => 'Europe/Copenhagen',
		'Europe/Dublin' => 'Europe/Dublin',
		'Europe/Gibraltar' => 'Europe/Gibraltar',
		'Europe/Guernsey' => 'Europe/Guernsey',
		'Europe/Helsinki' => 'Europe/Helsinki',
		'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
		'Europe/Istanbul' => 'Europe/Istanbul',
		'Europe/Jersey' => 'Europe/Jersey',
		'Europe/Kaliningrad' => 'Europe/Kaliningrad',
		'Europe/Kiev' => 'Europe/Kiev',
		'Europe/Lisbon' => 'Europe/Lisbon',
		'Europe/Ljubljana' => 'Europe/Ljubljana',
		'Europe/London' => 'Europe/London',
		'Europe/Luxembourg' => 'Europe/Luxembourg',
		'Europe/Madrid' => 'Europe/Madrid',
		'Europe/Malta' => 'Europe/Malta',
		'Europe/Mariehamn' => 'Europe/Mariehamn',
		'Europe/Minsk' => 'Europe/Minsk',
		'Europe/Monaco' => 'Europe/Monaco',
		'Europe/Moscow' => 'Europe/Moscow',
		'Europe/Oslo' => 'Europe/Oslo',
		'Europe/Paris' => 'Europe/Paris',
		'Europe/Podgorica' => 'Europe/Podgorica',
		'Europe/Prague' => 'Europe/Prague',
		'Europe/Riga' => 'Europe/Riga',
		'Europe/Rome' => 'Europe/Rome',
		'Europe/Samara' => 'Europe/Samara',
		'Europe/San_Marino' => 'Europe/San_Marino',
		'Europe/Sarajevo' => 'Europe/Sarajevo',
		'Europe/Simferopol' => 'Europe/Simferopol',
		'Europe/Skopje' => 'Europe/Skopje',
		'Europe/Sofia' => 'Europe/Sofia',
		'Europe/Stockholm' => 'Europe/Stockholm',
		'Europe/Tallinn' => 'Europe/Tallinn',
		'Europe/Tirane' => 'Europe/Tirane',
		'Europe/Uzhgorod' => 'Europe/Uzhgorod',
		'Europe/Vaduz' => 'Europe/Vaduz',
		'Europe/Vatican' => 'Europe/Vatican',
		'Europe/Vienna' => 'Europe/Vienna',
		'Europe/Vilnius' => 'Europe/Vilnius',
		'Europe/Volgograd' => 'Europe/Volgograd',
		'Europe/Warsaw' => 'Europe/Warsaw',
		'Europe/Zagreb' => 'Europe/Zagreb',
		'Europe/Zaporozhye' => 'Europe/Zaporozhye',
		'Europe/Zurich' => 'Europe/Zurich',
		'Indian/Antananarivo' => 'Indian/Antananarivo',
		'Indian/Chagos' => 'Indian/Chagos',
		'Indian/Christmas' => 'Indian/Christmas',
		'Indian/Cocos' => 'Indian/Cocos',
		'Indian/Comoro' => 'Indian/Comoro',
		'Indian/Kerguelen' => 'Indian/Kerguelen',
		'Indian/Mahe' => 'Indian/Mahe',
		'Indian/Maldives' => 'Indian/Maldives',
		'Indian/Mauritius' => 'Indian/Mauritius',
		'Indian/Mayotte' => 'Indian/Mayotte',
		'Indian/Reunion' => 'Indian/Reunion',
		'Pacific/Apia' => 'Pacific/Apia',
		'Pacific/Auckland' => 'Pacific/Auckland',
		'Pacific/Chatham' => 'Pacific/Chatham',
		'Pacific/Chuuk' => 'Pacific/Chuuk',
		'Pacific/Easter' => 'Pacific/Easter',
		'Pacific/Efate' => 'Pacific/Efate',
		'Pacific/Enderbury' => 'Pacific/Enderbury',
		'Pacific/Fakaofo' => 'Pacific/Fakaofo',
		'Pacific/Fiji' => 'Pacific/Fiji',
		'Pacific/Funafuti' => 'Pacific/Funafuti',
		'Pacific/Galapagos' => 'Pacific/Galapagos',
		'Pacific/Gambier' => 'Pacific/Gambier',
		'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
		'Pacific/Guam' => 'Pacific/Guam',
		'Pacific/Honolulu' => 'Pacific/Honolulu',
		'Pacific/Johnston' => 'Pacific/Johnston',
		'Pacific/Kiritimati' => 'Pacific/Kiritimati',
		'Pacific/Kosrae' => 'Pacific/Kosrae',
		'Pacific/Kwajalein' => 'Pacific/Kwajalein',
		'Pacific/Majuro' => 'Pacific/Majuro',
		'Pacific/Marquesas' => 'Pacific/Marquesas',
		'Pacific/Midway' => 'Pacific/Midway',
		'Pacific/Nauru' => 'Pacific/Nauru',
		'Pacific/Niue' => 'Pacific/Niue',
		'Pacific/Norfolk' => 'Pacific/Norfolk',
		'Pacific/Noumea' => 'Pacific/Noumea',
		'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
		'Pacific/Palau' => 'Pacific/Palau',
		'Pacific/Pitcairn' => 'Pacific/Pitcairn',
		'Pacific/Pohnpei' => 'Pacific/Pohnpei',
		'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
		'Pacific/Rarotonga' => 'Pacific/Rarotonga',
		'Pacific/Saipan' => 'Pacific/Saipan',
		'Pacific/Tahiti' => 'Pacific/Tahiti',
		'Pacific/Tarawa' => 'Pacific/Tarawa',
		'Pacific/Tongatapu' => 'Pacific/Tongatapu',
		'Pacific/Wake' => 'Pacific/Wake',
		'Pacific/Wallis' => 'Pacific/Wallis',
		'UTC' => 'UTC',
	);
*/
	$gmt = array();
	foreach($tlist as $timezone){
		$gmt[] = array($timezone, $timezone);
	}
	return $gmt;
}

function GetMicroTime(){
	return microtime(true);
}

/**
 *     
 * @param $Time
 * @param bool $Full
 * @param bool $Logic
 * @return string
 */
function TimeRender( $Time, $Full=true, $Logic=true){
	if($Time==false || !is_numeric($Time)){
		return ' ';
	}
	$now = time();
	$ld = round(($now / 86400) - ($Time / 86400));
	if($ld>1 || $now<$Time || !$Logic){
		$fdate = 'd.m.Y';
	}elseif($ld==0){
		$fdate = '';
	}elseif($ld==1){
		$fdate = '';
	}else{
		return ' ';
	}
	if($Full){
		$date = date($fdate.' '.System::config('general/datetime_delimiter').' H:i', $Time);
	}else{
		$date = date($fdate,$Time);
	}
	return $date;
}

/**
 *        
 *    ,      
 *       .
 *
 * @param Time $RunTime    
 * @param Time $EndTime    
 * @return array('days'=> ,'hours'=> ,'sdays'=> ,'shours'=> )
 */
function TotalTime( $RunTime, $EndTime ){
	$right = $EndTime - $RunTime;
	if($right<0){return false;}

	$str = '';
	$days = floor($right / Day2Sec);

	$str2 = '';
	$hours = round(($right - $days * Day2Sec) / Hour2Sec);
	if($hours==24){
		$hours=0;
		$days++;
	}

	//  
	$days2 = $days;
	if($days>19){$days = $days % 10;}
	if($days == 1){$str .= '';}
	elseif($days > 1 && $days <= 4){$str .= '';}
	elseif(($days > 4 && $days <= 19) || $days == 0){$str .= '';}

	//  
	$hours2 = $hours;
	if($hours>19){$hours = $hours % 10;}
	if($hours == 1){$str2 = '';}
	elseif($hours > 1 && $hours <= 4){$str2 = '';}
	elseif(($hours > 4 && $hours <= 19) || $hours == 0){$str2 = '';}

	$str = $days2.' '.$str;
	$str2 = $hours2.' '.$str2;
	return array('days'=>$days2,'hours'=>$hours2,'sdays'=>$str,'shours'=>$str2);
}

/*header*/

/**
 *      
 *
 * @param String $Email // e-mail 
 * @return Boolean
 */
function CheckEmail( $Email ){
	return (preg_match('/^[-!#$%&\'*+\\.\/0-9=?A-Z^_`{|}~]+@([-0-9A-Z]+\.)+([0-9A-Z]){2,4}$/i',trim($Email)));
}

/**
 *  E-mail
 * @param $ToName
 * @param $ToEmail
 * @param $Subject
 * @param $Text
 * @param bool $Html
 * @param string $From
 * @param string $FromEmail
 */
function SendMail( $ToName, $ToEmail, $Subject, $Text, $Html=false, $From='', $FromEmail='' ){
	$mail = LmEmailExtended::Instance();

	if($From == '' && $FromEmail == ''){
		$mail->SetFrom(System::config('general/site_email'), Cp1251ToUtf8(System::config('general/site_name')));
	}else{
		$mail->SetFrom($FromEmail, Cp1251ToUtf8($From));
	}
	$mail->SetSubject(Cp1251ToUtf8($Subject));

	if(!$Html){
		$mail->AddTextPart(Cp1251ToUtf8($Text));
	}else{
		$mail->AddHtmlPart(Cp1251ToUtf8($Text));
	}

	$mail->AddTo($ToEmail, Cp1251ToUtf8($ToName));
	if(!$mail->Send()){
		 ErrorHandler(USER_ERROR, '   E-mail "'.$Subject.'".', __FILE__);
	}
}

function AntispamEmail( $Email, $AddJava=true ){
	static $javaAdd = false;
	if(!$javaAdd && $AddJava){
        System::site()->AddJS('
		function email(login, domain){
			mail = login+"@"+domain;
			mail = \'<a href="mailto:\'+mail+\'" target="_blank">\'+mail+\'</a>\';
			document.write(mail);
		}
		');
		$javaAdd = true;
	}
	$Email = explode('@', $Email);
	if(count($Email) == 2){
		return '<script>email(\''.$Email[0].'\',\''.$Email[1].'\');</script>';
	}else{
		return '';
	}
}

/*header*/

// 
define('ERROR_HANDLER', true);
define('ERROR', 1);
define('WARNING', 2);
define('PARSE', 4);
define('NOTICE', 8);
define('CORE_ERROR', 16);
define('CORE_WARNING', 32);
define('COMPILE_ERROR', 64);
define('COMPILE_WARNING', 128);
define('USER_ERROR', 256);
define('USER_WARNING', 512);
define('USER_NOTICE', 1024);

/**
 *   
 * @return void
 */
function ErrorsOn(){
	global $SITE_ERRORS;
	$SITE_ERRORS = true;
}

/**
 *    
 * @return void
 */
function ErrorsOff(){
	global $SITE_ERRORS;
	$SITE_ERRORS = false;
}

/**
 *  .
 * @param  $No
 * @param  $Error
 * @param  $File
 * @param  $Line
 * @return void
 */
function ErrorHandler( $No, $Error, $File, $Line = -1 ){
	global $SITE_ERRORS;
	if(!$SITE_ERRORS) return;
	$root = GetSiteRoot();
	$errortype = array(
		1 => '', 2 => '!', 4 => ' ', 8 => '', 16 => ' ', 32 => ' !', 64 => ' ',
		128 => ' !', 256 => ' ', 512 => ' !', 1024 => ' ', 2048 => ' ',
		4096 => ' ', 8192 => ' ', 16384 => '  ()'
	);
	/*
	 *  HTML  .       css .
	 */
	$ErrorId = count(System::$Errors);
	$ErrorHtml = '<div class="debug_error_container" id="debug_error_'.$ErrorId.'" data-id="'.$ErrorId.'">';
	$ErrorHtml .= '<span class="debug_error"><span class="debug_error_type debug_error_type_'.$No.'">'.$errortype[$No].'</span>: '
		         .'<span class="debug_error_text">"'.SafeDB($Error, 255, str).'"</span>  <span class="debug_error_file">'.SafeDB(str_replace($root, '', $File), 255, str).'</span>'
		         .($Line > -1 ? '   <span class="debug_error_line">'.$Line.'</span>' : '')
		         .'.</span>';
	/*
	 *   
	 */
	$trace = array_reverse(debug_backtrace());
	array_pop($trace);
	$ErrorHtml .= "\n".'<div class="debug_backtrace_container" id="debug_backtrace_'.$ErrorId.'">';
	foreach($trace as $i=>$t){
		$ErrorHtml .= ($i+1).'. ';
		if(isset($t['class'])){
			$ErrorHtml .= '<span class="debug_backtrace_class">'.$t['class'].'</span>::';
		}
		if(isset($t['function'])){
			$ErrorHtml .= '<span class="debug_backtrace_function">'.SafeDB($t['function'], 255, str).'</span>';
		}
		if(isset($t['args']) && count($t['args'])){
			$ErrorHtml .= '(';
			foreach($t['args'] as $a){
				if(is_array($a)){
					$a = 'Array';
				}elseif(is_object($a)){
					$a = 'Object';
				}elseif(is_bool($a)){
					$a = ($a ? 'true' : 'false');
				}
				$ErrorHtml .= '<span class="debug_backtrace_arg">'.SafeDB((string)$a, 100, str).'</span>, ';
			}
			$ErrorHtml = substr($ErrorHtml, 0, -2).')';
		}
		if(isset($t['file'])){
			$ErrorHtml .= ' <span class="debug_backtrace_path">['.SafeDB(str_replace($root, '', $t['file']), 255, str).(isset($t['line']) ? ':'.$t['line'] : '').']</span>';
		}
		$ErrorHtml .= "<br>\n";
	}
	$ErrorHtml = substr($ErrorHtml, 0, -5).';';
	$ErrorHtml .= '</div></div>';
	/*
	 *     .
	 */
	System::$Errors[] = $ErrorHtml;
}

/**
 *     .
 * @param $No
 * @param $Error
 * @param $File
 * @param $Line
 */
function error_handler( $No, $Error, $File, $Line = -1 ){
	ErrorHandler($No, $Error, $File, $Line);
}

/*header*/

/**
 *     .
 */

//    
define('EXT_MODULE', '1');
define('EXT_PLUGIN', '2');
define('EXT_BLOCK', '3');
define('EXT_TEMPLATE', '4');

/**
 *       
 * @param      $ExtPath      
 * @param null $PluginGroupInfo
 * @return array
 */
function ExtLoadInfo( $ExtPath, $PluginGroupInfo = null ){
	$result = false;
	$infoFile = RealPath2($ExtPath.'/info.php');
	if(is_file($infoFile)){ //    PHP 
		$result = include $infoFile;
		if(!is_array($result)){
			if(isset($module)){ //   
				foreach($module as $module){}
				$result = array(
					'name' => $module['name'],
					'description' => $module['comment'],
					'author' => $module['copyright'],
					'site' => '',
					'version' => '',
					'1.3' => true
				);
			}elseif(isset($plugins)){ //   
				foreach($plugins as $plugins){}
				$result = array(
					'name' => $plugins['name-ru'],
					'description' => $plugins['description-ru'],
					'author' => $plugins['author'],
					'site' => $plugins['site'],
					'version' => $plugins['version'],
					'function' => '',
					'type' => PLUG_MANUAL,
					'1.3' => true
				);
				if(isset($plugins['function'])){
					$result['function'] = $plugins['function'];
				}
				if(isset($plugins['type'])){
					$result['type'] = $plugins['type'];
				}elseif(isset($PluginGroupInfo) && isset($PluginGroupInfo['1.3_old_plugins_group_type'])){
					$result['type'] = $PluginGroupInfo['1.3_old_plugins_group_type'];
				}
			}elseif(isset($groups)){ //  1.3
				foreach($groups as $groups){}
				$result = array(
					'name' => $groups['name-ru'],
					'description' => $groups['description-ru'],
					'author' => '',
					'site' => '',
					'version' => '',
					'1.3' => true,
					'1.3_old_plugins_group' => true,
					'1.3_old_plugins_group_type' => $groups['type']
				);
			}else{
				return false;
			}
		}
		return $result;
	}
	$infoXML = RealPath2($ExtPath.'/info.xml');
	if(is_file($infoXML)){ //    XML 
		$info = simplexml_load_file($infoXML);
		$result = get_object_vars($info);
		foreach($result as $f=>&$v) {
			$result[$f] = Utf8ToCp1251($v);
		}
		return $result;
	}else{
		return false;
	}
}

/**
 *    .
 *           .
 * @param string     $Name     
 * @param string     $Folder       
 * @param int|string $IsIndex    index.php (1|0)
 * @param int|string $View      (1|2|3|4)
 * @param int|string $System       (1|0).          .
 * @param int|string $Enabled  (1|0)
 * @return void
 */
function ExtAddModule( $Name, $Folder, $IsIndex = 1, $View = 4, $System = 0, $Enabled = 1 ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	$System = SafeEnv($System, 1, int);
	$IsIndex = SafeEnv($IsIndex, 1, int);
	$View = SafeEnv($View, 1, int);
	$Enabled = SafeEnv($Enabled, 1, int);
	System::database()->Insert('modules',"'','$Name','$Folder','$System','$IsIndex','','','$View','$Enabled','0','1',''");
}

/**
 *      .
 * @param string $Folder      
 * @return void
 */
function ExtRemoveModule( $Folder ){
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Delete('modules', "`folder`='$Folder'");
}

/**
 *    .
 *           .
 * @param string $Group  ,         
 * @param string $Name          
 * @param string $Function  .        
 * @param string $Type  
 * @param string $Enabled 
 * @return void
 */
function ExtAddPlugin( $Group, $Name, $Function, $Type, $Enabled = '1' ){
	$Group = SafeEnv($Group, 250, str);
	$Name = SafeEnv($Name, 255, str);
	$Function = SafeEnv($Function, 255, str);
	$Type = SafeEnv($Type, 1, int);
	$Enabled = SafeEnv($Enabled, 1, int);
	if($Type == PLUG_MANUAL_ONE && $Enabled == '1'){ //     - 
		System::database()->Update('plugins', "`enabled`='0'", "`group`='$Group'");
	}
	System::database()->Insert('plugins',"'','$Name','$Function','','$Type','$Group','0','$Enabled'");
	PluginsClearCache();
}

/**
 *      .
 * @param string $Group    ( )
 * @param string $Name  
 * @return void
 */
function ExtRemovePlugin( $Group, $Name ){
	$Group = SafeEnv($Group, 250, str);
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('plugins', "`name`='$Name' and `group`='$Group'");
	PluginsClearCache();
}

/**
 *    .
 *           .
 * @param string $Name   
 * @param string $Folder      
 * @return void
 */
function ExtAddBlock( $Name, $Folder ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Insert('block_types',"'','$Name','','$Folder'");
}

/**
 *      .
 * @param string $Folder      
 * @return void
 */
function ExtRemoveBlock( $Folder ){
	$Folder = SafeEnv($Folder, 255, str);
	System::database()->Delete('block_types', "`folder`='$Folder'");
}

/**
 *    .
 *           .
 * @param        $Name
 * @param string $Folder      
 * @param string $Admin    -
 * @return void
 */
function ExtAddTemplate( $Name, $Folder, $Admin = '0' ){
	$Name = SafeEnv($Name, 255, str);
	$Folder = SafeEnv($Folder, 255, str);
	$Admin = SafeEnv($Admin, 1, int);
	System::database()->Insert('templates',"'','$Name','$Folder','$Admin','0'");
}

/**
 *      .
 * @param string $Folder      
 * @param bool $DelFiles    
 * @return void
 */
function ExtRemoveTemplate( $Folder, $DelFiles = false ){
	$FolderEnv = SafeEnv($Folder, 255, str);
	System::database()->Delete('templates', "`folder`='$FolderEnv'");
	if($DelFiles){ //   
		RmDirRecursive(RealPath2(System::config('tpl_dir').$Folder));
	}
}

/**
 *       .     .
 *        AdminMenuDeleteModule.
 * @param        $Title
 * @param        $Module
 * @param string $Icon
 * @param string $Action       (: admin: exe=mod; external: http://site/; js: alert('message');)
 * @param string $Type    (  jquery_menu: admin, external, js, node, delimiter)
 * @param string $ParentMod
 * @param bool   $ExternalBlank
 * @param string $Js
 * @param bool   $Enabled
 */
function AdminMenuAddItem( $Title, $Module, $Icon = '', $Action = '', $Type = 'admin', $ParentMod = '_mods_menu', $ExternalBlank = true, $Enabled = true ){
	static $ModCache = array();
	if($ParentMod == ''){ //   
		$Parent = '0';
	}else{
		if(!isset($ModCache[$ParentMod])){
			$ParentModEnv = SafeEnv($ParentMod, 255, str);
			System::database()->Select('adminmenu', "`module`='$ParentModEnv'");
			if(System::database()->NumRows() > 0){
				$mod = System::database()->FetchRow();
				$ModCache[$ParentMod] = SafeEnv($mod['id'], 11, int);
			}else{
				return false;
			}
		}
		$Parent = $ModCache[$ParentMod];
	}
	$Title = SafeEnv($Title, 255, str);
	$Module = SafeEnv($Module, 255, str);
	System::database()->Select('adminmenu', "`parent`='$Parent'");
	$Order = System::database()->NumRows();
	if($Icon == ''){
		if(is_file(System::config('mod_dir').$Module.'/icon.png')){
			$Icon = System::config('mod_dir').$Module.'/icon.png';
		}else{
			$Icon = 'images/application.png';
		}
	}
	$Icon = RealPath2(SafeEnv($Icon, 255, str));

	$AdminLink = '';
	$ExternalLink = '';
	$Js = '';

	if($Type == 'admin'){
		if($Action == ''){
			$AdminLink = 'exe='.$Module;
		}else{
			$AdminLink = $Action;
		}
	}elseif($Type == 'external'){
		$ExternalLink = $Action;
	}elseif($Type == 'js'){
		$Js = $Action;
	}

	if($ExternalBlank) $ExternalBlank = '1'; else $ExternalBlank = '0';
	if($Enabled) $Enabled = '1'; else $Enabled = '0';
	System::database()->Insert('adminmenu', "'','$Parent','$Order','$Module','$Title','$Icon','$AdminLink','$ExternalLink','$ExternalBlank','$Js','$Type','$Enabled'");
}

/**
 *         .
 * @param $Title   .
 * @param $Module  .
 * @param string $Icon    .
 * @param string $AdminLink  - (exe=mod_name)
 * @param string $ParentMod   ()      (: _system_menu, _site_menu, _mods_menu, _help_menu).
 */
function AdminMenuAddModule( $Title, $Module, $Icon = '', $AdminLink = '', $ParentMod = '_mods_menu' ){
	AdminMenuAddItem($Title, $Module, $Icon, $AdminLink, 'admin', $ParentMod);
}

/**
 *        .
 * @param $Module
 * @internal param $ModuleName   ()
 */
function AdminMenuDeleteModule( $Module ){
	$Module = SafeEnv($Module, 255, str);
	if($Module != ''){
		System::database()->Delete('adminmenu', "`module`='$Module'");
	}
}

/*header*/

/**
 *       .
 * @param String $FileName    
 * @param bool   $RemoveDot   
 * @return String
 */
function GetFileExt($FileName, $RemoveDot = false){
	$pos = strrpos($FileName, '.');
	if($RemoveDot){
		$pos++;
	}
	if($pos !== false){
		return substr($FileName, $pos);
	} else{
		return '';
	}
}

/**
 *          .
 * @param String $FileName    
 * @param bool   $RemoveDot   
 * @return String
 */
function GetSecondFileExt($FileName, $RemoveDot = false){
	$pos1 = strrpos($FileName, '.');
	if($pos1 === false){
		return '';
	}

	$pos2 = strrpos($FileName, '.', -(strlen($FileName) - $pos1 + 1));
	if($pos2 === false){
		return '';
	}

	if($RemoveDot){
		$RemoveDot = 1;
	} else{
		$RemoveDot = 0;
	}

	return substr($FileName, $pos2 + $RemoveDot, $pos1 - $pos2 - $RemoveDot);
}

/**
 *       .
 * @param string $FileName    
 * @param bool   $RemoveExt  
 * @return String
 */
function GetFileName($FileName, $RemoveExt = false){
	$pos = strrpos($FileName, '/');
	if($pos !== false){
		$FileName = substr($FileName, $pos + 1);
	}
	if($RemoveExt){
		$pos = strrpos($FileName, '.');
		if($pos !== false){
			$FileName = substr($FileName, 0, $pos);
		}
	}
	return $FileName;
}

/**
 *       .
 * @param      $FileName
 * @param bool $LastSlash
 * @return string
 */
function GetPathName($FileName, $LastSlash = true){
	$pos = strrpos($FileName, '/');
	if($pos !== false){
		return substr($FileName, 0, $pos + ($LastSlash ? 1 : 0));
	} else{
		return '';
	}
}

/**
 *            .
 * @param String  $folder          .
 * @param Boolean $use_subfolders   
 * @param Boolean $use_mask         
 * @param String  $mask            .     ( )  .
 * @param Boolean $newSearch          (   )
 * @param String  $parentf          .    .
 * @return Array   
 */
function GetFiles($folder, $use_subfolders = false, $use_mask = false, $mask = '', $newSearch = true, $parentf = ''){
	static $sfiles = array();
	if(!is_dir($folder)){
		return array();
	}
	if($newSearch){
		$sfiles = array();
		AddLastSlash($folder);
	}
	$mask = strtolower($mask);
	if($parentf == ''){
		$parentf = $folder;
	}
	$files = scandir($folder);
	foreach($files as $file){
		if(is_dir($folder.$file) && ($file != '.') && ($file != '..')){
			if($use_subfolders){
				GetFiles($folder.$file.'/', $use_subfolders, $use_mask, $mask, false, $parentf);
			}
		} elseif(is_file($folder.$file)){
			$ext = GetFileExt($file);
			if(!$use_mask || stripos($mask, strtolower($ext)) !== false){
				$rf       = str_replace($parentf, '', $folder.$file);
				$sfiles[] = $rf;
			}
		}
	}
	return $sfiles;
}

/**
 *          .
 * @param        $folder          .
 * @param bool   $use_subfolders   
 * @param bool   $newSearch          (   )
 * @param string $parentf
 * @return array
 */
function GetAllFilesAndFolders($folder, $use_subfolders = false, $newSearch = true, $parentf = ''){
	static $sfiles = array();
	if(!is_dir($folder)){
		return array();
	}
	if($newSearch){
		$sfiles = array();
		AddLastSlash($folder);
	}
	if($parentf == ''){
		$parentf = $folder;
	}
	$files = scandir($folder);
	foreach($files as $file){
		if(is_dir($folder.$file) && ($file != '.') && ($file != '..')){
			$sfiles[] = str_replace($parentf, '', $folder.$file);
			if($use_subfolders){
				GetAllFilesAndFolders($folder.$file.'/', $use_subfolders, false, $parentf);
			}
		} elseif(is_file($folder.$file)){
			$sfiles[] = str_replace($parentf, '', $folder.$file);
		}
	}
	return $sfiles;
}

/**
 *      .
 * @param string $Folder   .
 * @return array
 */
function GetFolders($Folder){
	$result = array();
	if(!is_dir($Folder)){
		return $result;
	}
	AddLastSlash($Folder);
	$files = scandir($Folder);
	foreach($files as $p){
		if(is_dir($Folder.$p) && ($p != ".") && ($p != "..")){
			$result[] = $p;
		}
	}
	return $result;
}

/**
 *      .
 * @param $Folder  .
 * @return int
 */
function GetFolderSize($Folder){
	$file_size = 0;
	AddLastSlash($Folder);
	$files = scandir($Folder);
	foreach($files as $file){
		if(($file != '.') && ($file != '..')){
			$f = $Folder.$file;
			if(is_dir($f)){
				$file_size += GetFolderSize($f);
			} else{
				$file_size += filesize($f);
			}
		}
	}
	return $file_size;
}

/**
 *     .
 * @param string $Path  .
 * @return bool
 */
function RmDirRecursive($Path){
	if(!is_dir($Path)){
		return false;
	}
	AddLastSlash($Path);
	$dir = @opendir($Path);
	if(!$dir){
		return false;
	}
	while($file = @readdir($dir)){
		$fn = $Path.$file;
		if(is_file($fn) || is_link($fn)){
			if(!unlink($fn)){
				return false;
			}
		} elseif(is_dir($fn) && ($file != '.') && ($file != '..')){
			if(!RmDirRecursive($fn)){
				return false;
			}
		}
	}
	@closedir($dir);
	if(!rmdir($Path)){
		return false;
	}
	return true;
}

/**
 *            .
 * @param     $Path
 * @param int $FilesMode
 * @param int $DirsMode
 * @return bool
 */
function ChmodRecursive($Path, $FilesMode = 0666, $DirsMode = 0777){
	if(is_file($Path)){
		chmod($Path, $FilesMode);
		return true;
	}
	AddLastSlash($Path);
	$files = scandir($Path);
	foreach($files as $file){
		if(is_dir($Path.$file) && ($file != '.') && ($file != '..')){
			chmod($Path.$file, $DirsMode);
			ChmodRecursive($Path.$file, $FilesMode, $DirsMode);
		} elseif(is_file($Path.$file)){
			chmod($Path.$file, $FilesMode);
		}
	}
	return true;
}

/**
 *         .
 * @param      $Path  ,       $Dest
 * @param      $Dest  ,    ( ,   )
 * @param bool $createSub
 */
function CopyRecursive($Path, $Dest, $createSub = false){
	if($createSub || !is_dir($Dest)){
		mkdir($Dest);
	}
	if(!$createSub){
		AddLastSlash($Path);
		AddLastSlash($Dest);
	}
	$files = scandir($Path);
	foreach($files as $file){
		$pfile = $Path.$file;
		$dfile = $Dest.$file;
		if(is_dir($pfile) && ($file != '.') && ($file != '..')){
			CopyRecursive($pfile.'/', $dfile.'/', true);
		} elseif(is_file($pfile)){
			copy($pfile, $dfile);
		}
	}
}

/**
 *     .
 * @param     $Path .
 * @param int $Mode
 * @return bool
 */
function MkDirRecursive($Path, $Mode = 0777){
	return mkdir($Path, $Mode, true);
}

/**
 *      .
 *                ,  false.
 *
 * @param $FileName
 * @return bool
 */
function IsPossiblyCreated( $FileName ){
	$FileName = RemoveLastSlash($FileName);
	$path = GetPathName($FileName, false);
	if(is_dir($path)){
		return is_writable($path);
	}
	$len = substr_count($path, '/');
	for($i=0; $i<$len; $i++){
		$pos = strrpos($path, '/');
		$path = substr($path, 0, $pos);
		if(is_dir($path)){
			return is_writable($path);
		}
	}
	return is_writable('.');
}

/**
 *          ".."  ".",
 *     Unix ,
 *       .
 *
 * @param      $Path
 * @param bool $RemoveSymbolicLinks
 * @return mixed|string
 */
function RealPath2($Path, $RemoveSymbolicLinks = true){
	$Path        = str_replace('\\', '/', $Path);
	$path_result = array();
	foreach(explode('/', $Path) as $name){
		if($RemoveSymbolicLinks){
			$name2 = str_replace('.', '', $name);
			if($name2 != ''){
				$path_result[] = $name;
			}
		} else{
			$path_result[] = $name;
		}
	}
	return implode('/', $path_result);
}

/**
 *     Unix ,
 *     .
 *
 * @param $Path
 * @return string
 */
function AddLastSlash(&$Path){
	$Path = str_replace('\\', '/', $Path);
	if(substr($Path, -1) != '/'){
		$Path .= '/';
	}
	return $Path;
}

/**
 *     Unix ,
 *     .
 *
 * @param $Path
 * @return string
 */
function RemoveLastSlash(&$Path){
	$Path = str_replace('\\', '/', $Path);
	if(substr($Path, -1) == '/'){
		$Path = substr($Path, 0, -1);
	}
	return $Path;
}

/**
 *        .
 * @param        $Size
 * @param string $SizeType
 * @return string
 */
function FormatFileSize($Size, $SizeType = 'b'){
	if($SizeType == 'b'){
		$mb = 1024 * 1024;
		if($Size > $mb){
			$Size = sprintf("%01.2f", $Size / $mb).' ';
		} elseif($Size >= 1024){
			$Size = sprintf("%01.2f", $Size / 1024).' ';
		} else{
			$Size = $Size.' ';
		}
	} else{
		if($SizeType == 'k'){
			$Size = $Size.' ';
		} elseif($SizeType == 'm'){
			$Size = $Size.' ';
		} else{
			$Size = $Size.' ';
		}
	}
	return $Size;
}

/*header*/

/**
 *     HTML::Select     
 * @param $val
 * @return array
 */
function GetGmtData($val){
	$tlist = timezone_identifiers_list();
	$gmt = array();
	foreach($tlist as $timezone){
        System::site()->DataAdd($gmt, $timezone, $timezone, $val == $timezone);
	}
	return $gmt;
}

/**
 *      HTML 
 * @param  $level
 * @return string
 */
function ViewLevelToInt( $level ){
	switch($level){
		case 'admins':
			$vi = '1';
			break;
		case 'members':
			$vi = '2';
			break;
		case 'guests':
			$vi = '3';
			break;
		case 'all':
			$vi = '4';
			break;
		default:
			$vi = '4';
	}
	return $vi;
}

/**
 *      
 * @param  $onoff
 * @return int
 */
function EnToInt($onoff){
	switch($onoff){
		case 'on':
			$r = 1;
			break;
		case 'off':
			$r = 0;
			break;
		default:
			$r = 1;
	}
	return $r;
}

/**
 *   "", ""  HTML::Select
 * @param bool $selected
 * @param string $on
 * @param string $off
 * @return array
 */
function GetEnData($selected = true, $on = '', $off = ''){
	$data = array();
	System::site()->DataAdd($data, 'on', $on, $selected);
	System::site()->DataAdd($data, 'off', $off, !$selected);
	return $data;
}

/**
 *   (select)     timestamp
 * @param  $daydata
 * @param  $mondata
 * @param  $yeardata
 * @param  $hourdata
 * @param  $mindata
 * @param  $timestamp
 * @param bool $last_years
 * @return void
 */
function GetDateFormData(&$daydata, &$mondata, &$yeardata, &$hourdata, &$mindata, $timestamp, $last_years = true){
	$data = getdate($timestamp);
	for($i = 1; $i <= 31; $i++){
		System::site()->DataAdd($daydata, $i, $i, ($data['mday'] == $i));
	}
	for($i = 1; $i <= 12; $i++){
		System::site()->DataAdd($mondata, $i, $i, ($data['mon'] == $i));
	}
	if($last_years){
		$min = 1970;
	} else{
		$min = date('Y');
	}
	$max = date('Y')+40;
	for($i = $min; $i <= $max; $i++){
		System::site()->DataAdd($yeardata, $i, $i, ($data['year'] == $i));
	}
	for($i = 0; $i <= 23; $i++){
		if($i < 10){
			$cap = '0'.$i;
		} else{
			$cap = $i;
		}
		System::site()->DataAdd($hourdata, $i, $cap, ($data['hours'] == $i));
	}
	System::site()->DataAdd($mindata, '0', '00', ($data['minutes'] == 0));
	System::site()->DataAdd($mindata, '5', '05', ($data['minutes'] == 0));
	for($i = 10; $i <= 55; $i = $i+5){
		System::site()->DataAdd($mindata, $i, $i, ($data['minutes'] == $i));
	}
}

function LoadImage($PostName, $Dir, $ThumbsDir, $MaxWidth, $MaxHeight, $Default, &$Error, $CreateThumbs = true, $OriginalOptimization = false, $OriginalMaxWidth = 800, $OriginalMaxHeight = 600){
	$Error = false;
	if($Default == 'no_image/no_image.png') {
		$Default = '';
	}

	$Dir = RealPath2($Dir);
	$ThumbsDir = RealPath2($ThumbsDir);

	$alloy_mime = array('image/gif', 'image/jpeg', 'image/pjpeg', 'image/png', 'image/x-png', 'application/octet-stream');
	$alloy_exts = array('.gif', '.jpg', '.jpeg', '.png');
	if(isset($_FILES[$PostName]) && is_file($_FILES[$PostName]['tmp_name'])){
		if(in_array($_FILES[$PostName]['type'], $alloy_mime) && in_array(strtolower(GetFileExt($_FILES[$PostName]['name'])), $alloy_exts)) {
			$file_name = Translit4Url($_FILES[$PostName]['name']);
			if(!is_dir($Dir)) {
				mkdir($Dir, 0777);
			}
			$ext = GetFileExt($file_name);
			$name = GetFileName($file_name, true);
			$i = 1;
			while(is_file($Dir.'/'.$file_name)){
				$i++;
				$file_name = $name.'_'.$i.$ext;
			}
			$FileName = $Dir.'/'.$file_name;
			$ThumbFileName = $ThumbsDir.'/'.$file_name;
			if(!$OriginalOptimization){
				copy($_FILES[$PostName]['tmp_name'], $FileName);
			}else{
				CreateThumb($_FILES[$PostName]['tmp_name'], $FileName, $OriginalMaxWidth, $OriginalMaxHeight);
			}
			if($CreateThumbs){
				if(!is_dir($ThumbsDir)){
					mkdir($ThumbsDir, 0777);
				}
				CreateThumb($FileName, $ThumbFileName, $MaxWidth, $MaxHeight);
			}
			$result = $file_name;
		}else{
			$Error = true;
			return RealPath2(SafeEnv($Default, 255, str));
		}
	}else{
		$result = RealPath2(SafeEnv($Default, 255, str));
	}
	return $result;
}

/*header*/

function GDVersion(){
	global $config;
	if(!isset($config['info']['gd'])){
		if(!extension_loaded('gd')){
			return ($config['info']['gd'] = 0);
		}
		if(function_exists('gd_info')){
			$ver_info = gd_info();
			preg_match('/\d/', $ver_info['GD Version'],$match);
			$config['info']['gd'] = $match[0];
			return $match[0];
		}else{
			return ($config['info']['gd'] = 0);
		}
	}else{
		return $config['info']['gd'];
	}
}

/**
 *    .
 * @param        $SrcFileName  .
 * @param string $DstFileName      .
 * @param int    $MaxWidth       .
 * @param int    $MaxHeight      .
 * @param bool   $Stretch            .
 * @param null   $SaveFormat     (jpeg, png, gif, wbmp).
 * @return \TPicture
 */
function CreateThumb( $SrcFileName, $DstFileName = '', $MaxWidth = 0, $MaxHeight = 0, $Stretch = false, $SaveFormat = null ){
	$thumb = new TPicture($SrcFileName);
	if($DstFileName == ''){
		return $thumb;
	}elseif(is_file($DstFileName)){
		unlink($DstFileName);
	}
	if($Stretch || (($MaxWidth > 0 || $MaxHeight > 0) && ($thumb->Width > $MaxWidth || $thumb->Height > $MaxHeight))){
		$thumb->SetImageSize($MaxWidth, $MaxHeight);
	}
	$thumb->SaveToFile($DstFileName, $SaveFormat);
	return $thumb;
}

function ImageSize( $FileName ){
	$size = getimagesize($FileName);
	$size['width'] = $size[0];
	$size['height'] = $size[1];
	return $size;
}

/**
 *     .    .
 * @param      $FileName     .
 * @param int  $MaxWidth     .
 * @param int  $MaxHeight    .
 * @param bool $Streech           
 * @param null $SaveFormat    (jpeg, png, gif, wbmp).
 * @return mixed
 */
function GetThumb( $FileName, $MaxWidth = 0, $MaxHeight = 0, $Streech = false, $SaveFormat = null ){
	if($FileName == ''){
		return 'images/no_image.png';
	}elseif(substr($FileName, 0, 7) == 'http://'){
		return $FileName;
	}
	$FileName = RealPath2($FileName);
	if(isset($SaveFormat)){
		$ext = '.'.$SaveFormat;
	}else{
		$ext = GetFileExt($FileName);
	}
	$tmb_path = System::config('general/tmb_path');
	if(!is_dir($tmb_path)){
		MkDirRecursive($tmb_path);
	}
	$tmb_file = $tmb_path.md5($FileName).'_'.$MaxWidth.'x'.$MaxHeight.($Streech ? '_streech' : '').$ext;
	if(!is_file($tmb_file)){
		CreateThumb($FileName, $tmb_file, $MaxWidth, $MaxHeight, $Streech, $SaveFormat);
	}
	return $tmb_file;
}

/*header*/

/**
 *     lib.      .
 * @param $FileName1      Lib (base/lib/  ),   lib.php )
 * @param string $FileName2
 * @param string $FileName3
 * @return void
 */
function UseLib( $FileName1, $FileName2 = '', $FileName3 = '' ){
	$args = func_get_args();
	if(is_array($args[0])){
		$args = $args[0];
	}
	foreach($args as $path){
		include_once RealPath2(System::config('lib_dir').$path.'/lib.php');
	}
}

/*header*/

//     .
function IsMainHost( $url ){
	$host = $_SERVER['HTTP_HOST'];
	if(stristr(Url($url), Url($host))) {
		return true;
	}else{
		return false;
	}
}

/**
 *       .
 *    Header('Location: ...');
 *
 * @param String $address //  .
 * @param bool   $exit
 * @param int    $response_code
 * @return bool
 */
function GO( $address, $exit = true, $response_code = 303 ){
	if($address == '') return false;
	if(count(System::$Errors) == 0 || !System::config('debug/php_errors')){
		if($response_code == 302){
			Header('Location: '.$address);
		}else{
			Header('Location: '.$address, true, $response_code);
		}
		if($exit){
			exit;
		}
		return true;
	}else{
		return false;
	}
}

function GoBack( $exit = true, $response_code = 303 ){
	if(isset($_SERVER['HTTP_REFERER'])){
		return GO($_SERVER['HTTP_REFERER'], $exit, $response_code);
	}else{
		return GO(Ufu('index.php'), $exit, $response_code);
	}
}

//            
//      $BackSteps  ,       GoBack()
//   $BackSteps  .
function HistoryGoBack( $BackSteps, $exit = true, $response_code = 303 ){
	$history = System::user()->Get('HISTORY');
	if(isset($history[10-$BackSteps])){
		return GO($history[10-$BackSteps], $exit, $response_code);
	}else{
		return false;
	}
}

function HistoryGetUrl( $BackSteps ){
	$history = System::user()->Get('HISTORY');
	if(isset($history[10-$BackSteps])){
		return $history[10-$BackSteps];
	}else{
		return '';
	}
}

/**
 *       
 * @param string $Url  URL
 * @return String <type>
 */
function SaveRefererUrl( $Url = '' ){
	static $Cache;
	if(isset($Cache[$Url])){
		return $Cache[$Url];
	}
	if($Url == ''){ //   
		$Url = GetSiteHost(true).GetPageUri();
	}
	if(isset($_SESSION['saved_urls']) && in_array($Url, $_SESSION['saved_urls'])){
		$key = array_keys($_SESSION['saved_urls'], $Url);
		$Cache[$Url] = $key[0];
		return $key[0];
	}
	$id = GenRandomString(10);
	$_SESSION['saved_urls'][$id] = $Url;
	return $id;
}

/**
 *       
 * @param        $id      
 * @param string $anchor    . : #post244. -     .
 * @param bool   $unset_url   URL  
 * @return bool
 */
function GoRefererUrl( $id, $anchor = '', $unset_url = true ){
	if(isset($_SESSION['saved_urls'][$id])){
		$url = $_SESSION['saved_urls'][$id];
		if($unset_url){
			unset($_SESSION['saved_urls'][$id]);
		}
		return GO($url.$anchor);
	}else{
		return GO(HistoryGetUrl(2));
	}
}

function GetRefererUrl( $id, $unset_url = true ){
	if(isset($_SESSION['saved_urls'][$id])){
		$url = $_SESSION['saved_urls'][$id];
		if($unset_url){
			unset($_SESSION['saved_urls'][$id]);
		}
		return $url;
	}else{
		return HistoryGetUrl(2);
	}
}

/**
 *   ,    .
 * @param bool $EndSlash   
 * @return String
 * @since 1.3.3
 */
function GetSiteDir( $EndSlash = true ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = str_replace('\\', '/', dirname($_SERVER['PHP_SELF']));

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *      .
 * @param bool $EndSlash   
 * @return string
 */
function GetSiteRoot( $EndSlash = true ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = $_SERVER['DOCUMENT_ROOT'].GetSiteDir(true);

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *   
 * @return string
 */
function GetSiteDomain(){
	return getenv("HTTP_HOST");
}

/**
 *   
 * @param bool $EndSlash
 * @return void
 */
function GetSiteHost( $EndSlash = false ){
	static $Result = null;
	if(isset($Result)){
		return $Result.($EndSlash ? '/' : '');
	}

	$Result = 'http://'.GetSiteDomain();

	if(substr($Result, -1) == '/'){
		$Result = substr($Result, 0, -1);
	}
	return $Result.($EndSlash ? '/' : '');
}

/**
 *  URL        .
 *
 * @param bool $EndSlash
 * @return String
 * @since 1.3.3
 */
function GetSiteUrl( $EndSlash = true ){
	return GetSiteHost().GetSiteDir($EndSlash);
}

/**
 *     .
 * @param bool $FirstSlash
 * @return string
 */
function GetPageUri( $FirstSlash = false ){
	static $Result = null;
	if(isset($Result)){
		return ($FirstSlash ? '/' : '').$Result;
	}

	$Result = $_SERVER['REQUEST_URI'];

	if(substr($Result, 0, 1) == '/'){
		$Result = substr($Result, 1);
	}
	return ($FirstSlash ? '/' : '').$Result;
}

/**
 *    404   .
 * @param bool $Exit  false    .
 */
function Error404( $Exit = true ){
	Header("HTTP/1.1 404 Not Found");
	$path = System::config('tpl_dir').System::config('general/site_template').'/';
	if($path.'404.html'){
		$page = new Page('404.html', '', false, PAGE_AJAX);
		$page->TEcho(false, false);
	}else{
		readfile('errorpages/404.html');
	}
	if($Exit){
		exit;
	}
}

/*header*/

define('PLUGINS', true);

//  
define('PLUG_AUTORUN', 1); //  (   config/init.php)
define('PLUG_ADMIN_AUTORUN', 2); //    
define('PLUG_MAIN_AUTORUN', 3); //    
// -------------
define('PLUG_CALLEE', 4); //    index.php&name=plugins&p=plugin_name (   modules/plugins/index.php)
// -------------
define('PLUG_MANUAL', 5); //        .  .
define('PLUG_MANUAL_ONE', 7); //   -   .  .
// ----------------------------
define('PLUG_SYSTEM', false); //  .  .

/**
 *   
 * @return void
 */
function PluginsClearCache(){
	System::cache()->Delete(system_cache, array('plugins', 'plugins_auto_main', 'plugins_auto_admin'));
}

/**
 *     
 * @return array
 */
function PluginsConfigsGroups(){
	$result = array();
	System::database()->Select('plugins_config_groups', '');
	while($group = System::database()->FetchRow()){
		$result[$group['name']] = $group;
	}
	return $result;
}

/**
 *            .
 * .
 * @return array
 */
function PluginsGetInstalled(){
	static $plugins = null;
	if(System::cache()->HasCache(system_cache, 'plugins')){
		$plugins = System::cache()->Get(system_cache, 'plugins');
	}
	if(!isset($plugins)){
		$plugins = System::database()->Select('plugins', "(`type`='5' or `type`='7') and `enabled`='1'");
		System::cache()->Write(system_cache, 'plugins', $plugins, Day2Sec);
	}
	return $plugins;
}

/**
 *     .
 * @param string $Group
 * @param string $function
 * @return arrays
 */
function PluginsGetInfo( $Group = '', $function = '' ){
	global $config;
	$plugins = PluginsGetInstalled();
	$plug_dir = System::config('plug_dir');
	$result = array();
	foreach($plugins as $plugin){
		if($Group == $plugin['group'] && ($function == '' || $function == $plugin['function'])){
			$include_plugin_path = RealPath2($plug_dir.$plugin['group'].'/'.$plugin['name']).'/';
			$info = ExtLoadInfo($include_plugin_path);
			$info['path'] = $include_plugin_path;
			$info['folder'] = $plugin['name'];
			$result[] = $info;
		}
	}
	return $result;
}

/**
 *   
 * @param $group 
 * @param string $function 
 * @param bool $return        
 * @return array
 */
function IncludePluginsGroup( $group, $function = '', $return = false ){
	global $config, $db, $user; //    
	global $include_plugin_path; //      
	$plugins = PluginsGetInstalled();
	$plug_dir = System::config('plug_dir');
	$result = array();
	foreach($plugins as $plugin){
		if($group == $plugin['group'] && ($function == '' || $function == $plugin['function'])){
			$include_plugin_path = RealPath2($plug_dir.$group.'/'.$plugin['name']).'/';
			if($return){
				$result[] = $include_plugin_path;
			}else{
				include $include_plugin_path.'index.php';
			}
		}
	}
	return $result;
}

/*header*/

/**
 *      .
 */

/**
 *    .
 * @param  $group 
 * @param string $function ( )
 * @param bool $return        
 * @param bool $return_full          
 * @return array
 */
function SystemPluginsIncludeGroup($group, $function = '', $return = false, $return_full = false){
	global $config;
	$result = array();

	//  
	$group_dir = System::config('sys_plug_dir').$group;
	if(!is_dir($group_dir)){
		return array();
	}
	$plugins = GetFolders($group_dir.'/');

	//  
	foreach($plugins as $plugin){
		if($function != ''){
			$plugin_name = RealPath2($group_dir.'/'.$plugin.'/'.$function).'/';
		}else{
			$plugin_name = RealPath2($group_dir.'/'.$plugin).'/';
		}
		global $include_plugin_path; //      
		$include_plugin_path = $plugin_name;
		if($return){
			$result[] = $include_plugin_path;
		}else{
			include $include_plugin_path.'index.php';
		}
	}
	return $result;
}

/*header*/

/**
 *             .
 * @param $votes_amount
 * @param $votes
 * @return string
 */
function GetRatingImage( $votes_amount, $votes ){
	$default = 'images/rating_system/rating.gif';
	if($votes_amount==0){
		return $default;
	}
	$rating = round($votes/$votes_amount);
	if($rating>=1 && $rating<=5){
		return 'images/rating_system/rating'.$rating.'.gif';
	}else{
		return $default;
	}
}

/**
 *  *    
 * @todo Annotations  
 * @param string|object $ClassObject
 * @param bool $WithMethods
 * @param bool $WithProperties
 * @return array
 */
function GetAnnotations( $ClassObject, $Cache = true, $WithMethods = true, $WithProperties = false ){
	if(is_object($ClassObject)){
		$ClassName = get_class($ClassObject);
	}else{
		$ClassName = $ClassObject;
	}
	$result = array();

	$ref  = new ReflectionClass($ClassName);
	$result['class'] = ParseAnnotations($ref->getDocComment());

	if($WithMethods){
		$result['methods'] = array();
		foreach($ref->getMethods() as $method){
			$result['methods'][$method->getName()] = ParseAnnotations($method->getDocComment());
		}
	}

	if($WithProperties){
		$result['properties'] = array();
		foreach($ref->getProperties() as $prop){
			$result['properties'][$prop->getName()] = ParseAnnotations($prop->getDocComment());
		}
	}

	return $result;
}

function ParseAnnotations( $DocComment ){
	preg_match_all('/@([a-zA-Z0-9_-]+)\:(.+)/', $DocComment, $parsed);
	$annotations = array();
	foreach($parsed[1] as $i=>$Name){
		$annotations[] = '"'.$Name.'": '.$parsed[2][$i];
	}
	$Json = '{'.implode(',', ObjectCp1251ToUtf8($annotations)).'}';
	return JsonDecode($Json);
}

/*header*/

//  
define('int', 'integer');
define('real', 'float');
define('bool', 'boolean');
define('str', 'string');
define('mix', 'array');
define('intmix', 'int_mix');
define('realmix', 'real_mix');
define('boolmix', 'bool_mix');
define('strmix', 'str_mix');
define('obj', 'object');
define('nil', null);
define('onoff', 'onoff2int');

//   PHP 5.4  htmlspecialchars
if(!defined('ENT_HTML5')){
	define('ENT_HTML5', 0);
}

/**
 *   htmlspecialchars.
 *
 * @param string         $String
 * @param int            $Flags
 * @param string         $Encoding
 * @return string
 */
function HtmlChars($String, $Flags = 0, $Encoding = 'cp1251'){
	if($Flags == 0){
		$Flags = ENT_COMPAT;
	}
	return htmlspecialchars($String, $Flags | ENT_HTML5, $Encoding);
}

/**
 *   htmlspecialchars_decode.
 *
 * @param string      $String
 * @param int         $Flags
 * @return string
 */
function HtmlCharsDecode($String, $Flags = 0){
	if($Flags == 0){
		$Flags = ENT_COMPAT;
	}
	return htmlspecialchars_decode($String, $Flags | ENT_HTML5);
}

//      boolean.
// Ÿ    .     true.
function GetBoolValue($var){
	if(is_string($var)){
		if(strlen($var) == 0){
			$r = false;
		} else{
			$r = true;
		}
	} else{
		$r = (bool)$var;
	}
	return $r;
}

function SafeXSS(&$var){
	$var = strtr(
		$var,
		array(
		     '&#34'  => '"',
		     '&#x22;'=> '"',
		     '&quot;'=> '"',
		     '%22'   => '"',
		     '&#39'  => "'",
		     '&#x27;'=> "'",
		     '%27'   => "'",
		     '&#96'  => '`',
		     '&#x60;'=> '`',
		     '%60'   => '`',
		     '&#32'  => ' ',
		     '&#x20;'=> ' ',
		     '&#9'   => "\t",
		     '&#x09;'=> "\t",
		     '%09'   => "\t",
		     '&#61'  => '=',
		     '&#x3D;'=> '=',
		     '%3D'   => '=',
		     '&#60'  => '<',
		     '&#x3C;'=> '<',
		     '&lt;'  => '<',
		     '%3C'   => '<',
		     '&#62'  => '>',
		     '&#x3E;'=> '>',
		     '&gt;'  => '>',
		     '%3E'   => '>',
		     '&#92'  => '\\',
		     '&#x5C;'=> '\\',
		     '%5C'   => '\\',
		     '&#37'  => '%',
		     '&#x25;'=> '%',
		     '%25'   => '%',
		     '&#43'  => '+',
		     '&#x2B;'=> '+',
		     '%2B'   => '+',
		     '&#173' => '-',
		     '&#xAD;'=> '-',
		     '&shy;' => '-',
		     '%AD'   => '-',
		     '&#38'  => '&',
		     '&#x26;'=> '&',
		     '&amp;' => '&',
		     '%26'   => '&'
		)
	);
}

/**
 *       php            .
 * ,   SafeXSS    ,       .
 *
 * @param mixed $Var        - 
 * @param int   $MaxLength     
 * @param int   $Type         .    system.php
 * @param bool  $StripTags   
 * @param bool  $AddSlashes      
 * @param bool  $SafeXss      html   
 * @return mixed
 */
function SafeEnv($Var, $MaxLength, $Type, $StripTags = false, $AddSlashes = true, $SafeXss = true){
	$onoff = false;
	if($Type == onoff){
		$onoff     = true;
		$Type      = str;
		$MaxLength = 3;
		$StripTags = false;
		$SafeXss   = false;
	}
	if(is_array($Var)){
		foreach($Var as &$v){
			if($MaxLength > 0){
				$v = substr($v, 0, $MaxLength);
			}
			$v = trim($v);
			if($SafeXss){
				SafeXSS($v);
			}
			if($StripTags){
				$v = strip_tags($v);
			}
			if($AddSlashes){
				if(defined("DATABASE")){
					$v = System::database()->EscapeString($v);
				} else{
					$v = addslashes($v);
				}
			}
			settype($v, $Type);
			if($onoff){
				$v = EnToInt($v);
			}
		}
	} else{
		if($MaxLength > 0){
			$Var = substr($Var, 0, $MaxLength);
		}
		$Var = trim($Var);
		if($SafeXss){
			SafeXSS($Var);
		}
		if($StripTags){
			$Var = strip_tags($Var);
		}
		if($AddSlashes){
			if(defined("DATABASE")){
				$Var = System::database()->EscapeString($Var);
			} else{
				$Var = addslashes($Var);
			}
		}
		settype($Var, $Type);
		if($onoff){
			$Var = EnToInt($Var);
		}
	}
	return $Var;
}

/**
 *          .
 *    ,           .
 * @param mixed $Var
 * @param int   $MaxLength
 * @param int   $Type
 * @param bool  $StripTags
 * @param bool  $SpecialChars
 * @param bool  $SafeXss
 * @return mixed
 */
function SafeDB($Var, $MaxLength, $Type, $StripTags = true, $SpecialChars = true, $SafeXss = true){
	if(is_array($Var)){
		foreach($Var as &$v){
			if($MaxLength > 0){
				$v = substr($v, 0, $MaxLength);
			}
			$v = trim($v);
			if($SafeXss){
				SafeXSS($v);
			}
			if($StripTags){
				$v = strip_tags($v);
			}
			if($SpecialChars){
				$v = HtmlChars($v, ENT_QUOTES);
			}
			settype($v, $Type);
		}
	} else{
		if($MaxLength > 0){
			$Var = substr($Var, 0, $MaxLength);
		}
		$Var = trim($Var);
		if($SafeXss){
			SafeXSS($Var);
		}
		if($StripTags){
			$Var = strip_tags($Var);
		}
		if($SpecialChars){
			$Var = HtmlChars($Var, ENT_QUOTES);
		}
		settype($Var, $Type);
	}
	return $Var;
}

/**
 *       php            .
 * ,   SafeXSS    ,       .
 *
 * @param string $Names          $_REQUEST.   
 *     ,     
 * @param int    $MaxLength     
 * @param int    $Type        
 * @param bool   $StripTags   Html 
 * @param bool   $AddSlashes  
 * @param bool   $SafeXss      html   
 * @return array
 */
function SafeR($Names, $MaxLength, $Type, $StripTags = false, $AddSlashes = true, $SafeXss = true){
	$Names  = explode(',', $Names);
	$Result = array();
	foreach($Names as $n){
		$n          = trim($n);
		$Result[$n] = SafeEnv($_REQUEST[$n], $MaxLength, $Type, $StripTags, $AddSlashes, $SafeXss);
	}
	return $Result;
}

/**
 *   $_GET    
 * @return bool
 */
function CheckGet(){
	$args = func_get_args();
	foreach($args as $name){
		if(!isset($_GET[$name])){
			return false;
		}
	}
	return true;
}

/**
 *   $_POST   
 * @return bool
 */
function CheckPost(){
	$args = func_get_args();
	foreach($args as $name){
		if(!isset($_POST[$name])){
			return false;
		}
	}
	return true;
}

/**
 *   
 * @param null $Method    
 * @return bool string|bool
 */
function RequestMethod($Method = null){
	if(isset($Method)){
		return $_SERVER['REQUEST_METHOD'] == $Method;
	} else{
		return $_SERVER['REQUEST_METHOD'];
	}
}

/*header*/

/**
 *       script  .      .
 * @param $FileName1        ( ?      URL,      $params)
 *                     FileName     .
 * @param string $FileName2
 * @param string $FileName3
 * @return mixed
 */
function UseScript( $FileName1, $FileName2 = '', $FileName3 = '' ){
	static $included = array();
	static $static_data = array(); //     ,     
	$return = false;
	$args = func_get_args();
	if(is_array($args[0])){
		$args = $args[0];
	}
	if(count($args) == 1){
		$return = true;
	}
	foreach($args as $path){
		$params = array();
		if(is_int(strpos($path, '?'))){
			$p = explode('?', $path, 2);
			$script = $p[0];
			parse_str($p[1], $params);
		}else{
			$script = $path;
		}
		if(isset($included[$path])) continue;
		$file = RealPath2('scripts/'.$script.'/script.php');
		if(is_file($file)){
			$included[$path] = true;
			if($return)	return include $file;
			else include $file;
		}else{
			// TODO: WARNING
			return false;
		}
	}
}


function ScriptsAddJs( $FileNameInScripts, $OtherParams = 'charset="utf-8"' ){
	if(USE_GZIP_STATIC){
		$FileNameInScripts .= '.gz';
	}
	$FileNameInScripts .= '.js';
	System::site()->AddJSFile('scripts/'.$FileNameInScripts, true, false, $OtherParams);
}

function ScriptsAddJQueryPlugin( $FileNameInScripts, $OtherParams = 'charset="utf-8"' ){
	if(USE_GZIP_STATIC){
		$FileNameInScripts .= '.gz';
	}
	$FileNameInScripts .= '.js';
	System::site()->JQueryPlugin('scripts/'.$FileNameInScripts, true, $OtherParams);
}

function ScriptsAddCss( $FileNameInScripts, $OtherParams = '' ){
	if(USE_GZIP_STATIC){
		$FileNameInScripts .= '.gz';
	}
	$FileNameInScripts .= '.css';
	System::site()->AddCSSFile('scripts/'.$FileNameInScripts, true, false, $OtherParams);
}

/*header*/

/**
 *    ,     . -           .
 * @param $text
 * @param $search
 * @return string
 */
function SCoincidence($text, $search){
	$swords = explode(' ', $search);
	$text = preg_replace('/\\[[^\\]]*\\]/s', '', $text); //  BBCode
	$text = strip_tags($text);
	$result_text = '';
	$set_text = false;
	foreach($swords as $search){
		$pos = stripos($text, $search);
		if(is_integer($pos)){ //   
			$slen = strlen($search);
			if(!$set_text){ //         
				$result_length = 124;
				$start_str = '';
				$end_str = '';
				if($pos - $result_length < 0){
					$start = 0;
				}else{
					$start = $pos - $result_length;
					$start_str = ' ... ';
				}
				if($start + $result_length*2 > strlen($text)){
					$length = strlen($text) - $start;
				}else{
					$length = $result_length*2;
					$end_str = ' ... ';
				}
				$result_text = $start_str.substr($text, $start, $length).$end_str;
				$set_text = true;
			}
			// 
			$pos = stripos($result_text, $search);
			while(is_integer($pos)){
				$start_str = substr($result_text, 0, $pos);
				$end_str = substr($result_text, $pos+$slen, strlen($result_text)-$pos-$slen);
				$search = substr($result_text, $pos, $slen);
				$result_text = $start_str.'<b>'.$search.'</b>'.$end_str;
				$pos = stripos($result_text, $search, $pos+$slen+7);
			}
		}
	}
	return $result_text;
}

/**
 *                 .
 * @param $text
 * @param $search
 * @return bool
 */
function SSearch($text, $search){
	if($search == ''){
		return false;
	}
	$swords = explode(' ', $search);
	$text = preg_replace('/\\[[^\\]]*\\]/s', '', $text); //  BBCode
	$text = strip_tags($text);
	foreach($swords as $search){
		if(stristr($text, $search) === false){
			return false;
		}
	}
	return true;
}

/*header*/

/**
 *  .
 * @param  $text
 * @return void
 */
function SmiliesReplace( &$text ){
	static $codes = null;
	if(!isset($codes)){
		$codes = array();
		$smilies_dir = System::config('general/smilies_dir');
		$smilies = System::database()->Select('smilies'); //     
		foreach($smilies as $smile){
			$sub_codes = explode(',', $smile['code']);
			$smile_file = SafeDB($smile['file'], 255, str);
			if($smile['desc'] != ''){
				$title = SafeDB($smile['desc'], 255, str);
			}else{
				$title = SafeDB(GetFileName($smile_file, true), 255, str);
			}
			foreach($sub_codes as $code){
				$code = trim($code);
				if($code != ''){
					$codes[$code] = '<img src="'.RealPath2($smilies_dir.$smile_file).'" title="'.$title.'">';
				}
			}
		}
	}
	$text = strtr($text, $codes);
}

/*header*/

define('EOL', "\n");
define('WIN_EOL', "\r\n");
define('MAC_EOL', "\r");

/**
 *  ,    ,  
 * @param string $Text
 * @param string $MaxWordLength
 * @return string
 */
function DivideWord( $Text, $MaxWordLength='30' ){
	return wordwrap($Text, $MaxWordLength, chr(13), 1);
}

/**
 *     
 * @param int $Length  
 * @param string $Chars
 * @return String
 */
function GenRandomString($Length, $Chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'){
	srand((double)microtime()*1000000);
	$char_length = (strlen($Chars)-1);
	$random_string = '';
	for($i=0; $i<$Length; $i++){
		$random_string .= $Chars[rand(0,$char_length)];
	}
	return $random_string;
}

/**
 *    
 * @param int $Length  
 * @return String
 */
function GenBPass($Length){
	srand((double)microtime()*1000000);
	$password = '';
	$vowels = array('a','e','i','o','u');
	$cons = array('b','c','d','g','h','j','k','l','m','n','p','r','s','t','u','v','w','tr','cr','br','fr','th','dr','ch','ph','wr','st','sp','sw','pr','sl','cl');
	$num_vowels = count($vowels);
	$num_cons = count($cons);
	for($i=0; $i<$Length; $i++){
		$password .= $cons[rand(0, $num_cons-1)].$vowels[rand(0, $num_vowels-1)];
	}
	return substr($password, 0, $Length);
}

/**
 *     ()  PHP .
 *     ,     LinkorCMS.
 * @param string $String   .
 *        
 * ( "2/" -      ).
 *     ,      .
 *    .
 * @param bool $FirstNewLine    .
 * @return string
 */
function Indent($String, $FirstNewLine = true){
	$lines = explode("\n", $String);
	$indent_lines = '';
	$first_line = false;
	$indent = 0; //  
	$cont_indent = 0; //     -    

	if($FirstNewLine){
		$indent_lines = "\n";
	}

	//      
	$first_line_length = strlen($lines[0]);
	if($first_line_length > 0){
		$param = explode('/', $lines[0], 2);
		if(is_numeric($param[0])){ //   
			$indent = (int)$param[0];
			if($param[1] != ''){ //   
				$first_line = $param[1];
			}
		}else{
			$first_line = $lines[0];
		}
	}
	$indent = str_repeat("\t", $indent);
	if($first_line !== false){ //      
		for($i=0; $i<strlen($first_line); $i++){
			if($first_line[$i] == "\t"){
				$cont_indent++;
			}else{
				break;
			}
		}
		$indent_lines .= $indent.substr($first_line, $cont_indent)."\n";
	}else{ //   -  ,    - 
		if(isset($lines[1])){
			for($i=0; $i<strlen($lines[1]); $i++){
				if($lines[1][$i] == "\t"){
					$cont_indent++;
				}else{
					break;
				}
			}
		}
	}
	//       
	// (      -     () )
	unset($lines[0]);
	//      -  .
	if(trim($lines[count($lines)]) == '') unset($lines[count($lines)]);
	foreach($lines as $line){
		if(trim($line) != ''){
			$indent_lines .= $indent.substr($line, $cont_indent)."\n";
		}else{
			$indent_lines .= "\n";
		}
	}
	return substr($indent_lines, 0, -1); //   \n
}

/**
 *     .
 * @param      $String      
 * @param bool $RemoveNL   
 * @return string
 */
function RemoveIndent( $String, $RemoveNL = true ){
	$lines = explode("\n", $String);
	$text = '';
	foreach( $lines as $line ){
		$line = trim($line);
		if($line != ''){
			$text .= $line;
			if(!$RemoveNL){
				$text .= "\n";
			}
		}
	}
	return $text;
}

/**
 *     .
 * @param $Eol
 * @param $Content
 * @return mixed
 */
function ReplaceEol( $Eol, $Content ){
	$order   = array("\r\n", "\n", "\r");
	$replace = '___***new'.'_'.'line***___';
	$Content = str_replace($order, $replace, $Content);
	$Content = str_replace($replace, $Eol, $Content);
	return $Content;
}

/*header*/

/**
 *   7.79-2000
 * @param string $text
 * @param bool $strip_spaces
 * @return string
 */
function Translit( $text, $strip_spaces = true ){
	if($strip_spaces) {
		$text = str_replace(' ', '_', $text);
	}
	$text = str_replace(' ', '_', $text);
	$text = strtr($text, array(
		'' => 'a', '' => 'A',
		'' => 'b', '' => 'B',
		'' => 'v', '' => 'V',
		'' => 'g', '' => 'G',
		'' => 'd', '' => 'D',
		'' => 'e', '' => 'E',
		'' => 'yo', '' => 'YO',
		'' => 'zh', '' => 'ZH',
		'' => 'z', '' => 'Z',
		'' => 'i', '' => 'I',
		'' => 'j', '' => 'J',
		'' => 'k', '' => 'K',
		'' => 'l', '' => 'L',
		'' => 'm', '' => 'M',
		'' => 'n', '' => 'N',
		'' => 'o', '' => 'O',
		'' => 'p', '' => 'P',
		'' => 'r', '' => 'R',
		'' => 's', '' => 'S',
		'' => 't', '' => 'T',
		'' => 'u', '' => 'U',
		'' => 'f', '' => 'F',
		'' => 'x', '' => 'X',
		'' => 'c', '' => 'C',
		'' => 'ch', '' => 'CH',
		'' => 'sh', '' => 'SH',
		'' => 'shh', '' => 'SHH',
		'' => '``', '' => '``',
		'' => 'y\'', '' => 'Y\'',
		'' => '`', '' => '`',
		'' => 'e`', '' => 'E`',
		'' => 'yu', '' => 'YU',
		'' => 'ya', '' => 'YA',
	));
	return $text;
}

/**
 *   7.79-2000
 * @param string $text
 * @param bool $strip_tospaces
 * @return string
 */
function Retranslit( $text, $strip_tospaces = true ){
	if($strip_tospaces){
		$text = str_replace('_', ' ', $text);
	}
	$text = strtr($text, array(
		'a' => '', 'A' => '',
		'b' => '', 'B' => '',
		'v' => '', 'V' => '',
		'g' => '', 'G' => '',
		'd' => '', 'D' => '',
		'e' => '', 'E' => '',
		'yo' => '', 'YO' => '',
		'zh' => '', 'ZH' => '',
		'z' => '', 'Z' => '',
		'i' => '', 'I' => '',
		'j' => '', 'J' => '',
		'k' => '', 'K' => '',
		'l' => '', 'L' => '',
		'm' => '', 'M' => '',
		'n' => '', 'N' => '',
		'o' => '', 'O' => '',
		'p' => '', 'P' => '',
		'r' => '', 'R' => '',
		's' => '', 'S' => '',
		't' => '', 'T' => '',
		'u' => '', 'U' => '',
		'f' => '', 'F' => '',
		'x' => '', 'X' => '',
		'c' => '', 'C' => '',
		'ch' => '', 'CH' => '',
		'sh' => '', 'SH' => '',
		'shh' => '', 'SHH' => '',
		'``' => '',
		'y\'' => '', 'Y\'' => '',
		'`' => '',
		'e`' => '', 'E`' => '',
		'yu' => '', 'YU' => '',
		'ya' => '', 'YA' => '',
	));
	return $text;
}

/**
 *      URL
 * @param string $text
 * @return string
 */
function Translit4Url( $text ){
	$text = strtr($text, array(
		'' => 'a', '' => 'A',
		'' => 'b', '' => 'B',
		'' => 'v', '' => 'V',
		'' => 'g', '' => 'G',
		'' => 'd', '' => 'D',
		'' => 'e', '' => 'E',
		'' => 'yo', '' => 'YO',
		'' => 'zh', '' => 'ZH',
		'' => 'z', '' => 'Z',
		'' => 'i', '' => 'I',
		'' => 'j', '' => 'J',
		'' => 'k', '' => 'K',
		'' => 'l', '' => 'L',
		'' => 'm', '' => 'M',
		'' => 'n', '' => 'N',
		'' => 'o', '' => 'O',
		'' => 'p', '' => 'P',
		'' => 'r', '' => 'R',
		'' => 's', '' => 'S',
		'' => 't', '' => 'T',
		'' => 'u', '' => 'U',
		'' => 'f', '' => 'F',
		'' => 'x', '' => 'X',
		'' => 'c', '' => 'C',
		'' => 'ch', '' => 'CH',
		'' => 'sh', '' => 'SH',
		'' => 'shh', '' => 'SHH',
		'' => '', '' => '',
		'' => 'y', '' => 'Y',
		'' => '', '' => '',
		'' => 'e', '' => 'E',
		'' => 'yu', '' => 'YU',
		'' => 'ya', '' => 'YA',
	));
	$text = preg_replace('/[^a-zA-Z0-9\.\-_ ]*/', '', $text);
	$text = trim($text, ' _');
	$text = str_replace(' ', '_', $text);
	return $text;
}

/*header*/

/**
 *       .
 * @since 1.4.1
 */
function UfuInit(){
	if(System::config('general/ufu')){
		if(isset($_GET['ufu'])){
			$Path = trim($_GET['ufu']);
			if($Path != ''){
				$_GET = UfuRewrite($_GET['ufu']);
				if($_GET === false){
					Error404();
				}
			}
		}
	}
}

/**
 *   .
 * @param string $Ufu
 * @param bool $Clear
 * @return array
 */
function &UfuGetRules( $Ufu = null, $Clear = false ){
	static $UfuRewriteRules = null;
	if($Clear){
		$UfuRewriteRules = null;
		System::cache()->Delete(system_cache, 'rewrite_rules');
		return $UfuRewriteRules;
	}
	if($UfuRewriteRules == null){
		if(System::cache()->HasCache(system_cache, 'rewrite_rules')){
			$UfuRewriteRules = System::cache()->Get(system_cache, 'rewrite_rules');
		}else{
			$UfuRewriteRules = array();
			$_rules = System::database()->Select('rewrite_rules');
			SortArray($_rules, 'order');
			foreach($_rules as $_rule){
				$rule = array(
					'ufu' => $_rule['ufu'],
					'pattern' => $_rule['pattern'],
					'params' => $_rule['params']
				);
				if($_rule['module'] != '' && $_rule['name'] != ''){
					$UfuRewriteRules[$_rule['module'].':'.$_rule['name']] = $rule;
				}else{
					$UfuRewriteRules[$_rule['ufu']] = $rule;
				}
			}
			System::cache()->Write(system_cache, 'rewrite_rules', $UfuRewriteRules, Day2Sec);
		}
	}
	if(isset($Ufu)){
		if(isset($UfuRewriteRules[$Ufu])){
			return $UfuRewriteRules[$Ufu];
		}else{
			$null = null;
			return $null;
		}
	}
	return $UfuRewriteRules;
}

/**
 *      ,
 *      .
 *
 * @param $Path
 * @return bool
 */
function UfuRewrite( $Path ){
	$Rules = UfuGetRules();
	$search = array();
	$replace = array();
	foreach($Rules as $Rule){
		if(preg_match_all('/^'.$Rule['pattern'].'$/u', $Path, $matches)){
			foreach($matches as $i=>$m){
				$search[] = '$'.$i;
				$replace[] = $m[0];
			}
			parse_str(str_replace($search, $replace, $Rule['params']), $Params);
			return $Params;
		}
	}
	return false; //  
}

/**
 *  ()         .
 *
 * @param $text
 * @return mixed
 */
function UfuLink( $text ){
	$text = preg_replace('/[^[\pL_\-\.\ 0-9]+]*/u', '', Cp1251ToUtf8($text));
	$text = str_replace(array(' ', '_'), '-', $text);
	return Utf8ToCp1251($text);
}

/**
 *        .
 * @param      $UfuTemplate           .
 * @param      $Params           ,     "name=value&name2=val".
 * @param bool $PatternsInParams     .
 * @return array (RegExp, Replace)
 * @since 1.4.1
 */
function UfuGeneratePattern( $UfuTemplate, $Params, $PatternsInParams = false ){
	if(is_string($Params)){
		parse_str($Params, $Params);
	}

	$r_patterns = array(
		'{num}'  => '([0-9]+)',
		'{ustr}' => '([\pL_\-\.\ 0-9]+)',
		'{str}'  => '([a-zA-Z_\-\.\ 0-9]+)'
	);

	//            
	$temp_pos = array();
	foreach($Params as $key=>$val){
		$p = strpos($UfuTemplate, '{'.$key.'}');
		if($p !== false){
			$temp_pos[] = array($p, $key);
		}
	}
	SortArray($temp_pos, 0);
	$pos = array();
	foreach($temp_pos as $key=>$val){
		$pos[$val[1]] = $key+1;
	}

	//      
	$replace = array();
	$ReplacePattern = '';
	foreach($Params as $key=>$val){
		if(strpos($UfuTemplate, '{'.$key.'}') !== false){
			$param_pattern = '';
			if($val != ''){
				if($PatternsInParams){
					if(isset($r_patterns[$val])){
						$param_pattern = $r_patterns[$val];
					}else{
						$param_pattern = '('.$val.')';
					}
				}else{
					if(is_numeric($val)){
						$param_pattern = '([0-9]+)';
					}else{
						$param_pattern = '([\pL_\-\.\ 0-9]+)';
					}
				}
			}
			$replace['\{'.$key.'\}'] = $param_pattern;
			$ReplacePattern .= "$key=\${$pos[$key]}&";
		}else{
			$ReplacePattern .= "$key=$val&";
		}
	}
	if(substr($ReplacePattern, -1) == '&'){
		$ReplacePattern = substr($ReplacePattern, 0, -1);
	}
	$Pattern = strtr(preg_quote($UfuTemplate, '/'), $replace);
	return array($Pattern, $ReplacePattern);
}

/**
 *      .
 * @param int $Start
 * @return int
 */
function UfuGetOrder( $Start = 0 ){
	static $OrderCache = array();
	if(!isset($OrderCache[$Start])){
		$Max = $Start;
		foreach(System::database()->Select('rewrite_rules') as $rule){
			if($rule['order'] > $Max){
				$Max = $rule['order'];
			}
		}
		$OrderCache[$Start] = $Max;
	}
	$OrderCache[$Start] ++;
	return $OrderCache[$Start];
}

/**
 *       .
 * @param        $Module           .
 * @param        $Name              Ufu.
 * @param        $Description  .
 * @param        $Params         ,      UfuTemplate,       .
 *                                       .
 *                                   {num} - , {str} - ,  , {ustr} - Unicode ,
 *                                    -  ,  'name=news&topic=[0-9]{4}'.
 * @param        $UfuTemplate      ,             .
 *                            : 'news/{topic}/'
 * @param int   $MinOrder        . 0 -   , 1000 -  ( ), 5000 -  ( ), 10000 -  .
 *                                   ,    1000,    -  5000.
 * @return array                .
 * @since    1.4.1
 * @examples
 *
 *           UfuAddRuleByTemplate('news', 'topics', '   .', 'name=news&topic={num}', 'news/{topic}/');
 *           Ufu('index.php?name=news&topic=1', 'news:topics');
 *           UfuAddRuleByTemplate('news', 'topics-pagination', '    ( ).', 'name=news&topic={num}&page={num}', 'news/{topic}/page-{page}/');
 *           Ufu('index.php?name=news&topic=1', 'news:topics-pagination', 'page');
 */
function UfuAddRuleByTemplate( $Module, $Name, $Description, $Params, $UfuTemplate, $MinOrder = 5000 ){
	list($Pattern, $Replace) = UfuGeneratePattern($UfuTemplate, $Params, true);
	$rule = array(
		'id'=>'',
		'name'=>SafeEnv($Name, 255, str),
		'module'=>SafeEnv($Module, 255, str),
		'description'=>SafeEnv($Description, 255, str),
		'ufu'=>SafeEnv($UfuTemplate, 255, str),
		'pattern'=>SafeEnv($Pattern, 255, str),
		'params'=>SafeEnv($Replace, 255, str),
		'order'=>UfuGetOrder($MinOrder)
	);
	System::database()->Insert('rewrite_rules', Values($rule));
	$rule['id'] = System::database()->GetLastId();
	UfuGetRules(null, true);
	return $rule;
}

/**
 *      .
 *       Ufu().
 * @param        $UfuTemplate
 * @param        $Params
 * @param int    $MinOrder
 * @return array   .
 * @see UfuAddRuleByTemplate()
 */
function UfuAddRewriteRule( $UfuTemplate, $Params, $MinOrder = 10000 ){
	list($Pattern, $Replace) = UfuGeneratePattern($UfuTemplate, $Params);
	$rule = array(
		'id'=>'',
		'name'=>'',
		'module'=>'_any',
		'description'=>'',
		'ufu'=>SafeEnv($UfuTemplate, 255, str),
		'pattern'=>SafeEnv($Pattern, 255, str),
		'params'=>SafeEnv($Replace, 255, str),
		'order'=>UfuGetOrder($MinOrder)
	);
	System::database()->Insert('rewrite_rules', Values($rule));
	$rule['id'] = System::database()->GetLastId();
	UfuGetRules(null, true);
	return $rule;
}

/**
 *      .     ,     .
 * @param        $Module
 * @param string $Name
 */
function UfuRemoveRule( $Module, $Name = '' ){
	$Module = SafeEnv($Module, 255, str);
	$Name = SafeEnv($Name, 255, str);
	System::database()->Delete('rewrite_rules', "`module`='$Module'".($Name != '' ? " and `name`='$Name'" : ''));
	UfuGetRules(null, true);
}

/**
 *      .
 * @param               $Url
 * @param string        $Ufu
 * @param string|bool   $NavLink
 * @param string        $NavParam
 * @param int           $MinOrder
 * @return string
 * @examples
 *           Ufu('index.php?name=news&topic=5', 'news/{topic}/');
 *           Ufu('index.php?name=news&topic=5', 'news:show-topics');
 */
function Ufu( $Url, $Ufu = '', $NavLink = null, $NavParam = null, $MinOrder = 10000 ){
	if(System::config('general/ufu')){
		if($Url == 'index.php'){
			return GetSiteUrl().'index.html';
		}

		//   
		$p = strpos($Url, '?');
		if($p !== false){
			$Url = substr($Url, $p + 1);
		}
		$p = strrpos($Url, '#');
		if($p !== false){
			$anchor = substr($Url, $p);
			$Url = substr($Url, 0, $p);
		}else{
			$anchor = '';
		}
		parse_str($Url, $params);

		// NavLink
		if(isset($NavLink) && !is_string($NavLink)){
			if($NavLink === true){
				if(isset($NavParam)){
					$NavLink = $NavParam;
				}else{
					$NavLink = 'page';
				}
			}else{
				$NavLink = null;
			}
		}

		//      ufu 
		$replace = array();
		foreach($params as $key=>$val){
			$replace['{'.$key.'}'] = rawurlencode(Cp1251ToUtf8($val));
		}

		//  
		$rule = UfuGetRules($Ufu);
		if(!isset($rule)){
			if(isset($NavLink)){
				$params[$NavLink] = '1';
			}
			$rule = UfuAddRewriteRule($Ufu, $params, $MinOrder);
		}

		//     
		return strtr($rule['ufu'], $replace).$anchor;
	}else{
		if($Url == 'index.php'){
			return GetSiteUrl().$Url;
		}else{
			$Url = new Url($Url);
			return $Url->ToString();
		}
	}
}

/*header*/

/**
 *    http .
 * @param $url
 * @return mixed
 */
function Url( $url ){
	return preg_replace(array('/^https:\/\//', '/^http:\/\//', '/^www\./'), '', $url);
}

//   -        
// -    .
//      ( ) -   
//(   "    ").
function UrlRender( $url ){
	static $out = null;
	if(!isset($out)){
		$out = System::config('general/specialoutlinks');
		if($out == 0) $out = false;
		elseif($out == 1) $out = true;
		elseif($out == 2 && !System::user()->Auth) $out = true;
		else $out = false;
	}

	if($out && !IsMainHost($url)){
		return 'index.php?name=plugins&p=out&url='.urlencode(Url($url));
	}else{
		return 'http://'.Url($url);
	}
}

/*header*/

$system_users_cache = null;
$system_userranks_cache = null;
$system_usertypes_cache = null;

/**
 *         id.
 * @return array
 */
function &GetUsers(){
	global $system_users_cache;
	if($system_users_cache == null){
		if(System::cache()->HasCache(system_cache, 'users')){
			$system_users_cache = System::cache()->Get(system_cache, 'users');
		}else{
			System::database()->Select('users', '');
			$system_users_cache = array();
			foreach(System::database()->QueryResult as $usr){
				$system_users_cache[$usr['id']] = $usr;
			}
			//         
			System::cache()->Write(system_cache, 'users', $system_users_cache, Day2Sec);
		}
	}
	return $system_users_cache;
}

/**
 *       ,  ,  ,     .   .
 * @param $user_id
 * @return array|bool
 */
function GetUserInfo( $user_id ){
	$system_users_cache = GetUsers();
	if(isset($system_users_cache[$user_id])){
		$usr = $system_users_cache[$user_id];
		// 
		$usr['avatar_file'] = GetUserAvatar($user_id);
		$usr['avatar_file_small'] = GetSmallUserAvatar($user_id, $usr['avatar_file']);
		$usr['avatar_file_smallest'] = GetSmallestUserAvatar($user_id,  $usr['avatar_file']);
		// 
		$rank = GetUserRank($usr['points'], $usr['type'], $usr['access']);
		$usr['rank_name'] = $rank[0];
		$usr['rank_image'] = $rank[1];
		//  
		$online = System::user()->Online();
		$usr['online'] = isset($online[$user_id]);
		//  
		if(!is_array($usr['data'])){
			if($usr['data'] == ''){
				$usr['data'] = array();
			}else{
				$system_users_cache[$user_id]['data'] = unserialize($usr['data']);
				$usr['data'] = $system_users_cache[$user_id]['data'];
			}
		}
		return $usr;
	}else{
		return false;
	}
}

/**
 *   
 * @return array
 */
function &GetUserTypes(){
	global $system_usertypes_cache;
	if($system_usertypes_cache == null){
		if(System::cache()->HasCache(system_cache, 'usertypes')){
			$system_usertypes_cache = System::cache()->Get(system_cache, 'usertypes');
		}else{
			$types = System::database()->Select('usertypes', '');
			$system_usertypes_cache = array();
			foreach($types as $type){
				$system_usertypes_cache[$type['id']] = $type;
			}
			System::cache()->Write(system_cache, 'usertypes', $system_usertypes_cache);
		}
	}
	return $system_usertypes_cache;
}

/**
 *     .   GetPersonalAvatar.
 * @param $user_id
 * @return string
 */
function GetUserAvatar( $user_id ){
	return GetPersonalAvatar($user_id);
}

/**
 *         64px
 * @param $user_id
 * @param string $avatar
 * @return string
 */
function GetSmallUserAvatar( $user_id, $avatar = '' ){
	if($avatar == ''){
		$avatar = GetPersonalAvatar($user_id);
		if(substr($avatar, 0, 10) == 'index.php?'){
			return $avatar.'&size=small';
		}
	}
	$filename = RealPath2(System::config('general/personal_avatars_dir').GetFileName($avatar, true).'_64x64'.GetFileExt($avatar));
	if(is_file($filename)){
		return $filename;
	}else{
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id.'&size=small';
	}
}

/**
 *          24px
 * @param $user_id
 * @param string $avatar
 * @return string
 */
function GetSmallestUserAvatar( $user_id, $avatar = '' ){
	if($avatar == ''){
		$avatar = GetPersonalAvatar($user_id);
		if(substr($avatar, 0, 10) == 'index.php?'){
			return $avatar.'&size=smallest';
		}
	}
	$filename = RealPath2(System::config('general/personal_avatars_dir').GetFileName($avatar, true).'_24x24'.GetFileExt($avatar));
	if(is_file($filename)){
		return $filename;
	}else{
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id.'&size=smallest';
	}
}

/**
 *     
 * @param $user_id
 * @return string
 */
function GetPersonalAvatar( $user_id, $GetFile = false ){
	if($user_id == 0){
		return GetGalleryAvatar('guest.gif');
	}
	if(System::config('user/secure_avatar_upload') && GDVersion() <> 0 && !$GetFile){
		return 'index.php?name=plugins&p=avatars_render&user='.$user_id;
	}else{
		$users = GetUsers();
		if(!isset($users[$user_id])){
			return GetGalleryAvatar('guest.gif');
		}
		if($users[$user_id]['a_personal'] == '1'){
			$avatar_file = RealPath2(System::config('general/personal_avatars_dir').$users[$user_id]['avatar']);
		}else{
			$avatar_file = RealPath2(System::config('general/avatars_dir').$users[$user_id]['avatar']);
		}
		if(is_file($avatar_file)){
			return $avatar_file;
		}else{
			return GetGalleryAvatar('noavatar.gif');
		}
	}
}

/**
 *        
 * @param $filename
 * @return string
 */
function GetGalleryAvatar($filename){
	if(!defined('SETUP_SCRIPT')){
		if(trim($filename)==''){
			$filename = 'noavatar.gif';
		}
		return RealPath2(System::config('general/avatars_dir').$filename);
	}else{
		return $filename;
	}
}

/**
 *   
 * @return array|null|string
 */
function &GetUserRanks(){
	global $system_userranks_cache;
	if($system_userranks_cache == null){
		if(System::cache()->HasCache(system_cache, 'userranks')){
			$system_userranks_cache = System::cache()->Get(system_cache, 'userranks');
		}else{
			$ranks = System::database()->Select('userranks', '');
			SortArray($ranks, 'min');
			foreach($ranks as $rank){
				$system_userranks_cache[$rank['id']] = $rank;
			}
			System::cache()->Write(system_cache, 'userranks', $system_userranks_cache);
		}
	}
	return $system_userranks_cache;
}

/**
 *  ,     .
 * @param $points
 * @param $type
 * @param $access
 * @return array
 */
function GetUserRank( $points = null, $type = null, $access = null ){
	static $admintypes = null;
	if(!isset($points)){
		$points = System::user()->Get('u_points');
		$type = System::user()->Get('u_level');
		$access = System::user()->Get('u_access');
	}
	if($type == 2){ // 
		$ranks = GetUserRanks();
		$last = current($ranks);
		foreach($ranks as $rank){
			if($rank['min'] > $points){
				return array(
					SafeDB($last['title'], 250, str),
					RealPath2(System::config('general/ranks_dir').SafeDB($last['image'], 250, str)),
					SafeDB($last['id'], 11, int));
			}else{
				$last = $rank;
			}
		}
		return array(
			SafeDB($last['title'], 250, str),
			RealPath2(System::config('general/ranks_dir').SafeDB($last['image'], 250, str)),
			SafeDB($last['id'], 11, int));
	}else{ // 
		$admintypes = GetUserTypes();
		if(isset($admintypes[$access])){
			return array(
				'<font color="'.SafeDB($admintypes[$access]['color'], 9, str).'">'.SafeDB($admintypes[$access]['name'], 255, str).'</font>',
				RealPath2(System::config('general/ranks_dir').SafeDB($admintypes[$access]['image'], 250, str)),
				SafeDB($admintypes[$access]['id'], 11, int));
		}
	}
}

/**
 *      .
 * @param type $UserId
 * @return boolean
 */
function GetUserRankInfo( $UserId = null ){
	$system_users_cache = GetUsers();
	if(isset($UserId)){
		$user = $system_users_cache[$UserId];
		$points = $user['points'];
		$type = $user['type'];
		$access = $user['access'];
	}else{
		$points = System::user()->Get('u_points');
		$type = System::user()->Get('u_level');
		$access = System::user()->Get('u_access');
	}
	if($type >= 3){
		return false; // 
	}elseif($type == 1){
		return true; // 
	}
	$ranks = GetUserRanks();
	$last = current($ranks);
	foreach($ranks as $rank){
		if($rank['min'] > $points){
			return $rank;
		}else{
			$last = $rank;
		}
	}
	return $last;
}

/**
 *       .
 * @param type $RankId
 */
function GetRankInfo( $RankId, $SubInfo = null ){
	$system_userranks_cache = GetUserRanks();
	if(!isset($system_userranks_cache[$RankId])){
		return false;
	}
	if(isset($SubInfo)){
		return $system_userranks_cache[$RankId][$SubInfo];
	}else{
		return $system_userranks_cache[$RankId];
	}
}

/**
 *  E-mail    
 * @param $Email
 * @param $error_out
 * @param bool $CheckExist
 * @param int $xor_id
 * @return bool
 */
function CheckUserEmail( $Email, &$error_out, $CheckExist=false, $xor_id=0 ){
	if($Email == ''){
		$error_out[] = '    E-mail .';
		return false;
	}
	if(!CheckEmail($Email)){
		$error_out[] = '   E-mail.    : <b>domain@host.ru</b> .';
		return false;
	}
	if($CheckExist){
        System::database()->Select('users', "`email`='$Email'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows() > 0){
			$error_out[] = '   E-mail   !';
			return false;
		}
	}
	return true;
}

/**
 *    
 * @param String $login 
 * @param $error_out      
 * @param bool $CheckExist     
 * @param int $xor_id
 * @return Boolean    
 */
function CheckLogin( $login, &$error_out, $CheckExist=false, $xor_id=0 ){
	$result = true;
	if(System::config('user/login_min_length')){
		$minlength = System::config('user/login_min_length');
	}else{
		$minlength = 4;
	}
	if(strlen($login) < $minlength || strlen($login) > 30){
		$error_out[] = '     '.$minlength.'    30 .';
		$result = false;
	}
	if(preg_match('/[^a-zA-Z--0-9_]/', $login)){
		$error_out[] = '         ,    .';
		$result = false;
	}
	if($CheckExist){
        System::database()->Select('users',"`login`='$login'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows()>0){
			$error_out[] = '      !';
			$result = false;
		}
	}
	return $result;
}

/**
 *    
 * @param String $nikname 
 * @param $error_out      
 * @param bool $CheckExist     
 * @param int $xor_id
 * @return Boolean    
 */
function CheckNikname( $nikname, &$error_out, $CheckExist=false, $xor_id=0 ){
	$result = true;
	if($nikname == ''){
		$error_out[] = '   !';
		$result = false;
	}
	if(preg_match("/[^a-zA-Z--0-9_ ]/", $nikname)){
		$error_out[] = '           ,    .';
		$result = false;
	}
	if($CheckExist){
        System::database()->Select('users',"`name`='$nikname'".($xor_id<>0?' and `id`<>'.$xor_id:''));
		if(System::database()->NumRows()>0){
			$error_out[] = '      !';
			$result = false;
		}
	}
	return $result;
}

/**
 *    
 * @param String $pass 
 * @param $error_out       ()
 * @return Boolean    
 */
function CheckPass( $pass, &$error_out ){
	$result = true;
	if(System::config('user/pass_min_length')){
		$minlength = System::config('user/pass_min_length');
	}else{
		$minlength = 4;
	}
	if($pass<>'' && (strlen($pass) < $minlength || strlen($pass)>255)){
		$error_out[] = '     '.$minlength.' .';
		$result = false;
	}
	return $result;
}

/**
 *      E-mail
 * @param $username
 * @param $user_mail
 * @param $login
 * @param $pass
 * @param $code
 * @param $regtime
 * @return void
 */
function UserSendActivationMail( $username, $user_mail, $login, $pass, $code, $regtime ){
	$time = $regtime+604800;
	$time = date("d.m.Y", $time);

	$text = System::config('user/mail_template');
	$keys = array(
		'{sitename}' => System::config('general/site_name'),
		'{siteurl}' => System::config('general/site_url'),
		'{username}' => $username,
		'{date}' => $time,
		'{login}' => $login,
		'{pass}' => $pass,
		'{link}' => System::config('general/site_url').'index.php?name=user&op=activate&code='.$code
	);

	$text = str_replace(array_keys($keys), array_values($keys), $text);
	SendMail($username, $user_mail, '  '.System::config('general/site_name'), $text);
}

/**
 *     
 * @param $user_mail
 * @param $name
 * @param $login
 * @param $pass
 * @param $regtime
 * @return void
 */
function UserSendEndRegMail($user_mail, $name, $login, $pass, $regtime){
	$text = Indent('
		, ['.$name.']!

		     
		"'.GetSiteDomain().'"

		 : '.date("d.m.Y", $regtime).'
		: '.$name.'

		    :
		: '.$login.'
		: '.$pass.'

		,     .
		 ,   "'.GetSiteDomain().'".
	');
	SendMail($name, $user_mail, '  '.GetSiteDomain(), $text);
}

/**
 *     
 * @param $user_mail
 * @param $name
 * @param $login
 * @param $pass
 * @return void
 */
function UserSendForgotPassword($user_mail, $name, $login, $pass){
	$ip = getip();
	$text = Indent('
		, ['.$name.']!

		  '.GetSiteDomain().'
		   .

		: '.$name.'

		    :
		: '.$login.'
		: '.$pass.'

		      :
		'.GetSiteUrl().Ufu('index.php?name=user&op=editprofile', 'user/{op}/').'

		IP-,     : '.$ip.'

		 ,   '.GetSiteDomain().'.
	');
	SendMail($name, $user_mail, '['.GetSiteDomain().']  ', $text);
}

/**
 *          HTML::Select
 * @param $avatar
 * @param $personal
 * @return array
 */
function GetGalleryAvatarsData($avatar, $personal){
	$avatars = GetFiles(System::config('general/avatars_dir'), false, true, '.gif.jpg.jpeg.png');
	$selindex = 0;
	$avd = array(
	);
	if($personal == '1'){
		System::site()->DataAdd($avd, '', '', true);
	}
	for($i = 0, $c = count($avatars); $i < $c; $i++){
		if($avatar == $avatars[$i]){
			$sel = true;
			$selindex = $i;
		} else{
			$sel = false;
		}
		System::site()->DataAdd($avd, $avatars[$i], $avatars[$i], $sel);
	}
	return array(
		$avd, $avatars[$selindex]
	);
}

/**
 *     ($_FILES['upavatar'])
 * @param $errors
 * @param $avatar
 * @param $a_personal
 * @param $oldAvatarName
 * @param $oldAvatarPersonal
 * @param $editmode
 */
function UserLoadAvatar(&$errors, &$avatar, &$a_personal, $oldAvatarName, $oldAvatarPersonal, $editmode){
	$asize = getimagesize($_FILES['upavatar']['tmp_name']);

	//  
	$alloy_mime = array(
		'image/gif', 'image/jpeg', 'image/pjpeg', 'image/png', 'image/x-png'
	);
	$alloy_exts = array(
		'.gif', '.jpg', '.jpeg', '.png'
	);
	if(in_array($_FILES['upavatar']['type'], $alloy_mime) && in_array(strtolower(GetFileExt($_FILES['upavatar']['name'])), $alloy_exts)){
		//   
		if($editmode && $oldAvatarPersonal == '1'){
			UnlinkUserAvatarFiles($oldAvatarName);
		}

		// ,  ,       
		$NewName = GenRandomString(12, 'qwertyuiopasdfghjklzxcvbnm');
		$ext = strtolower(GetFileExt($_FILES['upavatar']['name']));
		$pavatar_dir = System::config('general/personal_avatars_dir');
		$max_width = System::config('user/max_avatar_width');
		$max_height = System::config('user/max_avatar_height');

		if($asize[0] > $max_width || $asize[1] > $max_height){
			CreateThumb($_FILES['upavatar']['tmp_name'], $pavatar_dir.$NewName.$ext, $max_width, $max_height);
		} else{
			copy($_FILES['upavatar']['tmp_name'], $pavatar_dir.$NewName.$ext);
		}

		//     2424  6464
		CreateThumb($_FILES['upavatar']['tmp_name'], System::config('general/personal_avatars_dir').$NewName.'_64x64'.$ext, 64, 64);
		CreateThumb($_FILES['upavatar']['tmp_name'], System::config('general/personal_avatars_dir').$NewName.'_24x24'.$ext, 24, 24);

		$avatar = $NewName.$ext;
		$a_personal = '1';
	}else{
		$errors[] = '   .      GIF, JPEG  PNG.';
		$a_personal = '0';
	}
}

/**
 *       
 * @param $AvatarFileName
 * @return void
 */
function UnlinkUserAvatarFiles( $AvatarFileName ){
	$pavatar_dir = System::config('general/personal_avatars_dir');
	$AvatarFileName = RealPath2($pavatar_dir.$AvatarFileName);
	if(is_file($AvatarFileName)){
		unlink($AvatarFileName);
		$_name = GetFileName($AvatarFileName, true);
		$_ext = GetFileExt($AvatarFileName);
		if(is_file($pavatar_dir.$_name.'_24x24'.$_ext)){
			unlink($pavatar_dir.$_name.'_24x24'.$_ext);
		}
		if(is_file($pavatar_dir.$_name.'_64x64'.$_ext)){
			unlink($pavatar_dir.$_name.'_64x64'.$_ext);
		}
	}
}

/**
 *      Html::Select
 * @param array | int $view          
 * @return array | int
 */
function GetUserTypesFormData( $view ){
	$visdata = array();
	if(!is_array($view)){
		$_view = $view;
		$view = array('1'=>false, '2'=>false, '3'=>false, '4'=>false);
		$view[$_view] = true;
	}
	System::admin()->DataAdd($visdata, 'all', '', $view['4']);
	System::admin()->DataAdd($visdata, 'members', ' ', $view['2']);
	System::admin()->DataAdd($visdata, 'guests', ' ', $view['3']);
	System::admin()->DataAdd($visdata, 'admins', ' ', $view['1']);
	return $visdata;
}

/**
 *    
 * @return int
 */
function GetSystemAdminsCount(){
	$atypes = System::database()->Select('usertypes', '');
	foreach($atypes as $type){
		$types[$type['id']] = $type['system'];
	}
	unset($atypes);
	$admins = System::database()->Select('users', "`type`='1'");
	//   
	$system = 0;
	for($i = 0, $c = count($admins); $i < $c; $i++){
		if($types[$admins[$i]['access']] == '1'){
			$system++;
		}
	}
	return $system;
}

/**
 *      id 
 * @param  $access
 * @return bool
 */
function groupIsSystem($access){
	if($access == -1){
		return false;
	}
    System::database()->Select('usertypes', "`id`='$access'");
	if(System::database()->NumRows() > 0){
		$access = System::database()->FetchRow();
		return $access['system'] == '1';
	} else{
		return false;
	}
}

/**
 *      -.
 *
 * @param  $save_link     (    action)
 * @param string $a     (edit or add)
 * @param int $id  
 * @param bool $isadmin   (       email)
 * @param bool $EditProfile     (        )
 * @return
 */
function AdminUserEditor( $save_link, $a = 'add', $id = '0', $isadmin = false ){
	$active = array(false, false, false);

	$SystemAdmin = System::user()->isSuperUser();

	$edit = $a == 'edit';
	$editProfile = $edit && !$SystemAdmin && $id == System::user()->Get('u_id'); //    
	$editStatus = false; //   
	$editType = false; //    

	//     
	if($edit){
		$user = System::database()->SelectOne('users', "`id`='$id'".($isadmin ? " and `type`='1'" : " and `type`='2'"));
		if(!$user){
			AddTextBox('', '<p align="center">  ,         .</p>');
			return;
		}
	}

	//   
	if($isadmin){ //  
		if($SystemAdmin){ //         
			if(!(groupIsSystem(SafeEnv($user['access'], 11, int)) && GetSystemAdminsCount() <= 1)){//        1
				$editStatus = true;
			}
			$editType = $editStatus;
		}
	}else{ //  
		$editStatus = true; //        
		$editType = $SystemAdmin; //      
	}

	if($editType){
		$user_types_db = System::database()->Select('usertypes');
		$types = array('member'=> array('member', '', false));
		foreach($user_types_db as $type){
			$types[$type['id']] = array(SafeDB($type['id'], 11, int), SafeDB($type['name'], 255, str), false);
		}
	}

	if($edit){
		$login = SafeDB($user['login'], 30, str);
		$mail = SafeDB($user['email'], 50, str);
		$hideemail = ($user['hideemail'] == 1 ? true : false);
		$snews = ($user['servernews'] == 1 ? true : false);
		$name = SafeDB($user['name'], 50, str);
		$tname = SafeDB($user['truename'], 250, str);
		$age = SafeDB($user['age'], 11, str);
		$city = SafeDB($user['city'], 100, str);
		$url = SafeDB($user['url'], 250, str);
		$icq = SafeDB($user['icq'], 15, str);
		$gmt = SafeDB($user['timezone'], 255, str);
		$about = SafeDB($user['about'], 0, str);
		$avatar = SafeDB($user['avatar'], 250, str);
		$apersonal = SafeDB($user['a_personal'], 1, int);

		if($editStatus){
			if($user['active'] == '1'){
				$active[0] = true;
			}elseif($user['active'] == '0' && $user['activate'] == ''){
				$active[1] = true;
			}elseif($user['active'] == '0' && $user['activate'] != ''){
				$active[2] = true;
			}
		}

		if($editType){
			if($user['type'] == '1'){
				$types[$user['access']][2] = true;
			}else{
				$types['member'][2] = true; //
			}
		}

		$caption = '';
		if($isadmin){
			if($editProfile){
				$title = ' ';
			}else{
				$title = ' ';
			}
		}else{
			$title = ' ';
		}
	}else{
		$login = '';
		$mail = '';
		$snews = false;
		$hideemail = false;
		$name = '';
		$tname = '';
		$age = '';
		$city = '';
		$url = '';
		$icq = '';
		$gmt = System::config('general/default_timezone');
		$about = '';
		$avatar = '';
		$apersonal = '0';
		if($editStatus){
			$active[0] = true;
		}
		if($editType){
			$types['member'][2] = true;
		}

		$caption = '';
		$title = ' ';
	}

	FormRow('', System::site()->Edit('login', $login, false, 'style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('pass', '', true, 'style="width:400px;"'));
	FormRow(' <br /><small>( )</small>', System::site()->Edit('rpass', '', true, 'style="width:400px;"'));
	FormRow('E-mail', System::site()->Edit('email', $mail, false, 'style="width:300px;"').' <label for="hideemail"></label>&nbsp;'.System::site()->Check('hideemail', '1', $hideemail, 'id="hideemail"'));
	FormRow('<label for="snews"></label>', System::site()->Check('snews', '1', $snews, 'id="snews"'));
	FormRow('', System::site()->Edit('nikname', $name, false, 'style="width:400px;"'));
	FormRow(' ', System::site()->Edit('realname', $tname, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('age', $age, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('city', $city, false, 'style="width:400px;"'));
	FormRow('', System::site()->Edit('homepage', $url, false, 'style="width:400px;"'));
	FormRow('ICQ', System::site()->Edit('icq', $icq, false, 'style="width:400px;"'));
	$gmt = GetGmtData($gmt);
	FormRow(' ', System::site()->Select('gmt', $gmt, false, 'style="width:400px;"'));
	FormRow(' ', System::site()->TextArea('about', $about, 'style="width:400px; height:200px;"'));
	$avatars = GetGalleryAvatarsData($avatar, $apersonal);
	if($apersonal == '1'){
		$selected = GetPersonalAvatar($id);
	} else{
		$selected = GetGalleryAvatar($avatars[1]);
	}
	System::site()->AddJS('
	ShowAvatar = function(){
		if(document.userform.avatar.value==\'\'){
			document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&user='.$id : System::config('general/personal_avatars_dir').$avatar).'\';
		}else{
			document.userform.avatarview.src = \''.(System::config('user/secure_avatar_upload') ? 'index.php?name=plugins&p=avatars_render&aname=' : System::config('general/avatars_dir')).'\'+document.userform.avatar.value;
		}
	}');
	FormRow('', System::site()->Select('avatar', $avatars[0], false, 'onchange="ShowAvatar();"'));
	FormRow('', '<img id="avatarview" src="'.$selected.'" border="0">');
	FormRow(' ', System::site()->FFile('upavatar'));

	if($editStatus){
		FormRow('',
		        System::site()->Radio('activate', 'auto', $active[0]).''
		        .System::site()->Radio('activate', 'manual', $active[1]).' '
		        .(!$isadmin ? System::site()->Radio('activate', 'mail', $active[2]).' E-mail' : '')
		);
	}
	if($editType){
		$user_types = array();
		foreach($types as $type){
			System::site()->DataAdd($user_types, $type[0], $type[1], $type[2]);
		}
		FormRow('', System::site()->Select('status', $user_types));
	}

	TAddSubTitle($title);
	AddCenterBox($title);
	AddForm('<form name="userform" action="'.ADMIN_FILE.'?exe='.$save_link.'&id='.$id.'" method="post"  enctype="multipart/form-data">',
	        System::site()->Button('', 'onclick="history.go(-1);"').System::site()->Submit($caption));
}

/**
 *      AdminUserEditor
 *
 * @param  $back_link
 * @param string $a
 * @param int $id
 * @param bool $IsAdmin
 * @return void
 */
function AdminUserEditSave( $back_link, $a = 'insert', $id = 0, $IsAdmin = false ){

	$SystemAdmin = System::user()->isSuperUser();

	$edit = $a == 'update';
	$editProfile = $edit && !$SystemAdmin && $id == System::user()->Get('u_id'); //    
	$editStatus = false; //   
	$editType = false; //    

	//     
	if($edit){
		$user = System::database()->SelectOne('users', "`id`='$id'".($IsAdmin ? " and `type`='1'" : " and `type`='2'"));
		if(!$user){
			AddTextBox('', '<p align="center">  ,         .</p>');
			return;
		}
	}

	//   
	if($IsAdmin){ //  
		if($SystemAdmin){ //         
			if(!$edit){
				$editStatus = true;
			}elseif(!(groupIsSystem(SafeEnv($user['access'], 11, int)) && GetSystemAdminsCount() <= 1)){//        1
				$editStatus = true;
			}
			$editType = $editStatus;
		}
	}else{ //  
		$editStatus = true; //        
		$editType = $SystemAdmin; //      
	}

	//  
	$errors = array();

	// 
	if(isset($_POST['login']) && CheckLogin($_POST['login'], $errors, !$edit)){
		$login = SafeEnv($_POST['login'], 30, str);
	} else{
		$login = '';
	}

	// 
	$pass = '';
	if(!$edit || $_POST['pass'] != ''){
		$pass_generate_message = '';
		if(isset($_POST['pass']) && CheckPass($_POST['pass'], $errors)){
			$pass = SafeEnv($_POST['pass'], 30, str);
			if(!isset($_POST['rpass']) || SafeEnv($_POST['rpass'], 30, str) != $pass){
				$errors[] = '  .';
			}
		} else{
			$pass = '';
		}
		if(isset($_POST['pass']) && $_POST['pass'] == ''){
			srand(time());
			$pass = GenBPass(rand(System::config('user/pass_min_length'), 15));
			$pass_generate_message = '<br />     ,         E-mail .';
		}
		$pass2 = md5($pass);
	}

	// e-mail
	if(isset($_POST['email']) && $_POST['email'] != ''){
		if(!CheckEmail($_POST['email'])){
			$errors[] = '   E-mail.    : <b>domain@host.ru</b> .';
		}
		$email = SafeEnv($_POST['email'], 50, str, true);
	} else{
		$email = '';
		$errors[] = '   E-mail.';
	}

	//  e-mail
	if(isset($_POST['hideemail'])){
		$hide_email = '1';
	} else{
		$hide_email = '0';
	}

	//    
	if(isset($_POST['nikname']) && CheckNikname($_POST['nikname'], $errors, !$edit)){
		$nik_name = SafeEnv($_POST['nikname'], 50, str, true);
	} else{
		$nik_name = '';
	}

	//  
	if(isset($_POST['realname'])){
		$real_name = SafeEnv($_POST['realname'], 250, str, true);
	} else{
		$real_name = '';
	}

	// 
	if(isset($_POST['age'])){
		if($_POST['age'] == '' || is_numeric($_POST['age'])){
			$age = SafeEnv($_POST['age'], 3, int);
		} else{
			$errors[] = '    !';
		}
	} else{
		$age = '';
	}

	//  
	if(isset($_POST['homepage'])){
		if($_POST['homepage'] != '' && substr($_POST['homepage'], 0, 7) == 'http://'){
			$_POST['homepage'] = substr($_POST['homepage'], 7);
		}
		$homepage = SafeEnv($_POST['homepage'], 250, str, true);
	} else{
		$homepage = '';
	}

	//  ICQ
	if(isset($_POST['icq'])){
		if($_POST['icq'] == '' || is_numeric($_POST['icq'])){
			$icq = SafeEnv($_POST['icq'], 15, str, true);
		} else{
			$errors[] = ' ICQ    !';
		}
	} else{
		$icq = '';
	}

	// 
	if(isset($_POST['city'])){
		$city = SafeEnv($_POST['city'], 100, str, true);
	} else{
		$city = '';
	}

	//  
	if(isset($_POST['gmt'])){
		$gmt = SafeEnv($_POST['gmt'], 255, str);
	} else{
		$gmt = System::config('general/default_timezone');
	}

	//  
	if(isset($_POST['about'])){
		$about = SafeEnv($_POST['about'], System::config('user/about_max_length'), str, true);
	} else{
		$about = '';
	}

	//   
	if(isset($_POST['snews'])){
		$server_news = '1';
	} else{
		$server_news = '0';
	}

	// 
	$updateAvatar = true;
	if(isset($_POST['avatar'])){
		if(System::config('user/avatar_transfer') == '1' && isset($_FILES['upavatar']) && file_exists($_FILES['upavatar']['tmp_name'])){
			if($edit){
				$avatar = $user['avatar'];
				$a_personal = $user['a_personal'];
			}else{
				$avatar = '';
				$a_personal = '0';
			}
			UserLoadAvatar($errors, $avatar, $a_personal, $avatar, $a_personal, $edit);
		}elseif($_POST['avatar'] == ''){
			$updateAvatar = false;
		}elseif(file_exists(RealPath2(System::config('general/avatars_dir').$_POST['avatar']))){
			if($edit){
				if($user['a_personal'] == '1'){
					UnlinkUserAvatarFiles($user['avatar']);
				}
			}
			$a_personal = '0';
			$avatar = $_POST['avatar'];
		}else{
			$avatar = '';
			$a_personal = '0';
		}
	}else{
		$avatar = '';
		$a_personal = '0';
	}

	$SendActivation = false;
	if($edit){
		$active = SafeEnv($user['active'], 11, int);
		$code = SafeEnv($user['activate'], 11, int);
	}else{
		$active = '1';
		$code = '';
	}
	if($editStatus){
		$activate = $_POST['activate'];
		$lastactivate = 'manual';
		if($active == '0' && $code != ''){
			$lastactivate = 'mail';
		}elseif($active == '1' && $code == ''){
			$lastactivate = 'auto';
		}
		if($activate != $lastactivate){
			switch($activate){
				case 'manual':
					$active = '0';
					$code = '';
					$SendActivation = false;
					break;
				case 'auto':
					$active = '1';
					$code = '';
					$SendActivation = false;
					break;
				case 'mail':
					$active = '0';
					$code = GenRandomString(8, 'qwertyuiopasdfghjklzxcvbnm');
					$SendActivation = true;
					break;
			}
		}
	}

	if($edit){
		$access = SafeEnv($user['type'], 11, int);
		$user_type = SafeEnv($user['access'], 11, int);
	}else{
		$access = '2';
		$user_type = '-1';
	}

	if($editType && $_POST['status'] != 'member'){
		$access = '1';
		$user_type = SafeEnv($_POST['status'], 11, int);
	}

	$reg_date = time();
	$last_visit = time();
	$ip = getip();
	$points = 0;
	$visits = 0;
	if($SendActivation){
		UserSendActivationMail($nik_name, $email, $login, $pass, $code, $reg_date);
	}elseif(!$edit){
		UserSendEndRegMail($email, $nik_name, $login, $pass, $reg_date);
	}

	if(!$edit){
		$values = Values('', $login, $pass2, $nik_name, $real_name, $age, $email, $hide_email, $city, $icq, $homepage, $gmt, $avatar, $about, $server_news, $reg_date, $last_visit, $ip, $points, $visits, $active, $code, $access, $user_type, $a_personal, serialize(array()));
		System::database()->Insert('users', $values);
	}else{
		$set = "`login`='$login',`email`='$email',`hideemail`='$hide_email',`name`='$nik_name',"
			."`truename`='$real_name',`age`='$age',`url`='$homepage',`icq`='$icq',`city`='$city',"
			."`timezone`='$gmt'".($updateAvatar == true ? ",`avatar`='$avatar',`a_personal`='$a_personal'" : '').","
			."`about`='$about',`servernews`='$server_news'".($pass != '' ? ",`pass`='$pass2'" : '').",`type`='$access',"
			."`access`='$user_type',`active`='$active',`activate`='$code'";
		System::database()->Update('users', $set, "`id`='".$id."'");
		System::user()->UpdateMemberSession();
		UpdateUserComments($id, $id, $nik_name, $email, $hide_email, $homepage);
	}

	if(count($errors) > 0){
		$text = ' ,     :<br /><ul>';
		foreach($errors as $error){
			$text .= '<li>'.$error;
		}
		$text .= '</ul>';
		AddTextBox('', $text);
	}else{
		//   
		System::cache()->Delete(system_cache, 'users');
		if(!$editProfile){
			GO(ADMIN_FILE.'?exe='.$back_link);
		}else{
			System::admin()->AddCenterBox(' ');
			System::admin()->Highlight('  ,  .');
		}
	}
}

/**
 *  IP  
 * @return string
 */
function getip(){
	static $ip = null;
	if(!isset($ip)){
		if(isset($_SERVER['REMOTE_ADDR'])){
			$ip = $_SERVER['REMOTE_ADDR'];
		}elseif(isset($HTTP_SERVER_VARS['REMOTE_ADDR'])){
			$ip = $HTTP_SERVER_VARS['REMOTE_ADDR'];
		}elseif(getenv('REMOTE_ADDR')){
			$ip = getenv('REMOTE_ADDR');
		}
		if($ip!=""){
			if(preg_match("/^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/", $ip, $ipm)){
				$private = array(
					"/^0\./",
					"/^127\.0\.0\.1/",
					"/^192\.168\..*/",
					"/^172\.16\..*/",
					"/^10..*/","/^224..*/","/^240..*/"
				);
				$ip = preg_replace($private, $ip, $ipm[1]);
			}
		}
		if (strlen($ip)>16) $ip = substr($ip, 0, 16);
	}
	return $ip;
}

/**
 *    .
 * @param type $Name
 * @param type $Title
 * @param type $Description
 * @param type $Value
 */
function AddPointsConfig( $Name, $Title, $Description, $Value ){
	$points_group = '9';
	$Name = SafeEnv($Name, 255, str);
	$Title = SafeEnv($Title, 255, str);
	$Description = SafeEnv($Description, 255, str);
	$Value = SafeEnv($Value, 0, str);
	System::database()->Insert('config', "'','$points_group','$Name','$Value','1','$Title','$Description','edit:w50px','','','10,int,false','1'");
}

/**
 *   .
 * @param type $Name
 */
function RemovePointsConfig( $Name ){
	$points_group = '9';
	System::database()->Delete('config', "`group_id`='$points_group' and `name`='$Name'");
}

/**
 *           .
 * @param null $Name  .
 * @param null $Value ,    .   null.
 * @param null $UserId  .   ,     .
 * @return array|null|var  null    .
 */
function UserData( $Name = null, $Value = null, $UserId = null ){
	$this_user = false;
	if(!isset($UserId)){
		if(System::user()->Auth){
			$UserId = SafeEnv(System::user()->Get('u_id'), 11, int);
			$this_user = true;
		}else{
			if(isset($Name)){
				return null;
			}else{
				return array();
			}
		}
	}
	$Data = GetUserInfo($UserId);
	$Data = $Data['data'];
	if(!isset($Value)){ // 
		if(isset($Name)){
			if(isset($Data[$Name])){
				return $Data[$Name];
			}else{
				return null;
			}
		}else{
			return $Data;
		}
	}else{ // 
		$Data[$Name] = $Value;
		$system_users_cache = GetUsers();
		$system_users_cache[$UserId]['data'] = $Data;
		if($this_user){
			System::user()->Session('u_data', $Data);
		}
		System::database()->Update('users', "`data`='".SafeEnv(serialize($Data), 0, str)."'", "`id`='$UserId'");
	}
}

/**
 *        .
 * @param      $Name  .
 * @param null $UserId  .   ,     .
 * @return var|null    ,  null,    .
 */
function UserDataDelete( $Name, $UserId = null ){
	$this_user = false;
	if(!isset($UserId)){
		if(System::user()->Auth){
			$UserId = SafeEnv($this->Get('u_id'), 11, int);
			$this_user = true;
		}else{
			return null;
		}
	}
	$Data = GetUserInfo($UserId);
	$Data = $Data['data'];
	if(isset($Data[$Name])){
		$value = $Data[$Name];
		unset($Data[$Name]);
		$system_users_cache = GetUsers();
		$system_users_cache[$UserId]['data'] = $Data;
		if($this_user){
			System::user()->Session('u_data', $Data);
		}
		System::database()->Update('users', "`data`='".SafeEnv(serialize($Data), 0, str)."'", "`id`='$UserId'");
		return $value;
	}
}

/*header*/

/**
 *     UTF-8
 * @param $String
 * @return string
 */
function Cp1251ToUtf8( $String ){
	return iconv("windows-1251", "utf-8//IGNORE//TRANSLIT", $String);
}

/**
 *    UTF-8   Cp1251
 * @param $Unicode
 * @return string
 */
function Utf8ToCp1251( $Unicode ){
	return iconv("utf-8", "windows-1251", $Unicode);
}

/**
 *        UTF-8
 * @param  $var
 * @return array|string
 * @since 1.3.5
 */
function ObjectCp1251ToUtf8( &$var ){
	if(is_array($var)){
		foreach($var as &$v){
			$v = ObjectCp1251ToUtf8($v);
		}
	}elseif(is_object($var)){
		$vars = get_object_vars($var);
		foreach($vars as $f=>&$v) {
			$var->$f = ObjectCp1251ToUtf8($v);
		}
	}elseif(is_string($var)){
		$var = Cp1251ToUtf8($var);
	}
	return $var;
}

/**
 *       UTF-8   CP1251
 * @param  $var
 * @return array|string
 * @since 1.3.5
 */
function ObjectUtf8ToCp1251( &$var ){
	if(is_array($var)){
		foreach($var as &$v){
			$v = ObjectUtf8ToCp1251($v);
		}
	}elseif(is_object($var)){
		$vars = get_object_vars($var);
		foreach($vars as $f=>&$v) {
			$var->$f = ObjectUtf8ToCp1251($v);
		}
	}elseif(is_string($var)){
		$var = Utf8ToCp1251($var);
	}
	return $var;
}