<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle(' ');

if(!System::user()->isSuperUser()){
	System::admin()->AccessDenied();
}

global $action;
$action = isset($_GET['a']) ? $_GET['a'] : 'main';
AdminFdbAdminGenMenu();

switch($action){
	case 'main':
		include(MOD_DIR.'table_list.inc.php');
		break;
	case 'createtable':
		include(MOD_DIR.'table_create.inc.php');
		break;
	case 'newtable':
	case 'edittable':
		include(MOD_DIR.'table_edit.inc.php');
		break;
	case 'savetable':
	case 'editsavetable':
		include(MOD_DIR.'table_save.inc.php');
		break;
	case 'droptable':
		include(MOD_DIR.'table_drop.inc.php');
		break;
	case 'renametable':
		include(MOD_DIR.'table_rename.inc.php');
		break;
	case 'structure':
		include(MOD_DIR.'table_structure.inc.php');
		break;
	case 'review':
		include(MOD_DIR.'table_review.inc.php');
		break;
	case 'insert':
	case 'editfield':
		include(MOD_DIR.'row_edit.inc.php');
		break;
	case 'insertsave':
	case 'editsave':
		include(MOD_DIR.'row_save.inc.php');
		break;
	case 'deleterow':
		include(MOD_DIR.'row_delete.inc.php');
		break;
	case 'newcoll':
		include(MOD_DIR.'coll_edit.inc.php');
		break;
	case 'addcoll':
		include(MOD_DIR.'coll_save.inc.php');
		break;
	case 'deletecoll':
		include(MOD_DIR.'coll_delete.inc.php');
		break;
	case 'viewcode':
		include(MOD_DIR.'code_row.inc.php');
		break;
	case 'viewcollinfo':
		include(MOD_DIR.'code_coll.inc.php');
		break;
	case 'viewtablecode':
		include(MOD_DIR.'code_table.inc.php');
		break;
	case 'backups':
		include(MOD_DIR.'backups.inc.php');
		break;
	case 'backup_create':
		include(MOD_DIR.'backup_create.inc.php');
		break;
	case 'backup_delete':
		include(MOD_DIR.'backup_delete.inc.php');
		break;
	case 'backup_restore':
		include(MOD_DIR.'backup_restore.inc.php');
		break;
	case 'query':
		include(MOD_DIR.'db_query.inc.php');
		break;
	case 'performsql':
		include(MOD_DIR.'db_performsql.inc.php');
		break;
	case 'optimize':
		include(MOD_DIR.'db_optimize.inc.php');
		break;
	case 'truncatetable':
		include(MOD_DIR.'table_truncate.inc.php');
		break;
	case 'repair_filesdb':
		AdminDbRepairFilesDB();
		break;
	case 'repair_resetid':
		AdminDbRepairResetId();
		break;
}

if($action == 'main'){
	System::admin()->SideBarAddTextBlock('', $top_text);
}

function AdminFdbAdminGenMenu(){
	global $action;
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin', 'main');
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=createtable', 'createtable');
	System::admin()->SideBarAddMenuItem('  ', 'exe=dbadmin&a=backups', 'backups');
	if(System::database()->Name == 'MySQL'){
		System::admin()->SideBarAddMenuItem(' SQL ', 'exe=dbadmin&a=query', 'query');
		System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=optimize', 'optimize');
	}
	System::admin()->SideBarAddMenuBlock('  "'.System::database()->SelectDbName.'"', $action);
}

function AdminFdbAdminGenTableMenu($name){
	global $action;
	//        
	System::admin()->BreadCrumbAdd(' ', 'exe=dbadmin&a=main');
	$num_rows = 0;

	$tables = System::database()->GetTableInfo();
	SortArray($tables, 'name');

	$prefs  = strpos($name, '_');
	if($prefs !== false){
		$pref = substr($name, 0, $prefs);
		//     
		foreach($tables as $table){
			$n = SafeDb($table['name'], 255, str);
			if(substr($n, 0, $prefs) == $pref){
				System::admin()->BreadCrumbMenuItem($n, 'exe=dbadmin&a=structure&name='.$n);
			}
			if($n == $name){
				$num_rows = SafeDB($table['num_rows'], 11, int);
			}
		}
		System::admin()->BreadCrumbMenuDelimiter();
		foreach($tables as $table){
			$n = SafeDb($table['name'], 255, str);
			if(substr($n, 0, $prefs) != $pref){
				System::admin()->BreadCrumbMenuItem($n, 'exe=dbadmin&a=structure&name='.$n);
			}
			if($n == $name){
				$num_rows = SafeDB($table['num_rows'], 11, int);
			}
		}
	}else{
		foreach($tables as $table){
			$n = SafeDb($table['name'], 255, str);
			System::admin()->BreadCrumbMenuItem($n, 'exe=dbadmin&a=structure&name='.$n);
			if($n == $name){
				$num_rows = SafeDB($table['num_rows'], 11, int);
			}
		}
	}

	System::admin()->BreadCrumbAdd($name, 'exe=dbadmin&a=main');

	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=structure&name='.$name, 'structure');
	System::admin()->SideBarAddMenuItem('  ('.$num_rows.')', 'exe=dbadmin&a=review&name='.$name, 'review');
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=insert&name='.$name, 'insert');
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=edittable&name='.$name, 'edittable');
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=truncatetable&name='.$name, 'truncatetable');
	System::admin()->SideBarAddMenuItem(' ', 'exe=dbadmin&a=droptable&name='.$name, 'droptable');
	System::admin()->SideBarAddMenuBlock(' "'.$_GET['name'].'"', $action);
}

function AdminFdbAdminAddTableForm(&$text, $tablename, $SetComment = '', $SetTableType = ''){
	$tabletypes = array(
		array(
			'default',
			' '
		),
		array(
			'myisam',
			'MyISAM'
		),
		array(
			'heap',
			'MyISAM'
		),
		array(
			'merge',
			'Merge'
		),
		array(
			'berkeleydb',
			'Berkeley DB'
		),
		array(
			'isam',
			'ISAM'
		),
	);
	for($i = 0; $i < 4; $i++){
		if($SetTableType == $tabletypes[$i][0]){
			$checked = true;
		} else{
			$checked = false;
		}
		System::admin()->DataAdd($tabletype, $tabletypes[$i][0], $tabletypes[$i][1]);
	}
	$text .= '<font size="2">   '
		.System::admin()->Edit('comment', $SetComment, false, 'style="width: 300px;"').'&nbsp;&nbsp;&nbsp;&nbsp; '
		.System::admin()->Select('tabletype', $tabletype).'</font>'
		.System::admin()->Hidden('tablename', $tablename);
}

/**
 *     ,    .
 */
function AdminDbRepairFilesDB(){
	System::database()->Repair();
}

/**
 *        counter     .
 */
function AdminDbRepairResetId(){
	if(System::database()->Name != 'FilesDB') return;
	$table = $_GET['table'];
	$columns = System::database()->GetTableColumns($table);
	$increment_columns = array();
	foreach($columns as $c){
		if(isset($c['auto_increment']) && $c['auto_increment'] == true){
			$increment_columns[] = $c['name'];
		}
	}
	$data = System::database()->Select($table);
	System::database()->Truncate($table);

	foreach($data as $row){
		foreach($increment_columns as $name){
			$row[$name] = '';
		}
		$row = SafeEnv($row, 0, str, false, true, false);
		System::database()->Insert($table, Values($row));
	}
}