<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

$tables = System::database()->GetTableInfo();

//   
$backup_files = GetFiles(System::config('backup_dir'), false, true, '.zip');
rsort($backup_files, SORT_STRING);
$backup_files2 = array();
foreach($backup_files as $file){
	if(GetSecondFileExt($file, true) == System::database()->Name){
		$backup_files2[] = $file;
	}
}
if(count($backup_files2) > 0){
	$last_backup_name = SafeDB($backup_files2[0], 255, str);
}else{
	$last_backup_name = '';
}


$sort = 'name';
$sort_dec = false;
if(isset($_GET['sort'])) $sort = $_GET['sort'];
if(isset($_GET['dec'])) $sort_dec = true;
SortArray($tables, $sort, $sort_dec);

$top_text = '';
$top_text .= '<strong>:</strong> '.System::database()->SelectDbName.'<br>';
if(System::database()->Name == 'FilesDB'){
	$mode = '  ';
}else{
	$mode = 'MySQL';
}
$top_text .= '<strong></strong>: '.$mode.'<br>';

$text = '';
$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">'
.'<tr>
	<th>#</th>
	<th>'.System::admin()->Link('', ADMIN_FILE.'?exe=dbadmin&sort=name'.($sort == 'name' && !$sort_dec ? '&dec=1' : ''), '').'</th>
	<th>'.System::admin()->Link('', ADMIN_FILE.'?exe=dbadmin&sort=num_rows'.($sort == 'num_rows' && !$sort_dec ? '&dec=1' : ''), '').'</th>
	<th>'.System::admin()->Link('', ADMIN_FILE.'?exe=dbadmin&sort=size'.($sort == 'size' && !$sort_dec ? '&dec=1' : ''), '').'</th>
	<th></th>
	<th></th>
</tr>';
$totalsize = 0;
$totalrows = 0;
$light = array();

$i = 0;
foreach($tables as $r){
	$i++;
	$name = SafeDb($r['name'], 255, str);
	$a = '';
	if($sort == 'name'){
		$F = SafeDb($r['name'], 1, str);
		if(!isset($light[$F])){
			$light[$F] = $F;
			$a = '<span style="float:right; font-size:18px; margin-right:10px;"><b>'.strtoupper($F).'</b></span>';
		}
	}

	$func = SpeedButton('PHP   ', ADMIN_FILE.'?exe=dbadmin&a=viewtablecode&name='.$name, 'images/admin/php.png');
	$func .= SpeedButton('', ADMIN_FILE.'?exe=dbadmin&a=renametable&name='.$name, 'images/admin/rename.png');
	if($last_backup_name != ''){
		$func .= System::admin()->SpeedConfirm('    ', ADMIN_FILE.'?exe=dbadmin&a=backup_restore&name='.$last_backup_name.'&table='.$name, 'images/admin/restore.png', '    .       ?');
	}
	$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=dbadmin&a=droptable&name='.$name.'&ok=0', 'images/admin/delete.png', ' ?');

	$text .= '<tr>'
	.'<td style="text-align:left; padding-left:10px;">'.$i.$a.'</td>'
	.'<td align="left" style="text-align:left; padding-left:10px;"><b>'.System::admin()->Link($name, ADMIN_FILE.'?exe=dbadmin&a=structure&name='.$name).'</b></td>'
	.'<td>'.$r['num_rows'].'</td>'
	.'<td>'.FormatFileSize($r['size']).'</td>'
	.'<td>'.(isset($r['type'])?$r['type']:' ').'</td>'
	.'<td class="cfgtd">'.$func.'</td>'
	.'</tr>';
	$totalsize += $r['size'];
	$totalrows += $r['num_rows'];
	System::admin()->BreadCrumbMenuItem($name, 'exe=dbadmin&a=structure&name='.$name);
}
$text .= '</table><br><br>';
$top_text .= '<strong></strong>: '.System::database()->NumRows().'<br>';
$top_text .= '<strong> </strong>: '.$totalrows.'<br>';
$top_text .= '<strong> </strong>: '.FormatFileSize($totalsize).'<br>';

AddCenterBox('  ('.System::database()->NumRows().')');
AddText($text);
