<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle(' ');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main': IndexDownloadsMain();
	break;
	case 'full': IndexDownloadsFull();
	break;
	case 'download': IndexDownloadsFile();
	break;
	case 'addvote': IndexDownloadsAddVote();
	break;
	// 
	case 'addpost':
		$id = intval(SafeEnv($_GET['file'], 11, int));
		$cat = SafeDB($_GET['cat'], 11, int);
		CommentsAddPost(
			$id,
			'downloads_comments',
			'downloads',
			'comments_counter',
			'allow_comments',
			"index.php?name=downloads&op=full&file=$id&cat=$cat",
			'downloads/{cat}/{file}/'
		);
		break;
	case 'savepost':
		if(CommentsEditPostSave(SafeEnv($_GET['file'], 11, int), 'downloads_comments')){
			break;
		}
	case 'editpost':
		CommentsEditPost('downloads_comments', "index.php?name=downloads&op=savepost&file=".SafeDB($_GET['file'], 11, int).'&back='.SafeDB($_GET['back'], 255, str));
		break;
	case 'deletepost':
		$id = SafeEnv($_GET['file'], 11, int);
		$delete_url = "index.php?name=downloads&op=deletepost&file=$id&back=".SafeDB($_GET['back'], 255, str);
		CommentsDeletePost($id, 'downloads_comments', 'downloads', 'comments_counter', $delete_url);
		break;
	// //
	default:
		HackOff();
}

function IndexDownloadsGetFileType($filename){
	$ext = strtolower(GetFileExt($filename, true));

	$types = array(
		'rar' => ' RAR',
		'zip' => ' ZIP',
		'7z' => ' 7zip',
		'ace' => 'WinACE',
		'odt' => '  OpenDocument',
		'odg' => '  OpenDocument',
		'odp' => '  OpenDocument',
		'ods' => '  OpenDocument',
		'odc' => '  OpenDocument',
		'odi' => '  OpenDocument',
		'odf' => '  OpenDocument',
		'odm' => '   OpenDocument'
	);

	if(isset($types[$ext])){
		return $types[$ext];
	}else{
		if(preg_match('/pdf|pds/i', $ext)) {
			return ' Adobe PDF';
		}
		if(preg_match('/xls|xl|xla|xlb|xlc|xld|xlk|xll|xlm|xlt|xlv|xlw/i', $ext)) {
			return ' MS-Excel';
		}
		if(preg_match('/doc|dot|wiz|wzs|docx/i', $ext)) {
			return ' MS-Word';
		}
		if(preg_match('/pot|ppa|pps|ppt|pwz/i', $ext)) {
			return ' MS-Powerpoint';
		}
		if (preg_match('/flv|f4v|f4p|f4a|f4b/i', $ext)) {
			return 'Flash Video (FLV)';
		}
		if (preg_match('/jpeg|jpe|jpg/i', $ext)) {
			return 'JPEG/JPE/JPG';
		}
		if (preg_match('/ogv|oga|ogx|ogg/i', $ext)) {
			return 'Ogg Vorbis';
		}

		return strtoupper($ext);
	}
}

function IndexDownloadsGetTree(){
	static $tree = null;
	if(is_null($tree)){
		$tree = new IndexTree('downloads_cats');
		$tree->moduleName = 'downloads';
		$tree->id_par_name = 'cat';
		$tree->NumItems = 'IndexDownloadsGetNumItems';
	}
	return $tree;
}

function IndexDownloadsGetNumItems(){
	System::database()->Select('downloads', GetWhereByAccess('view', "`active`='1'"));
	$num = System::database()->NumRows();
	System::database()->FreeResult();
	return '<p align="center">    : '.$num.'.</p>';
}

function IndexDownloadsFunc($id){
	$back = SaveRefererUrl();
	return'&nbsp'
	.'<a href="'.ADMIN_FILE.'?exe=downloads&a=editor&id='.$id.'&back='.$back.'" class="admin_edit_link"><img src="images/admin/edit.png" title=""></a>'
	.'<a href="'.ADMIN_FILE.'?exe=downloads&a=deletefile&id='.$id.'&ok=0&back='.$back.'" class="admin_edit_link"><img src="images/admin/delete.png" title=""></a>';
}

function AddDownload(&$down){
	$id = SafeDB($down['id'], 11, int);
	$cat_id = SafeDB($down['category'], 11, int);
	$func = IndexDownloadsFunc($id);

	$vars = array();
	$vars['file_title'] = SafeDB($down['title'], 255, str).(System::user()->isAdmin() ? $func : '');
	$vars['url'] = Ufu("index.php?name=downloads&op=full&file=$id&cat=$cat_id", 'downloads/{cat}/{file}/');

	if($down['image'] != ''){
		$vars['image'] = RealPath2(System::config('downloads/images_dir').SafeDB($down['image'], 255, str));
		$vars['thumb_image'] = RealPath2(System::config('downloads/images_dir').'thumbs/'.SafeDB($down['image'], 255, str));
	}else{
		$vars['image'] = false;
	}
	$vars['description'] = SafeDB($down['shortdesc'], 0, str, false, false);

	if($down['allow_comments'] == '1'){
		$vars['comments'] = SafeDB($down['comments_counter'], 11, int);
	}else{
		$vars['comments'] = ' - ';
	}

	$vars['author'] = SafeDB($down['author'], 200, str);
	$vars['homepage'] = SafeDB($down['author_site'], 250, str);
	$vars['homepage_url'] = UrlRender(SafeDB($down['author_site'], 250, str));
	$vars['mail'] = SafeDB($down['author_email'], 50, str);

	$vars['date'] = TimeRender($down['public']);
	$vars['hits'] = SafeDB($down['hits'], 11, int);
	$vars['version'] = SafeDB($down['file_version'], 250, str);

	$vars['size'] = FormatFileSize(SafeDB($down['size'], 11, real), SafeDB($down['size_type'], 1, str));
	$vars['filetype'] = IndexDownloadsGetFileType(SafeDB($down['url'], 250, str));
	$vars['allow_votes'] = SafeDB($down['allow_votes'], 1, bool);
	$vars['num_votes'] = SafeDB($down['votes_amount'], 11, int);

	$vars['rating'] = GetRatingImage(SafeDB($down['votes_amount'], 11, int), SafeDB($down['votes'], 11, int));
	System::site()->AddSubBlock('download', true, $vars);
}

function AddDetailDownload(&$down){
	$id = SafeDB($down['id'], 11, int);
	$cat_id = SafeDB($down['category'], 11, int);
	$func = IndexDownloadsFunc($id);

	$vars = array();
	$vars['category_url'] = Ufu("index.php?name=downloads&cat=$cat_id", 'downloads/{cat}/');
	$vars['category_title'] = IndexDownloadsGetTree()->IdCats[$down['category']]['title'];
	$vars['category'] = '<a href="'.$vars['category_url'].'">'.$vars['category_title'].'</a>';

	$vars['file_link'] = "index.php?name=downloads&op=download&file=$id"; //    ,       
	if(AccessIsResolved($down['view'])){
		$vars['access'] = true;
		$url = '<a href="'.$vars['file_link'].'" target="_blank"> </a>';
	}else{
		$vars['access'] = false;
		$url = '    .';
	}
	$vars['not_access'] = !$vars['access'];
	$vars['url'] = $url;

	$vars['file_title'] = SafeDB($down['title'], 255, str).(System::user()->isAdmin() ? $func : '');
	$vars['description'] = SafeDB($down['description'], 0, str, false, false);

	$vars['author'] = SafeDB($down['author'], 200, str);
	$vars['homepage'] = SafeDB($down['author_site'], 250, str);
	$vars['homepage_url'] = UrlRender(SafeDB($down['author_site'], 250, str));
	$vars['mail'] = SafeDB($down['author_email'], 50, str);

	$vars['date'] = TimeRender($down['public']);
	$vars['hits'] = SafeDB($down['hits'], 11, int);
	$vars['version'] = SafeDB($down['file_version'], 250, str);

	$vars['size'] = FormatFileSize(SafeDB($down['size'], 11, real), SafeDB($down['size_type'], 1, str));
	$vars['filetype'] = IndexDownloadsGetFileType(SafeDB($down['url'], 250, str));

	$vars['addvote_url'] = "index.php?name=downloads&op=addvote&file=$id";
	System::site()->DataAdd($vdata, '0', ' ');
	System::site()->DataAdd($vdata, '1', ' ');
	System::site()->DataAdd($vdata, '2', '');
	System::site()->DataAdd($vdata, '3', '');
	System::site()->DataAdd($vdata, '4', '');
	System::site()->DataAdd($vdata, '5', '');

	$vars['votes'] = System::site()->Select('vote', $vdata);
	$vars['addvotesubm'] = System::site()->Submit(' ');
	$vars['allow_votes'] = SafeDB($down['allow_votes'], 1, bool);


	if($down['image'] != ''){
		$vars['image'] = RealPath2(System::config('downloads/images_dir').SafeDB($down['image'], 255, str));
		$vars['thumb_image'] = RealPath2(System::config('downloads/images_dir').'thumbs/'.SafeDB($down['image'], 255, str));
	}else{
		$vars['image'] = false;
	}

	// rating
	$vars['rating_num_votes'] = SafeDB($down['votes_amount'], 11, int);
	$vars['rating_image'] = GetRatingImage(SafeDB($down['votes_amount'], 11, int), SafeDB($down['votes'], 11, int));
	$rating = $vars['rating_image'];
	if($rating == '' && SafeDB($down['allow_votes'], 1, bool)){ // allow_rating
		$rating = ' ';
	}elseif(SafeDB($down['allow_votes'], 1, bool)){
		$rating = '<img src="'.$rating.'" /> (: '.SafeDB($down['votes_amount'], 11, int).')';
	}else{
		$rating = ' - ';
	}
	$vars['rating'] = $rating;
	//

	if(!SafeDB($down['allow_comments'], 1, bool)){ // allow coments
		$vars['comments'] = ' - ';
	}else{
		$vars['comments'] = SafeDB($down['comments_counter'], 11, int);
	}

	System::site()->AddBlock('download',true,false,'dl');
	System::site()->Blocks['download']['vars'] = $vars;
}

function IndexDownloadsMain(){
	if(isset($_GET['cat'])){
		$cat = SafeEnv($_GET['cat'],11,int);
	}else{
		$cat = 0;
	}

	if($cat != 0){
		System::site()->SetTitle('   '.SafeDB(IndexDownloadsGetTree()->IdCats[$cat]['title'], 255, str));
	}

	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 10, int);
	}else{
		$page = 1;
	}

	if(System::config('downloads/show_last')=='1'){
        IndexDownloadsGetTree()->ShowCats($cat);
        IndexDownloadsGetTree()->BreadCrumbs($cat);
	}
	if($cat != 0 || System::config('downloads/show_last') == '1'){
		$downs = System::database()->Select('downloads', GetWhereByAccess('view', ($cat != 0 ? "`category`='$cat' and " : '')."`active`='1'"));
		SortArray($downs, 'public', true);

		//  
		$num = System::config('downloads/filesonpage');
		$navigation = new Navigation($page);
		$nav_link = Ufu('index.php?name=downloads'.($cat != 0 ? '&cat='.$cat : ''), 'downloads/'.($cat != 0 ? '{cat}/' : '').'page{page}/', true);
		$navigation->FrendlyUrl = System::config('general/ufu');
		$navigation->GenNavigationMenu($downs, $num, $nav_link);

		if(System::database()->NumRows() > 0){
			System::site()->AddTemplatedBox('','module/download.html');
			System::site()->AddBlock('download', true, true, 'dl');
			foreach($downs as $down){
				AddDownload($down);
			}
		}elseif(!isset(IndexDownloadsGetTree()->Cats[$cat]) && count(IndexDownloadsGetTree()->Cats) > 0){
			System::site()->AddTextBox('','<p align="center">     .</p>');
		}
	}
}

function IndexDownloadsFull(){
	if(isset($_GET['file'])){
		$id = SafeEnv($_GET['file'],11,int);
	}else{
		GO(GetSiteUrl().Ufu('index.php?name=downloads', '{name}/'));
	}
	System::database()->Select('downloads', GetWhereByAccess('view', "`id`='$id' and `active`='1'"));
	if(System::database()->NumRows() == 0){
		GO(GetSiteUrl().Ufu('index.php?name=downloads', '{name}/'));
	}
	$file = System::database()->FetchRow();
	$cat = SafeDB($file['category'], 11, int);
	IndexDownloadsGetTree()->BreadCrumbs($cat);
	System::site()->BreadCrumbAdd(SafeDB($file['title'], 255, str));
	System::site()->SetTitle(' '.SafeDB($file['title'], 255, str));

	System::site()->AddTemplatedBox('','module/download_full.html');
	AddDetailDownload($file);

	//  
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 0;
	}
	include_once(System::config('inc_dir').'posts.class.php');
	$posts = new Posts('downloads_comments', $file['allow_comments'] == '1');
	$posts->EditPageUrl = "index.php?name=downloads&op=editpost&file=$id"; //   
	$posts->DeletePageUrl = "index.php?name=downloads&op=deletepost&file=$id"; //  
	$posts->PostFormAction = "index.php?name=downloads&op=addpost&file=$id&cat=$cat&page=$page"; //   ()

	$posts->NavigationUrl = Ufu("index.php?name=downloads&op=full&file=$id&cat=$cat", 'downloads/{cat}/{file}/page{page}/', true);
	$posts->NavigationAnchor = '#comments';
	$posts->RenderPosts($id, 'download_comments', 'comments_navigation', false, $page);
	$posts->RenderForm(false, 'download_comments_form');
}

function IndexDownloadsFile(){
	$file = SafeEnv($_GET['file'],11,int);
	System::database()->Select('downloads', GetWhereByAccess('view', "`id`='$file' and `active`='1'"));
	if(System::database()->NumRows() > 0){
		$sfile = System::database()->FetchRow();
		$counter = SafeDB($sfile['hits'],11,int)+1;
		System::database()->Update('downloads',"hits='$counter'","`id`='$file'");
		System::user()->ChargePoints(System::config('points/download_download'));
		GO(SafeDB($sfile['url'],250,str));
	}else{
		System::site()->AddTextBox('','<p align="center">,    ,  , ,     .</p>');
	}
}

function IndexDownloadsAddVote(){
	$ip = getip();
	$time = time() - 86400; //1 
	$file = SafeEnv($_GET['file'], 11, int);
	$vote = SafeEnv($_POST['vote'], 1, int);
	System::database()->Delete('downloads_rating', "`time`<'$time'");
	System::site()->OtherMeta .= '<meta http-equiv="REFRESH" content="3; URL='.HistoryGetUrl(1).'">';
	System::database()->Select('downloads', GetWhereByAccess('view', "`id`='$file' and `active`='1'"));
	if(System::database()->NumRows() > 0){
		$dfile = System::database()->FetchRow();
		if($dfile['allow_votes']=='1'){ //  
			System::database()->Select('downloads_rating',"`ip`='$ip' and `downid`='$file'");
			if(System::database()->NumRows()>0){
				System::site()->AddTextBox('','<p align="center">     .<br><br><a href="javascript:history.go(-1)"></a></p>');
			}else{
				if($vote==0){
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}else{
					System::user()->ChargePoints(System::config('points/download_rating'));
					$time = time();
					System::database()->Insert('downloads_rating',"'','$file','$ip','$time'");
					$vote = SafeDB($dfile['votes'],11,int)+$vote;
					$numvotes = SafeDB($dfile['votes_amount'],11,int)+1;
					System::database()->Update('downloads',"votes_amount='$numvotes',votes='$vote'","`id`='$file'");
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}
			}
		}else{ //  
			System::site()->AddTextBox('','<p align="center">,    .<br><br><a href="javascript:history.go(-1)"></a></p>');
		}
	}else{ //   
		System::site()->AddTextBox('','<p align="center"> . ,    ,      .    .<br><br><a href="javascript:history.go(-1)"></a></p>');
	}
}
