<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle(' ');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main':
		IndexFeedBackForm();
		break;
	case 'send':
		IndexFeedBackSend();
		break;
	default:
		HackOff();
}

function IndexFeedBackForm( $errors = false ){
	System::site()->AddTemplatedBox(' ', 'module/feedback.html');

	if(System::config('feedback/max_filesize') > intval(ini_get('upload_max_filesize'))){
		$max_file_size = intval(ini_get('upload_max_filesize')).'';
	}else{
		$max_file_size = System::config('feedback/max_filesize').'';
	}

	System::site()->AddBlock('feedback', true, false, 'fb');
	$vars['url'] = Ufu('index.php?name=feedback&op=send', 'feedback/{op}/');
	if(!$errors){
		$vars['top_text'] = System::config('feedback/top_text');
		$vars['bottom_text'] = System::config('feedback/bottom_text');
	}else{
		$vars['top_text'] = '';
		$vars['bottom_text'] = '';
	}
	$vars['max_attachment_size'] = $max_file_size;

	// 
	$vars['show_kaptcha'] = true;
	$vars['kaptcha_url'] = 'index.php?name=plugins&p=antibot';
	$vars['kaptcha_width'] = '120';
	$vars['kaptcha_height'] = '40';

	//  
	$department = '';
	if(isset($_POST['feedback_form'])){
		$vars['name'] = SafeDB($_POST['name'], 255, str);
		$vars['email'] = SafeDB($_POST['email'], 255, str);
		$vars['subject'] = SafeDB($_POST['subject'], 255, str);
		$vars['message'] = SafeDB($_POST['message'], 255, str);
		$department = SafeDB($_POST['department'], 11, int);
	}else{
		$vars['name'] = '';
		$vars['email'] = '';
		$vars['subject'] = '';
		$vars['message'] = '';
	}

	System::site()->SetVars('feedback', $vars);

	System::site()->AddBlock('departments', true, true, 'department');
	$vars = array('id'=>0,'hname'=>'','selected'=>'');
	System::site()->AddSubBlock('departments', true, $vars);
	System::database()->Select('feedback', "`active`='1'");
	while($dp = System::database()->FetchRow()){
		$vars = array();
		$vars['id'] = SafeDB($dp['id'], 11, int);
		$vars['hname'] = SafeDB($dp['name'], 255, str);
		$vars['selected'] = ($dp['id'] == $department ? ' selected' : '');
		System::site()->AddSubBlock('departments', true, $vars);
	}
}

function IndexFeedBackSend(){
	$err = array();
	if(!isset($_POST['name'])
		|| !isset($_POST['email'])
		|| !isset($_POST['subject'])
		|| !isset($_POST['department'])
		|| !isset($_POST['message'])
		|| !isset($_POST['feedback_form'])
	){
		GO(Ufu('index.php'));
	}else{
		if($_POST['name'] != ''){
			$name = SafeDB($_POST['name'], 250, str);
		}else{
			$err[] = ',   !';
		}
		if($_POST['email'] != ''){
			$email = SafeDB($_POST['email'], 50, str);
		}else{
			$err[] = ',     E-mail!';
		}
		if($_POST['subject'] != ''){
			$subject = SafeDB($_POST['subject'], 250, str, false, false, false);
		}else{
			$err[] = ',   !';
		}

		//  
		if(!System::user()->isDef('captcha_keystring') || System::user()->Get('captcha_keystring') != $_POST['keystr']){
			$err[] = '      .';
		}

		if($_POST['department'] != ''){
			$department = SafeEnv($_POST['department'], 11, int);
            System::database()->Select('feedback', "`active`='1' and `id`='$department'");
			if(System::database()->NumRows() > 0){
				$dep = System::database()->FetchRow();
				$dep_email = SafeDB($dep['email'], 255, str);
				$department = SafeDB($dep['name'], 255, str);
			}else{
				$err[] = '          .';
			}
		}else{
			$err[] = ',  !';
		}
		if($_POST['message'] != ''){
			$message = SafeDB($_POST['message'], 65535, str, false, false, false);
		}else{
			$err[] = ',  !';
		}
	}

	$size = $_FILES['attach']['size']; // / 1024;
	if($_FILES['attach']['error'] == UPLOAD_ERR_OK && $size >= System::config('feedback/max_filesize')){
		$err[] = '   .';
	}

	if(count($err) == 0){
		$mail = LmEmailExtended::Instance();
		$mail->SetTo($dep_email, Cp1251ToUtf8($department));
		$mail->SetFrom($email, Cp1251ToUtf8($name));
		$mail->SetSubject(Cp1251ToUtf8($subject));
		$text = Indent("
			!

			       \"".System::config('general/site_name')."\"
			   .

			: $department
			: $name
			E-mail: $email
			 : $subject
			 : ".TimeRender(time(), true, false)."
			: $message
		");
		$mail->AddTextPart(Cp1251ToUtf8($text));
		if($_FILES['attach']['error'] == UPLOAD_ERR_OK){
			$mail->AddAttachmentPart(file_get_contents($_FILES['attach']['tmp_name']), $_FILES['attach']['name']);
		}
		if($mail->Send()){
			System::site()->AddTextBox(' ', '<div style="text-align: center;">   !</div>');
		}else{
			System::site()->AddTextBox(' ', '<div style="text-align: center;">     ,      .</div>');
		}
	}else{
		$text = '  :<br /><ul>';
		foreach($err as $error){
			$text .= '<li>'.$error.'</li>';
		}
		$text .= '</ul>';
		System::site()->AddTextBox('', $text);
		IndexFeedBackForm();
	}

}
