<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//     (, , , , , ,  ).

function IndexForumEditTopics(){
	global $forum_lang;

	if(!System::user()->isAdmin()){
		System::site()->AddTextBox($forum_lang['forum'], '<p align="center">'.$forum_lang['error_no_right_edit'].'.</p>');
		return;
	}
	if(!isset($_POST['topics'])){
		System::site()->AddTextBox($forum_lang['forum'], '<p align="center">'.$forum_lang['error_no_topics'].'</p><br><a href="javascript:history.go(-1)">'.System::site()->Button('').'</a>');
		return;
	}

	if(isset($_GET['ok']) && $_GET['ok'] == '1'){
		$topics_ids = SafeEnv(explode(',', $_POST['topics']), 11, int);

		$back_url = $_POST['backurl'];
		if(isset($_GET['back'])){
			$back_url = GetRefererUrl($_GET['back']);
		}

		$moderation_result = ForumModerationTopics($_GET['edit'], $topics_ids, true);

		if($moderation_result !== false){
			$text = $moderation_result.'<br><br><b><a href="'.$back_url.'">'.$forum_lang['return_read'].'</a></b>';
			System::site()->AddTextBox($forum_lang['executed'], $text);
		}
	}
	else{
		$topics_ids = array();
		foreach( array_keys($_POST['topics']) as $topic_id ){
			$topics_ids[] = SafeEnv($topic_id, 11, int);
		}

		$form_url = 'index.php?name=forum&op=edit_topics&edit='.SafeDB($_POST['do'], 255, str).'&ok=1';
		if(isset($_GET['back'])){
			$form_url .= '&back='.SafeDB($_GET['back'], 10, str);
		}

		$moderation_content = ForumModerationTopics($_POST['do'], $topics_ids, false);

		if($moderation_content !== false){
			$text = System::site()->FormOpen($form_url)
				.System::site()->Hidden('topics', implode(',', $topics_ids))
				.System::site()->Hidden('backurl', $_SERVER['HTTP_REFERER'])
				.$moderation_content
				.System::site()->Button($forum_lang['back'], 'onclick="history.go(-1);"')
				.System::site()->Submit($forum_lang['execute'])
			;
			System::site()->AddTextBox(' ', $text);
		}
	}
}

function ForumModerationTopics( $do, $topics, $begin ){
	global $forum_lang;
	switch($do){
		case 'deletetopic': return ForumModerationDeleteTopics($topics, $begin);

		case 'open': return ForumModerationSet($topics, $begin, $forum_lang['open_topics'], "`close_topics`='0'");
		case 'close': return ForumModerationSet($topics, $begin, $forum_lang['close_topics'], "`close_topics`='1'");
		case 'stick': return ForumModerationSet($topics, $begin, $forum_lang['important_topics'], "`stick`='1'");
		case 'unstick': return ForumModerationSet($topics, $begin, $forum_lang['remove_important_topics'], "`stick`='0'");

		case 'movetopic': return ForumModerationMoveTopics($topics, $begin);
		case 'mergetopic': return ForumModerationMergeTopics($topics, $begin);
	}
}

function ForumModerationDeleteTopics( $topics, $begin ){
	global $forum_lang;
	if($begin){
		$forum = null;
		$forum_id = null;
		$deleted_topics = 0;
		$deleted_posts = 0;

		// TODO:       .
		$reason = '';
		if(isset($_POST['text'])){
			$reason = SafeEnv($_POST['text'], 255, str);
		}

		$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');

		foreach( $topics as $topic ){
			$topic_id = SafeEnv($topic['id'], 11, int);
			if($topic['delete'] == '1'){ //   
				continue;
			}

			// 
			if(!isset($forum)){
				$forum_id = SafeEnv($topic['forum_id'], 11, int);
				System::database()->Select('forums', "`id`='$forum_id'");
				if(System::database()->NumRows() == 0){
					System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum'].' "'.SafeDB($topic['title'], 255, str).'"');
					return false;
				}
				$forum = System::database()->FetchRow();
			}

			$deleted_topics++;
			$deleted_posts += (int)$topic['posts'];

			// 
			if(System::config('forum/basket')){ //    
				Moderation_Do_Basket_Topic($topic_id, $reason);
			}else{
				ForumAdminDeleteTopic($topic_id);
			}
		}

		if($deleted_topics > 0){
			//  
			$forum_topics = (int)$forum['topics'] - $deleted_topics;
			if($forum_topics < 0){
				$forum_topics = 0;
			}
			$forum_posts = (int)$forum['posts'] - $deleted_posts;
			if($forum_posts < 0){
				$forum_posts = 0;
			}
			ForumSetLastTopic($forum_id, "`topics`='$forum_topics',`posts`='$forum_posts'");

			ForumCacheClear();
		}
		return $forum_lang['delete_topics_success'];
	}else{
		$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
		$text = $forum_lang['confirm'].':&nbsp;'.$forum_lang['delete_topics'];
		$text .= '<ul style="margin: 10px 0;">';
		foreach( $topics as $topic_id ){
			$text .= '<li>'.SafeDB($topic_id['title'], 255, str).'</li>';
		}
		$text .= '</ul>';
		return $text;
	}
}

function ForumModerationSet( $topics, $begin, $action, $set ){
	global $forum_lang;
	if($begin){
		System::database()->Update('forum_topics', $set, '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
		ForumCacheClear();
		if(isset($_GET['back'])){
			GoRefererUrl($_GET['back']);
		}else{
			GO($_POST['backurl']);
		}
	}else{
		$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
		$text = $forum_lang['confirm'].':&nbsp;'.$action;
		$text .= '<ul style="margin: 10px 0;">';
		foreach( $topics as $topic ){
			$text .= '<li>'.SafeDB($topic['title'], 255, str).'</li>';
		}
		$text .= '</ul>';
		return $text;
	}
}

function ForumModerationMoveTopics( $topics, $begin ){
	global $forum_lang;
	if(!$begin){
		$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
		$forum_id = $topics[0]['forum_id'];
		$text = $forum_lang['confirm'].':&nbsp;'.$forum_lang['move_topics'];
		$text .= '<ul style="margin: 10px 0;">';
		foreach( $topics as $topic ){
			$text .= '<li>'.SafeDB($topic['title'], 255, str).'</li>';
		}
		$text .= '</ul>';
		$data = ForumTree::Instance()->GetCatsDataF($forum_id, false, false, 0, true);
		$text .= $forum_lang['select_category'].': <br>'
			.System::site()->Select('forum', $data).
			'<br><br>';
		return $text;
	}

	//   (   )
	$dst_forum_id = SafeEnv($_POST['forum'], 11, int); //  
	System::database()->Select('forums', "`id`='$dst_forum_id'");
	if(System::database()->NumRows() == 0){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']);
		return false;
	}
	$dst_forum = System::database()->FetchRow();

	if(count($topics) == 0){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_topic']);
		return false;
	}
	$move_topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
	$src_forum_id = SafeEnv($move_topics[0]['forum_id'], 11, int);
	System::database()->Select('forums', "`id`='$src_forum_id'");
	$src_forum = System::database()->FetchRow();

	//    
	System::database()->Update('forum_topics', "`forum_id`='$dst_forum_id'", '`id`=\''.implode('\' or `id`=\'', $topics).'\'');

	//   
	ForumCacheClear();

	//      
	$moved_topics = count($move_topics);
	$moved_posts = 0;
	foreach($move_topics as $topic){
		$moved_posts += $topic['posts'];
	}

	//        ( )
	$forum_topics = (int)$src_forum['topics'] - $moved_topics;
	$forum_posts = (int)$src_forum['posts'] - $moved_posts;
	if($forum_topics < 0){
		$forum_topics = 0;
	}
	if($forum_posts < 0){
		$forum_posts = 0;
	}
	ForumSetLastTopic($src_forum_id, "`topics`='$forum_topics',`posts`='$forum_posts'");

	//        ( )
	$forum_topics = (int)$dst_forum['topics'] + $moved_topics;
	$forum_posts = (int)$dst_forum['posts'] + $moved_posts;
	if($forum_topics < 0){
		$forum_topics = 0;
	}
	if($forum_posts < 0){
		$forum_posts = 0;
	}
	ForumSetLastTopic($dst_forum_id, "`topics`='$forum_topics',`posts`='$forum_posts'");

	//   
	ForumCacheClear();
}

function ForumModerationMergeTopics( $topics, $begin ){
	global $forum_lang;
	if(count($topics) < 2){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['merge_topics_error']);
		return false;
	}
	if(!$begin){
		$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');
		$text = $forum_lang['confirm'].':&nbsp;'. $forum_lang['merge_topics'];
		$select_data = array();
		$text .= '<ul style="margin: 10px 0;">';
		foreach($topics as $topic){
			$text .= '<li>'.SafeDB($topic['title'], 255, str).'</li>';
			System::site()->DataAdd($select_data, SafeDB($topic['id'], 11, int), SafeDB($topic['title'], 255, str), false);
		}
		$text .= '</ul>';
		$text .= $forum_lang['merge_dest_topic'].':<br>'
			.System::site()->Select('dest_topic', $select_data)
			.'<br><br>';
		return $text;
	}

	$destination_topic_id = SafeEnv($_POST['dest_topic'], 11, int);
	$topics = System::database()->Select('forum_topics', '`id`=\''.implode('\' or `id`=\'', $topics).'\'');

	// 
	$deleted_topics = 0;
	$moved_posts = 0;
	$dst_topic = null;

	foreach($topics as $topic){
		$topic_id = SafeEnv($topic['id'], 11, int);
		if($topic_id != $destination_topic_id){
			$moved_posts += $topic['posts'] + 1;

			System::database()->Update('forum_posts', "`object`='$destination_topic_id'", "`object`='$topic_id'");
			System::database()->Delete('forum_topics', "`id`='$topic_id'");
			System::database()->Delete('forum_topics_read', "`tid`='$topic_id'");

			$deleted_topics++;
		}else{
			$forum_id = SafeEnv($topic['forum_id'], 11, int);
			$dst_topic = $topic;
		}
	}
	$topic_posts = (int)$dst_topic['posts']+$moved_posts;
	System::database()->Update('forum_topics', "`posts`='$topic_posts'", "`id`='$destination_topic_id'");

	//  
	System::database()->Select('forums', "`id`='$forum_id'");
	$forum = System::database()->FetchRow();
	$forum_topics = (int)$forum['topics'] - $deleted_topics;
	$forum_posts = (int)$forum['posts'] + $deleted_topics; //          
	if($forum_topics < 0){
		$forum_topics = 0;
	}
	if($forum_posts < 0){
		$forum_posts = 0;
	}
	ForumSetLastTopic($forum_id, "`topics`='$forum_topics',`posts`='$forum_posts'");

	ForumCacheClear();
}