<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *    .
 */
class ForumTree extends Tree{

	static protected $_instance;
	public $AccessForums = null;

	private $DisableCats;

	/**
	 *        .
	 * @param type $CatId   .
	 */
	public function BreadCrumbsF($CatId){
		if($CatId == 0){
			return;
		}
		$parents = $this->GetAllParent($CatId);
		foreach($parents as $parent){
			$link = Ufu('index.php?name='.$this->moduleName.'&op=showforum&forum='.SafeDB($parent['id'], 11, int), $this->moduleName.'/{forum}/');
			System::site()->BreadCrumbAdd(SafeDB($parent['title'], 255, str), $link);
		}
	}

	public function ForumCatsData($tree, $level){
		global $FCatsData;
		if(in_array($tree[$this->IdKey], $this->childs) === false){
			$levs  = str_repeat('&nbsp;-&nbsp;', $level);
			$items = '';
			if($this->viewitems){
				$items = (isset($tree[$this->FileCounterKey]) && $tree[$this->FileCounterKey] > 0 ? ' ('.$tree[$this->FileCounterKey].')' : '');
			}
			System::site()->DataAdd(
				$FCatsData,
				$tree[$this->IdKey],
				$levs.$tree[$this->TitleKey].$items,
				in_array($tree[$this->IdKey], $this->sel_id),
				($this->DisableCats && $tree[$this->ParentKey] == 0 ? 'disabled="disabled"' : '')
			);
		}
	}

	/**
	 *      Select   .
	 *
	 * @param int|array       $sel_id     .
	 * @param bool            $viewitems     .
	 * @param bool            $root        .
	 * @param int             $id_exclude_childs
	 * @param bool            $DisableCategories
	 * @global array          $FCatsData
	 * @internal param \type $id         (  ).
	 * @return array
	 */
	public function GetCatsDataF($sel_id, $viewitems = true, $root = false, $id_exclude_childs = 0, $DisableCategories = false){
		global $FCatsData;
		$FCatsData    = array();
		$this->childs = array();
		if(!is_array($sel_id)){
			$sel_id = array($sel_id);
		}
		$this->sel_id      = $sel_id;
		$this->viewitems   = $viewitems;
		$this->DisableCats = $DisableCategories;
		if($id_exclude_childs != 0){
			$this->childs = $this->GetAllAccessForumId($id_exclude_childs);
		}
		if($root){
			System::site()->DataAdd($FCatsData, '0', $this->TopCatName, in_array(0, $sel_id));
		}
		$this->ListingTree(0, array(
		                           $this,
		                           'ForumCatsData'
		                      ));
		return $FCatsData;
	}

	//    GetAllAccessForumId.
	protected function CheckForumAccess($forum){
		//  ,   AccessForums     
		$access     = true;
		$user_level = System::user()->AccessLevel();
		if($user_level == ACCESS_MEMBER){ // 
			$user_rank = GetUserRankInfo(); //   
		}
		if(!AccessIsResolved($forum['view'])){
			$access = false;
		} elseif($forum['status'] == '0'){
			$access = false;
		} elseif($user_level != ACCESS_ADMIN && $forum['rang_access'] != '0'){
			if($user_level > ACCESS_MEMBER){ // 
				$access = false;
			} elseif($user_level == ACCESS_MEMBER && GetRankInfo($forum['rang_access'], 'min') > $user_rank['min']){ // 
				$access = false;
			}
		}
		if($access){
			$this->AccessForums[] = $forum['id'];
			if(isset($forum[TREE_CHILD_ID])){
				foreach($forum[TREE_CHILD_ID] as $tree_item){
					$this->CheckForumAccess($tree_item);
				}
			}
		}
	}

	/**
	 *         .
	 */
	public function GetAllAccessForumId($ParentCat = 0){
		if(!isset($this->AccessForums)){
			$this->AccessForums = array();
		}
		$tree = $this->GetChildTree($ParentCat);
		foreach($tree as $tree_item){
			$this->CheckForumAccess($tree_item);
		}
		return $this->AccessForums;
	}

	/**
	 *            ,  -   
	 *          .
	 * @param type $CatId
	 * @param null $UserLevel
	 * @param null $RankMin
	 * @return array [no_link_guest, new_message_email, access, add_topic, add_post, close, access_reason, add_topic_reason, add_post_reason, ...]
	 */
	public function GetForumConfigRecursive($CatId, $UserLevel = null, $RankMin = null){
		$config = array(
			'no_link_guest'     => '0',
			//    
			'new_message_email' => '1',
			//      
			'admin_theme_add'   => '0',
			//      

			'rang_access'       => '0',
			//   
			'rang_message'      => '0',
			//      
			'rang_add_theme'    => '0',
			//      

			'close_topic'       => '0',
			//   

			'view'              => '4',
			//      
			'status'            => '1'
			//  (., .)
		);
		$result = array(
			'no_link_guest'     => false,
			'new_message_email' => true,

			'access'            => true,
			//          
			'add_topic'         => true,
			//        
			'add_post'          => true,
			//      
			'close'             => false,
			//     ,       

			'access_reason'     => '',
			//   
			'add_topic_reason'  => '',
			//    
			'add_post_reason'   => '',
			//    

			'topics'            => 0,
			'posts'             => 0,
			'last_post'         => 0,
			'last_poster_id'    => 0,
			'last_poster_name'  => '',
			'last_title'        => '',
			'last_id'           => 0
		);

		//   
		$parents = $this->GetAllParent($CatId); //      
		foreach($parents as &$parent){
			if($parent['no_link_guest'] == '1'){
				$config['no_link_guest'] = '1';
			}
			if($parent['new_message_email'] == '0'){
				$config['new_message_email'] = '0';
			}
			if($parent['admin_theme_add'] == '1'){
				$config['admin_theme_add'] = '1';
			}
			if($parent['rang_access'] != '0' && $config['rang_access'] == '0'){
				$config['rang_access'] = $parent['rang_access'];
			} elseif($parent['rang_access'] != '0' && $config['rang_access'] != '0' && GetRankInfo($parent['rang_access'], 'min') > GetRankInfo($config['rang_access'], 'min')){
				$config['rang_access'] = $parent['rang_access'];
			}
			if($parent['rang_message'] != '0' && $config['rang_message'] == '0'){
				$config['rang_message'] = $parent['rang_message'];
			} elseif($parent['rang_message'] != '0' && $config['rang_message'] != '0' && GetRankInfo($parent['rang_message'], 'min') > GetRankInfo($config['rang_message'], 'min')){
				$config['rang_message'] = $parent['rang_message'];
			}
			if($parent['rang_add_theme'] != '0' && $config['rang_add_theme'] == '0'){
				$config['rang_add_theme'] = $parent['rang_add_theme'];
			} elseif($parent['rang_add_theme'] != '0' && $config['rang_add_theme'] != '0' && GetRankInfo($parent['rang_add_theme'], 'min') > GetRankInfo($config['rang_add_theme'], 'min')){
				$config['rang_add_theme'] = $parent['rang_add_theme'];
			}
			if($parent['close_topic'] == '1'){
				$config['close_topic'] = '1';
			}
			if($parent['view'] < $config['view']){
				$config['view'] = $parent['view'];
			}
			if($parent['status'] == '0'){
				$config['status'] = '0';
			}
		}

		$user_rank = array();
		if(isset($UserLevel)){
			$user_level = $UserLevel;
			if(isset($RankMin)){
				$user_rank['min'] = $RankMin;
			} else{
				$user_rank['min'] = 0;
			}
		} else{
			$user_level = System::user()->AccessLevel();
			if($user_level == ACCESS_MEMBER){ // 
				$user_rank = GetUserRankInfo(); //   
			}
		}

		$result['no_link_guest']     = $user_level == ACCESS_GUEST && $config['no_link_guest'] == '1'; //   
		$result['new_message_email'] = $user_level < ACCESS_MEMBER && $config['new_message_email'] == '1'; //   

		// 
		if(!AccessIsResolved($config['view'])){ //    view
			$result['access']        = false;
			$result['access_reason'] = '    .';
		} elseif($config['status'] == '0'){
			$result['access']        = false;
			$result['access_reason'] = ' .';
		} elseif($user_level != ACCESS_ADMIN && $config['rang_access'] != '0'){
			if($user_level > ACCESS_MEMBER){ // 
				$result['access']        = false;
				$result['access_reason'] = '      .';
			} elseif($user_level == ACCESS_MEMBER && GetRankInfo($config['rang_access'], 'min') > $user_rank['min']){ // 
				$result['access']        = false;
				$result['access_reason'] = '         "'.SafeDB(GetRankInfo($config['rang_access'], 'title'), 255, str).'"  .';
			}
		}

		//  
		if(!$result['access']){
			$result['add_topic']        = false;
			$result['add_topic_reason'] = $result['access_reason'];
		} elseif($user_level != ACCESS_ADMIN){
			if($user_level > ACCESS_MEMBER){
				$result['add_topic']        = false;
				$result['add_topic_reason'] = '    .';
			} elseif($config['close_topic'] == '1'){
				$result['add_topic']        = false;
				$result['add_topic_reason'] = '   .';
			} elseif($config['admin_theme_add'] == '1'){
				$result['add_topic']        = false;
				$result['add_topic_reason'] = '     .';
			} elseif($config['rang_add_theme'] != '0'){
				if($user_level == ACCESS_MEMBER && GetRankInfo($config['rang_add_theme'], 'min') > $user_rank['min']){ // 
					$result['add_topic']        = false;
					$result['add_topic_reason'] = '       "'.SafeDB(GetRankInfo($config['rang_add_theme'], 'title'), 255, str).'"  .';
				}
			}
		}

		//  
		if(!$result['access']){
			$result['add_post']        = false;
			$result['add_post_reason'] = $result['access_reason'];
		} elseif($user_level != ACCESS_ADMIN){
			if($user_level > ACCESS_MEMBER){
				$result['add_post']        = false;
				$result['add_post_reason'] = '    .';
			} elseif($config['close_topic'] == '1'){
				$result['add_post']        = false;
				$result['add_post_reason'] = '   .';
			} elseif($config['rang_add_theme'] != '0'){
				if($user_level == ACCESS_MEMBER && GetRankInfo($config['rang_message'], 'min') > $user_rank['min']){ // 
					$result['add_post']        = false;
					$result['add_post_reason'] = '       "'.SafeDB(GetRankInfo($config['rang_message'], 'title'), 255, str).'"  .';
				}
			}
		}

		//  
		$result['close'] = $config['close_topic'] == '1';

		//     ,      
		$childs = $this->GetAllChildId($CatId);
		foreach($childs as $child){
			$child = $this->IdCats[$child];
			$result['topics'] += $child['topics'];
			$result['posts'] += $child['posts'];
			if($result['last_post'] < $child['last_post']){
				$result['last_post']        = $child['last_post'];
				$result['last_poster_id']   = $child['last_poster_id'];
				$result['last_poster_name'] = $child['last_poster_name'];
				$result['last_title']       = $child['last_title'];
				$result['last_id']          = $child['last_id'];
			}
		}

		return $result;
	}

	/**
	 *  
	 * @param null $Forums
	 * @return ForumTree
	 */
	static public function Instance($Forums = null){
		if(!(self::$_instance instanceof ForumTree)){
			if(!isset($Forums)){
				$Forums = ForumCacheGetForums(); //    ()
			}
			self::$_instance             = new ForumTree($Forums, 'id', 'parent_id', 'title', 'topics', 'posts');
			self::$_instance->moduleName = 'forum';
			self::$_instance->TopCatName = '';
		}
		return self::$_instance;
	}

}
